/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eurocarbdb.application.glycanbuilder.BuilderWorkspace;
import org.eurocarbdb.application.glycanbuilder.GlycanRenderer;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.tools.glycanbuilder.core.renderer.ResidueRendererSWT;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;

public class ResidueSelectorComposite
extends Composite {
    private List<Residue> m_lResidues = new ArrayList<Residue>();

    public ResidueSelectorComposite(Composite parent) {
        super(parent, 0);
        BuilderWorkspaceSWT bw = new BuilderWorkspaceSWT((Device)parent.getDisplay());
        ResidueRendererSWT rr = bw.getGlycanRenderer().getResidueRenderer();
        bw.setNotation("snfg");
        this.setLayout((Layout)new GridLayout(1, false));
        for (String sup : ResidueDictionary.getSuperclasses()) {
            Group g = new Group((Composite)this, 0);
            g.setText(sup);
            g.setLayout((Layout)new GridLayout(8, false));
            for (ResidueType res : ResidueDictionary.getResidues((String)sup)) {
                Button btn = new Button((Composite)g, 8);
                rr.setBackgroundColor(btn.getBackground());
                btn.setText(res.getName());
                btn.setImage(rr.getImage(res, 36));
                btn.setToolTipText(res.getDescription());
            }
            g.pack();
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Residue selector");
        shell.setLayout((Layout)new FillLayout());
        shell.setBackgroundMode(2);
        new BuilderWorkspace((GlycanRenderer)new GlycanRendererAWT());
        ScrolledComposite sc = new ScrolledComposite((Composite)shell, 768);
        ResidueSelectorComposite resSelector = new ResidueSelectorComposite((Composite)sc);
        sc.setContent((Control)resSelector);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        resSelector.pack();
        sc.setMinSize(resSelector.getBounds().width, resSelector.getBounds().height);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        resSelector.dispose();
        display.dispose();
    }
}

