/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.preference;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotation;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotationPeak;
import org.grits.toolbox.entry.ms.annotation.glycan.preference.xml.MSGlycanAnnotationCustomAnnotationTemplate;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationFile;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationTemplate;

public class MSGlycanAnnotationSpecialPeaksFile
extends MassSpecCustomAnnotationFile {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSpecialPeaksFile.class);
    public static final String[] HEADER_COLUMN_LABELS = new String[]{"Peak m/z", "MS Level", "Peak Label", "Glycan Sequence"};

    public static String[] getHeaderColumns() {
        return HEADER_COLUMN_LABELS;
    }

    public static boolean testFile(File f) {
        boolean bPass = false;
        try {
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String header = reader.readLine();
            String[] toks = header.split("\t");
            if (toks[0].equalsIgnoreCase(HEADER_COLUMN_LABELS[0])) {
                bPass = true;
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }

    public static boolean readFile(MassSpecCustomAnnotation msca, String sFilePath) {
        boolean bPass = false;
        try {
            File f = new File(sFilePath);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            String sCurLine = reader.readLine();
            boolean hasHeader = MassSpecCustomAnnotationFile.hasHeaders((String)sCurLine);
            if (hasHeader) {
                sCurLine = reader.readLine();
            }
            if (msca.getAnnotatedPeaks() == null) {
                msca.setAnnotatedPeaks(new HashMap());
            }
            while (sCurLine != null) {
                try {
                    if (!sCurLine.trim().equals("")) {
                        String[] toks = sCurLine.split("\t");
                        MSGlycanAnnotationCustomAnnotationPeak peak = new MSGlycanAnnotationCustomAnnotationPeak();
                        Double dMz = Double.parseDouble(toks[0]);
                        peak.setPeakMz(dMz);
                        Integer iMSLevel = Integer.parseInt(toks[1]);
                        peak.setMSLevel(iMSLevel);
                        peak.setPeakLabel("");
                        if (toks.length >= 3 && toks[2] != null) {
                            String sLabel = toks[2].trim();
                            peak.setPeakLabel(sLabel);
                        }
                        if (toks.length >= 4 && toks[3] != null) {
                            String sSequence = toks[3].trim();
                            peak.setPeakSequence(sSequence);
                        }
                        msca.getAnnotatedPeaks().put(peak.getPeakMz(), peak);
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                sCurLine = reader.readLine();
            }
            reader.close();
            bPass = true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }

    public static boolean writeFile(MassSpecCustomAnnotation msca, String sFilePath) {
        boolean bPass = false;
        try {
            File f = new File(sFilePath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            String sw = "";
            int i = 0;
            while (i < HEADER_COLUMN_LABELS.length) {
                writer.write(sw);
                writer.write(HEADER_COLUMN_LABELS[i]);
                if (sw.equals("")) {
                    sw = "\t";
                }
                ++i;
            }
            writer.write("\n");
            Object[] peaks = msca.getAnnotatedPeaks().values().toArray();
            int i2 = 0;
            while (i2 < peaks.length) {
                MSGlycanAnnotationCustomAnnotationPeak peak = (MSGlycanAnnotationCustomAnnotationPeak)((Object)peaks[i2]);
                writer.write(Double.toString(peak.getPeakMz()));
                writer.write("\t");
                writer.write(Integer.toString(peak.getMSLevel()));
                writer.write("\t");
                writer.write(peak.getPeakLabel() == null ? "" : peak.getPeakLabel());
                writer.write("\t");
                writer.write(peak.getPeakSequence() == null ? "" : peak.getPeakSequence());
                writer.write("\n");
                ++i2;
            }
            writer.close();
            bPass = true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }

    public static MSGlycanAnnotationCustomAnnotation readXMLFile(String sFilePath) {
        try {
            File f = new File(sFilePath);
            BufferedReader reader = new BufferedReader(new FileReader(f));
            MSGlycanAnnotationCustomAnnotationTemplate template = MSGlycanAnnotationCustomAnnotationTemplate.unmarshalAnnotationTemplate(sFilePath);
            MSGlycanAnnotationCustomAnnotation msca = (MSGlycanAnnotationCustomAnnotation)template.copyToNewAnnotation();
            reader.close();
            return msca;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static boolean writeXMLFile(MassSpecCustomAnnotation msca, String sFilePath) {
        boolean bPass = false;
        try {
            File f = new File(sFilePath);
            BufferedWriter writer = new BufferedWriter(new FileWriter(f));
            MassSpecCustomAnnotationTemplate template = msca.copyToNewTemplate();
            String sXML = MassSpecCustomAnnotationTemplate.marshalAnnotatedTemplate((MassSpecCustomAnnotationTemplate)template);
            writer.write(sXML);
            writer.write(System.getProperty("line.separator"));
            writer.close();
            bPass = true;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return bPass;
    }
}

