/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.action;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;
import org.grits.toolbox.core.img.ImageShare;
import org.grits.toolbox.entry.sample.model.Category;
import org.grits.toolbox.entry.sample.model.CategoryTemplate;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;
import org.grits.toolbox.entry.sample.part.action.AbstractTreeTableAction;
import org.grits.toolbox.entry.sample.part.providers.CategoryTreeContentProvider;
import org.grits.toolbox.entry.sample.utilities.UtilityDescriptorDescriptorGroup;

public class DeleteDescriptorDescriptorGroupAction
extends AbstractTreeTableAction {
    @Override
    protected void setUp() {
        this.setToolTipText("Delete");
        this.setImageDescriptor(ImageShare.DELETE_ICON);
    }

    public void run() {
        boolean removed = false;
        if (this.treeViewer != null) {
            Category category = (Category)this.treeViewer.getInput();
            if (!this.treeViewer.getSelection().isEmpty()) {
                boolean removeTemplate = false;
                CategoryTemplate categoryTemplate = ((CategoryTreeContentProvider)this.treeViewer.getContentProvider()).getCategoryTemplate();
                List<TreeItem> allItems = Arrays.asList(this.treeViewer.getTree().getSelection());
                TreeItem firstSelectedItem = allItems.get(0);
                if (firstSelectedItem.getData() instanceof Descriptor) {
                    Descriptor selectedDescriptor = (Descriptor)firstSelectedItem.getData();
                    boolean independentDescriptor = category.getDescriptors().contains(selectedDescriptor);
                    if (independentDescriptor) {
                        if (categoryTemplate == null) {
                            removed = category.getDescriptors().remove(selectedDescriptor);
                        } else {
                            List<String> mandatoryDescriptorURIs = UtilityDescriptorDescriptorGroup.getMandatoryDescriptorURIs(categoryTemplate);
                            if (mandatoryDescriptorURIs.contains(selectedDescriptor.getUri())) {
                                int count = 0;
                                for (Descriptor d : category.getDescriptors()) {
                                    if (!d.getUri().equals(selectedDescriptor.getUri())) continue;
                                    ++count;
                                }
                                if (count > 1) {
                                    removed = category.getDescriptors().remove(selectedDescriptor);
                                } else if (this.confirmTemplateRemovalDialog((Composite)this.treeViewer.getTree(), "descriptor", "template")) {
                                    removed = category.getDescriptors().remove(selectedDescriptor);
                                    removeTemplate = true;
                                }
                            } else {
                                removed = category.getDescriptors().remove(selectedDescriptor);
                            }
                        }
                    } else {
                        removed = this.removeDescriptorFromDescriptorGroup(selectedDescriptor);
                    }
                } else if (firstSelectedItem.getData() instanceof DescriptorGroup) {
                    DescriptorGroup descriptorGroupToBeRemoved = (DescriptorGroup)firstSelectedItem.getData();
                    if (categoryTemplate == null) {
                        removed = category.getDescriptorGroups().remove(descriptorGroupToBeRemoved);
                    } else {
                        List<String> mandatoryDgURIs = UtilityDescriptorDescriptorGroup.getMandatoryDescriptorGroupURIs(categoryTemplate);
                        if (mandatoryDgURIs.contains(descriptorGroupToBeRemoved.getUri())) {
                            if (this.confirmTemplateRemovalDialog((Composite)this.treeViewer.getTree(), "descriptor group", "template")) {
                                removed = category.getDescriptorGroups().remove(descriptorGroupToBeRemoved);
                                removeTemplate = true;
                            }
                        } else {
                            removed = category.getDescriptorGroups().remove(descriptorGroupToBeRemoved);
                        }
                    }
                }
                if (removeTemplate) {
                    this.component.setTemplateUri(null);
                    this.eventBroker.post("component_modified_in_a_tab", (Object)this.component);
                } else if (removed) {
                    this.treeViewer.refresh();
                    this.dirtyable.setDirty(true);
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No Descriptor / Descriptor Group selected", (String)"Please select a descriptor or descriptor group to delete.");
            }
        } else if (this.tableViewer != null) {
            int selection = this.tableViewer.getTable().getSelectionIndex();
            if (selection != -1) {
                TableItem tableItem = this.tableViewer.getTable().getItem(selection);
                if (tableItem.getData() instanceof Descriptor) {
                    Descriptor descriptorToBeRemoved = (Descriptor)tableItem.getData();
                    removed = this.removeDescriptorFromDescriptorGroup((DescriptorGroup)this.tableViewer.getInput(), descriptorToBeRemoved);
                    if (removed) {
                        this.tableViewer.getTable().remove(selection);
                        this.tableViewer.refresh();
                    }
                }
            } else {
                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"No Descriptor selected", (String)"Please select a descriptor to delete.");
            }
        }
    }

    private boolean confirmTemplateRemovalDialog(Composite comp, String descriptor, String template) {
        return MessageDialog.openConfirm((Shell)comp.getShell(), (String)"Please Confirm", (String)("This " + descriptor + " is mandatory in the " + template + ". You will loose the template if you delete it. Do you want to delete it?"));
    }

    private boolean removeDescriptorFromDescriptorGroup(Descriptor selectedDescriptor) {
        Category category = (Category)this.treeViewer.getInput();
        boolean removed = false;
        for (DescriptorGroup dg : category.getDescriptorGroups()) {
            if (!this.removeDescriptorFromDescriptorGroup(dg, selectedDescriptor)) continue;
            removed = true;
            break;
        }
        return removed;
    }

    private boolean removeDescriptorFromDescriptorGroup(DescriptorGroup dg, Descriptor selectedDescriptor) {
        boolean removed = false;
        if (dg.getMandatoryDescriptors().contains(selectedDescriptor)) {
            int count = 0;
            for (Descriptor d : dg.getMandatoryDescriptors()) {
                if (!d.getUri().equals(selectedDescriptor.getUri())) continue;
                ++count;
            }
            if (count > 1) {
                dg.getMandatoryDescriptors().remove(selectedDescriptor);
                removed = true;
            } else {
                this.showCannotDeleteDialog("descriptor", "descriptor group");
            }
        } else if (dg.getOptionalDescriptors().contains(selectedDescriptor)) {
            dg.getOptionalDescriptors().remove(selectedDescriptor);
            removed = true;
            if (dg.getMandatoryDescriptors().isEmpty() && dg.getOptionalDescriptors().isEmpty()) {
                dg.addOptionalDescriptor(selectedDescriptor);
                removed = false;
                MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Not Allowed", (String)"Empty Descriptor group is not allowed. You cannot delete this descriptor.");
            }
        }
        return removed;
    }

    private void showCannotDeleteDialog(String objectName, String mandatoryInObjectName) {
        MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Not Allowed", (String)("This " + objectName + " is mandatory in the " + mandatoryInObjectName + ", you cannot delete it."));
    }
}

