/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfExtraRowSet
extends RtfContainer {
    static final int DEFAULT_IDNUM = 0;
    private ITableColumnsInfo parentITableColumnsInfo;
    private final List cells = new LinkedList();
    private int maxRowIndex;

    RtfExtraRowSet(Writer w) throws IOException {
        super(null, w);
    }

    int addTable(RtfTable tbl, int rowIndex, int xOffset) {
        for (Object o : tbl.getChildren()) {
            RtfElement e = (RtfElement)o;
            if (!(e instanceof RtfTableRow)) continue;
            this.addRow((RtfTableRow)e, rowIndex, xOffset);
            this.maxRowIndex = Math.max(++rowIndex, this.maxRowIndex);
        }
        return rowIndex;
    }

    private void addRow(RtfTableRow row, int rowIndex, int xOffset) {
        for (Object o : row.getChildren()) {
            RtfElement e = (RtfElement)o;
            if (!(e instanceof RtfTableCell)) continue;
            RtfTableCell c = (RtfTableCell)e;
            this.cells.add(new PositionedCell(c, rowIndex, xOffset));
            xOffset += c.getCellWidth();
        }
    }

    RtfTableCell createExtraCell(int rowIndex, int xOffset, int cellWidth, RtfAttributes parentCellAttributes) throws IOException {
        RtfTableCell c = new RtfTableCell(null, this.writer, cellWidth, parentCellAttributes, 0);
        this.cells.add(new PositionedCell(c, rowIndex, xOffset));
        return c;
    }

    @Override
    protected void writeRtfContent() throws IOException {
        Collections.sort(this.cells);
        LinkedList<PositionedCell> rowCells = null;
        int rowIndex = -1;
        for (Object cell : this.cells) {
            PositionedCell pc = (PositionedCell)cell;
            if (pc.rowIndex != rowIndex) {
                if (rowCells != null) {
                    this.writeRow(rowCells);
                }
                rowIndex = pc.rowIndex;
                rowCells = new LinkedList<PositionedCell>();
            }
            rowCells.add(pc);
        }
        if (rowCells != null) {
            this.writeRow(rowCells);
        }
    }

    private void writeRow(List cells) throws IOException {
        if (RtfExtraRowSet.allCellsEmpty(cells)) {
            return;
        }
        RtfTableRow row = new RtfTableRow(null, this.writer, 0);
        int cellIndex = 0;
        ITableColumnsInfo parentITableColumnsInfo = this.getParentITableColumnsInfo();
        parentITableColumnsInfo.selectFirstColumn();
        float xOffset = 0.0f;
        float xOffsetOfLastPositionedCell = 0.0f;
        for (Object cell : cells) {
            PositionedCell pc = (PositionedCell)cell;
            if (cellIndex == 0 && pc.xOffset > 0) {
                for (int i = 0; xOffset < (float)pc.xOffset && i < parentITableColumnsInfo.getNumberOfColumns(); xOffset += parentITableColumnsInfo.getColumnWidth(), ++i) {
                    row.newTableCellMergedVertically((int)parentITableColumnsInfo.getColumnWidth(), ((PositionedCell)pc).cell.attrib);
                    parentITableColumnsInfo.selectNextColumn();
                }
            }
            row.addChild(pc.cell);
            xOffsetOfLastPositionedCell = pc.xOffset + pc.cell.getCellWidth();
            ++cellIndex;
        }
        if (parentITableColumnsInfo.getColumnIndex() < parentITableColumnsInfo.getNumberOfColumns() - 1) {
            parentITableColumnsInfo.selectNextColumn();
            while (parentITableColumnsInfo.getColumnIndex() < parentITableColumnsInfo.getNumberOfColumns()) {
                row.newTableCellMergedVertically((int)parentITableColumnsInfo.getColumnWidth(), this.attrib);
                parentITableColumnsInfo.selectNextColumn();
            }
        }
        row.writeRtf();
    }

    private static boolean allCellsEmpty(List cells) {
        boolean empty = true;
        for (Object cell : cells) {
            PositionedCell pc = (PositionedCell)cell;
            if (!pc.cell.containsText()) continue;
            empty = false;
            break;
        }
        return empty;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public ITableColumnsInfo getParentITableColumnsInfo() {
        return this.parentITableColumnsInfo;
    }

    public void setParentITableColumnsInfo(ITableColumnsInfo parentITableColumnsInfo) {
        this.parentITableColumnsInfo = parentITableColumnsInfo;
    }

    private static class PositionedCell
    implements Comparable {
        private final RtfTableCell cell;
        private final int xOffset;
        private final int rowIndex;

        PositionedCell(RtfTableCell c, int index, int offset) {
            this.cell = c;
            this.xOffset = offset;
            this.rowIndex = index;
        }

        public String toString() {
            return "PositionedCell: row " + this.rowIndex + ", offset " + this.xOffset;
        }

        public int compareTo(Object o) {
            int result = 0;
            if (o == null) {
                result = 1;
            } else if (!(o instanceof PositionedCell)) {
                result = 1;
            } else {
                PositionedCell pc = (PositionedCell)o;
                if (this.rowIndex < pc.rowIndex) {
                    result = -1;
                } else if (this.rowIndex > pc.rowIndex) {
                    result = 1;
                } else if (this.xOffset < pc.xOffset) {
                    result = -1;
                } else if (this.xOffset > pc.xOffset) {
                    result = 1;
                }
            }
            return result;
        }

        public int hashCode() {
            int hc = super.hashCode();
            hc ^= hc * 11 + this.xOffset;
            hc ^= hc * 19 + this.rowIndex;
            return hc;
        }

        public boolean equals(Object o) {
            if (o instanceof PositionedCell) {
                PositionedCell pc = (PositionedCell)o;
                return pc.rowIndex == this.rowIndex && pc.xOffset == this.xOffset;
            }
            return false;
        }
    }
}

