/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.Action;
import com.sun.deploy.association.Association;
import com.sun.deploy.association.utility.AppAssociationReader;
import com.sun.deploy.association.utility.MacOSXBundleUtil;
import com.sun.deploy.model.LocalApplicationProperties;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MacOSXAppAssociationReader
implements AppAssociationReader {
    private static final String BUNDLE_PATH_KEY = "macosx.bundlePath";
    private static final String ACTION_COMMAND = "command";
    private final LocalApplicationProperties lap;

    public MacOSXAppAssociationReader(LocalApplicationProperties localApplicationProperties) {
        this.lap = localApplicationProperties;
    }

    public String getDescriptionByMimeType(String string) {
        HashMap hashMap = this.getDocumentTypeByMimeType(string);
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get("CFBundleTypeName");
    }

    public String getDescriptionByFileExt(String string) {
        HashMap hashMap = this.getDocumentTypeByFileExt(string);
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get("CFBundleTypeName");
    }

    public String getMimeTypeByURL(URL uRL) {
        throw new RuntimeException("Unimplemented");
    }

    public List getFileExtListByMimeType(String string) {
        HashMap hashMap = this.getDocumentTypeByMimeType(string);
        if (hashMap == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = (String[])hashMap.get("CFBundleTypeExtensions");
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i]);
        }
        return arrayList;
    }

    public String getMimeTypeByFileExt(String string) {
        HashMap hashMap = this.getDocumentTypeByFileExt(string);
        if (hashMap == null) {
            return null;
        }
        String[] stringArray = (String[])hashMap.get("CFBundleTypeMIMETypes");
        return stringArray[0];
    }

    public String getIconFileNameByMimeType(String string) {
        HashMap hashMap = this.getDocumentTypeByMimeType(string);
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get("JWSIconPath");
    }

    public String getIconFileNameByFileExt(String string) {
        HashMap hashMap = this.getDocumentTypeByFileExt(string);
        if (hashMap == null) {
            return null;
        }
        return (String)hashMap.get("JWSIconPath");
    }

    public List getActionListByMimeType(String string) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(new Action("open", ACTION_COMMAND));
        return arrayList;
    }

    public List getActionListByFileExt(String string) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        arrayList.add(new Action("open", ACTION_COMMAND));
        return arrayList;
    }

    public boolean isMimeTypeExist(String string) {
        HashMap hashMap = this.getDocumentTypeByMimeType(string);
        return hashMap != null;
    }

    public boolean isFileExtExist(String string) {
        HashMap hashMap = this.getDocumentTypeByFileExt(string);
        return hashMap != null;
    }

    public List getAssociations() {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        File file = MacOSXAppAssociationReader.getBundleFile(this.lap);
        if (file == null) {
            return arrayList;
        }
        HashMap[] hashMapArray = MacOSXBundleUtil.getDocumentTypes(file.getAbsolutePath());
        if (hashMapArray == null) {
            return arrayList;
        }
        for (int i = 0; i < hashMapArray.length; ++i) {
            HashMap hashMap = hashMapArray[i];
            String[] stringArray = (String[])hashMap.get("CFBundleTypeMIMETypes");
            String[] stringArray2 = (String[])hashMap.get("CFBundleTypeExtensions");
            String string = (String)hashMap.get("CFBundleTypeName");
            String string2 = (String)hashMap.get("JWSIconPath");
            Association association = new Association();
            for (int j = 0; j < stringArray2.length; ++j) {
                association.addFileExtension(stringArray2[j]);
            }
            association.setMimeType(stringArray[0]);
            association.setDescription(string);
            association.addAction(new Action("open", ACTION_COMMAND));
            association.setIconFileName(string2);
            arrayList.add(association);
        }
        return arrayList;
    }

    private static File getBundleFile(LocalApplicationProperties localApplicationProperties) {
        File file;
        String string = localApplicationProperties.get(BUNDLE_PATH_KEY);
        if (string != null && (file = new File(string)).exists() && file.isDirectory()) {
            return file;
        }
        return null;
    }

    private HashMap getDocumentTypeByMimeType(String string) {
        File file = MacOSXAppAssociationReader.getBundleFile(this.lap);
        if (file == null) {
            return null;
        }
        HashMap[] hashMapArray = MacOSXBundleUtil.getDocumentTypes(file.getAbsolutePath());
        if (hashMapArray == null) {
            return null;
        }
        for (int i = 0; i < hashMapArray.length; ++i) {
            String[] stringArray = (String[])hashMapArray[i].get("CFBundleTypeMIMETypes");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string)) continue;
                return hashMapArray[i];
            }
        }
        return null;
    }

    private HashMap getDocumentTypeByFileExt(String string) {
        File file = MacOSXAppAssociationReader.getBundleFile(this.lap);
        if (file == null) {
            return null;
        }
        HashMap[] hashMapArray = MacOSXBundleUtil.getDocumentTypes(file.getAbsolutePath());
        if (hashMapArray == null) {
            return null;
        }
        for (int i = 0; i < hashMapArray.length; ++i) {
            String[] stringArray = (String[])hashMapArray[i].get("CFBundleTypeExtensions");
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray[j].equals(string)) continue;
                return hashMapArray[i];
            }
        }
        return null;
    }
}

