/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.util.io.glycolipid;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;
import org.grits.toolbox.ms.om.data.GlycolipidAnnotation;
import org.grits.toolbox.ms.om.data.LipidAnnotation;
import org.grits.toolbox.ms.om.data.Peak;
import org.grits.toolbox.tools.gsl.util.io.excel.ExporterXLSXAbstract;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.AnnotatedIon;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.AnnotatedStructure;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.AnnotationInformationUnit;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.AnnotationReport;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.GlycolipidAnnotationReport;
import org.grits.toolbox.tools.gsl.util.io.glycolipid.data.GlycolipidStructure;
import org.grits.toolbox.utils.io.ExcelWriterHelper;

public class GlycolipidAnnotationExporterXLSX
extends ExporterXLSXAbstract {
    private static final Logger logger = Logger.getLogger(GlycolipidAnnotationExporterXLSX.class);
    private List<GlycolipidAnnotationReport> m_lReports;
    private boolean m_bExportCartoon = false;
    private int m_nAnnotPerSheet = -1;
    private ExcelWriterHelper m_helper = new ExcelWriterHelper();
    private Map<String, BufferedImage> m_mapGWBSequenceToImage;
    private List<Picture> m_lPictures;
    private static List<String> lBlankAnnot = Arrays.asList("", "", "", "", "");
    private static List<String> lBlankHead = Arrays.asList("", "", "", "");

    public GlycolipidAnnotationExporterXLSX(String a_strOutputFile) throws IOException {
        super(a_strOutputFile);
        this.m_lReports = new ArrayList<GlycolipidAnnotationReport>();
        this.m_mapGWBSequenceToImage = new HashMap<String, BufferedImage>();
        this.m_lPictures = new ArrayList<Picture>();
    }

    public void addReport(GlycolipidAnnotationReport a_report) {
        this.m_lReports.add(a_report);
    }

    public void setExportCartoon(boolean a_bExport) {
        this.m_bExportCartoon = a_bExport;
    }

    public void setNumberOfAnnotationPerSheet(int a_nAnnot) {
        this.m_nAnnotPerSheet = a_nAnnot;
    }

    @Override
    public boolean createBook() {
        for (GlycolipidAnnotationReport t_report : this.m_lReports) {
            if (!this.createSheetForSummary(t_report)) {
                return false;
            }
            if (!this.createSheetForDetailedSummary(t_report)) {
                return false;
            }
            if (!this.createSheetForComposition(t_report)) {
                return false;
            }
            if (!this.createSheetForScan(t_report)) {
                return false;
            }
            if (t_report.getSubScanReports().isEmpty()) continue;
            for (AnnotationReport t_reportSub : t_report.getSubScanReports()) {
                if (!this.createSheetForSubScanSummary(t_reportSub)) {
                    return false;
                }
                if (this.createSheetForScan(t_reportSub)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean createSheetForSummary(GlycolipidAnnotationReport a_report) {
        this.m_sheetCurent = this.createSheet(String.valueOf(a_report.getReportName()) + "-Summary");
        logger.debug((Object)("Create sheet: " + this.m_sheetCurent.getSheetName()));
        this.createRow(Arrays.asList("", "Annotated structures", "", "Ions", "m/z", "deltaM (ppm)", "Count Score", "Intensity Score"));
        String t_strCharge = a_report.getPrecursorPeak().getPrecursorCharge().toString();
        if (!t_strCharge.startsWith("-")) {
            t_strCharge = "+" + t_strCharge;
        }
        String t_strMz = a_report.getPrecursorPeak().getPrecursorMz().toString();
        this.createRow(Arrays.asList("Precursor", "", "", t_strCharge, t_strMz, "--", "--", "--"));
        int i = 0;
        for (AnnotatedStructure t_as : this.getSortedAnnotatedStructures(a_report, true)) {
            GlycolipidStructure t_gl = (GlycolipidStructure)t_as.getStructure();
            AnnotationInformationUnit t_unit = a_report.getPrecursorAnnotationUnit(t_as.getID());
            AnnotatedIon t_info = this.sortInformationByDeviation(t_unit).get(0);
            this.createRow(Arrays.asList("" + ++i, t_gl.getGlycanSequence(), t_gl.getLipidName(), t_info.getIon(), t_info.getMass(), t_info.getDeviation(), t_as.getCountScore(), t_as.getIntensityScore()));
        }
        return true;
    }

    protected boolean createSheetForDetailedSummary(final GlycolipidAnnotationReport a_report) {
        this.m_sheetCurent = this.createSheet(String.valueOf(a_report.getReportName()) + "-Detail");
        logger.debug((Object)("Create sheet: " + this.m_sheetCurent.getSheetName()));
        this.createRow(Arrays.asList("", "Annotated structures", "", "Ions", "m/z", "deltaM (ppm)", "Count Score", "Intensity Score"));
        String t_strCharge = a_report.getPrecursorPeak().getPrecursorCharge().toString();
        if (!t_strCharge.startsWith("-")) {
            t_strCharge = "+" + t_strCharge;
        }
        String t_strMz = a_report.getPrecursorPeak().getPrecursorMz().toString();
        this.createRow(Arrays.asList("Precursor", "Glycan", "Lipid", t_strCharge, t_strMz, "--", "--", "--"));
        int i = 0;
        for (AnnotatedStructure t_as : this.getSortedAnnotatedStructures(a_report, true)) {
            GlycolipidStructure t_gl = (GlycolipidStructure)t_as.getStructure();
            AnnotationInformationUnit t_unit = a_report.getPrecursorAnnotationUnit(t_as.getID());
            AnnotatedIon t_info = this.sortInformationByDeviation(t_unit).get(0);
            this.createRow(Arrays.asList("" + ++i, t_gl.getGlycanSequence(), t_gl.getLipidName()));
            List<Annotation> t_lAnnots = a_report.getAnnotations(t_as);
            Collections.sort(t_lAnnots, new Comparator<Annotation>(){

                @Override
                public int compare(Annotation o1, Annotation o2) {
                    Double t_dIScore1 = a_report.getIntensityScore(o1);
                    Double t_dIScore2 = a_report.getIntensityScore(o2);
                    if (t_dIScore1 < t_dIScore2) {
                        return -1;
                    }
                    if (t_dIScore1 > t_dIScore2) {
                        return 1;
                    }
                    Double t_dCScore1 = a_report.getCountingScore(o1);
                    Double t_dCScore2 = a_report.getCountingScore(o2);
                    if (t_dCScore1 < t_dCScore2) {
                        return -1;
                    }
                    if (t_dCScore1 > t_dCScore2) {
                        return 1;
                    }
                    return 0;
                }
            });
            Collections.reverse(t_lAnnots);
            for (Annotation t_annot : t_lAnnots) {
                Double t_dCScore = a_report.getCountingScore(t_annot);
                Double t_dIScore = a_report.getIntensityScore(t_annot);
                String t_strGSeq = "";
                String t_strLName = "";
                if (t_annot instanceof GlycolipidAnnotation) {
                    GlycolipidAnnotation t_glAnnot = (GlycolipidAnnotation)t_annot;
                    t_strGSeq = t_glAnnot.getGlycanAnnotation().getSequenceGWB();
                    t_strLName = t_glAnnot.getLipidAnnotation().getSequence();
                }
                if (t_annot instanceof GlycanAnnotation) {
                    t_strGSeq = ((GlycanAnnotation)t_annot).getSequenceGWB();
                }
                if (t_annot instanceof LipidAnnotation) {
                    t_strLName = ((LipidAnnotation)t_annot).getSequence();
                }
                this.createRow(Arrays.asList("", t_strGSeq, t_strLName, t_info.getIon(), t_info.getMass(), t_info.getDeviation(), t_dCScore.toString(), t_dIScore.toString()));
                this.convertGWBSequenceToImage(this.m_sheetCurent, this.m_nRowCurrent - 1, 1);
            }
        }
        return true;
    }

    protected boolean createSheetForComposition(GlycolipidAnnotationReport a_report) {
        this.m_sheetCurent = this.createSheet(String.valueOf(a_report.getReportName()) + "-Composition");
        logger.debug((Object)("Create sheet: " + this.m_sheetCurent.getSheetName()));
        this.createRow(Arrays.asList("Glycan composition", "Glycan strcutures"));
        for (String t_strGCompo : a_report.getGlycanCompositions()) {
            ArrayList<String> t_lGCmpRow = new ArrayList<String>();
            ArrayList<String> t_lGImgRow = new ArrayList<String>();
            t_lGCmpRow.add(t_strGCompo);
            t_lGImgRow.add("");
            for (GlycanAnnotation t_gAnnot : a_report.getGlycanAnnotations(t_strGCompo)) {
                t_lGCmpRow.add(t_gAnnot.getStringId());
                t_lGImgRow.add(t_gAnnot.getSequenceGWB());
            }
            this.createRow(t_lGCmpRow);
            this.createRow(t_lGImgRow);
            int i = 1;
            while (i < t_lGImgRow.size()) {
                this.convertGWBSequenceToImage(this.m_sheetCurent, this.m_nRowCurrent - 1, i);
                ++i;
            }
        }
        this.createRow(Arrays.asList("Lipid composition", "Lipid structure"));
        for (String t_strLCompo : a_report.getLipidCompositions()) {
            ArrayList<String> t_lLCmpRow = new ArrayList<String>();
            t_lLCmpRow.add(t_strLCompo);
            for (LipidAnnotation t_lAnnot : a_report.getLipidAnnotations(t_strLCompo)) {
                t_lLCmpRow.add(t_lAnnot.getSequence());
            }
            this.createRow(t_lLCmpRow);
        }
        return true;
    }

    protected boolean createSheetForScan(AnnotationReport a_report) {
        if (this.m_nAnnotPerSheet == -1) {
            return this.createSheetForScan(a_report, this.getSortedAnnotatedStructures(a_report, true), 1, 1);
        }
        int t_nAnnotation = a_report.getAnnotatedStructures().size();
        int t_nSheet = t_nAnnotation / this.m_nAnnotPerSheet;
        if (t_nAnnotation % this.m_nAnnotPerSheet > 0) {
            ++t_nSheet;
        }
        ArrayList<AnnotatedStructure> t_lAS = new ArrayList<AnnotatedStructure>();
        int t_iSheet = 1;
        for (AnnotatedStructure t_as : this.getSortedAnnotatedStructures(a_report, true)) {
            t_lAS.add(t_as);
            if (this.m_nAnnotPerSheet == -1 || t_lAS.size() < this.m_nAnnotPerSheet) continue;
            if (!this.createSheetForScan(a_report, t_lAS, t_iSheet++, t_nSheet)) {
                return false;
            }
            t_lAS.clear();
        }
        if (!t_lAS.isEmpty() && !this.createSheetForScan(a_report, t_lAS, t_iSheet++, t_nSheet)) {
            return false;
        }
        return false;
    }

    protected boolean createSheetForScan(AnnotationReport a_report, List<AnnotatedStructure> a_lAS, int t_iSheet, int t_nSheet) {
        String t_strSheetName = a_report.getReportName();
        if (t_nSheet != 1) {
            t_strSheetName = String.valueOf(t_strSheetName) + "-" + t_iSheet + "/" + t_nSheet;
        }
        this.m_sheetCurent = this.createSheet(t_strSheetName);
        logger.debug((Object)("Create sheet: " + this.m_sheetCurent.getSheetName()));
        ArrayList<String> t_lFirstRow = new ArrayList<String>();
        ArrayList<String> t_lSecondRow = new ArrayList<String>();
        t_lFirstRow.addAll(Arrays.asList("No.", "m/z", "Intensity", ""));
        t_lSecondRow.addAll(Arrays.asList("", "", "Absolute", "Relative"));
        List<String> t_lFirstAnnotRow = Arrays.asList("AnnotatedStructure", "", "Ions", "m/z", "deltaM (ppm)");
        List<String> t_lSecondAnnotRow = Arrays.asList("Glycan", "Lipid", "", "", "");
        int i = 0;
        while (i < a_lAS.size()) {
            t_lFirstRow.addAll(t_lFirstAnnotRow);
            t_lSecondRow.addAll(t_lSecondAnnotRow);
            ++i;
        }
        this.createRow(t_lFirstRow);
        this.createRow(t_lSecondRow);
        this.m_sheetCurent.addMergedRegion(new CellRangeAddress(0, 0, 2, 3));
        i = 0;
        while (i < a_lAS.size()) {
            this.m_sheetCurent.addMergedRegion(new CellRangeAddress(0, 0, 4 + i * 5, 5 + i * 5));
            ++i;
        }
        Peak t_peakPre = a_report.getPrecursorPeak();
        ArrayList<String> t_lPreRow = new ArrayList<String>();
        t_lPreRow.addAll(this.getPeakArray("Precursor", t_peakPre));
        for (AnnotatedStructure t_as : a_lAS) {
            ArrayList<String> t_lPreArray = new ArrayList<String>();
            GlycolipidStructure t_glStructure = (GlycolipidStructure)t_as.getStructure();
            t_lPreArray.add(t_glStructure.getGlycanSequence());
            t_lPreArray.add(t_glStructure.getLipidName());
            AnnotationInformationUnit t_annotUnit = a_report.getPrecursorAnnotationUnit(t_as.getID());
            AnnotatedIon t_info = t_annotUnit.getAnnotationInfo().get(0);
            t_lPreArray.add(t_info.getIon());
            t_lPreArray.add(t_info.getMass());
            t_lPreArray.add(t_info.getDeviation());
            t_lPreRow.addAll(t_lPreArray);
        }
        this.createRow(t_lPreRow);
        int j = 0;
        while (j < a_lAS.size()) {
            this.convertGWBSequenceToImage(this.m_sheetCurent, this.m_nRowCurrent - 1, 4 + j * 5);
            ++j;
        }
        for (Peak t_peak : a_report.getPeaks()) {
            if (this.createRowsForPeak(t_peak, a_report, a_lAS)) continue;
            return false;
        }
        this.m_sheetCurent.createFreezePane(4, 3);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean createRowsForPeak(Peak a_peak, AnnotationReport a_report, List<AnnotatedStructure> a_lAS) {
        logger.info((Object)a_peak.toString());
        if (a_peak.getFeatures().isEmpty()) {
            ArrayList<String> t_lRow = new ArrayList<String>();
            t_lRow.addAll(this.getPeakArray(a_peak.getId().toString(), a_peak));
            this.createRow(t_lRow);
            return true;
        }
        int t_nMaxInfoCount = 0;
        ArrayList t_lUnitRows = new ArrayList();
        for (AnnotatedStructure t_as : a_lAS) {
            ArrayList arrayList = new ArrayList();
            AnnotationInformationUnit t_unit = a_report.getAnnotationInformationUnit(a_peak.getId(), t_as.getID());
            if (t_unit == null) {
                t_lUnitRows.add(arrayList);
                continue;
            }
            for (AnnotatedIon t_info : this.sortInformationByDeviation(t_unit)) {
                ArrayList<String> t_lInfoRow = new ArrayList<String>();
                GlycolipidStructure t_glSt = (GlycolipidStructure)t_info.getAnnotatedStructure();
                t_lInfoRow.add(t_glSt.getGlycanSequence());
                t_lInfoRow.add(t_glSt.getLipidName());
                t_lInfoRow.add(t_info.getIon());
                t_lInfoRow.add(t_info.getMass());
                t_lInfoRow.add(t_info.getDeviation());
                boolean t_bIsMarged = false;
                for (List list : arrayList) {
                    if (!((String)list.get(2)).equals(t_lInfoRow.get(2)) || !((String)list.get(3)).equals(t_lInfoRow.get(3)) || !((String)list.get(4)).equals(t_lInfoRow.get(4))) continue;
                    if (((String)list.get(1)).isEmpty() && ((String)t_lInfoRow.get(1)).isEmpty()) {
                        list.set(0, String.valueOf((String)list.get(0)) + "\n" + (String)t_lInfoRow.get(0));
                        t_bIsMarged = true;
                        break;
                    }
                    if (((String)list.get(0)).isEmpty() && ((String)t_lInfoRow.get(0)).isEmpty()) {
                        list.set(1, String.valueOf((String)list.get(1)) + "\n" + (String)t_lInfoRow.get(1));
                        t_bIsMarged = true;
                        break;
                    }
                    if (((String)list.get(0)).isEmpty() || ((String)t_lInfoRow.get(0)).isEmpty() || ((String)list.get(1)).isEmpty() || ((String)t_lInfoRow.get(1)).isEmpty()) continue;
                    if (((String)list.get(1)).contains((CharSequence)t_lInfoRow.get(1)) && !((String)list.get(0)).contains((CharSequence)t_lInfoRow.get(0))) {
                        list.set(0, String.valueOf((String)list.get(0)) + "\n" + (String)t_lInfoRow.get(0));
                        t_bIsMarged = true;
                        break;
                    }
                    if (((String)list.get(0)).contains((CharSequence)t_lInfoRow.get(0)) && !((String)list.get(1)).contains((CharSequence)t_lInfoRow.get(1))) {
                        list.set(1, String.valueOf((String)list.get(1)) + "\n" + (String)t_lInfoRow.get(1));
                        t_bIsMarged = true;
                        break;
                    }
                    if (!((String)list.get(0)).contains((CharSequence)t_lInfoRow.get(0)) || !((String)list.get(1)).contains((CharSequence)t_lInfoRow.get(1))) continue;
                    t_bIsMarged = true;
                    break;
                }
                if (t_bIsMarged) continue;
                arrayList.add(t_lInfoRow);
            }
            t_lUnitRows.add(arrayList);
            if (t_nMaxInfoCount >= arrayList.size()) continue;
            t_nMaxInfoCount = arrayList.size();
        }
        int i = 0;
        while (i < t_nMaxInfoCount) {
            ArrayList<String> t_lPeakRow = new ArrayList<String>();
            if (i == 0) {
                t_lPeakRow.addAll(this.getPeakArray(a_peak.getId().toString(), a_peak));
            } else {
                t_lPeakRow.addAll(lBlankHead);
            }
            for (List list : t_lUnitRows) {
                if (list.size() < i + 1) {
                    t_lPeakRow.addAll(lBlankAnnot);
                    continue;
                }
                t_lPeakRow.addAll((Collection)list.get(i));
            }
            this.createRow(t_lPeakRow);
            if (this.m_bExportCartoon) {
                void var8_14;
                boolean bl = false;
                while (var8_14 < t_lPeakRow.size()) {
                    this.convertGWBSequenceToImage(this.m_sheetCurent, this.m_nRowCurrent - 1, 4 + var8_14 * 5);
                    ++var8_14;
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean createSheetForSubScanSummary(AnnotationReport a_reportSub) {
        this.m_sheetCurent = this.createSheet(String.valueOf(a_reportSub.getReportName()) + "-Summary");
        logger.debug((Object)("Create sheet: " + this.m_sheetCurent.getSheetName()));
        this.createRow(Arrays.asList("", "Annotated Fragments", "", "Ions", "m/z", "deltaM (ppm)", "Count Score", "Intensity Score"));
        String t_strCharge = "--";
        Integer t_iCharge = a_reportSub.getPrecursorPeak().getCharge();
        if (t_iCharge != null && t_iCharge > 0) {
            t_strCharge = "+" + t_iCharge.toString();
        }
        this.createRow(Arrays.asList("Precursor", "Glycan", "Lipid", t_strCharge, a_reportSub.getPrecursorPeak().getMz().toString(), "--", "--", "--"));
        int i = 0;
        for (AnnotatedStructure t_as : this.getSortedAnnotatedStructures(a_reportSub, false)) {
            GlycolipidStructure t_gl = (GlycolipidStructure)t_as.getStructure();
            AnnotationInformationUnit t_unit = a_reportSub.getPrecursorAnnotationUnit(t_as.getID());
            AnnotatedIon t_info = this.sortInformationByDeviation(t_unit).get(0);
            this.createRow(Arrays.asList("" + ++i, t_gl.getGlycanSequence(), t_gl.getLipidName(), t_info.getIon(), t_info.getMass(), t_info.getDeviation(), t_as.getCountScore(), t_as.getIntensityScore()));
            this.convertGWBSequenceToImage(this.m_sheetCurent, this.m_nRowCurrent - 1, 1);
        }
        return true;
    }

    private List<AnnotatedStructure> getSortedAnnotatedStructures(AnnotationReport a_report, final boolean a_bPriorDeviation) {
        List<AnnotatedStructure> t_lAS = a_report.getAnnotatedStructures();
        final HashMap<AnnotatedStructure, String> t_mapASToDev = new HashMap<AnnotatedStructure, String>();
        for (AnnotatedStructure t_as : t_lAS) {
            AnnotationInformationUnit t_annotUnit = a_report.getPrecursorAnnotationUnit(t_as.getID());
            List<AnnotatedIon> t_lInfo = this.sortInformationByDeviation(t_annotUnit);
            AnnotatedIon t_info = t_lInfo.get(0);
            t_mapASToDev.put(t_as, t_info.getDeviation());
        }
        Collections.sort(t_lAS, new Comparator<AnnotatedStructure>(){

            @Override
            public int compare(AnnotatedStructure o1, AnnotatedStructure o2) {
                if (a_bPriorDeviation) {
                    BigDecimal t_dDev2;
                    BigDecimal t_dDev1 = new BigDecimal((String)t_mapASToDev.get(o1));
                    if (t_dDev1.compareTo(t_dDev2 = new BigDecimal((String)t_mapASToDev.get(o2))) < 0) {
                        return -1;
                    }
                    if (t_dDev1.compareTo(t_dDev2) > 0) {
                        return 1;
                    }
                }
                Double t_dIScore1 = Double.valueOf(o1.getIntensityScore());
                Double t_dIScore2 = Double.valueOf(o2.getIntensityScore());
                if (t_dIScore1 > t_dIScore2) {
                    return -1;
                }
                if (t_dIScore1 < t_dIScore2) {
                    return 1;
                }
                Double t_dCScore1 = Double.valueOf(o1.getCountScore());
                Double t_dCScore2 = Double.valueOf(o2.getCountScore());
                if (t_dCScore1 > t_dCScore2) {
                    return -1;
                }
                if (t_dCScore1 < t_dCScore2) {
                    return 1;
                }
                if (!a_bPriorDeviation) {
                    BigDecimal t_dDev2;
                    BigDecimal t_dDev1 = new BigDecimal((String)t_mapASToDev.get(o1));
                    if (t_dDev1.compareTo(t_dDev2 = new BigDecimal((String)t_mapASToDev.get(o2))) < 0) {
                        return -1;
                    }
                    if (t_dDev1.compareTo(t_dDev2) > 0) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        return t_lAS;
    }

    private List<AnnotatedIon> sortInformationByDeviation(AnnotationInformationUnit a_unit) {
        List<AnnotatedIon> t_lInfo = a_unit.getAnnotationInfo();
        Collections.sort(t_lInfo, new Comparator<AnnotatedIon>(){

            @Override
            public int compare(AnnotatedIon o1, AnnotatedIon o2) {
                BigDecimal t_dDev2;
                BigDecimal t_dDev1 = new BigDecimal(o1.getDeviation());
                if (t_dDev1.compareTo(t_dDev2 = new BigDecimal(o2.getDeviation())) < 0) {
                    return -1;
                }
                if (t_dDev1.compareTo(t_dDev2) > 0) {
                    return 1;
                }
                return 0;
            }
        });
        return t_lInfo;
    }

    private List<String> getPeakArray(String t_strHead, Peak a_peak) {
        return Arrays.asList(t_strHead, this.roundDouble(a_peak.getMz(), 5), this.roundDouble(a_peak.getIntensity(), 2), a_peak.getRelativeIntensity() == null ? "--" : this.roundDouble(a_peak.getRelativeIntensity() * 100.0, 2));
    }

    private String roundDouble(double value, int places) {
        return new BigDecimal(value).setScale(places, 4).toPlainString();
    }

    private void convertGWBSequenceToImage(Sheet a_sheet, int a_iRow, int a_iCol) {
        Cell t_cell = a_sheet.getRow(a_iRow).getCell(a_iCol);
        if (t_cell == null || t_cell.getStringCellValue().isEmpty()) {
            return;
        }
        if (this.setGWBSequenceImage(a_sheet, a_iRow, a_iCol, t_cell.getStringCellValue())) {
            t_cell.setCellValue("");
        }
    }

    private boolean setGWBSequenceImage(Sheet a_sheet, int a_iRow, int a_iCol, String a_strGWBSeq) {
        BufferedImage t_img;
        block3: {
            try {
                System.out.println("Generate image of " + a_strGWBSeq);
                t_img = this.getGWBSequenceImage(a_strGWBSeq);
                if (t_img != null) break block3;
                return false;
            }
            catch (Exception e) {
                logger.error((Object)"An error in converting GWB sequence in the cell to image", (Throwable)e);
                return false;
            }
        }
        System.out.println("Add image No." + this.m_lPictures.size() + " to " + a_iRow + "," + a_iCol + " in " + a_sheet.getSheetName());
        this.m_helper.writeCellImage(this.m_book, a_sheet, a_iRow, a_iCol, t_img, this.m_lPictures);
        return true;
    }

    private BufferedImage getGWBSequenceImage(String a_strGWBSeq) throws Exception {
        if (this.m_mapGWBSequenceToImage.containsKey(a_strGWBSeq)) {
            return this.m_mapGWBSequenceToImage.get(a_strGWBSeq);
        }
        ArrayList<String> t_lGWBSeqs = new ArrayList<String>();
        if (a_strGWBSeq.contains("\n")) {
            String[] stringArray = a_strGWBSeq.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String t_strGWBSeq = stringArray[n2];
                if (t_strGWBSeq.isEmpty()) {
                    return null;
                }
                t_lGWBSeqs.add(t_strGWBSeq);
                ++n2;
            }
        }
        BufferedImage t_img = this.m_helper.createGlycanImage(t_lGWBSeqs, null, false, true, Double.valueOf(0.5));
        this.m_mapGWBSequenceToImage.put(a_strGWBSeq, t_img);
        return t_img;
    }
}

