/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.gsl.dango;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.grits.toolbox.ms.annotation.structure.GlycanPreDefinedOptions;
import org.grits.toolbox.ms.om.data.LipidSettings;
import org.grits.toolbox.tools.gsl.database.lipid.LipidData;
import org.grits.toolbox.tools.gsl.database.lipid.LipidDatabase;
import org.grits.toolbox.tools.gsl.structure.LipidFragmentInfo;
import org.grits.toolbox.tools.gsl.structure.LipidNameParser;
import org.grits.toolbox.tools.gsl.structure.lipid.Ceramide;
import org.grits.toolbox.tools.gsl.structure.lipid.ILipid;
import org.grits.toolbox.tools.gsl.structure.lipid.Sphingosine;
import org.grits.toolbox.tools.gsl.util.generator.structure.LipidFragmenter;
import org.grits.toolbox.tools.gsl.util.io.lipid.LipidDatabaseFileHandler;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalComposition;
import org.grits.toolbox.tools.gsl.util.mass.ChemicalCompositionProvider;

public class LipidAnnotationUtils {
    public static String getLipidComposition(String a_strLipName) {
        ILipid t_lip = LipidNameParser.parseLipidName(a_strLipName);
        if (t_lip == null) {
            return "";
        }
        return t_lip.getCompositionName();
    }

    public static List<String[]> getLipidFragments(String a_strLipName, String a_strFragmentType) {
        ArrayList<String[]> t_lLipFrags = new ArrayList<String[]>();
        ILipid t_lip = LipidNameParser.parseLipidName(a_strLipName);
        if (t_lip == null) {
            return t_lLipFrags;
        }
        LipidFragmenter t_lipFrager = new LipidFragmenter();
        for (LipidFragmentInfo t_fragInfo : t_lipFrager.fragment(t_lip)) {
            if (a_strFragmentType != null) {
                t_fragInfo.addFragmentType(a_strFragmentType);
            }
            String[] t_strLipFragInfo = new String[]{t_fragInfo.getFragment().getName(), t_fragInfo.getFragmentType()};
            t_lLipFrags.add(t_strLipFragInfo);
        }
        return t_lLipFrags;
    }

    public static List<String[]> getLipidFragments(String a_strLipName) {
        return LipidAnnotationUtils.getLipidFragments(a_strLipName, null);
    }

    public static BigDecimal calculateLipidMass(String a_strLipName, String t_strPerDerivType) {
        ILipid t_lip = LipidNameParser.parseLipidName(a_strLipName);
        if (t_lip == null) {
            return null;
        }
        ChemicalComposition t_ccLip = ChemicalCompositionProvider.getChemicalComposition(t_lip);
        if (t_strPerDerivType.equals(GlycanPreDefinedOptions.DERIVITIZATION_PERMETHYLATED)) {
            t_ccLip.derivatize();
        }
        return new BigDecimal(t_ccLip.getMonoisotopicMass());
    }

    public static List<String> getLipidNames(LipidSettings a_lSettings) {
        ArrayList<String> t_lLipNames = new ArrayList<String>();
        String t_strLDB = a_lSettings.getDatabase().getURI();
        LipidDatabase t_lDB = LipidDatabaseFileHandler.importXML(t_strLDB);
        if (t_lDB != null) {
            for (LipidData t_ld : t_lDB.getLipidData()) {
                t_lLipNames.add(t_ld.getCommonName());
            }
        }
        return t_lLipNames;
    }

    public static boolean canConnectToGlycan(String a_strLipName) {
        ILipid t_lip = LipidNameParser.parseLipidName(a_strLipName);
        if (!(t_lip instanceof Ceramide) && !(t_lip instanceof Sphingosine)) {
            return false;
        }
        int t_nOH = 0;
        if (t_lip instanceof Ceramide) {
            t_nOH = ((Ceramide)t_lip).getSphingosine().getNumberOfHydroxylGroups();
        }
        if (t_lip instanceof Sphingosine) {
            t_nOH = ((Sphingosine)t_lip).getNumberOfHydroxylGroups();
        }
        return t_nOH >= 1;
    }
}

