/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.dialog;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.sample.config.ImageRegistry;
import org.grits.toolbox.entry.sample.dialog.contentprovider.WorkspaceComponentsContentProvider;
import org.grits.toolbox.entry.sample.dialog.labelprovider.ChooseComponentTreeLabelProvider;
import org.grits.toolbox.entry.sample.model.Component;
import org.grits.toolbox.entry.sample.model.Sample;

public class SelectWorkspaceComponentsDialog
extends TitleAreaDialog {
    protected TreeViewer treeViewer = null;
    private Component selectedComponent = null;
    private Map<Entry, Sample> entryToSampleCacheMap = new HashMap<Entry, Sample>();

    public SelectWorkspaceComponentsDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Component");
        this.setMessage("Select component to copy");
        this.getShell().setSize(300, 550);
    }

    public Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(comp, 4);
        container.getShell().setImage(ImageRegistry.getImageDescriptor(ImageRegistry.SampleImage.ADD_COMPONENT_LAUNCHER_ICON).createImage());
        container.setLayout((Layout)new GridLayout());
        this.treeViewer = new TreeViewer(container, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 260;
        gd.heightHint = 330;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.treeViewer.getTree().setLayoutData((Object)gd);
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Tree tree = (Tree)e.getSource();
                Object selection = tree.getSelection()[0].getData();
                if (!(selection instanceof Component)) {
                    SelectWorkspaceComponentsDialog.this.getButton(0).setEnabled(false);
                } else {
                    SelectWorkspaceComponentsDialog.this.getButton(0).setEnabled(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new WorkspaceComponentsContentProvider(this.entryToSampleCacheMap));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ChooseComponentTreeLabelProvider());
        this.treeViewer.setAutoExpandLevel(3);
        this.treeViewer.setInput((Object)PropertyHandler.getDataModel().getRoot());
        return comp;
    }

    public Component getSelectedComponent() {
        return this.selectedComponent;
    }

    public void okPressed() {
        if (!this.treeViewer.getSelection().isEmpty()) {
            Component selectedComponent = (Component)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
            this.selectedComponent = selectedComponent.getACopy();
            super.okPressed();
        }
    }
}

