/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ScrollableEntryEditorPart;
import org.grits.toolbox.datamodel.ms.tablemodel.MassSpecTableDataObject;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationExternalQuantDialog;
import org.grits.toolbox.entry.ms.annotation.dialog.MSAnnotationStandardQuantApplyDialog;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationEntityProperty;
import org.grits.toolbox.entry.ms.annotation.property.MSAnnotationProperty;
import org.grits.toolbox.entry.ms.annotation.property.datamodel.MSAnnotationMetaData;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.dialog.MassSpecPeakIntensityApplyDialog;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuant;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecStandardQuantPeak;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.property.MassSpecProperty;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantAlias;
import org.grits.toolbox.entry.ms.property.datamodel.ExternalQuantFileToAlias;
import org.grits.toolbox.entry.ms.property.datamodel.MSPropertyDataFile;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecMetaData;
import org.grits.toolbox.entry.ms.property.datamodel.MassSpecUISettings;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFilePeaksToCorrectedIntensities;
import org.grits.toolbox.entry.ms.property.datamodel.QuantFileToCorrectedPeaks;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecMultiPageViewer;

public abstract class MSAnnotationQuantificationView
extends ScrollableEntryEditorPart
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MSAnnotationQuantificationView.class);
    private MPart part;
    private Composite parent;
    private Composite container;
    protected Color sectionColor;
    protected Color backgroundColor;
    private TableViewer extQuantTableViewer;
    private MassSpecUISettings entrySettings;
    protected MassSpecPreference localStandardQuant;
    protected MassSpecPreference entryStandardQuant;
    private TableViewer standardPeaksTable;
    private TreeViewer standardFilesTable;
    private Table peakIntensityTable;
    private static String[] columnHeaders = new String[]{"File Name", "Type", "m/z", "Corrected Intensity"};

    @Inject
    public MSAnnotationQuantificationView(Entry entry) {
        this.entry = entry;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.setPart(part);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite c = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 6;
        c.setLayout((Layout)layout);
        this.parent = parent.getParent().getParent();
        this.container = c;
        try {
            this.addOtherSettings();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding property elements.", (Throwable)e);
        }
        sc.setContent((Control)c);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    protected void addOtherSettings() {
        this.sectionColor = new Color((Device)Display.getCurrent(), 20, 199, 255);
        this.backgroundColor = Display.getCurrent().getSystemColor(22);
        this.createExternalQuantificationSection();
        this.createStandardQuantificationSection();
        this.createIntensitiesSection();
    }

    protected void createExternalQuantificationSection() {
        Section section = new Section(this.getContainer(), 324);
        section.setText("External Quantifications");
        section.setTitleBarBackground(this.sectionColor);
        section.setBackground(this.backgroundColor);
        section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        section.setLayoutData((Object)gridData);
        Composite sectionComposite = new Composite((Composite)section, 64);
        sectionComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 4));
        sectionComposite.setLayout((Layout)new GridLayout(3, false));
        sectionComposite.setBackground(this.backgroundColor);
        sectionComposite.setBackgroundMode(2);
        List<MSPropertyDataFile> quantFiles = this.getQuantificationFiles();
        this.entrySettings = this.getEntrySettings();
        this.extQuantTableViewer = new TableViewer(sectionComposite);
        this.extQuantTableViewer.getTable().setHeaderVisible(true);
        this.extQuantTableViewer.getTable().setLinesVisible(true);
        GridData gd_table_2 = new GridData(4, 4, true, true, 3, 1);
        gd_table_2.heightHint = 100;
        this.extQuantTableViewer.getTable().setLayoutData((Object)gd_table_2);
        TableViewerColumn fileNameCol = new TableViewerColumn(this.extQuantTableViewer, 0);
        fileNameCol.getColumn().setText("File");
        fileNameCol.getColumn().setWidth(250);
        fileNameCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    MSPropertyDataFile mspdf = (MSPropertyDataFile)element;
                    String sFileName = MSPropertyDataFile.getFormattedName((MSPropertyDataFile)mspdf);
                    return sFileName;
                }
                return "";
            }
        });
        TableViewerColumn fileTypeCol = new TableViewerColumn(this.extQuantTableViewer, 0);
        fileTypeCol.getColumn().setText("Type");
        fileTypeCol.getColumn().setWidth(100);
        fileTypeCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    return ((MSPropertyDataFile)element).getType();
                }
                return "";
            }
        });
        TableViewerColumn fileAliasCol = new TableViewerColumn(this.extQuantTableViewer, 0);
        fileAliasCol.getColumn().setText("Alias");
        fileAliasCol.getColumn().setWidth(200);
        fileAliasCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    MSPropertyDataFile mspdf = (MSPropertyDataFile)element;
                    String sExtQuantType = MassSpecUISettings.getExternalQuantType((MSPropertyDataFile)mspdf);
                    String sFilePath = mspdf.getName();
                    ExternalQuantFileToAlias mAliases = MSAnnotationQuantificationView.this.entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                    String sAlias = MSPropertyDataFile.getFormattedName((MSPropertyDataFile)mspdf);
                    if (mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath)) {
                        ExternalQuantAlias aliasInfo = (ExternalQuantAlias)mAliases.getSourceDataFileNameToAlias().get(sFilePath);
                        sAlias = aliasInfo.getAlias();
                    }
                    return sAlias;
                }
                return "";
            }
        });
        TableViewerColumn fileInUseCol = new TableViewerColumn(this.extQuantTableViewer, 0);
        fileInUseCol.getColumn().setText("Applied?");
        fileInUseCol.getColumn().setWidth(80);
        fileInUseCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    MSPropertyDataFile mspdf = (MSPropertyDataFile)element;
                    String sExtQuantType = MassSpecUISettings.getExternalQuantType((MSPropertyDataFile)mspdf);
                    String sFilePath = mspdf.getName();
                    ExternalQuantFileToAlias mAliases = MSAnnotationQuantificationView.this.entrySettings.getExternalQuantToAliasByQuantType(sExtQuantType);
                    boolean isInUse = mAliases != null && mAliases.getSourceDataFileNameToAlias().containsKey(sFilePath);
                    return isInUse ? "Yes" : "No";
                }
                return "N/A";
            }
        });
        this.extQuantTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.extQuantTableViewer.setInput(quantFiles);
        this.createButton(sectionComposite);
        section.setClient((Control)sectionComposite);
    }

    void createButton(Composite parent) {
        Button editButton = new Button(parent, 8);
        editButton.setText("Add/Modify External Quantifications");
        GridData gd = new GridData(131072, 4, false, true, 3, 1);
        if (this.entry.getParent() != null && this.entry.getParent().getProperty() instanceof MSAnnotationEntityProperty) {
            editButton.setEnabled(true);
        } else {
            editButton.setEnabled(false);
        }
        editButton.setLayoutData((Object)gd);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSAnnotationMultiPageViewer curView = MSAnnotationQuantificationView.this.getCurrentViewer();
                if (curView == null) {
                    return;
                }
                MSAnnotationQuantificationView.this.openExternalQuantDialog(curView);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected abstract void openExternalQuantDialog(MSAnnotationMultiPageViewer var1);

    protected abstract void openStandardQuantDialog(MSAnnotationMultiPageViewer var1);

    protected abstract void initializeStandardQuantifications();

    protected List<MSPropertyDataFile> getQuantificationFiles() {
        MassSpecProperty msp = ((MSAnnotationEntityProperty)this.entry.getProperty()).getMassSpecParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings.getQuantificationFiles();
    }

    protected List<MSPropertyDataFile> getStandardQuantificationFiles() {
        MassSpecProperty msp = ((MSAnnotationEntityProperty)this.entry.getProperty()).getMassSpecParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        ArrayList<MSPropertyDataFile> fileList = new ArrayList<MSPropertyDataFile>();
        fileList.addAll(entrySettings.getAnnotationFiles());
        fileList.addAll(entrySettings.getQuantificationFiles());
        return fileList;
    }

    protected MassSpecUISettings getEntrySettings() {
        MSAnnotationEntityProperty msep = (MSAnnotationEntityProperty)this.entry.getProperty();
        MSAnnotationProperty msap = msep.getMSAnnotationParentProperty();
        MSAnnotationMetaData entrySettings = msap.getMSAnnotationMetaData();
        return entrySettings;
    }

    protected void createStandardQuantificationSection() {
        Section section = new Section(this.getContainer(), 324);
        section.setText("Standard Quantifications");
        section.setTitleBarBackground(this.sectionColor);
        section.setBackground(this.backgroundColor);
        section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        section.setLayoutData((Object)gridData);
        Composite sectionComposite = new Composite((Composite)section, 64);
        sectionComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 4));
        sectionComposite.setLayout((Layout)new GridLayout(6, false));
        sectionComposite.setBackground(this.backgroundColor);
        sectionComposite.setBackgroundMode(2);
        this.initializeStandardQuantifications();
        List<MassSpecStandardQuantPeak> peakList = this.createPeakList();
        this.standardPeaksTable = new TableViewer(sectionComposite);
        this.standardPeaksTable.getTable().setLinesVisible(true);
        this.standardPeaksTable.getTable().setHeaderVisible(true);
        GridData gd_table_2 = new GridData(4, 4, true, true, 2, 1);
        gd_table_2.heightHint = 100;
        this.standardPeaksTable.getTable().setLayoutData((Object)gd_table_2);
        TableViewerColumn stdQuantName = new TableViewerColumn(this.standardPeaksTable, 0);
        stdQuantName.getColumn().setText("Standard Quantification");
        stdQuantName.getColumn().setWidth(150);
        stdQuantName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecStandardQuantPeak) {
                    return MSAnnotationQuantificationView.this.findStandardQuantNameForPeak((MassSpecStandardQuantPeak)element);
                }
                return "";
            }
        });
        TableViewerColumn peakMz = new TableViewerColumn(this.standardPeaksTable, 0);
        peakMz.getColumn().setText("Peak M/z");
        peakMz.getColumn().setWidth(100);
        peakMz.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecStandardQuantPeak) {
                    return ((MassSpecStandardQuantPeak)element).getPeakMz() == null ? "" : ((MassSpecStandardQuantPeak)element).getPeakMz().toString();
                }
                return "";
            }
        });
        TableViewerColumn peakLabel = new TableViewerColumn(this.standardPeaksTable, 0);
        peakLabel.getColumn().setText("Peak Label");
        peakLabel.getColumn().setWidth(100);
        peakLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecStandardQuantPeak) {
                    return ((MassSpecStandardQuantPeak)element).getPeakLabel();
                }
                return "";
            }
        });
        TableViewerColumn msLabel = new TableViewerColumn(this.standardPeaksTable, 0);
        msLabel.getColumn().setText("MS Level");
        msLabel.getColumn().setWidth(100);
        msLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecStandardQuantPeak) {
                    return ((MassSpecStandardQuantPeak)element).getMSLevel() == null ? "" : ((MassSpecStandardQuantPeak)element).getMSLevel().toString();
                }
                return "";
            }
        });
        this.standardPeaksTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.standardPeaksTable.setInput(peakList);
        this.standardFilesTable = new TreeViewer(sectionComposite);
        this.standardFilesTable.getTree().setLinesVisible(true);
        this.standardFilesTable.getTree().setHeaderVisible(true);
        GridData gd_table = new GridData(4, 4, true, true, 4, 1);
        gd_table.heightHint = 100;
        this.standardFilesTable.getTree().setLayoutData((Object)gd_table);
        TreeViewerColumn stdQuantName2 = new TreeViewerColumn(this.standardFilesTable, 0);
        stdQuantName2.getColumn().setText("Standard Quantification");
        stdQuantName2.getColumn().setWidth(150);
        stdQuantName2.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Map.Entry) {
                    return (String)((Map.Entry)element).getKey();
                }
                return "";
            }
        });
        TreeViewerColumn fileName = new TreeViewerColumn(this.standardFilesTable, 0);
        fileName.getColumn().setText("Quantification File");
        fileName.getColumn().setWidth(350);
        fileName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MSPropertyDataFile) {
                    return MSPropertyDataFile.getFormattedName((MSPropertyDataFile)((MSPropertyDataFile)element));
                }
                return "";
            }
        });
        this.standardFilesTable.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                if (element instanceof Map.Entry) {
                    if ((List)((Map.Entry)element).getValue() == null) {
                        return false;
                    }
                    return ((List)((Map.Entry)element).getValue()).size() != 0;
                }
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Set) {
                    return ((Set)inputElement).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Set) {
                    ((Set)parentElement).toArray();
                } else if (parentElement instanceof Map.Entry) {
                    return ((List)((Map.Entry)parentElement).getValue()).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.initializeStandardFilesTable();
        this.createStandardButton(sectionComposite);
        section.setClient((Control)sectionComposite);
    }

    private void initializeStandardFilesTable() {
        List<MSPropertyDataFile> allFiles = this.getStandardQuantificationFiles();
        HashMap<String, List<MSPropertyDataFile>> usedFiles = this.getFilesWithStandardQuant(allFiles);
        this.standardFilesTable.setInput(usedFiles.entrySet());
        this.standardFilesTable.expandAll();
    }

    private HashMap<String, List<MSPropertyDataFile>> getFilesWithStandardQuant(List<MSPropertyDataFile> allFiles) {
        ExternalQuantFileToAlias mAliases;
        List<Object> files;
        HashMap<String, List<MSPropertyDataFile>> map = new HashMap<String, List<MSPropertyDataFile>>();
        for (MassSpecStandardQuant std : this.entryStandardQuant.getStandardQuant()) {
            files = (ArrayList)map.get(std.getStandardQuantName());
            if (files == null) {
                files = new ArrayList();
            }
            for (MSPropertyDataFile f : allFiles) {
                mAliases = this.entrySettings.getInternalQuantFileToAlias(std.getStandardQuantName(), f);
                if (mAliases == null || !mAliases.getSourceDataFileNameToAlias().containsKey(f.getName()) || files.contains(f)) continue;
                files.add(f);
            }
            map.put(std.getStandardQuantName(), files);
        }
        for (MassSpecStandardQuant std : this.localStandardQuant.getStandardQuant()) {
            files = map.get(std.getStandardQuantName());
            if (files == null) {
                files = new ArrayList();
            }
            for (MSPropertyDataFile f : allFiles) {
                mAliases = this.entrySettings.getInternalQuantFileToAlias(std.getStandardQuantName(), f);
                if (mAliases == null || !mAliases.getSourceDataFileNameToAlias().containsKey(f.getName()) || files.contains(f)) continue;
                files.add(f);
            }
            map.put(std.getStandardQuantName(), files);
        }
        return map;
    }

    protected String findStandardQuantNameForPeak(MassSpecStandardQuantPeak peak) {
        String name = "";
        for (MassSpecStandardQuant std : this.localStandardQuant.getStandardQuant()) {
            if (!std.getStandardQuantPeaks().values().contains(peak)) continue;
            name = std.getStandardQuantName();
            break;
        }
        if (name.isEmpty()) {
            for (MassSpecStandardQuant std : this.entryStandardQuant.getStandardQuant()) {
                if (!std.getStandardQuantPeaks().values().contains(peak)) continue;
                name = std.getStandardQuantName();
                break;
            }
        }
        return name;
    }

    private List<MassSpecStandardQuantPeak> createPeakList() {
        ArrayList<MassSpecStandardQuantPeak> peakList = new ArrayList<MassSpecStandardQuantPeak>();
        for (MassSpecStandardQuant std : this.localStandardQuant.getStandardQuant()) {
            for (MassSpecStandardQuantPeak peak : std.getStandardQuantPeaks().values()) {
                if (peakList.contains(peak)) continue;
                peakList.add(peak);
            }
        }
        for (MassSpecStandardQuant std : this.entryStandardQuant.getStandardQuant()) {
            for (MassSpecStandardQuantPeak peak : std.getStandardQuantPeaks().values()) {
                if (peakList.contains(peak)) continue;
                peakList.add(peak);
            }
        }
        return peakList;
    }

    void createStandardButton(Composite parent) {
        Button editButton = new Button(parent, 8);
        editButton.setText("Add/Modify Standard Quantifications");
        GridData gd = new GridData(131072, 4, false, true, 6, 1);
        if (this.entry.getParent() != null && this.entry.getParent().getProperty() instanceof MSAnnotationEntityProperty) {
            editButton.setEnabled(true);
        } else {
            editButton.setEnabled(false);
        }
        editButton.setLayoutData((Object)gd);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSAnnotationMultiPageViewer curView = MSAnnotationQuantificationView.this.getCurrentViewer();
                if (curView == null) {
                    return;
                }
                MSAnnotationQuantificationView.this.openStandardQuantDialog(curView);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createIntensitiesSection() {
        Section section = new Section(this.getContainer(), 324);
        section.setText("Overridden Intensities");
        section.setTitleBarBackground(this.sectionColor);
        section.setBackground(this.backgroundColor);
        section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        section.setLayoutData((Object)gridData);
        Composite sectionComposite = new Composite((Composite)section, 64);
        sectionComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 4));
        sectionComposite.setLayout((Layout)new GridLayout(3, false));
        sectionComposite.setBackground(this.backgroundColor);
        sectionComposite.setBackgroundMode(2);
        this.peakIntensityTable = new Table(sectionComposite, 0);
        this.peakIntensityTable.setLinesVisible(true);
        this.peakIntensityTable.setHeaderVisible(true);
        GridData gd_table_2 = new GridData(4, 4, true, true, 3, 1);
        gd_table_2.heightHint = 100;
        this.peakIntensityTable.setLayoutData((Object)gd_table_2);
        int i = 0;
        String[] stringArray = columnHeaders;
        int n = columnHeaders.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            TableColumn col = new TableColumn(this.peakIntensityTable, 0);
            col.setText(string);
            if (i == 0) {
                col.setWidth(250);
            } else {
                col.setWidth(100);
            }
            ++i;
            ++n2;
        }
        this.initializeCorrectedIntensities();
        this.createIntensityButton(sectionComposite);
        section.setClient((Control)sectionComposite);
    }

    private void initializeCorrectedIntensities() {
        MassSpecUISettings entrySettings = this.getSourceMassSpecEntrySettings();
        if (entrySettings.getQuantFileToCorrectedPeaks() != null) {
            for (String file : entrySettings.getQuantFileToCorrectedPeaks().keySet()) {
                QuantFileToCorrectedPeaks correctedPeak = (QuantFileToCorrectedPeaks)entrySettings.getQuantFileToCorrectedPeaks().get(file);
                for (String type : correctedPeak.getPeakTypeToMZs().keySet()) {
                    QuantFilePeaksToCorrectedIntensities correctedIntensity = (QuantFilePeaksToCorrectedIntensities)correctedPeak.getPeakTypeToMZs().get(type);
                    for (Double peakMz : correctedIntensity.getPeakMzToIntensity().keySet()) {
                        Double intensity = (Double)correctedIntensity.getPeakMzToIntensity().get(peakMz);
                        TableItem item = new TableItem(this.peakIntensityTable, 0);
                        item.setText(0, file);
                        item.setText(1, type);
                        item.setText(2, peakMz.toString());
                        item.setText(3, intensity.toString());
                    }
                }
            }
        }
    }

    protected void openIntensityDialog(MSAnnotationMultiPageViewer curView) {
        if (MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog == null || MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.getShell() == null || MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.getShell().isDisposed()) {
            MassSpecTableDataObject tdo = ((MassSpecTableDataProcessor)curView.getScansView().getTableDataProcessor()).getSimianTableDataObject();
            MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog = new MassSpecPeakIntensityApplyDialog(Display.getCurrent().getActiveShell(), (MassSpecMultiPageViewer)curView, tdo);
            MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.addListener((IPropertyChangeListener)curView);
            MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.addListener((IPropertyChangeListener)this);
            MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.open();
        } else {
            MassSpecMultiPageViewer.massSpecPeakIntensityApplyDialog.getShell().forceActive();
        }
    }

    void createIntensityButton(Composite parent) {
        Button editButton = new Button(parent, 8);
        editButton.setText("Edit Corrected Intensities");
        GridData gd = new GridData(131072, 4, false, true, 6, 1);
        if (this.entry.getParent() != null && this.entry.getParent().getProperty() instanceof MSAnnotationEntityProperty) {
            editButton.setEnabled(true);
        } else {
            editButton.setEnabled(false);
        }
        editButton.setLayoutData((Object)gd);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSAnnotationMultiPageViewer curView = MSAnnotationQuantificationView.this.getCurrentViewer();
                if (curView == null) {
                    return;
                }
                MSAnnotationQuantificationView.this.openIntensityDialog(curView);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public MassSpecUISettings getSourceMassSpecEntrySettings() {
        MassSpecProperty msp = ((MSAnnotationEntityProperty)this.entry.getProperty()).getMassSpecParentProperty();
        MassSpecMetaData entrySettings = msp.getMassSpecMetaData();
        return entrySettings;
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected void initializeComponents() {
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    public void setPart(MPart part) {
        this.part = part;
    }

    public MPart getPart() {
        return this.part;
    }

    public Composite getContainer() {
        return this.container;
    }

    protected MSAnnotationMultiPageViewer getCurrentViewer() {
        return MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.getPart().getContext(), this.entry);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof MSAnnotationExternalQuantDialog) {
            List<MSPropertyDataFile> quantFiles = this.getQuantificationFiles();
            this.entrySettings = this.getEntrySettings();
            this.extQuantTableViewer.setInput(quantFiles);
            this.extQuantTableViewer.refresh();
        } else if (event.getSource() instanceof MSAnnotationStandardQuantApplyDialog) {
            this.initializeStandardQuantifications();
            this.standardPeaksTable.setInput(this.createPeakList());
            this.standardPeaksTable.refresh();
            this.initializeStandardFilesTable();
            this.standardFilesTable.refresh();
        } else if (event.getSource() instanceof MassSpecPeakIntensityApplyDialog) {
            this.peakIntensityTable.removeAll();
            this.initializeCorrectedIntensities();
        }
    }
}

