/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.views.tabbed;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.editor.ScrollableEntryEditorPart;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationMultiPageViewer;
import org.grits.toolbox.entry.ms.preference.IMSPreferenceWithCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotation;
import org.grits.toolbox.entry.ms.preference.xml.MassSpecCustomAnnotationPeak;

public abstract class MSAnnotationOtherSettingsView
extends ScrollableEntryEditorPart {
    private static final Logger logger = Logger.getLogger(MSAnnotationOtherSettingsView.class);
    private MPart part;
    private Composite parent;
    private Composite container;
    protected Color sectionColor;
    protected Color backgroundColor;
    Map<String, TableViewer> peaksTableList = new HashMap<String, TableViewer>();
    Map<String, List<Control>> controlList = new HashMap<String, List<Control>>();
    private Button editButton;
    private Composite sectionComposite;
    private Section section;
    protected IMSPreferenceWithCustomAnnotation localAnnotations;
    protected IMSPreferenceWithCustomAnnotation entryAnnotations;

    @Inject
    public MSAnnotationOtherSettingsView(Entry entry) {
        this.entry = entry;
    }

    @PostConstruct
    public void postConstruct(MPart part) {
        this.setPart(part);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        ScrolledComposite sc = new ScrolledComposite(parent, 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite c = new Composite((Composite)sc, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        layout.numColumns = 6;
        c.setLayout((Layout)layout);
        this.parent = parent.getParent().getParent();
        this.container = c;
        try {
            this.addOtherSettings();
        }
        catch (Exception e) {
            logger.error((Object)"Error adding property elements.", (Throwable)e);
        }
        sc.setContent((Control)c);
        sc.setMinSize(c.computeSize(-1, -1));
    }

    protected void addOtherSettings() {
        this.sectionColor = new Color((Device)Display.getCurrent(), 20, 199, 255);
        this.backgroundColor = Display.getCurrent().getSystemColor(22);
        this.createCustomAnnotationSection();
    }

    protected void createCustomAnnotationSection() {
        HashSet peaks;
        this.section = new Section(this.getContainer(), 324);
        this.section.setText("Custom Annotations");
        this.section.setTitleBarBackground(this.sectionColor);
        this.section.setBackground(this.backgroundColor);
        this.section.setTitleBarForeground(Display.getCurrent().getSystemColor(10));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 6;
        this.section.setLayoutData((Object)gridData);
        this.sectionComposite = new Composite((Composite)this.section, 64);
        this.sectionComposite.setLayoutData((Object)new GridData(16384, 4, true, true, 6, 4));
        this.sectionComposite.setLayout((Layout)new GridLayout(3, false));
        this.sectionComposite.setBackground(this.backgroundColor);
        this.sectionComposite.setBackgroundMode(2);
        this.initializeCustomAnnotations();
        HashSet<String> processed = new HashSet<String>();
        for (MassSpecCustomAnnotation customAnnotation : this.entryAnnotations.getCustomAnnotations()) {
            peaks = new HashSet();
            if (processed.contains(customAnnotation.getAnnotationName())) continue;
            peaks.addAll(customAnnotation.getAnnotatedPeaks().values());
            this.createPeaksTable(this.sectionComposite, peaks, customAnnotation);
            processed.add(customAnnotation.getAnnotationName());
        }
        for (MassSpecCustomAnnotation customAnnotation : this.localAnnotations.getCustomAnnotations()) {
            if (processed.contains(customAnnotation.getAnnotationName())) continue;
            peaks = new HashSet();
            peaks.addAll(customAnnotation.getAnnotatedPeaks().values());
            this.createPeaksTable(this.sectionComposite, peaks, customAnnotation);
            processed.add(customAnnotation.getAnnotationName());
        }
        this.createButton(this.sectionComposite);
        this.section.setClient((Control)this.sectionComposite);
    }

    void createButton(Composite parent) {
        this.editButton = new Button(parent, 8);
        this.editButton.setText("Add/Modify Custom Annotations");
        GridData gd = new GridData(131072, 4, false, true, 3, 1);
        final MSAnnotationMultiPageViewer curView = this.getCurrentViewer();
        if (curView == null) {
            this.editButton.setEnabled(false);
        }
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MSAnnotationOtherSettingsView.this.openModifyDialog(curView);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected abstract void openModifyDialog(MSAnnotationMultiPageViewer var1);

    protected abstract void initializeCustomAnnotations();

    void createPeaksTable(Composite parent, Set<?> input, MassSpecCustomAnnotation annotation) {
        Label customAnnotLabel = new Label(parent, 1);
        customAnnotLabel.setText("Custom Annotation Name:");
        Text customAnnotName = new Text(parent, 2048);
        customAnnotName.setEditable(false);
        customAnnotName.setText(annotation.getAnnotationName());
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        customAnnotName.setLayoutData((Object)gd);
        Label customAnnotDescLabel = new Label(parent, 1);
        customAnnotDescLabel.setText("Description");
        Text customAnnotDescription = new Text(parent, 2048);
        customAnnotDescription.setText(annotation.getDescription());
        customAnnotDescription.setEditable(false);
        gd = new GridData(4, 4, true, true, 2, 3);
        customAnnotDescription.setLayoutData((Object)gd);
        List<Control> existing = this.controlList.get(annotation.getAnnotationName());
        if (existing == null) {
            existing = new ArrayList<Control>();
            existing.add((Control)customAnnotLabel);
            existing.add((Control)customAnnotName);
            existing.add((Control)customAnnotDescLabel);
            existing.add((Control)customAnnotDescription);
            this.controlList.put(annotation.getAnnotationName(), existing);
        }
        TableViewer peaksTable = new TableViewer(parent);
        GridData gd_table_2 = new GridData(4, 4, true, true, 3, 1);
        gd_table_2.heightHint = 100;
        peaksTable.getTable().setLayoutData((Object)gd_table_2);
        peaksTable.getTable().setHeaderVisible(true);
        peaksTable.getTable().setLinesVisible(true);
        TableViewerColumn peakMz = new TableViewerColumn(peaksTable, 0);
        peakMz.getColumn().setText("Peak M/z");
        peakMz.getColumn().setWidth(100);
        peakMz.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecCustomAnnotationPeak) {
                    return ((MassSpecCustomAnnotationPeak)element).getPeakMz() == null ? "" : ((MassSpecCustomAnnotationPeak)element).getPeakMz().toString();
                }
                return "";
            }
        });
        TableViewerColumn peakLabel = new TableViewerColumn(peaksTable, 0);
        peakLabel.getColumn().setText("Peak Label");
        peakLabel.getColumn().setWidth(100);
        peakLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecCustomAnnotationPeak) {
                    return ((MassSpecCustomAnnotationPeak)element).getPeakLabel();
                }
                return "";
            }
        });
        TableViewerColumn msLabel = new TableViewerColumn(peaksTable, 0);
        msLabel.getColumn().setText("MS Level");
        msLabel.getColumn().setWidth(100);
        msLabel.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof MassSpecCustomAnnotationPeak) {
                    return ((MassSpecCustomAnnotationPeak)element).getMSLevel() == null ? "" : ((MassSpecCustomAnnotationPeak)element).getMSLevel().toString();
                }
                return "";
            }
        });
        peaksTable.setContentProvider((IContentProvider)new ArrayContentProvider());
        peaksTable.setInput(input);
        this.peaksTableList.put(annotation.getAnnotationName(), peaksTable);
    }

    protected void refreshCustomAnnotations() {
        TableViewer currentPeaksTable;
        boolean needLayout = false;
        String toBeRemoved = null;
        for (String customAnnotName : this.peaksTableList.keySet()) {
            currentPeaksTable = this.peaksTableList.get(customAnnotName);
            boolean found = false;
            for (MassSpecCustomAnnotation customAnnotation : this.entryAnnotations.getCustomAnnotations()) {
                if (!customAnnotName.equals(customAnnotation.getAnnotationName())) continue;
                found = true;
                if (currentPeaksTable.getTable().isDisposed()) continue;
                currentPeaksTable.setInput(customAnnotation.getAnnotatedPeaks().values());
                currentPeaksTable.refresh();
            }
            if (found) continue;
            currentPeaksTable.getControl().dispose();
            List<Control> controls = this.controlList.get(customAnnotName);
            if (controls != null) {
                for (Control control : controls) {
                    control.dispose();
                }
            }
            toBeRemoved = customAnnotName;
            needLayout = true;
        }
        if (toBeRemoved != null) {
            this.peaksTableList.remove(toBeRemoved);
            this.controlList.remove(toBeRemoved);
        }
        for (MassSpecCustomAnnotation customAnnotation : this.entryAnnotations.getCustomAnnotations()) {
            currentPeaksTable = this.peaksTableList.get(customAnnotation.getAnnotationName());
            if (currentPeaksTable != null) continue;
            needLayout = true;
            HashSet peaks = new HashSet();
            peaks.addAll(customAnnotation.getAnnotatedPeaks().values());
            this.createPeaksTable(this.sectionComposite, peaks, customAnnotation);
        }
        if (needLayout) {
            this.editButton.dispose();
            this.createButton(this.sectionComposite);
            this.sectionComposite.layout(true, true);
            this.sectionComposite.redraw();
            this.section.layout(true, true);
            this.section.setSize(this.sectionComposite.computeSize(-1, -1));
        }
    }

    protected Composite getParent() {
        return this.parent;
    }

    protected void initializeComponents() {
    }

    protected void updateProjectProperty() {
    }

    protected void savePreference() {
    }

    public void setPart(MPart part) {
        this.part = part;
    }

    public MPart getPart() {
        return this.part;
    }

    public Composite getContainer() {
        return this.container;
    }

    protected MSAnnotationMultiPageViewer getCurrentViewer() {
        return MSAnnotationMultiPageViewer.getActiveViewerForEntry(this.getPart().getContext(), this.entry.getParent());
    }
}

