/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed;

import org.apache.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationEntityScroller;
import org.grits.toolbox.entry.ms.annotation.glycan.views.tabbed.MSGlycanAnnotationSpectraView;
import org.grits.toolbox.entry.ms.annotation.process.loader.MSAnnotationTableDataProcessor;
import org.grits.toolbox.entry.ms.annotation.views.tabbed.MSAnnotationSpectraControlPanelView;
import org.grits.toolbox.entry.ms.process.loader.MassSpecTableDataProcessor;
import org.grits.toolbox.entry.ms.views.tabbed.MassSpecSpectraView;
import org.grits.toolbox.ms.om.data.Annotation;
import org.grits.toolbox.ms.om.data.Feature;
import org.grits.toolbox.ms.om.data.Scan;

public class MSGlycanAnnotationSpectraControlPanelView
extends MSAnnotationSpectraControlPanelView {
    private static final Logger logger = Logger.getLogger(MSGlycanAnnotationSpectraControlPanelView.class);
    protected Button cbLabelsAsImages = null;
    protected MSGlycanAnnotationEntityScroller entityScroller = null;
    private int iMyCurView = -1;

    public MSGlycanAnnotationSpectraControlPanelView(MassSpecSpectraView parentView) {
        super(parentView);
    }

    public MSGlycanAnnotationEntityScroller getEntityScroller() {
        return this.entityScroller;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    protected GridLayout getNewGridLayout() {
        MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
        if (view.getDetailsView() == null) {
            return super.getNewGridLayout();
        }
        return new GridLayout(4, false);
    }

    protected void setMSGlycanAnnotationElements() {
        MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
        if (view.getDetailsView() == null) {
            return;
        }
        this.entityScroller = this.getNewMSAnnotationEntityScroller();
        RowLayout rowLayout = new RowLayout();
        this.entityScroller.setLayout((Layout)rowLayout);
        this.entityScroller.createPartControl((Composite)this.entityScroller);
        this.entityScroller.getNextButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                MSGlycanAnnotationSpectraControlPanelView.this.goNext();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.entityScroller.getPrevButton().addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                MSGlycanAnnotationSpectraControlPanelView.this.goPrev();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.entityScroller.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                MSGlycanAnnotationSpectraControlPanelView.this.updateView();
                MSGlycanAnnotationSpectraControlPanelView.this.entityScroller.removePaintListener(this);
            }
        });
        GridData gd = new GridData(0x1000008, 1, true, true, 1, 4);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.entityScroller.reDraw();
        this.entityScroller.setLayoutData(gd);
    }

    protected void addElements() {
        this.setMSElements();
        this.setMSGlycanAnnotationElements();
        this.setPickedPeaksElements();
        this.setAnnotatedElements();
        this.setUnAnnotatedElements();
    }

    public void setCurViewIndex(int iMyCurView) {
        this.iMyCurView = iMyCurView;
    }

    public int getCurViewIndex() {
        return this.iMyCurView;
    }

    protected MSGlycanAnnotationEntityScroller getNewMSAnnotationEntityScroller() {
        MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
        return new MSGlycanAnnotationEntityScroller(this.parent, 0, view.getDetailsView(), view.getDetailsView().getCartoonOptions());
    }

    public void updateView() {
        try {
            MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
            if (view.getCurrentPeaksView() == null) {
                return;
            }
            view.setPeakListTableProcessor((MassSpecTableDataProcessor)((MSAnnotationTableDataProcessor)view.getCurrentPeaksView().getTableDataProcessor()));
            view.createThisChart();
            Feature curFeature = (Feature)view.getDetailsView().getFeatures().get(this.iMyCurView);
            Annotation annot = ((MSAnnotationTableDataProcessor)view.getCurrentPeaksView().getTableDataProcessor()).getAnnotation(curFeature.getAnnotationId());
            Scan scan = ((MSAnnotationTableDataProcessor)view.getCurrentPeaksView().getTableDataProcessor()).getScan(view.getDetailsView().getMsEntityProperty().getScanNum());
            if (this.entityScroller == null) {
                return;
            }
            this.entityScroller.setFeature(curFeature);
            this.entityScroller.setAnnotation(annot);
            this.entityScroller.setScan(scan);
            this.entityScroller.reDraw();
        }
        catch (Exception e) {
            logger.error((Object)"Failed attempt to update view.", (Throwable)e);
        }
    }

    public void goNext() {
        try {
            ++this.iMyCurView;
            MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
            if (this.iMyCurView >= view.getDetailsView().getPeakComposites().size()) {
                this.iMyCurView = 0;
            }
            this.updateView();
        }
        catch (Exception e) {
            logger.error((Object)"Attempted to go to next page when at end of list", (Throwable)e);
        }
    }

    public void goPrev() {
        try {
            --this.iMyCurView;
            MSGlycanAnnotationSpectraView view = (MSGlycanAnnotationSpectraView)this.getParentView();
            if (this.iMyCurView < 0) {
                this.iMyCurView = view.getDetailsView().getPeakComposites().size() - 1;
            }
            this.updateView();
        }
        catch (Exception e) {
            logger.error((Object)"Attempted to go to prev page when at end of list", (Throwable)e);
        }
    }

    @Focus
    public void setFocus() {
    }
}

