/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.ms.preference;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.entry.ms.preference.MassSpecCustomAnnotationsPreferenceUI;
import org.grits.toolbox.entry.ms.preference.MassSpecPreference;

public class MassSpecCustomAnnotationPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    private static final Logger logger = Logger.getLogger(MassSpecCustomAnnotationPreferencePage.class);
    protected MassSpecCustomAnnotationsPreferenceUI customAnnotationPreference;
    protected MassSpecPreference preferences = (MassSpecPreference)MassSpecPreference.loadWorkspacePreferences();

    protected Control createContents(Composite parent) {
        this.customAnnotationPreference = new MassSpecCustomAnnotationsPreferenceUI(parent, 2048, this, false);
        this.customAnnotationPreference.setLocalAnnotations(this.preferences);
        this.customAnnotationPreference.initComponents();
        return parent;
    }

    public boolean isValid() {
        if (!this.customAnnotationPreference.isPageCompete()) {
            this.setErrorMessage(this.customAnnotationPreference.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void performApply() {
        this.save();
    }

    public boolean performOk() {
        this.save();
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setValid(this.isValid());
    }

    protected void save() {
        try {
            this.customAnnotationPreference.updateSettings();
            this.customAnnotationPreference.updatePreferences();
            logger.debug((Object)"Time to save values!");
            this.customAnnotationPreference.save();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void performDefaults() {
        boolean load = MessageDialog.openConfirm((Shell)this.getShell(), (String)"Are you sure?", (String)"This will remove all the preferences you've created and load the default ones if any. Do you want to continue?");
        if (load) {
            this.preferences = new MassSpecPreference();
            this.preferences.loadDefaultCustomAnnotations();
            this.preferences.saveValues();
            this.customAnnotationPreference.clearValues();
            this.customAnnotationPreference.initStoredAnnotations();
            this.customAnnotationPreference.initLocalAnnotations();
            this.customAnnotationPreference.processSelection(null);
            this.customAnnotationPreference.updateUI();
        }
    }
}

