/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.WURCSFramework.exec;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.TreeMap;
import org.glycoinfo.WURCSFramework.util.array.WURCSExporter;
import org.glycoinfo.WURCSFramework.util.array.WURCSImporter;
import org.glycoinfo.WURCSFramework.util.rdf.WURCSBasetype;
import org.glycoinfo.WURCSFramework.wurcs.array.UniqueRES;
import org.glycoinfo.WURCSFramework.wurcs.array.WURCSArray;

public class WURCSBaseTypeExample {
    public static void main(String[] args) throws Exception {
        String input = "WURCS=2.0/7,10,9/[x2122h-1x_1-5_2*NCC/3=O][12122h-1b_1-5_2*NCC/3=O][11122h-1b_1-5][21122h-1a_1-5][12112h-1b_1-5_2*NCC/3=O][12112h-1b_1-5][11221m-1a_1-5]/1-2-3-4-2-5-4-2-6-7/a4-b1_a6-j1_b4-c1_d2-e1_e4-f1_g2-h1_h4-i1_d1-c3|c6_g1-c3|c6";
        String file_WURCS = "20150210result-GlyTouCan_GlycoCTmfWURCS.txt";
        input = "src/org/glycoinfo/WURCSFramework/testresource/" + file_WURCS;
        if (input == null || input.equals("")) {
            throw new Exception();
        }
        TreeMap<Object, Object> wurcsIndex = new TreeMap();
        WURCSImporter ws = new WURCSImporter();
        File file = new File(input);
        if (file.isFile()) {
            wurcsIndex = WURCSBaseTypeExample.openString(input);
            try {
                StringBuilder sb = new StringBuilder();
                String t_strUniqueBasetypes = "";
                LinkedList<String> t_aUbasetype = new LinkedList<String>();
                for (String string : wurcsIndex.keySet()) {
                    WURCSArray wurcs = ws.extractWURCSArray((String)wurcsIndex.get(string));
                    WURCSExporter export = new WURCSExporter();
                    String AccessionNumber = string;
                    for (UniqueRES a_oURES : wurcs.getUniqueRESs()) {
                        String t_strBasetype = WURCSBasetype.getBasetype(a_oURES);
                        if (!t_aUbasetype.contains(t_strBasetype)) {
                            t_aUbasetype.add(t_strBasetype);
                        }
                        sb.append(AccessionNumber + "\t" + t_strBasetype + "\t" + export.getUniqueRESString(a_oURES) + "\n");
                        System.out.println(AccessionNumber + "\t" + t_strBasetype + "\t" + export.getUniqueRESString(a_oURES));
                    }
                }
                Collections.sort(t_aUbasetype);
                for (Object object : t_aUbasetype) {
                    t_strUniqueBasetypes = t_strUniqueBasetypes + object.toString() + "\n";
                }
                File savefile = new File("../../../testdata/WURCS-BaseType.txt");
                try {
                    savefile.createNewFile();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                if (savefile.isFile()) {
                    FileWriter fileWriter = new FileWriter(savefile);
                    fileWriter.write(t_strUniqueBasetypes + "\n\n## LIST\n" + sb.toString());
                    fileWriter.close();
                }
                System.out.println("Fin...");
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else if (input.indexOf("WURCS") != -1) {
            try {
                WURCSArray wurcs = ws.extractWURCSArray(input.substring(input.indexOf("W")));
                WURCSExporter export = new WURCSExporter();
                StringBuilder sb = new StringBuilder();
                for (UniqueRES uniqueRES : wurcs.getUniqueRESs()) {
                    String t_strBasetype = WURCSBasetype.getBasetype(uniqueRES);
                    sb.append(t_strBasetype + "\t" + export.getUniqueRESString(uniqueRES) + "\n");
                }
                File savefile = new File("../../../testdata/WURCS-BaseType.txt");
                try {
                    savefile.createNewFile();
                }
                catch (IOException iOException) {
                    System.out.println(iOException);
                }
                if (savefile.isFile()) {
                    FileWriter fileWriter = new FileWriter(savefile);
                    fileWriter.write(sb.toString());
                    fileWriter.close();
                }
                System.out.println("Fin...");
            }
            catch (IOException e) {
                System.out.println(e);
            }
        } else {
            throw new Exception("This file is not found");
        }
    }

    public static TreeMap<String, String> openString(String a_strFile) throws Exception {
        try {
            return WURCSBaseTypeExample.readWURCS(new BufferedReader(new FileReader(a_strFile)));
        }
        catch (IOException e) {
            throw new Exception();
        }
    }

    public static TreeMap<String, String> readWURCS(BufferedReader a_bfFile) throws IOException {
        String line = "";
        TreeMap<String, String> wret = new TreeMap<String, String>();
        wret.clear();
        while ((line = a_bfFile.readLine()) != null) {
            String[] IDandWURCS;
            line.trim();
            if (line.indexOf("WURCS") == -1 || (IDandWURCS = line.split("\t")).length != 2) continue;
            wret.put(IDandWURCS[0].trim(), IDandWURCS[1]);
        }
        a_bfFile.close();
        return wret;
    }
}

