/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.math.BigInteger;

public class PermutationGenerator {
    private int[] a;
    private int n;
    private int k;
    private BigInteger numLeft;
    private BigInteger total;

    public PermutationGenerator(int n) {
        this.n = n;
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    public void reset() {
        this.k = 0;
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    public BigInteger getTotal() {
        return this.total;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }

    private void swap(int[] a, int i, int j) {
        int h = a[i];
        a[i] = a[j];
        a[j] = h;
    }

    public int[] getNext() {
        if (this.numLeft.equals(BigInteger.ZERO)) {
            return null;
        }
        if (this.n > 1) {
            this.swap(this.a, this.k, this.k + 1);
            this.k = (this.k + 1) % (this.n - 1);
        }
        this.numLeft = this.numLeft.subtract(BigInteger.ONE);
        return this.a;
    }
}

