/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycanbuilder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.sax.TransformerHandler;
import org.eurocarbdb.application.glycanbuilder.BBoxManager;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.BaseWorkspace;
import org.eurocarbdb.application.glycanbuilder.DescendingDoubleComparator;
import org.eurocarbdb.application.glycanbuilder.ExtensionFileFilter;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.GWSParser;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanParser;
import org.eurocarbdb.application.glycanbuilder.GlycanParserFactory;
import org.eurocarbdb.application.glycanbuilder.GlycoCTCondensedParser;
import org.eurocarbdb.application.glycanbuilder.GlycoCTParser;
import org.eurocarbdb.application.glycanbuilder.Linkage;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.Residue;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.eurocarbdb.application.glycanbuilder.SAXUtils;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlycanDocument
extends BaseDocument
implements SAXUtils.SAXWriter {
    private BaseWorkspace theWorkspace = null;
    private Vector<Glycan> structures = new Vector();

    public GlycanDocument(BaseWorkspace workspace) {
        this.theWorkspace = workspace;
    }

    @Override
    public String getName() {
        return "Structures";
    }

    @Override
    public ImageIcon getIcon() {
        return FileUtils.themeManager.getImageIcon("glycandoc");
    }

    @Override
    public Collection<FileFilter> getFileFormats() {
        Vector<FileFilter> filters = new Vector<FileFilter>();
        filters.add(new ExtensionFileFilter("gws", "GlycoWorkbench structure file"));
        return filters;
    }

    @Override
    public FileFilter getAllFileFormats() {
        return new ExtensionFileFilter("gws", "Structure files");
    }

    @Override
    public boolean isEmpty() {
        return this.structures.size() == 0;
    }

    @Override
    public int size() {
        return this.structures.size();
    }

    public int getNoStructures() {
        return this.structures.size();
    }

    public Glycan getFirstStructure() {
        return this.structures.isEmpty() ? null : this.structures.firstElement();
    }

    public Glycan getLastStructure() {
        return this.structures.isEmpty() ? null : this.structures.lastElement();
    }

    public Glycan getStructure(int ind) {
        return this.structures.elementAt(ind);
    }

    public int indexOf(Glycan structure) {
        return this.structures.indexOf(structure);
    }

    public Vector<Glycan> getStructures() {
        return this.structures;
    }

    public Vector<Glycan> getStructures(int[] inds) {
        Vector<Glycan> ret = new Vector<Glycan>();
        for (int i = 0; i < inds.length; ++i) {
            ret.add(this.structures.elementAt(inds[i]));
        }
        return ret;
    }

    public Iterator<Glycan> iterator() {
        return this.structures.iterator();
    }

    public Glycan findStructureWith(Residue node) {
        if (node == null) {
            return null;
        }
        for (Glycan structure : this.structures) {
            if (!structure.contains(node)) continue;
            return structure;
        }
        return null;
    }

    public boolean isInComposition(Residue node) {
        Glycan s = this.findStructureWith(node);
        return s != null && s.isComposition();
    }

    public Collection<Glycan> findStructuresWith(Collection<Residue> nodes, Collection<Linkage> links) {
        Glycan toadd;
        Vector<Glycan> ret = new Vector<Glycan>();
        if (nodes != null) {
            for (Residue r : nodes) {
                toadd = this.findStructureWith(r);
                if (ret.contains(toadd)) continue;
                ret.add(toadd);
            }
        }
        if (links != null) {
            for (Linkage l : links) {
                toadd = this.findStructureWith(l.getChildResidue());
                if (ret.contains(toadd)) continue;
                ret.add(toadd);
            }
        }
        return ret;
    }

    public boolean contains(Residue node) {
        return this.findStructureWith(node) != null;
    }

    public void orderStructures(boolean descending) {
        if (this.structures.size() <= 1) {
            return;
        }
        TreeMap<Object, Vector<Glycan>> sorted_structures = new TreeMap();
        if (descending) {
            sorted_structures = new TreeMap(new DescendingDoubleComparator());
        }
        for (Glycan s : this.structures) {
            double mz = s.computeMZ();
            Vector<Glycan> vec = (Vector<Glycan>)sorted_structures.get(mz);
            if (vec == null) {
                vec = new Vector<Glycan>();
                sorted_structures.put(mz, vec);
            }
            vec.add(s);
        }
        this.structures.clear();
        for (Vector vec : sorted_structures.values()) {
            this.structures.addAll(vec);
        }
        this.fireDocumentChanged();
    }

    public void setStructure(Glycan _structure) {
        this.setStructure(_structure, true);
    }

    private void setStructure(Glycan _structure, boolean fire) {
        this.structures.clear();
        this.addStructure(_structure, false);
        if (fire) {
            this.fireDocumentChanged();
        }
    }

    public void setStructures(Collection<Glycan> _structures) {
        this.setStructures(_structures, true);
    }

    private void setStructures(Collection<Glycan> _structures, boolean fire) {
        this.structures.clear();
        this.addStructures(_structures, false);
        if (fire) {
            this.fireDocumentChanged();
        }
    }

    public Residue addStructure(Residue root) {
        return this.addStructure(root, true);
    }

    private Residue addStructure(Residue root, boolean fire) {
        if (root == null) {
            return null;
        }
        if (root.isReducingEnd() && !root.hasChildren()) {
            return null;
        }
        Glycan new_structure = new Glycan(root, true, this.theWorkspace.getDefaultMassOptions());
        this.structures.add(new_structure);
        if (fire) {
            this.fireDocumentChanged();
        }
        return new_structure.getRoot();
    }

    public void addStructure(Glycan _structure) {
        this.addStructure(_structure, true);
    }

    private void addStructure(Glycan _structure, boolean fire) {
        if (_structure != null && _structure.getRoot() != null) {
            this.structures.add(_structure.clone(true));
            if (fire) {
                this.fireDocumentChanged();
            }
        }
    }

    public void addStructures(Collection<Glycan> _structures) {
        this.addStructures(_structures, true);
    }

    private void addStructures(Collection<Glycan> _structures, boolean fire) {
        if (_structures != null && _structures.size() > 0) {
            for (Glycan _structure : _structures) {
                this.addStructure(_structure, false);
            }
            if (fire) {
                this.fireDocumentChanged();
            }
        }
    }

    public void removeStructure(int ind) {
        this.removeStructure(ind, true);
    }

    public void removeStructure(int ind, boolean fire) {
        this.structures.removeElementAt(ind);
        if (fire) {
            this.fireDocumentChanged();
        }
    }

    public void removeStructures(int[] inds) {
        this.removeStructures(inds, true);
    }

    public void removeStructures(int[] inds, boolean fire) {
        boolean removed = false;
        Vector<Glycan> toremove = this.getStructures(inds);
        Iterator<Glycan> i = this.structures.iterator();
        while (i.hasNext()) {
            if (!toremove.contains(i.next())) continue;
            i.remove();
            removed = true;
        }
        if (removed && fire) {
            this.fireDocumentChanged();
        }
    }

    public boolean setMassOptions(Collection<Glycan> structures, MassOptions common_options) {
        boolean changed = false;
        for (Glycan structure : structures) {
            changed |= structure.setMassOptions(common_options);
        }
        if (changed) {
            this.fireDocumentChanged();
        }
        return changed;
    }

    public Residue addResidue(Residue current, Residue toadd) {
        if (toadd == null || this.isInComposition(current)) {
            return null;
        }
        if (this.isEmpty() || current == null || current.isReducingEnd()) {
            return this.addStructure(toadd);
        }
        if (!current.addChild(toadd)) {
            return null;
        }
        this.fireDocumentChanged();
        return toadd;
    }

    public Residue addResidue(Residue current, Vector<Residue> linked, Residue toadd) {
        if (toadd == null || this.isInComposition(current)) {
            return null;
        }
        if (this.isEmpty() || current == null || current.isReducingEnd()) {
            return this.addStructure(toadd);
        }
        if (!current.addChild(toadd)) {
            return null;
        }
        if (linked != null) {
            for (Residue r : linked) {
                r.addChild(toadd.cloneSubtree());
            }
        }
        this.fireDocumentChanged();
        return toadd;
    }

    public Residue insertResidueBefore(Residue current, Residue toinsert) {
        if (toinsert == null || current == null || current.getParent() == null || this.isInComposition(current)) {
            return null;
        }
        if (!current.insertParent(toinsert)) {
            return null;
        }
        this.fireDocumentChanged();
        return toinsert;
    }

    public Residue insertResidueBefore(Residue current, Vector<Residue> linked, Residue toinsert) {
        if (toinsert == null || current == null || current.getParent() == null || this.isInComposition(current)) {
            return null;
        }
        if (!current.insertParent(toinsert)) {
            return null;
        }
        if (linked != null) {
            for (Residue r : linked) {
                r.insertParent(toinsert.cloneResidue());
            }
        }
        this.fireDocumentChanged();
        return toinsert;
    }

    public Residue addBracket(Residue current) {
        Residue bracket;
        Glycan structure = this.findStructureWith(current);
        if (structure != null && !structure.isComposition() && (bracket = structure.addBracket()) != null) {
            this.fireDocumentChanged();
            return bracket;
        }
        return null;
    }

    public boolean changeResidueType(Residue current, ResidueType new_type) {
        if (current == null || current.hasParent() && !new_type.canHaveParent() || !current.hasParent() && !new_type.canBeReducingEnd() || current.hasChildren() && !new_type.canHaveChildren() || this.isInComposition(current)) {
            return false;
        }
        current.setType(new_type);
        this.fireDocumentChanged();
        return true;
    }

    public boolean changeResidueType(Residue current, Vector<Residue> linked, ResidueType new_type) {
        if (current == null || current.hasParent() && !new_type.canHaveParent() || !current.hasParent() && !new_type.canBeReducingEnd() || current.hasChildren() && !new_type.canHaveChildren() || this.isInComposition(current)) {
            return false;
        }
        current.setType(new_type);
        if (linked != null) {
            for (Residue r : linked) {
                r.setType(new_type);
            }
        }
        this.fireDocumentChanged();
        return true;
    }

    private boolean changeReducingEndTypePVT(Glycan structure, ResidueType new_type) {
        if (structure != null) {
            return structure.setReducingEndType(new_type);
        }
        return false;
    }

    public boolean changeReducingEndType(Collection<Glycan> structures, ResidueType new_type) {
        boolean changed = false;
        for (Glycan s : structures) {
            changed |= this.changeReducingEndTypePVT(s, new_type);
        }
        if (changed) {
            this.fireDocumentChanged();
        }
        return changed;
    }

    public boolean changeReducingEndType(Residue current, ResidueType new_type) {
        Glycan structure = this.findStructureWith(current);
        if (this.changeReducingEndTypePVT(structure, new_type)) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    private boolean addStructuresPVT(Residue current, Collection<Glycan> toadd) {
        if (toadd == null || toadd.isEmpty()) {
            return false;
        }
        if (this.isEmpty() || current == null || current.isReducingEnd()) {
            this.addStructures(toadd, false);
        } else {
            Iterator<Glycan> i = toadd.iterator();
            while (i.hasNext()) {
                current.addChild(i.next().getRoot());
            }
            Vector<Residue> brackets = new Vector<Residue>();
            for (Glycan structure : toadd) {
                if (structure.getBracket() == null) continue;
                boolean found = false;
                Iterator l = brackets.iterator();
                while (l.hasNext()) {
                    if (!structure.getBracket().subtreeEquals((Residue)l.next())) continue;
                    found = true;
                }
                if (found) continue;
                brackets.add(structure.getBracket());
            }
            Glycan cur_structure = this.findStructureWith(current);
            for (Residue b : brackets) {
                for (Linkage link : b.getChildrenLinkages()) {
                    cur_structure.addAntenna(link.getChildResidue(), link.getBonds());
                }
            }
        }
        return true;
    }

    public void addStructures(Residue current, Collection<Glycan> toadd) {
        if (this.canAddStructures(current, toadd) && this.addStructuresPVT(current, toadd)) {
            this.fireDocumentChanged();
        }
    }

    public boolean canAddStructures(Residue current, HashSet<Residue> toadd) {
        return this.canAddStructures(current, this.extractView(toadd));
    }

    public boolean canAddStructures(Residue current, Collection<Glycan> toadd) {
        if (current == null) {
            return true;
        }
        if (this.isInComposition(current)) {
            return false;
        }
        if (current.isAntenna() || current.isBracket()) {
            for (Glycan s : toadd) {
                if (!s.isFuzzy()) continue;
                return false;
            }
        }
        if (current.isInRepetition()) {
            for (Glycan s : toadd) {
                if (!s.hasRepetition()) continue;
                return false;
            }
        }
        return true;
    }

    public void copyResidues(Residue current, HashSet<Residue> tocopy) {
        Vector<Glycan> cloned_structures = this.extractView(tocopy);
        if (this.canAddStructures(current, cloned_structures) && this.addStructuresPVT(current, cloned_structures)) {
            this.fireDocumentChanged();
        }
    }

    public void copyResidues(Residue current, Vector<Residue> linked, HashSet<Residue> tocopy) {
        Vector<Glycan> cloned_structures = this.extractView(tocopy);
        if (this.canAddStructures(current, cloned_structures) && this.addStructuresPVT(current, cloned_structures)) {
            if (linked != null) {
                for (Residue r : linked) {
                    this.addStructuresPVT(r, this.extractView(tocopy));
                }
            }
            this.fireDocumentChanged();
        }
    }

    public void moveResidues(Residue current, HashSet<Residue> tomove) {
        Vector<Glycan> cloned_structures = this.extractView(tomove);
        if (this.canAddStructures(current, cloned_structures) && this.addStructuresPVT(current, cloned_structures)) {
            this.removeResiduesPVT(tomove);
            this.fireDocumentChanged();
        }
    }

    public void moveResidues(Residue current, Vector<Residue> linked, HashSet<Residue> tomove) {
        Vector<Glycan> cloned_structures = this.extractView(tomove);
        if (this.canAddStructures(current, cloned_structures) && this.addStructuresPVT(current, cloned_structures)) {
            if (linked != null) {
                for (Residue r : linked) {
                    this.addStructuresPVT(r, this.extractView(tomove));
                }
            }
            this.removeResiduesPVT(tomove);
            this.fireDocumentChanged();
        }
    }

    private boolean removeResiduePVT(Residue toremove) {
        if (toremove == null) {
            return false;
        }
        for (int i = 0; i < this.structures.size(); ++i) {
            Glycan structure = this.structures.elementAt(i);
            if (!structure.removeResidue(toremove)) continue;
            if (structure.isEmpty()) {
                this.structures.removeElementAt(i);
            } else {
                Vector<Glycan> new_structures = structure.splitMultipleRoots();
                Iterator<Glycan> l = new_structures.iterator();
                while (l.hasNext()) {
                    this.structures.insertElementAt(l.next(), 1 + i++);
                }
            }
            return true;
        }
        return false;
    }

    public boolean removeResidue(Residue toremove) {
        if (this.removeResiduePVT(toremove)) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    private boolean removeResiduesPVT(Collection<Residue> toremove) {
        if (toremove == null) {
            return false;
        }
        boolean removed = false;
        for (int i = 0; i < this.structures.size(); ++i) {
            Glycan structure = this.structures.elementAt(i);
            if (!structure.removeResidues(toremove)) continue;
            if (structure.isEmpty()) {
                this.structures.removeElementAt(i);
                --i;
            } else {
                Vector<Glycan> new_structures = structure.splitMultipleRoots();
                Iterator<Glycan> l = new_structures.iterator();
                while (l.hasNext()) {
                    this.structures.insertElementAt(l.next(), 1 + i++);
                }
            }
            removed = true;
        }
        return removed;
    }

    public void removeResidues(Collection<Residue> toremove) {
        if (this.removeResiduesPVT(toremove)) {
            this.fireDocumentChanged();
        }
    }

    protected boolean swap(Residue node1, Residue node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        if (node1.getParent() != node2.getParent()) {
            return false;
        }
        Residue parent = node1.getParent();
        if (parent.swapChildren(node1, node2)) {
            this.fireDocumentChanged();
            return true;
        }
        return false;
    }

    public boolean createRepetition(Residue selected_last, Collection<Residue> nodes) throws Exception {
        if (nodes == null || nodes.size() == 0) {
            return false;
        }
        Residue first = null;
        Residue last = selected_last;
        for (Residue r : nodes) {
            if (r.isReducingEnd()) {
                throw new Exception("The repeating unit cannot contain the reducing end");
            }
            if (r.isBracket()) {
                throw new Exception("The repeating unit cannot contain the bracket");
            }
            if (r.isCleavage()) {
                throw new Exception("The repeating unit cannot contain a cleavage");
            }
            if (r.isRepetition()) {
                throw new Exception("Repeating units cannot be nested");
            }
            if (r.getParent() != null && !nodes.contains(r.getParent())) {
                if (first == null) {
                    first = r;
                } else {
                    throw new Exception("The residue forming the repeating unit must be all linked together.");
                }
            }
            if (selected_last != null || !r.isSaccharide() || r.getNoChildren() <= 0) continue;
            int links_out = 0;
            for (Linkage l : r.getChildrenLinkages()) {
                if (nodes.contains(l.getChildResidue())) continue;
                ++links_out;
            }
            if (links_out <= 0) continue;
            if (last == null) {
                last = r;
                continue;
            }
            throw new Exception("There are more than one residue in the repeating units with children not in the repeating unit. Check that all the residues in the repeating unit have been selected.");
        }
        if (first == null) {
            throw new Exception("No available start point for the repeating unit.");
        }
        if (first.isInRepetition()) {
            throw new Exception("Repeating units cannot be nested");
        }
        if (first.isAntenna()) {
            throw new Exception("Repeating units cannot be in an antenna");
        }
        if (last == null) {
            if (nodes.size() == 1) {
                last = first;
            } else {
                return false;
            }
        }
        Residue start = ResidueDictionary.createStartRepetition();
        first.insertParent(start, first.getParentLinkage().getBonds());
        Residue end = ResidueDictionary.createEndRepetition();
        start.setEndRepitionResidue(end);
        last.addChild(end);
        Iterator<Linkage> il = last.iterator();
        while (il.hasNext()) {
            Linkage child_link = il.next();
            if (child_link.getChildResidue() == end || nodes.contains(child_link.getChildResidue())) continue;
            end.getChildrenLinkages().add(child_link);
            child_link.setParentResidue(end);
            il.remove();
        }
        this.fireDocumentChanged();
        return true;
    }

    @Override
    public void initData() {
        this.structures = new Vector();
    }

    private Residue cloneStructure(Residue root, HashSet<Residue> nodes, boolean add_attachment) {
        if (root == null) {
            return null;
        }
        if (!(!add_attachment || root.isReducingEnd() || root.getParent() != null && root.getParent().isReducingEnd())) {
            Residue cloned_root = ResidueDictionary.createAttachPoint();
            cloned_root.addChild(this.cloneStructure(root, nodes, false), root.getParentLinkage().getBonds());
            return cloned_root;
        }
        Residue cloned_root = root.cloneResidue();
        for (Linkage link : root.getChildrenLinkages()) {
            Residue child = link.getChildResidue();
            if (!nodes.contains(child)) continue;
            cloned_root.addChild(this.cloneStructure(child, nodes, false), link.getBonds());
        }
        return cloned_root;
    }

    public Vector<Glycan> extractView(HashSet<Residue> nodes) {
        Glycan orig_structure;
        Vector<Residue> roots = new Vector<Residue>();
        Vector<Residue> antennae = new Vector<Residue>();
        for (Residue cur : nodes) {
            Residue par = cur.getParent();
            if (par != null && nodes.contains(par) && !par.isBracket()) continue;
            if (cur.isAntenna()) {
                antennae.add(cur);
                continue;
            }
            if (cur.isBracket()) continue;
            roots.add(cur);
        }
        Vector<Residue> cloned_roots = new Vector<Residue>();
        HashMap<Residue, Glycan> roots_map = new HashMap<Residue, Glycan>();
        for (Residue root : roots) {
            Residue cloned_root = this.cloneStructure(root, nodes, true);
            if (cloned_root.isReducingEnd() && !cloned_root.hasChildren()) continue;
            cloned_roots.add(cloned_root);
            roots_map.put(cloned_root, this.findStructureWith(root));
        }
        HashMap<Residue, Glycan> antennae_map = new HashMap<Residue, Glycan>();
        for (Residue antenna : antennae) {
            antennae_map.put(antenna, this.findStructureWith(antenna));
        }
        HashSet<Residue> assigned_antennae = new HashSet<Residue>();
        Vector<Glycan> ret_structures = new Vector<Glycan>();
        for (Residue cloned_root : cloned_roots) {
            orig_structure = (Glycan)roots_map.get(cloned_root);
            Glycan ret_structure = new Glycan(cloned_root, false, orig_structure.getMassOptions());
            ret_structures.add(ret_structure);
            for (Residue antenna : antennae) {
                if (antennae_map.get(antenna) != orig_structure) continue;
                assigned_antennae.add(antenna);
                ret_structure.addAntenna(this.cloneStructure(antenna, nodes, true));
            }
        }
        for (Residue antenna : antennae) {
            if (assigned_antennae.contains(antenna)) continue;
            orig_structure = (Glycan)antennae_map.get(antenna);
            ret_structures.add(new Glycan(this.cloneStructure(antenna, nodes, true), false, orig_structure.getMassOptions()));
        }
        for (Glycan s : ret_structures) {
            s.removeUnpairedRepetitions();
        }
        return ret_structures;
    }

    public static Map<String, String> getImportFormats() {
        return GlycanParserFactory.getImportFormats();
    }

    public static Map<String, String> getExportFormats() {
        return GlycanParserFactory.getExportFormats();
    }

    public static Map<String, String> getFormats() {
        return GlycanParserFactory.getFormats();
    }

    public static boolean isSequenceFormat(String format) {
        return GlycanParserFactory.isSequenceFormat(format);
    }

    public static boolean supportMultipleStructures(String format) {
        if (!GlycanParserFactory.isSequenceFormat(format)) {
            return true;
        }
        try {
            GlycanParser parser = GlycanParserFactory.getParser(format);
            return parser != null && parser instanceof GWSParser;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean importFrom(String filename, String format) {
        try {
            FileInputStream fis = new FileInputStream(filename);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            return this.importFromString(this.consume(br), format);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public boolean importFromString(String buffer, String format) {
        return this.importFromString(buffer, format, false);
    }

    public boolean importFromString(String buffer, String format, boolean tolerate_unknown) {
        try {
            GlycanParser parser = GlycanParserFactory.getParser(format);
            parser.setTolerateUnknown(tolerate_unknown);
            this.fromString(buffer, true, true, parser);
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public boolean exportTo(String filename, String format) {
        try {
            System.err.println("Exporting: " + format);
            System.err.println("To file: " + filename);
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            GlycanParser parser = GlycanParserFactory.getParser(format);
            String str = this.toString(parser);
            if (str == null) {
                throw new Exception("Invalid output string");
            }
            bw.write(str, 0, str.length());
            bw.newLine();
            bw.close();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public static boolean exportTo(Collection<Glycan> toexport, String filename, String format) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
            GlycanParser parser = GlycanParserFactory.getParser(format);
            String str = GlycanDocument.toString(toexport, parser);
            if (str == null) {
                throw new Exception("Invalid output string");
            }
            bw.write(str, 0, str.length());
            bw.newLine();
            bw.close();
            return true;
        }
        catch (Exception e) {
            LogUtils.report(e);
            return false;
        }
    }

    public String toGlycoCT() {
        return GlycanDocument.toString(this.structures, new GlycoCTParser(false));
    }

    public String toGlycoCTCondensed() {
        return GlycanDocument.toString(this.structures, new GlycoCTCondensedParser(false));
    }

    protected void fromGlycoCT(String str, boolean merge, boolean fire, boolean tolerate) throws Exception {
        this.fromString(str, merge, fire, new GlycoCTParser(tolerate));
    }

    public String toString() {
        return GlycanDocument.toString(this.structures, new GWSParser());
    }

    public String toString(GlycanParser parser) {
        return GlycanDocument.toString(this.structures, parser);
    }

    public String toString(String format) {
        try {
            return GlycanDocument.toString(this.structures, GlycanParserFactory.getParser(format));
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    public String toStringWithCoordinates(String format, BBoxManager bboxManager) {
        try {
            return GlycanDocument.toString(this.structures, GlycanParserFactory.getParser(format), bboxManager);
        }
        catch (Exception e) {
            LogUtils.report(e);
            return "";
        }
    }

    public static String toString(Collection<Glycan> structures) {
        return GlycanDocument.toString(structures, new GWSParser());
    }

    public static String toString(Collection<Glycan> structures, GlycanParser parser) {
        return GlycanDocument.toString(structures, parser, null);
    }

    public static String toString(Collection<Glycan> structures, GlycanParser parser, BBoxManager bboxManager) {
        String str = "";
        if (parser instanceof GWSParser) {
            Iterator<Glycan> i = structures.iterator();
            while (i.hasNext()) {
                str = str + parser.writeGlycan(i.next(), bboxManager);
                if (!i.hasNext()) continue;
                str = str + ";";
            }
        } else {
            str = bboxManager != null ? parser.writeGlycan(structures.isEmpty() ? null : structures.iterator().next(), bboxManager) : parser.writeGlycan(structures.isEmpty() ? null : structures.iterator().next());
        }
        return str;
    }

    public void fromString(String str, String format) throws Exception {
        this.setStructures(this.parseString(str, GlycanParserFactory.getParser(format)), true);
    }

    public void fromURL(final String resourceLocation, final String format) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    String line;
                    InputStream inStream = null;
                    URL url = new URL(resourceLocation);
                    inStream = url.openStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line + "\n");
                    }
                    GlycanDocument.this.fromString(buffer.toString(), format);
                }
                catch (Exception ex) {
                    LogUtils.report(ex);
                }
                return null;
            }
        });
    }

    @Override
    public void fromString(String str, boolean merge) throws Exception {
        this.fromString(str, merge, false, new GWSParser());
    }

    public void fromString(String str, boolean merge, boolean fire, GlycanParser parser) throws Exception {
        if (merge) {
            this.addStructures(this.parseString(str, parser), fire);
        } else {
            this.setStructures(this.parseString(str, parser), fire);
        }
    }

    public Collection<Glycan> parseString(String str, GlycanParser parser) throws Exception {
        Vector<Glycan> parsed = new Vector<Glycan>();
        if (parser instanceof GWSParser) {
            for (String t : TextUtils.tokenize(str, ";")) {
                parsed.add(parser.readGlycan(t, this.theWorkspace.getDefaultMassOptions()));
            }
        } else {
            parsed.add(parser.readGlycan(str, this.theWorkspace.getDefaultMassOptions()));
        }
        return parsed;
    }

    public Collection<Glycan> parseString(String str) throws Exception {
        Vector<Glycan> parsed = new Vector<Glycan>();
        for (String t : TextUtils.tokenize(str, ";")) {
            parsed.add(GWSParser.fromString(t, this.theWorkspace.getDefaultMassOptions()));
        }
        return parsed;
    }

    public static Collection<Glycan> parseString(String str, MassOptions opt) throws Exception {
        Vector<Glycan> parsed = new Vector<Glycan>();
        for (String t : TextUtils.tokenize(str, ";")) {
            parsed.add(GWSParser.fromString(t, opt));
        }
        return parsed;
    }

    public void fromXML(Node struct_node, boolean merge) throws Exception {
        if (!merge) {
            this.resetStatus();
            this.initData();
        } else {
            this.setChanged(true);
        }
        Vector<Node> g_nodes = XMLUtils.findAllChildren(struct_node, "Glycan");
        for (Node g_node : g_nodes) {
            this.structures.add(Glycan.fromXML(g_node, this.theWorkspace.getDefaultMassOptions()));
        }
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element struct_node = document.createElement("Structures");
        for (Glycan s : this.structures) {
            struct_node.appendChild(s.toXML(document));
        }
        return struct_node;
    }

    @Override
    public void write(TransformerHandler th) throws SAXException {
        th.startElement("", "", "Structures", new AttributesImpl());
        for (Glycan s : this.structures) {
            s.write(th);
        }
        th.endElement("", "", "Structures");
    }

    public static class SAXHandler
    extends SAXUtils.ObjectTreeHandler {
        private GlycanDocument theDocument;
        private boolean merge;

        public SAXHandler(GlycanDocument _doc, boolean _merge) {
            this.theDocument = _doc;
            this.merge = _merge;
        }

        public boolean isElement(String namespaceURI, String localName, String qName) {
            return qName.equals(SAXHandler.getNodeElementName());
        }

        public static String getNodeElementName() {
            return "Structures";
        }

        protected SAXUtils.ObjectTreeHandler getHandler(String namespaceURI, String localName, String qName) {
            if (qName.equals(Glycan.SAXHandler.getNodeElementName())) {
                return new Glycan.SAXHandler(new MassOptions());
            }
            return null;
        }

        protected Object finalizeContent(String namespaceURI, String localName, String qName) throws SAXException {
            if (!this.merge) {
                this.theDocument.resetStatus();
                this.theDocument.initData();
            } else {
                this.theDocument.setChanged(true);
            }
            for (Object o : this.getSubObjects(Glycan.SAXHandler.getNodeElementName())) {
                this.theDocument.structures.add((Glycan)o);
            }
            this.object = this.theDocument;
            return this.object;
        }
    }
}

