/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class PositionPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(PositionPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.collaborator.position";
    public static String lastSelection = null;
    private SingleChoicePreference positionPreference = null;
    private List<String> allPositions = null;
    private String defaultPosition = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Positions");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createPositionsTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newPositionCount = 1;
                while (PositionPreference.this.allPositions.contains("Position " + newPositionCount)) {
                    ++newPositionCount;
                }
                String newPosition = "Position " + newPositionCount;
                PositionPreference.this.allPositions.add(newPosition);
                if (PositionPreference.this.allPositions.size() == 1) {
                    PositionPreference.this.defaultPosition = newPosition;
                }
                PositionPreference.this.checkboxTableViewer.refresh();
                PositionPreference.this.tableColumn2.getViewer().editElement((Object)newPosition, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)PositionPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedPosition = (String)selection.getFirstElement();
                    int selectionIndex = PositionPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    PositionPreference.this.allPositions.remove(selectedPosition);
                    if (selectedPosition.equals(PositionPreference.this.defaultPosition)) {
                        PositionPreference.this.defaultPosition = PositionPreference.this.allPositions.isEmpty() ? null : (String)PositionPreference.this.allPositions.iterator().next();
                    }
                    PositionPreference.this.checkboxTableViewer.refresh();
                    if (!PositionPreference.this.allPositions.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, PositionPreference.this.allPositions.size() - 1);
                        PositionPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(PositionPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)PositionPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(PositionPreference.this.defaultPosition);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PositionPreference.this.defaultPosition = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.POSITION.getPreferenceName()));
        this.positionPreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.POSITION);
        this.allPositions = new ArrayList<String>();
        this.allPositions.addAll(this.positionPreference.getAllValues());
        this.defaultPosition = this.positionPreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allPositions, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allPositions);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createPositionsTableViewer(Composite container) {
        Table positionsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        positionsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(positionsTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Positions");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (PositionPreference.this.checkboxTableViewer.getChecked(element)) {
                        PositionPreference.this.defaultPosition = newValue;
                    }
                    if (PositionPreference.this.allPositions.contains(element)) {
                        PositionPreference.this.allPositions.set(PositionPreference.this.allPositions.indexOf(element), newValue);
                    }
                    PositionPreference.this.checkboxTableViewer.refresh();
                    PositionPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allPositionsMap = this.positionPreference.loadDefaultValues(ProjectPreferenceStore.Preference.POSITION);
        this.allPositions = new ArrayList<String>();
        this.defaultPosition = null;
        for (String position : allPositionsMap.keySet()) {
            this.allPositions.add(position);
            if (!allPositionsMap.get(position).booleanValue()) continue;
            this.defaultPosition = position;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Position\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniquePositions = new HashSet<String>();
        uniquePositions.addAll(this.allPositions);
        String string = errorMessage = uniquePositions.size() == this.allPositions.size() ? errorMessage : "Non-unique Positions";
        if (uniquePositions.contains("")) {
            errorMessage = "Empty Position";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.positionPreference.setAllValues(new HashSet<String>());
        this.positionPreference.setDefaultValue(null);
        for (String position : this.allPositions) {
            if (this.checkboxTableViewer.getChecked(position) && this.positionPreference.getDefaultValue() == null) {
                this.positionPreference.setDefaultValue(position);
            }
            this.positionPreference.addValue(position);
        }
        return this.positionPreference.savePreference();
    }
}

