/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator.filters;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.filters.SelectFiltersAction;
import org.eclipse.ui.internal.navigator.filters.ToggleFilterAction;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.IMementoAware;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;

public class FilterActionGroup
extends ActionGroup
implements IMementoAware {
    private static final String FILTER_ACTION_GROUP = "filterActionGroup";
    private static final String FILTER_ACTION_GROUP_FILTERS_START = "filterActionGroupFilters-start";
    private static final String FILTER_ACTION_GROUP_FILTERS_END = "filterActionGroupFilters-end";
    private static final int MAX_FILTER_MENU_ENTRIES = 5;
    private static final String TAG_LRU_FILTERS = "lastRecentlyUsedFilters";
    private static final String TAG_CHILD = "child";
    private static final String TAG_FILTER_ID = "filterId";
    private SelectFiltersAction selectFiltersAction;
    private IMenuManager menuManager;
    private IMenuListener menuListener;
    private IMenuManager filtersMenu;
    private CommonViewer commonViewer;
    private INavigatorViewerDescriptor viewerDescriptor;
    private Deque<ICommonFilterDescriptor> lruFilterDescriptorStack = new ArrayDeque<ICommonFilterDescriptor>();

    public FilterActionGroup(CommonViewer aCommonViewer) {
        Assert.isNotNull((Object)((Object)aCommonViewer));
        this.commonViewer = aCommonViewer;
        this.viewerDescriptor = this.commonViewer.getNavigatorContentService().getViewerDescriptor();
        this.makeActions();
    }

    public void fillActionBars(IActionBars actionBars) {
        this.menuManager = actionBars.getMenuManager();
        this.menuManager.appendToGroup("additions", (IContributionItem)new Separator(FILTER_ACTION_GROUP));
        if (this.selectFiltersAction != null) {
            this.menuManager.addMenuListener(this.menuListener);
            this.menuManager.appendToGroup(FILTER_ACTION_GROUP, (IAction)this.selectFiltersAction);
            this.menuManager.appendToGroup(FILTER_ACTION_GROUP, (IContributionItem)new GroupMarker(FILTER_ACTION_GROUP_FILTERS_START));
            this.menuManager.appendToGroup(FILTER_ACTION_GROUP_FILTERS_START, (IContributionItem)new Separator(FILTER_ACTION_GROUP_FILTERS_END));
            this.menuManager.appendToGroup(FILTER_ACTION_GROUP_FILTERS_START, (IContributionItem)this.filtersMenu);
        }
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
    }

    public void dispose() {
        super.dispose();
        if (this.menuManager != null) {
            this.menuManager.removeMenuListener(this.menuListener);
        }
        if (this.filtersMenu != null) {
            this.filtersMenu.dispose();
        }
    }

    @Override
    public void restoreState(IMemento aMemento) {
        IMemento lruFilters = aMemento.getChild(TAG_LRU_FILTERS);
        this.lruFilterDescriptorStack.clear();
        if (lruFilters != null) {
            NavigatorFilterService filterService = (NavigatorFilterService)this.commonViewer.getNavigatorContentService().getFilterService();
            ICommonFilterDescriptor[] visibleFilterDescriptors = filterService.getVisibleFilterDescriptorsForUI();
            IMemento[] iMementoArray = lruFilters.getChildren(TAG_CHILD);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento child = iMementoArray[n2];
                String id = child.getString(TAG_FILTER_ID);
                if (id != null) {
                    ICommonFilterDescriptor[] iCommonFilterDescriptorArray = visibleFilterDescriptors;
                    int n3 = visibleFilterDescriptors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICommonFilterDescriptor visibleFilterDescriptor = iCommonFilterDescriptorArray[n4];
                        if (visibleFilterDescriptor.getId().equals(id)) {
                            this.lruFilterDescriptorStack.push(visibleFilterDescriptor);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public void saveState(IMemento aMemento) {
        IMemento lruFilters = aMemento.createChild(TAG_LRU_FILTERS);
        if (!this.lruFilterDescriptorStack.isEmpty()) {
            for (ICommonFilterDescriptor filterDescriptor : this.lruFilterDescriptorStack) {
                IMemento child = lruFilters.createChild(TAG_CHILD);
                child.putString(TAG_FILTER_ID, filterDescriptor.getId());
            }
        }
    }

    private void makeActions() {
        boolean hideAvailableCustomizationsDialog = this.viewerDescriptor.getBooleanConfigProperty("org.eclipse.ui.navigator.hideAvailableCustomizationsDialog");
        if (!hideAvailableCustomizationsDialog) {
            this.selectFiltersAction = new SelectFiltersAction(this.commonViewer, this);
            ImageDescriptor selectFiltersIcon = NavigatorPlugin.getImageDescriptor("icons/full/elcl16/filter_ps.png");
            this.selectFiltersAction.setImageDescriptor(selectFiltersIcon);
            this.selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
            this.filtersMenu = new MenuManager(CommonNavigatorMessages.FilterActionGroup_RecentFilters);
            this.menuListener = manager -> {
                this.filtersMenu.removeAll();
                this.addLRUFilterActions(this.filtersMenu);
            };
        }
    }

    private void addLRUFilterActions(IMenuManager manager) {
        if (this.lruFilterDescriptorStack.isEmpty()) {
            return;
        }
        NavigatorFilterService filterService = (NavigatorFilterService)this.commonViewer.getNavigatorContentService().getFilterService();
        ICommonFilterDescriptor[] filterDescriptors = this.lruFilterDescriptorStack.toArray(new ICommonFilterDescriptor[this.lruFilterDescriptorStack.size()]);
        Arrays.sort(filterDescriptors, (o1, o2) -> o1.getName().compareTo(o2.getName()));
        ICommonFilterDescriptor[] iCommonFilterDescriptorArray = filterDescriptors;
        int n = filterDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ICommonFilterDescriptor filterDescriptor = iCommonFilterDescriptorArray[n2];
            manager.add((IAction)new ToggleFilterAction(this.commonViewer, filterService, filterDescriptor));
            ++n2;
        }
    }

    protected void updateFilterShortcuts(ICommonFilterDescriptor[] filterDescriptorChangeHistory) {
        ArrayDeque<ICommonFilterDescriptor> oldestFirstStack = new ArrayDeque<ICommonFilterDescriptor>();
        int length = Math.min(filterDescriptorChangeHistory.length, 5);
        int i = 0;
        while (i < length) {
            oldestFirstStack.push(filterDescriptorChangeHistory[i]);
            ++i;
        }
        length = Math.min(this.lruFilterDescriptorStack.size(), 5 - oldestFirstStack.size());
        i = 0;
        while (i < length) {
            ICommonFilterDescriptor filter = this.lruFilterDescriptorStack.pollFirst();
            if (!oldestFirstStack.contains(filter)) {
                oldestFirstStack.push(filter);
            }
            ++i;
        }
        this.lruFilterDescriptorStack = oldestFirstStack;
    }
}

