/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;

@XmlRootElement(name="connection")
public class Connection
extends ModelElement {
    public static final Integer SOLID_CONNECTION = new Integer(1);
    public static final String LINESTYLE_PROP = "LineStyle";
    private static final IPropertyDescriptor[] descriptors = new IPropertyDescriptor[1];
    private static final String SOLID_STR = "Solid";
    private static final String DASHED_STR = "Dashed";
    private static final long serialVersionUID = 1L;
    private boolean isConnected;
    private int lineStyle = 1;
    private GraphNode source;
    private GraphNode target;

    static {
        Connection.descriptors[0] = new ComboBoxPropertyDescriptor((Object)LINESTYLE_PROP, LINESTYLE_PROP, new String[]{SOLID_STR, DASHED_STR});
    }

    public Connection() {
    }

    public Connection(GraphNode source, GraphNode target) {
        this.reconnect(source, target);
    }

    public void disconnect() {
        if (this.isConnected) {
            this.source.removeConnection(this);
            this.target.removeConnection(this);
            this.isConnected = false;
        }
    }

    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (id.equals(LINESTYLE_PROP)) {
            if (this.getLineStyle() == 2) {
                return new Integer(1);
            }
            return new Integer(0);
        }
        return super.getPropertyValue(id);
    }

    @XmlElement
    public GraphNode getSource() {
        return this.source;
    }

    public void setSource(GraphNode s) {
        this.source = s;
        if (this.target != null) {
            this.reconnect(s, this.target);
        }
    }

    @XmlElement
    public GraphNode getTarget() {
        return this.target;
    }

    public void setTarget(GraphNode t) {
        this.target = t;
        if (this.source != null) {
            this.reconnect(this.source, t);
        }
    }

    public void reconnect() {
        if (!this.isConnected) {
            this.source.addConnection(this);
            this.target.addConnection(this);
            this.isConnected = true;
        }
    }

    public void reconnect(GraphNode newSource, GraphNode newTarget) {
        if (newSource == null || newTarget == null || newSource == newTarget) {
            throw new IllegalArgumentException();
        }
        this.disconnect();
        this.source = newSource;
        this.target = newTarget;
        this.reconnect();
    }

    public void setLineStyle(int lineStyle) {
        if (lineStyle != 2 && lineStyle != 1) {
            throw new IllegalArgumentException();
        }
        this.lineStyle = lineStyle;
        this.firePropertyChange(LINESTYLE_PROP, null, new Integer(this.lineStyle));
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (id.equals(LINESTYLE_PROP)) {
            this.setLineStyle(new Integer(1).equals(value) ? 2 : 1);
        } else {
            super.setPropertyValue(id, value);
        }
    }
}

