/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.GlycanNamescheme;
import org.eurocarbdb.resourcesdb.MolecularEntity;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.atom.Atom;
import org.eurocarbdb.resourcesdb.atom.AtomTemplate;
import org.eurocarbdb.resourcesdb.atom.Composition;
import org.eurocarbdb.resourcesdb.atom.Periodic;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.LinkageType;
import org.eurocarbdb.resourcesdb.io.GlycoCTExporter;
import org.eurocarbdb.resourcesdb.io.GlycoCTImporter;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.BasetypeBuilderGroup;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.Ringtype;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;
import org.eurocarbdb.resourcesdb.util.Utils;

public class Basetype
extends MolecularEntity {
    private Stereocode stereocode;
    private int size;
    private int ringStart;
    private int ringEnd;
    private int defaultCarbonylPosition;
    private Anomer anomer;
    private StereoConfiguration configuration;
    private List<CoreModification> coreModifications;
    private String superclass;
    private Boolean isSuperclassFlag;
    private int dbId;
    public static final int UNKNOWN_RING = 0;
    public static final int OPEN_CHAIN = -1;

    public Basetype() {
        this(null, null);
    }

    public Basetype(Config conf, TemplateContainer container) {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
    }

    public Basetype(String glycoCTName) throws ResourcesDbException {
        this(glycoCTName, null, null);
    }

    public Basetype(String glycoCTName, Config conf, TemplateContainer container) throws ResourcesDbException {
        this.setConfig(conf);
        this.setTemplateContainer(container);
        this.init();
        GlycoCTImporter importer = new GlycoCTImporter(GlycanNamescheme.GLYCOCT, this.getConfig(), this.getTemplateContainer());
        Monosaccharide ms = new Monosaccharide(this);
        importer.parseMsString(glycoCTName, ms);
    }

    public int getDbId() {
        return this.dbId;
    }

    public void setDbId(int dbId) {
        this.dbId = dbId;
    }

    public int getRingStart() {
        return this.ringStart;
    }

    public void setRingStart(int position) {
        int currentPosition = this.getRingStart();
        this.ringStart = position;
        if (this.getRingEnd() > 0) {
            this.setRingEnd(this.getRingEnd() + (position - currentPosition));
        }
    }

    public void setRingStartNoAdjustment(int position) {
        this.ringStart = position;
    }

    public int getDefaultCarbonylPosition() {
        return this.defaultCarbonylPosition;
    }

    public void setDefaultCarbonylPosition(int position) {
        this.defaultCarbonylPosition = position;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public Anomer getAnomer() {
        return this.anomer;
    }

    public void setAnomer(Anomer anomer) {
        this.anomer = anomer;
    }

    public void setAnomer(String anomerStr) throws MonosaccharideException {
        this.setAnomer(Anomer.forNameOrSymbol(anomerStr));
    }

    public String getAnomerSymbol() {
        if (this.getAnomer() == null) {
            return null;
        }
        return this.getAnomer().getSymbol();
    }

    public void setAnomerSymbol(String anomerStr) throws MonosaccharideException {
        if (anomerStr == null) {
            this.setAnomer((Anomer)null);
        } else {
            this.setAnomer(anomerStr);
        }
    }

    public StereoConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(StereoConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConfiguration(String configStr) throws MonosaccharideException {
        this.setConfiguration(StereoConfiguration.forNameOrSymbol(configStr));
    }

    public String getConfigurationSymbol() {
        if (this.configuration == null) {
            return StereoConfiguration.Unknown.getSymbol();
        }
        return this.configuration.getSymbol();
    }

    public void setConfigurationSymbol(String confSymbol) throws MonosaccharideException {
        if (confSymbol == null) {
            this.setConfiguration((StereoConfiguration)null);
        } else {
            this.setConfiguration(confSymbol);
        }
    }

    public int getRingEnd() {
        return this.ringEnd;
    }

    public void setRingEnd(int pos) {
        this.ringEnd = pos;
    }

    public void setRingtype(Ringtype type) throws MonosaccharideException {
        if (type.equals((Object)Ringtype.PYRANOSE)) {
            this.setRingEnd(this.getRingStart() + 4);
        } else if (type.equals((Object)Ringtype.FURANOSE)) {
            this.setRingEnd(this.getRingStart() + 3);
        } else if (type.equals((Object)Ringtype.OPEN)) {
            this.setRingStartNoAdjustment(-1);
            this.setRingEnd(-1);
        } else if (type.equals((Object)Ringtype.UNKNOWN)) {
            this.setRingStartNoAdjustment(0);
            this.setRingEnd(0);
        }
    }

    public Ringtype getRingtype() {
        if (this.getRingEnd() == -1) {
            return Ringtype.OPEN;
        }
        if (this.getRingStart() <= 0 || this.getRingEnd() == 0) {
            return Ringtype.UNKNOWN;
        }
        if (this.getRingEnd() - this.getRingStart() == 4) {
            return Ringtype.PYRANOSE;
        }
        if (this.getRingEnd() - this.getRingStart() == 3) {
            return Ringtype.FURANOSE;
        }
        return Ringtype.UNKNOWN;
    }

    public String getRingtypeSymbol() {
        return this.getRingtype().getCarbbankSymbol();
    }

    public void setRingClosure(int start, int end) {
        this.ringStart = start;
        this.ringEnd = end;
    }

    public boolean isAlditol() {
        return this.hasCoreModification(CoreModificationTemplate.ALDITOL, 1);
    }

    public void setAlditol(boolean alditol) throws MonosaccharideException {
        if (alditol) {
            if (this.getRingEnd() > 0) {
                throw new MonosaccharideException("Monosaccharide cannot be an alditol if it is in ring form");
            }
            this.setRingEnd(-1);
            this.setRingStart(-1);
            if (!this.hasCoreModification(CoreModificationTemplate.ALDITOL, 1)) {
                this.addCoreModification(new CoreModification(CoreModificationTemplate.ALDITOL, 1));
            }
        } else if (this.hasCoreModification(CoreModificationTemplate.ALDITOL, 1)) {
            this.deleteCoreModification(CoreModificationTemplate.ALDITOL, 1);
        }
    }

    public Boolean getIsSuperclassFlag() {
        return this.isSuperclassFlag;
    }

    public boolean isSuperclass() {
        return this.isSuperclassFlag;
    }

    public void setIsSuperclassFlag(Boolean isSuperclass) {
        this.isSuperclassFlag = isSuperclass;
    }

    public void setIsSuperclass(boolean flag) {
        this.isSuperclassFlag = new Boolean(flag);
    }

    public void checkIsSuperclass() {
        this.setIsSuperclass(Stereocode.getChiralOnlyStereoString(this.getStereoStr()).length() == 0);
    }

    public String getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(String superclass) {
        this.superclass = superclass;
    }

    public Stereocode getStereocode() {
        return this.stereocode;
    }

    public void setStereocode(Stereocode stereocode) {
        this.stereocode = stereocode;
    }

    public String getStereoStr() {
        if (this.getStereocode() != null) {
            return this.getStereocode().getStereoStr();
        }
        return "";
    }

    public void setStereoStr(String stereoStr) {
        if (this.getStereocode() == null) {
            this.setStereocode(new Stereocode(stereoStr));
        } else {
            this.getStereocode().setStereoStr(stereoStr);
        }
    }

    public String getStereoStrWithoutAnomeric() throws ResourcesDbException {
        String stereo = this.getStereoStr();
        if (this.getRingStart() > 0 && this.getRingStart() < stereo.length()) {
            stereo = Stereocode.maskAnomerInStereoString(stereo, this);
        }
        return stereo;
    }

    public void setAnomerInStereocode() throws ResourcesDbException {
        String stereo = this.getStereoStr();
        int anomerPosition = this.getRingStart();
        if (anomerPosition >= 1) {
            String stereosymbolAnomer = this.getAnomer().getStereosymbolD();
            StereoConfiguration refConf = this.getAnomericReferenceConfiguration();
            if (refConf.equals((Object)StereoConfiguration.Laevus)) {
                stereosymbolAnomer = Stereocode.changeDLinStereoString(stereosymbolAnomer);
            } else if (refConf.equals((Object)StereoConfiguration.XLaevus)) {
                stereosymbolAnomer = Stereocode.changeDLinStereoString(stereosymbolAnomer);
                stereosymbolAnomer = Stereocode.absoluteToRelative(stereosymbolAnomer);
            } else if (refConf.equals((Object)StereoConfiguration.XDexter)) {
                stereosymbolAnomer = Stereocode.absoluteToRelative(stereosymbolAnomer);
            }
            stereo = stereo.substring(0, anomerPosition - 1) + stereosymbolAnomer + stereo.substring(anomerPosition);
        }
        this.setStereoStr(stereo);
    }

    public StereoConfiguration getAnomericReferenceConfiguration() throws ResourcesDbException {
        String stereo = this.getStereoStr();
        int anomerPosition = this.getRingStart();
        if (anomerPosition >= 1) {
            stereo = Stereocode.setPositionInStereoString(stereo, '0', anomerPosition);
        }
        StereoConfiguration conf = (stereo = Stereocode.getChiralOnlyStereoString(stereo)).length() > 4 ? StereoConfiguration.forStereosymbol(stereo.charAt(3)) : (stereo.length() == 0 ? StereoConfiguration.Unknown : StereoConfiguration.forStereosymbol(stereo.charAt(stereo.length() - 1)));
        return conf;
    }

    public Anomer getAnomerFromStereocode() throws ResourcesDbException {
        if (this.getRingtype().equals((Object)Ringtype.OPEN)) {
            return Anomer.OPEN_CHAIN;
        }
        if (this.getRingStart() > 0 && this.isStereolossPositionWithIgnoreType(this.getRingStart(), CoreModificationTemplate.KETO)) {
            return Anomer.NONE;
        }
        StereoConfiguration anomRefConf = this.getAnomericReferenceConfiguration();
        StereoConfiguration anomConf = Stereocode.getPositionFromStereoString(this.getStereoStr(), this.getRingStart());
        if (anomRefConf.equals((Object)StereoConfiguration.Dexter)) {
            if (anomConf.equals((Object)StereoConfiguration.Dexter)) {
                return Anomer.ALPHA;
            }
            if (anomConf.equals((Object)StereoConfiguration.Laevus)) {
                return Anomer.BETA;
            }
        }
        if (anomRefConf.equals((Object)StereoConfiguration.Laevus)) {
            if (anomConf.equals((Object)StereoConfiguration.Laevus)) {
                return Anomer.ALPHA;
            }
            if (anomConf.equals((Object)StereoConfiguration.Dexter)) {
                return Anomer.BETA;
            }
        }
        if (anomRefConf.equals((Object)StereoConfiguration.XDexter)) {
            if (anomConf.equals((Object)StereoConfiguration.XDexter)) {
                return Anomer.ALPHA;
            }
            if (anomConf.equals((Object)StereoConfiguration.XLaevus)) {
                return Anomer.BETA;
            }
        }
        if (anomRefConf.equals((Object)StereoConfiguration.XLaevus)) {
            if (anomConf.equals((Object)StereoConfiguration.XLaevus)) {
                return Anomer.ALPHA;
            }
            if (anomConf.equals((Object)StereoConfiguration.XDexter)) {
                return Anomer.BETA;
            }
        }
        return Anomer.UNKNOWN;
    }

    public StereoConfiguration getStereoConfigurationByPosition(int pos) throws ResourcesDbException {
        if (this.getStereoStr().length() >= pos) {
            return StereoConfiguration.forStereosymbol(this.getStereoStr().charAt(pos - 1));
        }
        return StereoConfiguration.Unknown;
    }

    public List<CoreModification> getCoreModifications() {
        if (this.coreModifications == null) {
            this.coreModifications = new ArrayList<CoreModification>();
        }
        return this.coreModifications;
    }

    public void setCoreModifications(List<CoreModification> coreModList) {
        this.coreModifications = coreModList;
        this.sortCoreModifications();
    }

    public boolean checkModificationPosition(CoreModification mod) throws MonosaccharideException {
        ArrayList<Integer> positionsList = mod.getPosition1Clone();
        positionsList.addAll(mod.getPosition2());
        Collections.sort(positionsList);
        for (int i = 0; i < positionsList.size(); ++i) {
            int position = positionsList.get(i);
            if (position < 0 || position > this.getSize()) {
                throw new MonosaccharideException("Modification position out of range: " + mod.toString());
            }
            if (position <= 0) continue;
            if (!(position != this.getRingStart() || this.getRingtype().equals((Object)Ringtype.OPEN) || mod.getTemplate().equals((Object)CoreModificationTemplate.ACID) && this.getRingStart() == 1 || mod.getTemplate().equals((Object)CoreModificationTemplate.KETO) || mod.getTemplate().equals((Object)CoreModificationTemplate.ENX) || mod.getTemplate().equals((Object)CoreModificationTemplate.EN) || mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY))) {
                throw new MonosaccharideException("Cannot modify monosaccharide at carbonyl position (" + this.getRingStart() + ").");
            }
            ArrayList<CoreModification> posMods = this.getCoreModificationsByPosition(position);
            for (CoreModification exstMod : posMods) {
                if (mod.equals(exstMod)) {
                    System.out.println("checkModificationPosition(): modification already present");
                    return false;
                }
                if (mod.isSubstitutable() || exstMod.isSubstitutable()) continue;
                throw new MonosaccharideException("Position already modified: " + exstMod.toString() + "\n Cannot add modification " + mod.toString());
            }
        }
        return true;
    }

    public boolean addCoreModification(CoreModification mod) throws MonosaccharideException {
        if (this.hasCoreModification(mod)) {
            return false;
        }
        int pos = mod.getIntValuePosition1();
        this.coreModifications.add(mod);
        if (pos > 0 && mod.getTemplate().equals((Object)CoreModificationTemplate.KETO)) {
            if (this.getRingStart() == 1) {
                if (pos != 1 && this.getCoreModification(CoreModificationTemplate.KETO.getName(), 1) == null) {
                    this.setRingStart(pos);
                }
            } else if (this.getRingStart() < 1) {
                // empty if block
            }
        }
        this.sortCoreModifications();
        return true;
    }

    public boolean addCoreModification(CoreModificationTemplate modTmpl, int position) throws MonosaccharideException {
        return this.addCoreModification(new CoreModification(modTmpl, position));
    }

    public void deleteCoreModification(CoreModificationTemplate modTmpl, int position) throws MonosaccharideException {
        this.deleteCoreModification(modTmpl.getName(), position);
    }

    public void deleteCoreModification(String name, int position) throws MonosaccharideException {
        List<CoreModification> modList = this.getCoreModifications();
        for (int i = 0; i < modList.size(); ++i) {
            CoreModification mod = modList.get(i);
            if (!mod.getName().equals(name) || mod.getPosition1().get(0) != position) continue;
            modList.remove(i);
            return;
        }
        throw new MonosaccharideException("Cannot remove CoreModification " + position + name + ": modification not found");
    }

    public void deleteCoreModification(CoreModification mod) throws MonosaccharideException {
        List<CoreModification> modList = this.getCoreModifications();
        for (int i = 0; i < modList.size(); ++i) {
            CoreModification presentMod = modList.get(i);
            if (!presentMod.equals(mod)) continue;
            modList.remove(i);
            return;
        }
        throw new MonosaccharideException("Cannot remove CoreModification: modification not found (" + mod.toString() + ")");
    }

    public void initCoreModifications() {
        if (this.getCoreModifications() == null) {
            this.coreModifications = new ArrayList<CoreModification>();
        }
        this.getCoreModifications().clear();
    }

    public int countCoreModifications() {
        return this.getCoreModifications().size();
    }

    public int countCoreModifications(String name) {
        int count = 0;
        List<CoreModification> modifications = this.getCoreModifications();
        for (int i = 0; i < modifications.size(); ++i) {
            CoreModification mod = modifications.get(i);
            if (!mod.getName().equals(name)) continue;
            ++count;
        }
        return count;
    }

    public int countCoreModifications(CoreModificationTemplate tmpl) {
        int count = 0;
        List<CoreModification> modifications = this.getCoreModifications();
        for (int i = 0; i < modifications.size(); ++i) {
            CoreModification mod = modifications.get(i);
            if (!mod.getTemplate().equals((Object)tmpl)) continue;
            ++count;
        }
        return count;
    }

    public void setUronic() throws MonosaccharideException {
        CoreModification mod = new CoreModification(CoreModificationTemplate.ACID, this.getSize());
        this.addCoreModification(mod);
    }

    public boolean isUronic() {
        return !this.hasCoreModification(CoreModificationTemplate.ACID, 1) && this.hasCoreModification(CoreModificationTemplate.ACID, this.getSize());
    }

    public void setAldonic() throws MonosaccharideException {
        CoreModification mod = new CoreModification(CoreModificationTemplate.ACID, 1);
        this.addCoreModification(mod);
    }

    public boolean isAldonic() {
        return this.hasCoreModification(CoreModificationTemplate.ACID, 1) && !this.hasCoreModification(CoreModificationTemplate.ACID, this.getSize());
    }

    public void setAldaric() throws MonosaccharideException {
        this.setAldonic();
        this.setUronic();
    }

    public boolean isAldaric() {
        return this.hasCoreModification(CoreModificationTemplate.ACID, 1) && this.hasCoreModification(CoreModificationTemplate.ACID, this.getSize());
    }

    public boolean hasDoubleBond(int pos) {
        return this.hasCoreModification(CoreModificationTemplate.EN, pos) || this.hasCoreModification(CoreModificationTemplate.ENX, pos);
    }

    public ArrayList<Integer> getStereolossPositions() {
        List<CoreModification> modifications = this.getCoreModifications();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < modifications.size(); ++i) {
            CoreModification mod = modifications.get(i);
            if (!mod.getTemplate().isStereoLoss()) continue;
            ArrayList<Integer> modPositions = mod.getPositions();
            for (int p = 0; p < modPositions.size(); ++p) {
                Integer pos = modPositions.get(p);
                if (positions.contains(pos)) continue;
                positions.add(pos);
            }
        }
        Collections.sort(positions);
        return positions;
    }

    public boolean isStereolossPosition(int pos) {
        ArrayList<CoreModification> modifications = this.getCoreModificationsByPosition(pos);
        for (CoreModification mod : modifications) {
            if (!mod.getTemplate().isStereoLoss()) continue;
            return true;
        }
        return false;
    }

    public boolean isStereolossPositionWithIgnoreType(int pos, CoreModificationTemplate ignore) {
        ArrayList<CoreModification> modifications = this.getCoreModificationsByPosition(pos);
        for (CoreModification mod : modifications) {
            if (mod.getTemplate().equals((Object)ignore) || !mod.getTemplate().isStereoLoss()) continue;
            return true;
        }
        return false;
    }

    public ArrayList<CoreModification> getCoreModificationsByPosition(int position) {
        ArrayList<CoreModification> positionMods = new ArrayList<CoreModification>();
        Integer positionInt = new Integer(position);
        for (CoreModification mod : this.getCoreModifications()) {
            if (!mod.getPositions().contains(positionInt)) continue;
            positionMods.add(mod);
        }
        return positionMods;
    }

    public ArrayList<CoreModificationTemplate> getCoreModificationTemplatesByPosition(int position) {
        ArrayList<CoreModificationTemplate> templateList = new ArrayList<CoreModificationTemplate>();
        for (CoreModification mod : this.getCoreModificationsByPosition(position)) {
            templateList.add(mod.getTemplate());
        }
        return templateList;
    }

    public ArrayList<CoreModification> getCoreModifications(String name) {
        ArrayList<CoreModification> modList = new ArrayList<CoreModification>();
        for (int i = 0; i < this.getCoreModifications().size(); ++i) {
            if (!this.getCoreModifications().get(i).getName().equalsIgnoreCase(name)) continue;
            modList.add(this.getCoreModifications().get(i));
        }
        return modList;
    }

    public ArrayList<CoreModification> getCoreModifications(CoreModificationTemplate tmpl) {
        ArrayList<CoreModification> modList = new ArrayList<CoreModification>();
        for (int i = 0; i < this.getCoreModifications().size(); ++i) {
            if (!this.getCoreModifications().get(i).getTemplate().equals((Object)tmpl)) continue;
            modList.add(this.getCoreModifications().get(i));
        }
        return modList;
    }

    public CoreModification getCoreModification(String name, int position) {
        ArrayList<CoreModification> modList = this.getCoreModificationsByPosition(position);
        for (int i = 0; i < modList.size(); ++i) {
            if (!modList.get(i).getName().equals(name)) continue;
            return modList.get(i);
        }
        return null;
    }

    public CoreModification getCoreModification(CoreModificationTemplate tmpl, int position) {
        ArrayList<CoreModification> modList = this.getCoreModificationsByPosition(position);
        for (int i = 0; i < modList.size(); ++i) {
            if (!modList.get(i).getTemplate().equals((Object)tmpl)) continue;
            return modList.get(i);
        }
        return null;
    }

    public ArrayList<CoreModification> getEnModifications() {
        ArrayList<CoreModification> enList = new ArrayList<CoreModification>();
        for (CoreModification mod : this.getCoreModifications()) {
            if (mod.getTemplate().equals((Object)CoreModificationTemplate.EN)) {
                enList.add(mod);
                continue;
            }
            if (!mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) continue;
            enList.add(mod);
        }
        return enList;
    }

    public boolean hasCoreModification(CoreModification mod) {
        for (int i = 0; i < this.getCoreModifications().size(); ++i) {
            if (!this.getCoreModifications().get(i).equals(mod)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCoreModification(CoreModificationTemplate tmpl, int position) {
        try {
            CoreModification coreMod = new CoreModification(tmpl, position);
            return this.hasCoreModification(coreMod);
        }
        catch (MonosaccharideException me) {
            return false;
        }
    }

    public boolean hasCoreModification(CoreModificationTemplate tmpl) {
        for (CoreModification mod : this.getCoreModifications()) {
            if (!mod.getName().equals(tmpl.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncertainCoremodificationPosition() {
        for (CoreModification mod : this.getCoreModifications()) {
            if (!mod.hasUncertainLinkagePosition()) continue;
            return true;
        }
        return false;
    }

    public void mirrorCoreModificationPositions() {
        List<CoreModification> modList = this.getCoreModifications();
        for (int m = 0; m < modList.size(); ++m) {
            CoreModification mod = modList.get(m);
            if (mod.getTemplate().equals((Object)CoreModificationTemplate.ALDITOL)) continue;
            ArrayList<Integer> positions1 = mod.getPosition1();
            for (int i = 0; i < positions1.size(); ++i) {
                int pos = positions1.get(i);
                if (pos <= 0) continue;
                pos = this.getSize() + 1 - pos;
                positions1.set(i, new Integer(pos));
            }
            ArrayList<Integer> positions2 = mod.getPosition2();
            for (int i = 0; i < positions2.size(); ++i) {
                int pos = positions2.get(i);
                if (pos <= 0) continue;
                pos = this.getSize() + 1 - pos;
                positions2.set(i, new Integer(pos));
            }
            mod.setPosition1(positions1);
            mod.setPosition2(positions2);
            mod.sortPositions();
        }
        this.sortCoreModifications();
    }

    public void sortCoreModifications() {
        List<CoreModification> modList = this.getCoreModifications();
        for (int i = 0; i < modList.size(); ++i) {
            for (int j = modList.size() - 1; j > 0; --j) {
                if (modList.get(j).makeCmpString().compareTo(modList.get(j - 1).makeCmpString()) >= 0) continue;
                CoreModification tmpMod = modList.get(j - 1);
                modList.set(j - 1, modList.get(j));
                modList.set(j, tmpMod);
            }
        }
    }

    public void buildAtoms() throws ResourcesDbException {
        this.buildAtoms(Config.getGlobalConfig());
    }

    public void buildAtoms(Config conf) throws ResourcesDbException {
        this.setAtoms(new ArrayList<Atom>());
        Atom anomericCarbon = null;
        Atom previousCarbon = null;
        for (int pos = 1; pos <= this.getSize(); ++pos) {
            int hCount = 1;
            if (pos == 1 || pos == this.getSize()) {
                ++hCount;
            }
            boolean hasOH = true;
            boolean isAcid = false;
            boolean isUlo = false;
            double boToPreviousCarbon = 1.0;
            Atom currentCarbon = new Atom(Periodic.C);
            if (pos == this.getRingStart() && !this.isAlditol()) {
                --hCount;
                if (this.getRingEnd() > 0) {
                    anomericCarbon = currentCarbon;
                } else {
                    hasOH = false;
                    isUlo = true;
                }
            }
            for (CoreModification mod : this.getCoreModificationsByPosition(pos)) {
                if (mod.getIntValuePosition1() == 0) {
                    throw new MonosaccharideException("Cannot build atoms for basetype with uncertain core modification position.");
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.EN)) {
                    --hCount;
                    if (mod.getIntValuePosition2() != pos) continue;
                    boToPreviousCarbon = 2.0;
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) {
                    throw new MonosaccharideException("Cannot build atoms for basetype with Enx core modification.");
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.YN)) {
                    hCount -= 2;
                    if (mod.getIntValuePosition2() != pos) continue;
                    boToPreviousCarbon = 3.0;
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) {
                    ++hCount;
                    hasOH = false;
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.SP2)) {
                    --hCount;
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.SP)) {
                    hCount -= 2;
                    continue;
                }
                if (mod.getTemplate().equals((Object)CoreModificationTemplate.ACID)) {
                    isAcid = true;
                    hasOH = false;
                    hCount -= 2;
                    continue;
                }
                if (!mod.getTemplate().equals((Object)CoreModificationTemplate.KETO) || this.getRingStart() == pos) continue;
                --hCount;
                hasOH = false;
                isUlo = true;
            }
            if (isAcid) {
                if (conf.isCarboxylGroupsDeprotonated()) {
                    currentCarbon.setTemplateAndInit(AtomTemplate.COOH_C_OX);
                } else {
                    currentCarbon.setTemplateAndInit(AtomTemplate.COOH_C_OH);
                }
            } else {
                currentCarbon.setTemplateAndInit(AtomTemplate.BB_C);
            }
            currentCarbon.setName(currentCarbon.getTemplate().formatAtomName(pos));
            if (pos == 1) {
                this.addAtom(currentCarbon);
            } else {
                this.addAtom(currentCarbon, previousCarbon, boToPreviousCarbon);
            }
            if (hasOH) {
                if (pos == this.getRingEnd()) {
                    Atom ringO = new Atom(Periodic.O);
                    ringO.setTemplateAndInit(AtomTemplate.BB_OR);
                    ringO.setName(ringO.getTemplate().formatAtomName(pos));
                    this.addAtom(ringO, currentCarbon, 1.0);
                    this.addBond(ringO, anomericCarbon, 1.0);
                } else {
                    Atom ohO = new Atom(Periodic.O);
                    ohO.setTemplateAndInit(AtomTemplate.BB_O);
                    ohO.setName(ohO.getTemplate().formatAtomName(pos));
                    this.addAtom(ohO, currentCarbon, 1.0);
                    Atom ohH = new Atom(Periodic.H);
                    ohH.setTemplateAndInit(AtomTemplate.BB_HO);
                    ohH.setName(ohH.getTemplate().formatAtomName(pos));
                    this.addAtom(ohH, ohO, 1.0);
                }
            }
            if (isUlo) {
                Atom oc = new Atom(Periodic.O);
                oc.setTemplateAndInit(AtomTemplate.BB_O);
                oc.setName(oc.getTemplate().formatAtomName(pos));
                this.addAtom(oc, currentCarbon, 2.0);
            }
            if (isAcid) {
                if (conf.isCarboxylGroupsDeprotonated()) {
                    Atom oa = new Atom(Periodic.O);
                    oa.setTemplateAndInit(AtomTemplate.COOH_OX);
                    oa.setName(oa.getTemplate().formatAtomName(pos, 0));
                    this.addAtom(oa, currentCarbon, 1.5);
                    Atom ob = new Atom(Periodic.O);
                    ob.setTemplateAndInit(AtomTemplate.COOH_OX);
                    ob.setName(oa.getTemplate().formatAtomName(pos, 1));
                    this.addAtom(ob, currentCarbon, 1.5);
                } else {
                    Atom o = new Atom(Periodic.O);
                    o.setTemplateAndInit(AtomTemplate.COOH_O);
                    o.setName(o.getTemplate().formatAtomName(pos));
                    this.addAtom(o, currentCarbon, 2.0);
                    Atom ohO = new Atom(Periodic.O);
                    ohO.setTemplateAndInit(AtomTemplate.COOH_OH);
                    ohO.setName(ohO.getTemplate().formatAtomName(pos));
                    this.addAtom(ohO, currentCarbon, 1.0);
                    Atom ohH = new Atom(Periodic.H);
                    ohH.setTemplateAndInit(AtomTemplate.COOH_H);
                    ohH.setName(ohH.getTemplate().formatAtomName(pos));
                    this.addAtom(ohH, ohO, 1.0);
                }
            }
            if (hCount == 1) {
                Atom hn = new Atom(Periodic.H);
                hn.setTemplateAndInit(AtomTemplate.BB_H);
                hn.setName(hn.getTemplate().formatAtomName(pos));
                this.addAtom(hn, currentCarbon, 1.0);
            } else {
                for (int h = 0; h < hCount; ++h) {
                    Atom hn = new Atom(Periodic.H);
                    hn.setTemplateAndInit(AtomTemplate.BB_HX);
                    hn.setName(hn.getTemplate().formatAtomName(pos, h));
                    this.addAtom(hn, currentCarbon, 1.0);
                }
            }
            previousCarbon = currentCarbon;
        }
    }

    public Atom getLinkingAtom(int position, LinkageType linktype) throws ResourcesDbException {
        Atom linkAtom = null;
        Atom removeAtom = null;
        if (linktype.equals((Object)LinkageType.H_AT_OH)) {
            linkAtom = this.getAtomByName(AtomTemplate.BB_O.formatAtomName(position));
            removeAtom = this.getAtomByName(AtomTemplate.BB_HO.formatAtomName(position));
        } else if (linktype.equals((Object)LinkageType.DEOXY)) {
            linkAtom = this.getAtomByName(AtomTemplate.BB_C.formatAtomName(position));
            removeAtom = this.getAtomByName(AtomTemplate.BB_O.formatAtomName(position));
        } else if (linktype.equals((Object)LinkageType.H_LOSE)) {
            linkAtom = this.getAtomByName(AtomTemplate.BB_C.formatAtomName(position));
            removeAtom = this.getAtomByName(AtomTemplate.BB_H.formatAtomName(position));
        }
        if (linkAtom == null) {
            throw new MonosaccharideException("Cannot get linking atom for " + linktype.name() + " linkage at position " + position);
        }
        if (removeAtom == null) {
            throw new MonosaccharideException("Cannot get atom to be removed for " + linktype.name() + " linkage at position " + position);
        }
        return linkAtom;
    }

    public void buildComposition() throws ResourcesDbException {
        this.buildComposition(Config.getGlobalConfig());
    }

    public void buildComposition(Config conf) throws ResourcesDbException {
        Composition compo = new Composition();
        compo.increaseCount(Periodic.C, this.getSize());
        compo.increaseCount(Periodic.H, 2 * this.getSize());
        compo.increaseCount(Periodic.O, this.getSize());
        for (CoreModification mod : this.getCoreModifications()) {
            if (mod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) {
                throw new MonosaccharideException("Cannot build composition for basetype with enx core modification");
            }
            compo.addComposition(mod.getTemplate().getCompositionChanges());
            if (mod.getTemplate().equals((Object)CoreModificationTemplate.ACID)) {
                if (mod.getIntValuePosition1() == 0) {
                    throw new MonosaccharideException("Cannot build composition for basetype with unknown acid position");
                }
                if (this.getRingStart() == 0 && mod.getIntValuePosition1() == 1) {
                    throw new MonosaccharideException("Cannot build composition for basetype with unknown carbonyl position and acid modification at position 1");
                }
                if (mod.getIntValuePosition1() != this.getRingStart()) {
                    compo.decreaseCount(Periodic.H, 2);
                }
                if (conf.isCarboxylGroupsDeprotonated()) {
                    compo.decreaseCount(Periodic.H, 1);
                }
            }
            if (mod.getTemplate().equals((Object)CoreModificationTemplate.LACTONE) && conf.isCarboxylGroupsDeprotonated()) {
                compo.increaseCount(Periodic.H, 1);
            }
            if (!mod.getTemplate().equals((Object)CoreModificationTemplate.KETO) || mod.getIntValuePosition1() <= 1 || this.hasCoreModification(CoreModificationTemplate.KETO, 1) || this.hasCoreModification(CoreModificationTemplate.ALDITOL, 1)) continue;
            compo.addComposition(CoreModificationTemplate.ALDITOL.getCompositionChanges());
        }
        this.setComposition(compo);
    }

    public void buildName() throws ResourcesDbException {
        GlycoCTExporter exporter = new GlycoCTExporter(GlycanNamescheme.MONOSACCHARIDEDB, this.getConfig(), this.getTemplateContainer());
        Monosaccharide ms = new Monosaccharide(this);
        this.setName(exporter.export(ms));
    }

    public static void buildBasetypeByExtendedStereocode(String extStereoStr, Basetype bt) throws ResourcesDbException {
        BasetypeBuilderGroup buildergroup;
        Utils.setTemplateDataIfNotSet(Config.getGlobalConfig());
        if (bt == null) {
            throw new MonosaccharideException("Basetype must not be null in buildBasetypeByExtendedStereocode().");
        }
        if (extStereoStr == null) {
            throw new MonosaccharideException("StereoString must not be null in buildBasetypeByExtendedStereocode().");
        }
        if (extStereoStr.length() != bt.getSize()) {
            throw new MonosaccharideException("StereoString length (" + extStereoStr.length() + ") doesn't match basetype size (" + bt.size + ")");
        }
        ArrayList<BasetypeBuilderGroup> groupList = new ArrayList<BasetypeBuilderGroup>(bt.getSize());
        for (int pos = 1; pos <= bt.getSize(); ++pos) {
            char posSymbol = extStereoStr.charAt(pos - 1);
            buildergroup = BasetypeBuilderGroup.forExtStereoSymbol(posSymbol);
            if (buildergroup == null) {
                throw new MonosaccharideException("Unknown stereocode symbol: '" + posSymbol + "'");
            }
            if (pos == 1 && bt.getRingStart() != 1) {
                if (!buildergroup.isHeadTail()) {
                    throw new MonosaccharideException("Stereocode symbol '" + posSymbol + "' is not allowed at position " + pos + " (only valid for non-terminal exocyclic positions)");
                }
            } else if (pos == bt.getSize() && bt.getRingEnd() < pos) {
                if (!buildergroup.isHeadTail()) {
                    throw new MonosaccharideException("Stereocode symbol '" + posSymbol + "' is not allowed at position " + pos + " (only valid for non-terminal exocyclic positions)");
                }
            } else if (buildergroup.isHeadTail() && pos < bt.getSize() && pos > 1) {
                throw new MonosaccharideException("Stereocode symbol '" + posSymbol + "' is not allowed at position " + pos + " (only valid for terminal positions)");
            }
            groupList.add(buildergroup);
        }
        String stereo = "";
        for (int pos = 1; pos <= bt.getSize(); ++pos) {
            buildergroup = (BasetypeBuilderGroup)((Object)groupList.get(pos - 1));
            if (pos == bt.getRingStart()) {
                if (buildergroup.equals((Object)BasetypeBuilderGroup.KETO)) {
                    throw new MonosaccharideException("KETO modification not allowed at ring start position. Select D or L configuration to indicate orientation of OH group at anomeric center.");
                }
                if (buildergroup.equals((Object)BasetypeBuilderGroup.CHO)) {
                    throw new MonosaccharideException("Carbonyl group not allowed at ring start position. Select D or L configuration to indicate orientation of OH group at anomeric center.");
                }
            }
            if (pos == 1 && (buildergroup.equals((Object)BasetypeBuilderGroup.CH3) || buildergroup.equals((Object)BasetypeBuilderGroup.H2COH)) && bt.getRingEnd() == -1 && !BasetypeBuilderGroup.hasCoreModification(groupList, CoreModificationTemplate.KETO)) {
                bt.addCoreModification(CoreModificationTemplate.ALDITOL, 1);
            }
            stereo = stereo + buildergroup.getStereoSymbol();
            for (CoreModificationTemplate modTmpl : buildergroup.getCoreMods()) {
                CoreModification mod;
                char nextPosSymbol;
                BasetypeBuilderGroup nextPosGroup;
                if (modTmpl.equals((Object)CoreModificationTemplate.EN)) {
                    CoreModification existEn = bt.getCoreModification(CoreModificationTemplate.EN, pos - 1);
                    if (existEn != null && existEn.getIntValuePosition1() == pos - 1) continue;
                    if (pos < bt.getSize() && (nextPosGroup = BasetypeBuilderGroup.forExtStereoSymbol(nextPosSymbol = extStereoStr.charAt(pos))).getCoreMods() != null && nextPosGroup.getCoreMods().contains((Object)CoreModificationTemplate.EN)) {
                        mod = new CoreModification(modTmpl, pos, pos + 1);
                        bt.addCoreModification(mod);
                        continue;
                    }
                    throw new MonosaccharideException("Position " + pos + " is single EN modification position (must be followed or preceeded by another EN modification position)");
                }
                if (modTmpl.equals((Object)CoreModificationTemplate.YN)) {
                    CoreModification existYn = bt.getCoreModification(CoreModificationTemplate.YN, pos - 1);
                    if (existYn != null && existYn.getIntValuePosition1() == pos - 1) continue;
                    if (pos < bt.getSize() && (nextPosGroup = BasetypeBuilderGroup.forExtStereoSymbol(nextPosSymbol = extStereoStr.charAt(pos))).getCoreMods() != null && nextPosGroup.getCoreMods().contains((Object)CoreModificationTemplate.YN)) {
                        mod = new CoreModification(modTmpl, pos, pos + 1);
                        bt.addCoreModification(mod);
                        continue;
                    }
                    throw new MonosaccharideException("Position " + pos + " is single EN modification position (must be followed or preceeded by another EN modification position)");
                }
                if (modTmpl.equals((Object)CoreModificationTemplate.KETO) && pos > bt.getRingStart() && bt.getRingStart() > 0 && !bt.hasCoreModification(CoreModificationTemplate.KETO, bt.getRingStart())) {
                    bt.addCoreModification(CoreModificationTemplate.KETO, bt.getRingStart());
                }
                bt.addCoreModification(modTmpl, pos);
            }
        }
        bt.setStereoStr(stereo);
        bt.setConfiguration(Stereocode.getConfigurationFromStereoString(stereo));
        bt.setAnomer(bt.getAnomerFromStereocode());
        if (bt.getRingStart() > 1) {
            if (!bt.hasCoreModification(CoreModificationTemplate.KETO, bt.getRingStart())) {
                bt.addCoreModification(new CoreModification(CoreModificationTemplate.KETO, bt.getRingStart()));
            }
        } else if (bt.hasCoreModification(CoreModificationTemplate.KETO, 1) && bt.countCoreModifications(CoreModificationTemplate.KETO) == 1) {
            bt.deleteCoreModification(CoreModificationTemplate.KETO, 1);
        }
        bt.buildName();
    }

    public void buildByExtendedStereocode(String extStereoStr, int size, int ringStart, int ringEnd) throws ResourcesDbException {
        this.init();
        this.setSize(size);
        this.setRingStart(ringStart);
        this.setRingEnd(ringEnd);
        Basetype.buildBasetypeByExtendedStereocode(extStereoStr, this);
    }

    public ArrayList<BasetypeBuilderGroup> toBuilderGroups() throws ResourcesDbException {
        ArrayList<BasetypeBuilderGroup> outList = new ArrayList<BasetypeBuilderGroup>();
        for (int i = 1; i <= this.getSize(); ++i) {
            StereoConfiguration posConf = this.getStereoConfigurationByPosition(i);
            if (posConf.equals((Object)StereoConfiguration.Dexter) || posConf.equals((Object)StereoConfiguration.XDexter)) {
                outList.add(BasetypeBuilderGroup.HCOH_D);
                continue;
            }
            if (posConf.equals((Object)StereoConfiguration.Laevus) || posConf.equals((Object)StereoConfiguration.XLaevus)) {
                outList.add(BasetypeBuilderGroup.HCOH_L);
                continue;
            }
            Boolean headTailFlag = false;
            if (i == 1 && i != this.getRingStart() || i == this.getSize()) {
                headTailFlag = true;
            }
            ArrayList<CoreModificationTemplate> modList = this.getCoreModificationTemplatesByPosition(i);
            modList.remove((Object)CoreModificationTemplate.ALDITOL);
            BasetypeBuilderGroup bbgroup = BasetypeBuilderGroup.forCoreModifications(modList, headTailFlag);
            if (bbgroup == null) {
                bbgroup = BasetypeBuilderGroup.UNKNOWN;
            }
            outList.add(bbgroup);
        }
        return outList;
    }

    @Override
    public void init() {
        this.setStereocode(new Stereocode());
        this.setSize(0);
        this.setRingStart(0);
        this.setRingEnd(0);
        this.setDefaultCarbonylPosition(0);
        this.coreModifications = new ArrayList<CoreModification>();
        this.setAnomer((Anomer)null);
        this.setConfiguration((StereoConfiguration)null);
        this.setName(null);
        this.setComposition(null);
        this.setMonoMass(null);
        this.setAvgMass(null);
        this.setSuperclass(null);
        this.setIsSuperclassFlag(null);
        this.setInchi(null);
        this.setSmiles(null);
        this.setDbId(0);
    }

    public String toString() {
        String outStr = "Basetype: ";
        outStr = outStr + "[Name: " + this.getName() + "; ";
        String anomerStr = "null";
        if (this.getAnomer() != null) {
            anomerStr = this.getAnomer().getSymbol();
        }
        String stereocodeStr = "null";
        if (this.getStereocode() != null) {
            stereocodeStr = this.getStereocode().getStereoStr();
        }
        String configStr = "null";
        if (this.getConfiguration() != null) {
            configStr = this.getConfiguration().getSymbol();
        }
        String modStr = "";
        if (this.getCoreModifications() != null) {
            for (int i = 0; i < this.getCoreModifications().size(); ++i) {
                modStr = modStr + this.getCoreModifications().get(i).toString();
            }
        }
        outStr = outStr + "Anomer: " + anomerStr + "; ";
        outStr = outStr + "Stereocode: " + stereocodeStr + "; ";
        outStr = outStr + "Configuration: " + configStr + "; ";
        outStr = outStr + "Ring atoms: " + this.getRingStart() + "/" + this.getRingEnd() + "; ";
        outStr = outStr + "Modifications: [" + modStr + "]";
        outStr = outStr + "]";
        return outStr;
    }
}

