/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.forms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.grits.toolbox.tools.glycanbuilder.core.workspace.BuilderWorkspaceSWT;
import org.grits.toolbox.tools.glycanbuilder.widgets.canvas.GlycanCanvasWithToolBarComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.dialog.DisplaySettingsDialog;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.FormAbstract;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.Messages;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.MultiPageFormAbstract;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GeneralIconProvider;
import org.grits.toolbox.tools.glycanbuilder.widgets.utils.GlycanIconProvider;

public class ViewSettingsForm
extends FormAbstract {
    private static final String[] SCALE_PERSENT = new String[]{"400%", "300%", "200%", "150%", "100%", "67%", "50%", "33%", "25%"};
    private static final double[] SCALE_VALUE = new double[]{4.0, 3.0, 2.0, 1.5, 1.0, 0.67, 0.5, 0.33, 0.25};
    private Button btnReset;
    private Map<String, Button> mapNotationToBtn = new HashMap<String, Button>();
    private Map<String, Button> mapDisplayStyleToBtn = new HashMap<String, Button>();
    private Button btnShowCollapse;
    private Button btnShowMass;
    private Button btnShowRedend;
    private Button btnShowID;
    private Button btnDisplayChange;
    private int iOrientation;
    private Button btnDisplayOrientation;
    private Combo cmbDisplayChangeScale;
    private Button btnShowPager;

    public ViewSettingsForm(MultiPageFormAbstract parent, String tabText) {
        super(parent, tabText);
        this.createControl();
    }

    private void createControl() {
        Button button;
        Button btn;
        this.getForm().setText(Messages.getString("ViewSettings.title"));
        this.btnReset = btn = this.getToolkit().createButton(this.getForm().getBody(), Messages.getString("ViewSettings.default"), 8);
        Composite sectionClient = this.createNewSection(Messages.getString("ViewSettings.format"));
        ArrayList<String> lNotations = new ArrayList<String>();
        lNotations.add("snfg");
        lNotations.add("cfg");
        lNotations.add("cfgbw");
        lNotations.add("cfglink");
        lNotations.add("uoxf");
        lNotations.add("uoxfcol");
        lNotations.add("text");
        for (String notation : lNotations) {
            Button button2 = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.format_" + notation), 16);
            this.mapNotationToBtn.put(notation, button2);
        }
        sectionClient = this.createNewSection(Messages.getString("ViewSettings.style"));
        ArrayList<String> lStyles = new ArrayList<String>();
        lStyles.add("compact");
        lStyles.add("normal");
        lStyles.add("normalinfo");
        lStyles.add("custom");
        for (String style : lStyles) {
            Button button3 = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.style_" + style), 16);
            this.mapDisplayStyleToBtn.put(style, button3);
        }
        sectionClient = this.createNewSection(Messages.getString("ViewSettings.show"));
        this.btnShowCollapse = button = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.show_collapse"), 32);
        this.btnShowMass = button = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.show_mass"), 32);
        this.btnShowRedend = button = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.show_redend"), 32);
        this.btnShowID = button = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.show_id"), 32);
        sectionClient = this.createNewSection(Messages.getString("ViewSettings.display"));
        sectionClient.setLayout((Layout)new GridLayout(2, false));
        button = this.getToolkit().createButton(sectionClient, null, 0x800000);
        button.setImage(GeneralIconProvider.getChangeDisplayIcon());
        button.setToolTipText(Messages.getString("ViewSettings.display_change"));
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnDisplayChange = button;
        this.iOrientation = 0;
        button = this.getToolkit().createButton(sectionClient, null, 0x800000);
        button.setImage(GeneralIconProvider.getOrientationIcon(this.iOrientation));
        button.setToolTipText(Messages.getString("ViewSettings.display_orientation"));
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnDisplayOrientation = button;
        this.getToolkit().createLabel(sectionClient, Messages.getString("ViewSettings.display_scale"));
        Combo cmb = new Combo(sectionClient, 8);
        cmb.setItems(SCALE_PERSENT);
        cmb.select(4);
        this.cmbDisplayChangeScale = cmb;
        button = this.getToolkit().createButton(sectionClient, Messages.getString("ViewSettings.display_pager"), 32);
        button.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.btnShowPager = button;
    }

    public void saveSettingsToWorkspace(BuilderWorkspaceSWT bws) {
        Button btn;
        for (String notation : this.mapNotationToBtn.keySet()) {
            btn = this.mapNotationToBtn.get(notation);
            if (!btn.getSelection()) continue;
            bws.setNotation(notation);
            GlycanIconProvider.setNotation(notation);
        }
        for (String display : this.mapDisplayStyleToBtn.keySet()) {
            btn = this.mapDisplayStyleToBtn.get(display);
            if (!btn.getSelection()) continue;
            bws.setDisplay(display);
        }
        bws.getGraphicOptions().COLLAPSE_MULTIPLE_ANTENNAE = this.btnShowCollapse.getSelection();
        bws.getGraphicOptions().SHOW_MASSES = this.btnShowMass.getSelection();
        bws.getGraphicOptions().SHOW_REDEND = this.btnShowRedend.getSelection();
        bws.getGraphicOptions().SHOW_ID = this.btnShowID.getSelection();
        bws.getGraphicOptions().ORIENTATION = this.iOrientation;
        bws.getGraphicOptions().setScale(SCALE_VALUE[this.cmbDisplayChangeScale.getSelectionIndex()]);
    }

    public void loadSettingsFromWorkspace(BuilderWorkspaceSWT bws) {
        Button btn;
        for (String notation : this.mapNotationToBtn.keySet()) {
            btn = this.mapNotationToBtn.get(notation);
            btn.setSelection(false);
            if (!notation.equals(bws.getGraphicOptions().NOTATION)) continue;
            btn.setSelection(true);
        }
        for (String display : this.mapDisplayStyleToBtn.keySet()) {
            btn = this.mapDisplayStyleToBtn.get(display);
            btn.setSelection(false);
            if (!display.equals(bws.getGraphicOptions().DISPLAY)) continue;
            btn.setSelection(true);
        }
        this.btnShowCollapse.setSelection(bws.getGraphicOptions().COLLAPSE_MULTIPLE_ANTENNAE);
        this.btnShowMass.setSelection(bws.getGraphicOptions().SHOW_MASSES);
        this.btnShowRedend.setSelection(bws.getGraphicOptions().SHOW_REDEND);
        this.btnShowID.setSelection(bws.getGraphicOptions().SHOW_ID);
        this.iOrientation = bws.getGraphicOptions().ORIENTATION;
        this.btnDisplayOrientation.setImage(GeneralIconProvider.getOrientationIcon(this.iOrientation));
        double curScale = bws.getGraphicOptions().SCALE;
        int inx = 0;
        double minDiff = Double.MAX_VALUE;
        int i = 0;
        while (i < SCALE_VALUE.length) {
            double scale = SCALE_VALUE[i];
            double diff = Math.abs(curScale - scale);
            if (diff < minDiff) {
                minDiff = diff;
                inx = i;
            }
            ++i;
        }
        this.cmbDisplayChangeScale.select(inx);
    }

    private void setDefaultToWorkspace(BuilderWorkspaceSWT bws) {
        bws.setNotation("snfg");
        bws.setDisplay("normalinfo");
        bws.getGraphicOptions().COLLAPSE_MULTIPLE_ANTENNAE = true;
        bws.getGraphicOptions().SHOW_MASSES = true;
        bws.getGraphicOptions().SHOW_REDEND = true;
        bws.getGraphicOptions().SHOW_ID = false;
        bws.getGraphicOptions().ORIENTATION = 0;
        bws.getGraphicOptions().setScale(1.0);
    }

    public void addCanvasUpdateListener(final GlycanCanvasWithToolBarComposite canvas) {
        this.addChangeViewSettingsListener(canvas.getGlycanCanvas().getBuilderWorkspace());
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.updateView();
            }
        };
        this.btnReset.addSelectionListener((SelectionListener)listener);
        for (Button btn : this.mapNotationToBtn.values()) {
            btn.addSelectionListener((SelectionListener)listener);
        }
        for (Button btn : this.mapDisplayStyleToBtn.values()) {
            btn.addSelectionListener((SelectionListener)listener);
        }
        this.btnShowCollapse.addSelectionListener((SelectionListener)listener);
        this.btnShowMass.addSelectionListener((SelectionListener)listener);
        this.btnShowRedend.addSelectionListener((SelectionListener)listener);
        this.btnShowID.addSelectionListener((SelectionListener)listener);
        this.btnDisplayChange.addSelectionListener((SelectionListener)listener);
        this.btnDisplayOrientation.addSelectionListener((SelectionListener)listener);
        this.cmbDisplayChangeScale.addSelectionListener((SelectionListener)listener);
        this.btnShowPager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getGlycanCanvas().showPager(ViewSettingsForm.this.btnShowPager.getSelection());
                canvas.updateView();
            }
        });
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                canvas.getShortcutToolBar().updateOrientationIcon();
            }
        };
        this.btnReset.addSelectionListener((SelectionListener)listener);
        this.btnDisplayOrientation.addSelectionListener((SelectionListener)listener);
        canvas.getShortcutToolBar().getChangeOrientationItem().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewSettingsForm.this.btnDisplayOrientation.setImage(GeneralIconProvider.getOrientationIcon(canvas.getGlycanCanvas().getBuilderWorkspace().getGraphicOptions().ORIENTATION));
            }
        });
        canvas.getGlycanCanvas().addMouseWheelListener(new MouseWheelListener(){

            public void mouseScrolled(MouseEvent e) {
                if ((e.stateMask & SWT.MODIFIER_MASK) != SWT.MOD1) {
                    return;
                }
                int inx = ViewSettingsForm.this.cmbDisplayChangeScale.getSelectionIndex();
                inx = e.count > 0 ? --inx : ++inx;
                if (inx < 0) {
                    inx = 0;
                }
                if (inx > ViewSettingsForm.this.cmbDisplayChangeScale.getItemCount() - 1) {
                    inx = ViewSettingsForm.this.cmbDisplayChangeScale.getItemCount() - 1;
                }
                ViewSettingsForm.this.cmbDisplayChangeScale.select(inx);
                canvas.getGlycanCanvas().getBuilderWorkspace().getGraphicOptions().setScale(SCALE_VALUE[inx]);
                canvas.updateView();
            }
        });
    }

    private void addChangeViewSettingsListener(final BuilderWorkspaceSWT bws) {
        Button btn = this.btnReset;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ViewSettingsForm.this.setDefaultToWorkspace(bws);
                ViewSettingsForm.this.loadSettingsFromWorkspace(bws);
                GlycanIconProvider.setNotation(bws.getGraphicOptions().NOTATION);
            }
        });
        for (final String notation : this.mapNotationToBtn.keySet()) {
            btn = this.mapNotationToBtn.get(notation);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    bws.setNotation(notation);
                    GlycanIconProvider.setNotation(notation);
                }
            });
        }
        for (final String style : this.mapDisplayStyleToBtn.keySet()) {
            btn = this.mapDisplayStyleToBtn.get(style);
            btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    bws.setDisplay(style);
                }
            });
        }
        btn = this.btnShowCollapse;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bws.getGraphicOptions().COLLAPSE_MULTIPLE_ANTENNAE = ((Button)e.widget).getSelection();
            }
        });
        btn = this.btnShowMass;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bws.getGraphicOptions().SHOW_MASSES = ((Button)e.widget).getSelection();
            }
        });
        btn = this.btnShowRedend;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bws.getGraphicOptions().SHOW_REDEND = ((Button)e.widget).getSelection();
            }
        });
        btn = this.btnShowID;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bws.getGraphicOptions().SHOW_ID = ((Button)e.widget).getSelection();
            }
        });
        btn = this.btnDisplayChange;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DisplaySettingsDialog dialog = new DisplaySettingsDialog(((Button)e.widget).getShell(), bws.getGraphicOptions());
                dialog.open();
                for (String style : ViewSettingsForm.this.mapDisplayStyleToBtn.keySet()) {
                    Button btnStyle = (Button)ViewSettingsForm.this.mapDisplayStyleToBtn.get(style);
                    if (bws.getGraphicOptions().DISPLAY.equals(style)) {
                        btnStyle.setSelection(true);
                        continue;
                    }
                    btnStyle.setSelection(false);
                }
            }
        });
        btn = this.btnDisplayOrientation;
        btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int orien = bws.getGraphicOptions().ORIENTATION;
                if (orien == 0) {
                    orien = 1;
                } else if (orien == 1) {
                    orien = 2;
                } else if (orien == 2) {
                    orien = 3;
                } else if (orien == 3) {
                    orien = 0;
                }
                bws.getGraphicOptions().ORIENTATION = orien;
                ((Button)e.widget).getImage().dispose();
                ((Button)e.widget).setImage(GeneralIconProvider.getOrientationIcon(orien));
            }
        });
        this.cmbDisplayChangeScale.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selection = ((Combo)e.getSource()).getSelectionIndex();
                bws.getGraphicOptions().setScale(SCALE_VALUE[selection]);
            }
        });
    }
}

