/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.widgets.dialog;

import java.util.HashSet;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanDocument;
import org.grits.toolbox.tools.glycanbuilder.core.structure.document.GlycanInfo;
import org.grits.toolbox.tools.glycanbuilder.database.GlycanDatabaseUtils;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.DatabaseIDComposite;
import org.grits.toolbox.tools.glycanbuilder.widgets.forms.DatabaseInformationComposite;
import org.grits.toolbox.util.structure.glycan.database.GlycanDatabase;
import org.grits.toolbox.util.structure.glycan.database.GlycanStructure;

public class DatabaseExportDialog
extends TitleAreaDialog {
    private GlycanDocument m_doc;
    private Text m_txtDBFile;
    private DatabaseInformationComposite m_dbInfo;
    private DatabaseIDComposite m_dbID;

    public DatabaseExportDialog(Shell parentShell, GlycanDocument doc) {
        super(parentShell);
        this.m_doc = doc;
    }

    public void setDatabaseInformation(DatabaseInformationComposite dbInfo) {
        this.m_dbInfo = dbInfo;
    }

    public void create() {
        super.create();
        this.setTitle("Export structures to database");
        this.validate();
    }

    public Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        this.createControls(container);
        area.pack();
        return area;
    }

    private void createControls(Composite container) {
        this.createFilesControl(container);
        Group grp = new Group(container, 0);
        grp.setText("Database Information");
        grp.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        DatabaseInformationComposite dbInfo = new DatabaseInformationComposite((Composite)grp);
        if (this.m_dbInfo != null) {
            dbInfo.setDatabaseName(this.m_dbInfo.getDatabaseName());
            dbInfo.setDatabaseVersion(this.m_dbInfo.getDatabaseVersion());
            dbInfo.setDatabaseDescription(this.m_dbInfo.getDatabaseDescription());
        }
        dbInfo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DatabaseExportDialog.this.isValidInput();
            }
        });
        this.m_dbInfo = dbInfo;
        grp = new Group(container, 0);
        grp.setText("Database IDs");
        grp.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.m_dbID = new DatabaseIDComposite((Composite)grp);
    }

    private void createFilesControl(final Composite container) {
        Label lbl = new Label(container, 0);
        lbl.setText("Database file");
        lbl.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.m_txtDBFile = new Text(container, 2048);
        this.m_txtDBFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_txtDBFile.setEditable(false);
        Button btnBrowse = new Button(container, 0);
        GridData data = new GridData(0x1000000, 0x1000000, false, false);
        data.widthHint = 100;
        btnBrowse.setLayoutData((Object)data);
        btnBrowse.setText("Save As");
        btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent a_event) {
                FileDialog dlgSave = new FileDialog(container.getShell(), 8192);
                dlgSave.setOverwrite(true);
                dlgSave.setFilterNames(new String[]{"Glycan structure database (.xml)", "All files"});
                dlgSave.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String strFile = dlgSave.open();
                if (strFile != null) {
                    DatabaseExportDialog.this.m_txtDBFile.setText(strFile);
                }
                DatabaseExportDialog.this.validate();
            }
        });
    }

    private void validate() {
        if (this.isValidInput()) {
            this.setErrorMessage(null);
        }
    }

    private boolean isValidInput() {
        if (this.m_txtDBFile.getText().isEmpty()) {
            this.setErrorMessage("Please select a file to save the database.");
            return false;
        }
        if (!this.m_dbInfo.isValidInput()) {
            this.setErrorMessage(this.m_dbInfo.getErrorMessage());
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void okPressed() {
        if (!this.isValidInput()) {
            return;
        }
        this.fillGlycanIDs(this.m_doc);
        GlycanDatabase database = new GlycanDatabase();
        database.setName(this.m_dbInfo.getDatabaseName());
        database.setVersion(this.m_dbInfo.getDatabaseVersion());
        database.setDescription(this.m_dbInfo.getDatabaseDescription());
        int i = 0;
        for (GlycanInfo gInfo : this.m_doc.getStructures()) {
            GlycanStructure gStructure = new GlycanStructure();
            gStructure.setGWBSequence(gInfo.getSequence());
            gStructure.setId(gInfo.getID());
            database.addStructure(gStructure);
            ++i;
        }
        database.setStructureCount(Integer.valueOf(i));
        GlycanDatabaseUtils.saveGlycanDatabase(database, this.m_txtDBFile.getText());
        super.okPressed();
    }

    private void fillGlycanIDs(GlycanDocument doc) {
        HashSet<String> setExistIDs = new HashSet<String>();
        if (!this.m_dbID.isOverwriteIDs()) {
            for (GlycanInfo glycan : doc.getStructures()) {
                setExistIDs.add(glycan.getID());
            }
        }
        int i = 1;
        for (GlycanInfo glycan : doc.getStructures()) {
            if (!this.m_dbID.isOverwriteIDs() && glycan.getID() != null && !glycan.getID().isEmpty()) continue;
            String newID = String.valueOf(this.m_dbID.getIDPrefix()) + i++ + this.m_dbID.getIDPostfix();
            while (setExistIDs.contains(newID)) {
                newID = String.valueOf(this.m_dbID.getIDPrefix()) + i++ + this.m_dbID.getIDPostfix();
            }
            glycan.setID(newID);
        }
    }
}

