/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.grid.internal;

import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.nebula.widgets.grid.internal.BranchRenderer;
import org.eclipse.nebula.widgets.grid.internal.CheckBoxRenderer;
import org.eclipse.nebula.widgets.grid.internal.TextUtils;
import org.eclipse.nebula.widgets.grid.internal.ToggleRenderer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;

public class DefaultCellRenderer
extends GridCellRenderer {
    int leftMargin = 4;
    int rightMargin = 4;
    int topMargin = 0;
    int bottomMargin = 0;
    int textTopMargin = 1;
    int textBottomMargin = 2;
    private final int insideMargin = 3;
    int treeIndent = 20;
    private ToggleRenderer toggleRenderer;
    private BranchRenderer branchRenderer;
    private CheckBoxRenderer checkRenderer;
    private TextLayout textLayout;

    @Override
    public void paint(GC gc, Object value) {
        Image image;
        GridItem item = (GridItem)((Object)value);
        gc.setFont(item.getFont(this.getColumn()));
        boolean drawAsSelected = this.isSelected();
        boolean drawBackground = true;
        if (this.isCellSelected()) {
            drawAsSelected = true;
        }
        if (drawAsSelected) {
            gc.setBackground(this.getDisplay().getSystemColor(26));
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            if (item.getParent().isEnabled()) {
                Color back = item.getBackground(this.getColumn());
                if (back != null) {
                    gc.setBackground(back);
                } else {
                    drawBackground = false;
                }
            } else {
                gc.setBackground(this.getDisplay().getSystemColor(22));
            }
            Color foreground = item.getForeground(this.getColumn());
            gc.setForeground(foreground == null ? this.getDisplay().getSystemColor(21) : foreground);
        }
        if (drawBackground) {
            gc.fillRectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width, this.getBounds().height);
        }
        int x = this.leftMargin;
        if (this.isTree()) {
            boolean renderBranches = item.getParent().getTreeLinesVisible();
            if (renderBranches) {
                this.branchRenderer.setBranches(this.getBranches(item));
                this.branchRenderer.setIndent(this.treeIndent);
                this.branchRenderer.setBounds(this.getBounds().x + x, this.getBounds().y, this.getToggleIndent(item), this.getBounds().height + 1);
            }
            this.toggleRenderer.setExpanded(item.isExpanded());
            this.toggleRenderer.setHover(this.getHoverDetail().equals("toggle"));
            this.toggleRenderer.setLocation(this.getBounds().x + (x += this.getToggleIndent(item)), (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2 + this.getBounds().y);
            if (item.hasChildren()) {
                this.toggleRenderer.paint(gc, null);
            }
            if (renderBranches) {
                this.branchRenderer.setToggleBounds(this.toggleRenderer.getBounds());
                this.branchRenderer.paint(gc, null);
            }
            x += this.toggleRenderer.getBounds().width + 3;
        }
        if (this.isCheck()) {
            this.checkRenderer.setChecked(item.getChecked(this.getColumn()));
            this.checkRenderer.setGrayed(item.getGrayed(this.getColumn()));
            if (!item.getParent().isEnabled()) {
                this.checkRenderer.setGrayed(true);
            }
            this.checkRenderer.setHover(this.getHoverDetail().equals("check"));
            if (this.isCenteredCheckBoxOnly(item)) {
                this.checkRenderer.setBounds(this.getBounds().x + (this.getBounds().width - this.checkRenderer.getBounds().width) / 2, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
            } else {
                this.checkRenderer.setBounds(this.getBounds().x + x, (this.getBounds().height - this.checkRenderer.getBounds().height) / 2 + this.getBounds().y, this.checkRenderer.getBounds().width, this.checkRenderer.getBounds().height);
                x += this.checkRenderer.getBounds().width + 3;
            }
            this.checkRenderer.paint(gc, null);
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            int y = this.getBounds().y;
            gc.drawImage(image, this.getBounds().x + x, y += (this.getBounds().height - image.getBounds().height) / 2);
            x += image.getBounds().width + 3;
        }
        int width = this.getBounds().width - x - this.rightMargin;
        if (drawAsSelected) {
            gc.setForeground(this.getDisplay().getSystemColor(27));
        } else {
            gc.setForeground(item.getForeground(this.getColumn()));
        }
        if (!this.isWordWrap()) {
            int len;
            String text = TextUtils.getShortString(gc, item.getText(this.getColumn()), width);
            if (this.getAlignment() == 131072) {
                int len2 = gc.stringExtent((String)text).x;
                if (len2 < width) {
                    x += width - len2;
                }
            } else if (this.getAlignment() == 0x1000000 && (len = gc.stringExtent((String)text).x) < width) {
                x += (width - len) / 2;
            }
            gc.drawString(text, this.getBounds().x + x, this.getBounds().y + this.textTopMargin + this.topMargin, true);
        } else {
            if (this.textLayout == null) {
                this.textLayout = new TextLayout(gc.getDevice());
                item.getParent().addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        DefaultCellRenderer.this.textLayout.dispose();
                    }
                });
            }
            this.textLayout.setFont(gc.getFont());
            this.textLayout.setText(item.getText(this.getColumn()));
            this.textLayout.setAlignment(this.getAlignment());
            this.textLayout.setWidth(width < 1 ? 1 : width);
            if (item.getParent().isAutoHeight()) {
                int columnCount = item.getParent().getColumnCount();
                int maxHeight = this.textLayout.getBounds().height + this.textTopMargin + this.textBottomMargin;
                int i = 0;
                while (i < columnCount) {
                    GridColumn column = item.getParent().getColumn(i);
                    if (i != this.getColumn() && column.getWordWrap()) {
                        int height = column.getCellRenderer().computeSize((GC)gc, (int)column.getWidth(), (int)-1, (Object)((Object)item)).y;
                        maxHeight = Math.max(maxHeight, height);
                    }
                    ++i;
                }
                if (item.getParent().isWordWrapHeader()) {
                    int height = item.getParent().getRowHeaderRenderer().computeSize((GC)gc, (int)-1, (int)-1, (Object)((Object)item)).y;
                    maxHeight = Math.max(maxHeight, height);
                }
                if (maxHeight != item.getHeight()) {
                    item.setHeight(maxHeight);
                }
            }
            this.textLayout.draw(gc, this.getBounds().x + x, this.getBounds().y + this.textTopMargin + this.topMargin);
        }
        if (item.getParent().getLinesVisible()) {
            if (this.isCellSelected()) {
                gc.setForeground(this.getDisplay().getSystemColor(17));
            } else {
                gc.setForeground(item.getParent().getLineColor());
            }
            gc.drawLine(this.getBounds().x, this.getBounds().y + this.getBounds().height, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
            gc.drawLine(this.getBounds().x + this.getBounds().width - 1, this.getBounds().y, this.getBounds().x + this.getBounds().width - 1, this.getBounds().y + this.getBounds().height);
        }
        if (this.isCellFocus()) {
            Rectangle focusRect = new Rectangle(this.getBounds().x, this.getBounds().y, this.getBounds().width - 1, this.getBounds().height);
            gc.setForeground(this.getDisplay().getSystemColor(24));
            gc.drawRectangle(focusRect);
            if (this.isFocus()) {
                ++focusRect.x;
                focusRect.width -= 2;
                ++focusRect.y;
                focusRect.height -= 2;
                gc.drawRectangle(focusRect);
            }
        }
    }

    private int[] getBranches(GridItem item) {
        int[] branches = new int[item.getLevel() + 1];
        GridItem[] roots = item.getParent().getRootItems();
        branches[item.getLevel()] = item.getParentItem() == null ? (!item.isExpanded() && ((Object)((Object)roots[roots.length - 1])).equals((Object)item) ? (item.hasChildren() ? 128 : 36) : (item.hasChildren() ? 192 : 20)) : (item.hasChildren() ? (item.isExpanded() ? 64 : 0) : 8);
        GridItem parent = item.getParentItem();
        if (parent == null) {
            return branches;
        }
        branches[item.getLevel() - 1] = parent.indexOf(item) < parent.getItemCount() - 1 ? 18 : (parent.getParentItem() == null && !((Object)((Object)parent)).equals((Object)roots[roots.length - 1]) ? 18 : 34);
        Grid grid = item.getParent();
        item = parent;
        parent = item.getParentItem();
        while (item.getLevel() > 0) {
            branches[item.getLevel() - 1] = parent.indexOf(item) == parent.getItemCount() - 1 ? (parent.getParentItem() == null && !((Object)((Object)grid.getRootItem(grid.getRootItemCount() - 1))).equals((Object)parent) ? 16 : 0) : 16;
            item = parent;
            parent = item.getParentItem();
        }
        return branches;
    }

    @Override
    public Point computeSize(GC gc, int wHint, int hHint, Object value) {
        GridItem item = (GridItem)((Object)value);
        gc.setFont(item.getFont(this.getColumn()));
        int x = 0;
        x += this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getBounds().width + 3;
        }
        if (this.isCheck()) {
            x += this.checkRenderer.getBounds().width + 3;
        }
        int y = 0;
        Image image = item.getImage(this.getColumn());
        if (image != null) {
            y = this.topMargin + image.getBounds().height + this.bottomMargin;
            x += image.getBounds().width + 3;
        }
        int textHeight = 0;
        if (!this.isWordWrap()) {
            x += gc.textExtent((String)item.getText((int)this.getColumn())).x + this.rightMargin;
            textHeight = this.topMargin + this.textTopMargin + gc.getFontMetrics().getHeight() + this.textBottomMargin + this.bottomMargin;
        } else {
            int plainTextWidth = wHint == -1 ? gc.textExtent((String)item.getText((int)this.getColumn())).x : wHint - x - this.rightMargin;
            TextLayout currTextLayout = new TextLayout(gc.getDevice());
            currTextLayout.setFont(gc.getFont());
            currTextLayout.setText(item.getText(this.getColumn()));
            currTextLayout.setAlignment(this.getAlignment());
            currTextLayout.setWidth(plainTextWidth < 1 ? 1 : plainTextWidth);
            x += plainTextWidth + this.rightMargin;
            textHeight += this.topMargin + this.textTopMargin;
            int cnt = 0;
            while (cnt < currTextLayout.getLineCount()) {
                textHeight += currTextLayout.getLineBounds((int)cnt).height;
                ++cnt;
            }
            textHeight += this.textBottomMargin + this.bottomMargin;
            currTextLayout.dispose();
        }
        y = Math.max(y, textHeight);
        return new Point(x, y);
    }

    @Override
    public boolean notify(int event, Point point, Object value) {
        GridItem item = (GridItem)((Object)value);
        if (this.isCheck()) {
            if (event == 5 && this.overCheck(item, point)) {
                this.setHoverDetail("check");
                return true;
            }
            if (event == 3 && this.overCheck(item, point)) {
                if (!item.getCheckable(this.getColumn())) {
                    return false;
                }
                item.setChecked(this.getColumn(), !item.getChecked(this.getColumn()));
                item.getParent().redraw();
                item.fireCheckEvent(this.getColumn());
                return true;
            }
        }
        if (this.isTree() && item.hasChildren()) {
            if (event == 5 && this.overToggle(item, point)) {
                this.setHoverDetail("toggle");
                return true;
            }
            if (event == 3 && this.overToggle(item, point)) {
                item.setExpanded(!item.isExpanded());
                item.getParent().redraw();
                if (item.isExpanded()) {
                    item.fireEvent(17);
                } else {
                    item.fireEvent(18);
                }
                return true;
            }
        }
        return false;
    }

    private boolean overCheck(GridItem item, Point point) {
        int yStart;
        if (this.isCenteredCheckBoxOnly(item)) {
            point = new Point(point.x, point.y);
            point.x -= this.getBounds().x;
            point.y -= this.getBounds().y;
            Rectangle checkBounds = new Rectangle(0, 0, 0, 0);
            checkBounds.x = (this.getBounds().width - this.checkRenderer.getBounds().width) / 2;
            checkBounds.y = (this.getBounds().height - this.checkRenderer.getBounds().height) / 2;
            checkBounds.width = this.checkRenderer.getBounds().width;
            checkBounds.height = this.checkRenderer.getBounds().height;
            return checkBounds.contains(point);
        }
        point = new Point(point.x, point.y);
        point.x -= this.getBounds().x;
        point.y -= this.getBounds().y;
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getSize().x + 3;
        }
        return point.x >= x && point.x < x + this.checkRenderer.getSize().x && point.y >= (yStart = (this.getBounds().height - this.checkRenderer.getBounds().height) / 2) && point.y < yStart + this.checkRenderer.getSize().y;
    }

    private int getToggleIndent(GridItem item) {
        return item.getLevel() * this.treeIndent;
    }

    private boolean overToggle(GridItem item, Point point) {
        int yStart;
        point = new Point(point.x, point.y);
        point.x -= this.getBounds().x - 1;
        point.y -= this.getBounds().y - 1;
        int x = this.leftMargin;
        return point.x >= (x += this.getToggleIndent(item)) && point.x < x + this.toggleRenderer.getSize().x && point.y >= (yStart = (this.getBounds().height - this.toggleRenderer.getBounds().height) / 2) && point.y < yStart + this.toggleRenderer.getSize().y;
    }

    @Override
    public void setTree(boolean tree) {
        super.setTree(tree);
        if (tree) {
            this.toggleRenderer = new ToggleRenderer();
            this.toggleRenderer.setDisplay(this.getDisplay());
            this.branchRenderer = new BranchRenderer();
            this.branchRenderer.setDisplay(this.getDisplay());
        }
    }

    @Override
    public void setCheck(boolean check) {
        super.setCheck(check);
        if (check) {
            this.checkRenderer = new CheckBoxRenderer();
            this.checkRenderer.setDisplay(this.getDisplay());
        } else {
            this.checkRenderer = null;
        }
    }

    @Override
    public Rectangle getTextBounds(GridItem item, boolean preferred) {
        Image image;
        int x = this.leftMargin;
        if (this.isTree()) {
            x += this.getToggleIndent(item);
            x += this.toggleRenderer.getBounds().width + 3;
        }
        if (this.isCheck()) {
            x += this.checkRenderer.getBounds().width + 3;
        }
        if ((image = item.getImage(this.getColumn())) != null) {
            x += image.getBounds().width + 3;
        }
        Rectangle bounds = new Rectangle(x, this.topMargin + this.textTopMargin, 0, 0);
        GC gc = new GC((Drawable)item.getParent());
        gc.setFont(item.getFont(this.getColumn()));
        Point size = gc.stringExtent(item.getText(this.getColumn()));
        bounds.height = size.y;
        bounds.width = preferred ? size.x - 1 : this.getBounds().width - x - this.rightMargin;
        gc.dispose();
        return bounds;
    }

    private boolean isCenteredCheckBoxOnly(GridItem item) {
        return !this.isTree() && item.getImage(this.getColumn()) == null && item.getText(this.getColumn()).equals("") && this.getAlignment() == 0x1000000;
    }
}

