/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.sugar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraph;
import org.eurocarbdb.MolecularFramework.sugar.GlycoGraphAlternative;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitAlternative;
import org.eurocarbdb.MolecularFramework.sugar.SugarUnitCyclic;
import org.eurocarbdb.MolecularFramework.sugar.UnderdeterminedSubTree;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorNodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sugar
implements GlycoGraph {
    private ArrayList<UnderdeterminedSubTree> m_aSpezialTrees = new ArrayList();
    private ArrayList<GlycoNode> m_aResidues = new ArrayList();

    @Override
    public ArrayList<GlycoNode> getRootNodes() throws GlycoconjugateException {
        ArrayList<GlycoNode> t_aResult = new ArrayList<GlycoNode>();
        Iterator<GlycoNode> t_iterResidue = this.getNodeIterator();
        while (t_iterResidue.hasNext()) {
            GlycoNode t_objResidue = t_iterResidue.next();
            GlycoEdge t_objParents = t_objResidue.getParentEdge();
            if (t_objParents != null) continue;
            t_aResult.add(t_objResidue);
        }
        if (t_aResult.size() < 1) {
            throw new GlycoconjugateException("Sugar seems not to have at least one root residue");
        }
        return t_aResult;
    }

    @Override
    public Iterator<GlycoNode> getNodeIterator() {
        return this.m_aResidues.iterator();
    }

    @Override
    public boolean isConnected() throws GlycoconjugateException {
        ArrayList<GlycoNode> t_objRoots = this.getRootNodes();
        return t_objRoots.size() <= 1;
    }

    @Override
    public boolean removeNode(GlycoNode a_objResidue) throws GlycoconjugateException {
        GlycoNode t_objResidue;
        GlycoEdge t_objLinkage2;
        if (a_objResidue == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (a_objResidue.getClass() != SugarUnitCyclic.class) {
            this.searchCyclicForDeleting(a_objResidue);
        }
        if ((t_objLinkage2 = a_objResidue.getParentEdge()) != null) {
            t_objResidue = t_objLinkage2.getParent();
            if (t_objResidue == null) {
                throw new GlycoconjugateException("A linkage with a null parent exists.");
            }
            t_objResidue.removeChildEdge(t_objLinkage2);
        }
        for (GlycoEdge t_objLinkage2 : a_objResidue.getChildEdges()) {
            t_objResidue = t_objLinkage2.getChild();
            if (t_objResidue == null) {
                throw new GlycoconjugateException("A linkage with a null child exists.");
            }
            t_objResidue.removeParentEdge(t_objLinkage2);
        }
        return this.m_aResidues.remove(a_objResidue);
    }

    @Override
    public ArrayList<GlycoNode> getNodes() {
        return this.m_aResidues;
    }

    @Override
    public boolean addNode(GlycoNode a_objResidue) throws GlycoconjugateException {
        if (a_objResidue == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (a_objResidue.getClass() == SugarUnitCyclic.class) {
            throw new GlycoconjugateException("Not possible to add cyclic unit that way : use addCyclic().");
        }
        if (!this.m_aResidues.contains(a_objResidue)) {
            a_objResidue.removeAllEdges();
            return this.m_aResidues.add(a_objResidue);
        }
        return false;
    }

    @Override
    public boolean addNode(GlycoNode a_objParent, GlycoEdge a_objLinkage, GlycoNode a_objChild) throws GlycoconjugateException {
        if (a_objParent == null || a_objChild == null) {
            throw new GlycoconjugateException("Invalide residue.");
        }
        if (a_objLinkage == null) {
            throw new GlycoconjugateException("Invalide linkage.");
        }
        if (a_objChild.getParentEdge() != null) {
            throw new GlycoconjugateException("The child residue has a parent residue.");
        }
        if (a_objChild.getClass() == SugarUnitCyclic.class) {
            throw new GlycoconjugateException("Not possible to add cyclic unit that way : use addCyclic().");
        }
        if (!this.m_aResidues.contains(a_objParent)) {
            a_objParent.removeAllEdges();
            this.m_aResidues.add(a_objParent);
        }
        if (!this.m_aResidues.contains(a_objChild)) {
            a_objChild.removeAllEdges();
            this.m_aResidues.add(a_objChild);
        }
        if (this.m_aResidues.contains(a_objChild) && this.m_aResidues.contains(a_objParent)) {
            if (this.isParent(a_objChild, a_objParent) || a_objChild == a_objParent) {
                return this.addCyclic(a_objParent, a_objLinkage, a_objChild);
            }
        } else {
            throw new GlycoconjugateException("Critical error imposible to add residue.");
        }
        a_objChild.setParentEdge(a_objLinkage);
        a_objParent.addChildEdge(a_objLinkage);
        a_objLinkage.setChild(a_objChild);
        a_objLinkage.setParent(a_objParent);
        return true;
    }

    public boolean addCyclic(GlycoNode a_objParent, GlycoEdge a_objLinkage, GlycoNode a_objCyclicResidue) throws GlycoconjugateException {
        if (!this.m_aResidues.contains(a_objParent)) {
            throw new GlycoconjugateException("Parent of the cyclic linkage is not part of the sugar.");
        }
        if (!this.m_aResidues.contains(a_objCyclicResidue)) {
            throw new GlycoconjugateException("Cyclic residue of the cyclic linkage is not part of the sugar.");
        }
        if (this.isParent(a_objCyclicResidue, a_objParent) || a_objCyclicResidue == a_objParent) {
            SugarUnitCyclic t_objCyclic = new SugarUnitCyclic(a_objCyclicResidue);
            t_objCyclic.setParentEdge(a_objLinkage);
            a_objParent.addChildEdge(a_objLinkage);
            a_objLinkage.setChild(t_objCyclic);
            a_objLinkage.setParent(a_objParent);
            return this.m_aResidues.add(t_objCyclic);
        }
        throw new GlycoconjugateException("The cyclic residue must be a parent residue of the residue.");
    }

    @Override
    public boolean addEdge(GlycoNode a_objParent, GlycoNode a_objChild, GlycoEdge a_objLinkage) throws GlycoconjugateException {
        return this.addNode(a_objParent, a_objLinkage, a_objChild);
    }

    @Override
    public boolean containsNode(GlycoNode a_objNode) {
        return this.m_aResidues.contains(a_objNode);
    }

    private void searchCyclicForDeleting(GlycoNode a_objResidue) throws GlycoconjugateException {
        for (GlycoNode t_objElement : this.m_aResidues) {
            SugarUnitCyclic t_objCyclic;
            if (t_objElement.getClass() != SugarUnitCyclic.class || (t_objCyclic = (SugarUnitCyclic)t_objElement).getCyclicStart() != a_objResidue) continue;
            this.removeNode(t_objElement);
        }
    }

    @Override
    public boolean isParent(GlycoNode a_objParent, GlycoNode a_objNode) {
        GlycoNode t_objParent = a_objNode.getParentNode();
        if (t_objParent == null) {
            return false;
        }
        if (t_objParent == a_objParent) {
            return true;
        }
        return this.isParent(a_objParent, t_objParent);
    }

    @Override
    public boolean removeEdge(GlycoEdge a_objEdge) throws GlycoconjugateException {
        if (a_objEdge == null) {
            return false;
        }
        GlycoNode t_objChild = a_objEdge.getChild();
        GlycoNode t_objParent = a_objEdge.getParent();
        if (t_objChild == null || t_objParent == null) {
            throw new GlycoconjugateException("The edge contains null values.");
        }
        if (t_objChild.getParentEdge() != a_objEdge) {
            throw new GlycoconjugateException("The child attachment is not correct");
        }
        ArrayList<GlycoEdge> t_aEdges = t_objParent.getChildEdges();
        if (!t_aEdges.contains(a_objEdge)) {
            throw new GlycoconjugateException("The parent attachment is not correct");
        }
        if (this.containsCyclicBelow(a_objEdge)) {
            throw new GlycoconjugateException("You try to remove a edge in a cyclic chain. Remove SugarUnitCyclic first.");
        }
        t_objChild.removeParentEdge(a_objEdge);
        t_objParent.removeChildEdge(a_objEdge);
        return true;
    }

    public Sugar copy() throws GlycoconjugateException {
        GlycoNode t_objNodeTwo;
        ArrayList t_aAlternative = new ArrayList();
        HashMap<GlycoNode, GlycoNode> t_hashResidues = new HashMap<GlycoNode, GlycoNode>();
        Sugar t_objCopy = new Sugar();
        GlycoVisitorNodeType t_visNodeType = new GlycoVisitorNodeType();
        for (GlycoNode t_objNodeOne : this.m_aResidues) {
            try {
                if (t_visNodeType.isSugarUnitCyclic(t_objNodeOne)) continue;
                if (t_visNodeType.isSugarUnitAlternative(t_objNodeOne)) {
                    throw new GlycoconjugateException("Unable to copy alternative residues.");
                }
                t_objNodeTwo = t_objNodeOne.copy();
                t_hashResidues.put(t_objNodeOne, t_objNodeTwo);
                t_objCopy.addNode(t_objNodeTwo);
            }
            catch (GlycoVisitorException e) {
                throw new GlycoconjugateException(e.getMessage(), e);
            }
        }
        for (GlycoNode t_objNodeOne : this.m_aResidues) {
            ArrayList<GlycoEdge> t_aLinkages = t_objNodeOne.getChildEdges();
            for (GlycoEdge t_objLinkOriginal : t_aLinkages) {
                GlycoEdge t_objLinkCopy = t_objLinkOriginal.copy();
                t_objNodeOne = (GlycoNode)t_hashResidues.get(t_objLinkOriginal.getParent());
                t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objLinkOriginal.getChild());
                if (t_objNodeOne == null) {
                    throw new GlycoconjugateException("Impossible to copy sugar. Null values in copy.");
                }
                if (t_objNodeTwo == null) {
                    try {
                        if (t_visNodeType.isSugarUnitCyclic(t_objLinkOriginal.getChild())) {
                            SugarUnitCyclic t_objCyclic = t_visNodeType.getSugarUnitCyclic(t_objLinkOriginal.getChild());
                            t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objCyclic.getCyclicStart());
                            if (t_objNodeTwo == null) {
                                throw new GlycoconjugateException("Error coping cyclic unit.");
                            }
                            t_objCopy.addCyclic(t_objNodeOne, t_objLinkCopy, t_objNodeTwo);
                            continue;
                        }
                        throw new GlycoconjugateException("Impossible to copy sugar. Null values in copy.");
                    }
                    catch (GlycoVisitorException e) {
                        throw new GlycoconjugateException(e.getMessage(), e);
                    }
                }
                t_objCopy.addEdge(t_objNodeOne, t_objNodeTwo, t_objLinkCopy);
            }
        }
        for (SugarUnitAlternative t_objAlternative : t_aAlternative) {
            HashMap<GlycoNode, GlycoNode> t_objMapNew = new HashMap<GlycoNode, GlycoNode>();
            for (GlycoGraphAlternative t_objAltGraph : t_objAlternative.getAlternatives()) {
                t_objMapNew.clear();
                HashMap<GlycoNode, GlycoNode> t_objMapOld = t_objAltGraph.getLeadOutNodeToNode();
                for (GlycoNode t_objKeyNode : t_objMapOld.keySet()) {
                    GlycoNode t_objKeyNodeNew = (GlycoNode)t_hashResidues.get(t_objKeyNode);
                    if (t_objKeyNodeNew == null) {
                        throw new GlycoconjugateException("Error child attache position of alternative graph was not translated.");
                    }
                    t_objMapNew.put(t_objKeyNodeNew, t_objMapOld.get(t_objKeyNode));
                }
                t_objAlternative.setLeadOutNodeToNode(t_objMapNew, t_objAltGraph);
            }
        }
        for (UnderdeterminedSubTree t_objTreeOriginal : this.m_aSpezialTrees) {
            UnderdeterminedSubTree t_objTreeCopy = t_objTreeOriginal.copy();
            t_objCopy.addUndeterminedSubTree(t_objTreeCopy);
            for (GlycoNode t_objNodeOne : t_objTreeOriginal.getParents()) {
                t_objNodeTwo = (GlycoNode)t_hashResidues.get(t_objNodeOne);
                if (t_objNodeTwo == null) {
                    throw new GlycoconjugateException("Impossible to copy sugar. Null values in copy.");
                }
                t_objTreeCopy.addParent(t_objNodeTwo);
            }
        }
        return t_objCopy;
    }

    public void setUndeterminedSubTrees(ArrayList<UnderdeterminedSubTree> a_aSubTree) throws GlycoconjugateException {
        if (a_aSubTree == null) {
            throw new GlycoconjugateException("null is not a valide set of special subtrees.");
        }
        this.m_aSpezialTrees.clear();
        Iterator<UnderdeterminedSubTree> t_iterTree = a_aSubTree.iterator();
        while (t_iterTree.hasNext()) {
            this.addUndeterminedSubTree(t_iterTree.next());
        }
    }

    public ArrayList<UnderdeterminedSubTree> getUndeterminedSubTrees() {
        return this.m_aSpezialTrees;
    }

    public boolean addUndeterminedSubTreeParent(UnderdeterminedSubTree a_objTree, GlycoNode a_objParent) throws GlycoconjugateException {
        if (!this.m_aResidues.contains(a_objParent)) {
            throw new GlycoconjugateException("Parent is not part of the sugar.");
        }
        if (!this.m_aSpezialTrees.contains(a_objTree)) {
            throw new GlycoconjugateException("UnderdeterminedSubTree is not part of the sugar.");
        }
        return a_objTree.addParent(a_objParent);
    }

    public boolean addUndeterminedSubTree(UnderdeterminedSubTree a_objTree) throws GlycoconjugateException {
        if (a_objTree == null) {
            throw new GlycoconjugateException("null is not valide for special subtree.");
        }
        if (!this.m_aSpezialTrees.contains(a_objTree)) {
            return this.m_aSpezialTrees.add(a_objTree);
        }
        return false;
    }

    private boolean containsCyclicBelow(GlycoEdge a_objEdge) throws GlycoconjugateException {
        GlycoNode t_objNode = a_objEdge.getChild();
        if (t_objNode == null) {
            throw new GlycoconjugateException("Critical error in the sugar, one edge contains a null child.");
        }
        if (t_objNode.getClass() == SugarUnitCyclic.class) {
            return true;
        }
        Iterator<GlycoEdge> t_iterEdges = t_objNode.getChildEdges().iterator();
        while (t_iterEdges.hasNext()) {
            if (!this.containsCyclicBelow(t_iterEdges.next())) continue;
            return true;
        }
        return false;
    }
}

