/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.dialogs;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DialogSettings
implements IDialogSettings {
    private String name;
    private Map<String, IDialogSettings> sections;
    private Map<String, String> items;
    private Map<String, String[]> arrayItems;
    private static final String TAG_SECTION = "section";
    private static final String TAG_NAME = "name";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";
    private static final String TAG_LIST = "list";
    private static final String TAG_ITEM = "item";

    public DialogSettings(String sectionName) {
        this.name = sectionName;
        this.items = new HashMap<String, String>();
        this.arrayItems = new HashMap<String, String[]>();
        this.sections = new HashMap<String, IDialogSettings>();
    }

    @Override
    public IDialogSettings addNewSection(String sectionName) {
        DialogSettings section = new DialogSettings(sectionName);
        this.addSection(section);
        return section;
    }

    @Override
    public void addSection(IDialogSettings section) {
        this.sections.put(section.getName(), section);
    }

    public void removeSection(IDialogSettings section) {
        if (this.sections.get(section.getName()) == section) {
            this.sections.remove(section.getName());
        }
    }

    public IDialogSettings removeSection(String sectionName) {
        return this.sections.remove(sectionName);
    }

    @Override
    public String get(String key) {
        return this.items.get(key);
    }

    @Override
    public String[] getArray(String key) {
        return this.arrayItems.get(key);
    }

    @Override
    public boolean getBoolean(String key) {
        return Boolean.valueOf(this.items.get(key));
    }

    @Override
    public double getDouble(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return Double.parseDouble(setting);
    }

    @Override
    public float getFloat(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return Float.parseFloat(setting);
    }

    @Override
    public int getInt(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return Integer.valueOf(setting);
    }

    @Override
    public long getLong(String key) throws NumberFormatException {
        String setting = this.items.get(key);
        if (setting == null) {
            throw new NumberFormatException("There is no setting associated with the key \"" + key + "\"");
        }
        return Long.valueOf(setting);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static IDialogSettings getOrCreateSection(IDialogSettings settings, String sectionName) {
        IDialogSettings section = settings.getSection(sectionName);
        if (section == null) {
            section = settings.addNewSection(sectionName);
        }
        return section;
    }

    @Override
    public IDialogSettings getSection(String sectionName) {
        return this.sections.get(sectionName);
    }

    @Override
    public IDialogSettings[] getSections() {
        Collection<IDialogSettings> values = this.sections.values();
        IDialogSettings[] result = new DialogSettings[values.size()];
        values.toArray(result);
        return result;
    }

    @Override
    public void load(Reader r) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = parser.parse(new InputSource(r));
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
            }
            this.load(document, (Element)root);
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    @Override
    public void load(String fileName) throws IOException {
        FileInputStream stream = new FileInputStream(fileName);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        this.load(reader);
        reader.close();
    }

    private void load(Document document, Element root) {
        Node n;
        this.name = root.getAttribute(TAG_NAME);
        NodeList l = root.getElementsByTagName(TAG_ITEM);
        int i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                String key = ((Element)l.item(i)).getAttribute(TAG_KEY);
                String value = ((Element)l.item(i)).getAttribute(TAG_VALUE);
                this.items.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName(TAG_LIST);
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                Element child = (Element)l.item(i);
                String key = child.getAttribute(TAG_KEY);
                NodeList list = child.getElementsByTagName(TAG_ITEM);
                ArrayList<String> valueList = new ArrayList<String>();
                int j = 0;
                while (j < list.getLength()) {
                    Element node = (Element)list.item(j);
                    if (child == node.getParentNode()) {
                        valueList.add(node.getAttribute(TAG_VALUE));
                    }
                    ++j;
                }
                String[] value = new String[valueList.size()];
                valueList.toArray(value);
                this.arrayItems.put(key, value);
            }
            ++i;
        }
        l = root.getElementsByTagName(TAG_SECTION);
        i = 0;
        while (i < l.getLength()) {
            n = l.item(i);
            if (root == n.getParentNode()) {
                DialogSettings s = new DialogSettings("NoName");
                s.load(document, (Element)n);
                this.addSection(s);
            }
            ++i;
        }
    }

    @Override
    public void put(String key, String[] value) {
        this.arrayItems.put(key, value);
    }

    @Override
    public void put(String key, double value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, float value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, int value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, long value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void put(String key, String value) {
        this.items.put(key, value);
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, String.valueOf(value));
    }

    @Override
    public void save(Writer writer) throws IOException {
        XMLWriter xmlWriter = new XMLWriter(writer);
        this.save(xmlWriter);
        xmlWriter.flush();
    }

    @Override
    public void save(String fileName) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLWriter writer = new XMLWriter(new FileOutputStream(fileName));){
            this.save(writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void save(XMLWriter out) throws IOException {
        String key;
        HashMap<String, String> attributes = new HashMap<String, String>(2);
        attributes.put(TAG_NAME, this.name == null ? "" : this.name);
        out.startTag(TAG_SECTION, attributes);
        attributes.clear();
        for (Map.Entry<String, String> entry : this.items.entrySet()) {
            key = entry.getKey();
            attributes.put(TAG_KEY, key == null ? "" : key);
            String string = entry.getValue();
            attributes.put(TAG_VALUE, string == null ? "" : string);
            out.printTag(TAG_ITEM, attributes, true);
        }
        attributes.clear();
        for (Map.Entry<String, String> entry : this.arrayItems.entrySet()) {
            key = entry.getKey();
            attributes.put(TAG_KEY, key == null ? "" : key);
            out.startTag(TAG_LIST, attributes);
            String[] value = (String[])entry.getValue();
            attributes.clear();
            if (value != null) {
                String[] stringArray = value;
                int n = value.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    attributes.put(TAG_VALUE, string == null ? "" : string);
                    out.printTag(TAG_ITEM, attributes, true);
                    ++n2;
                }
            }
            out.endTag(TAG_LIST);
            attributes.clear();
        }
        for (IDialogSettings iDialogSettings : this.sections.values()) {
            ((DialogSettings)iDialogSettings).save(out);
        }
        out.endTag(TAG_SECTION);
    }

    private static class XMLWriter
    extends BufferedWriter {
        protected int tab = 0;
        protected static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public XMLWriter(OutputStream output) throws IOException {
            this(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        }

        public XMLWriter(Writer output) throws IOException {
            super(output);
            this.writeln(XML_VERSION);
        }

        private void writeln(String text) throws IOException {
            this.write(text);
            this.newLine();
        }

        public void endTag(String name) throws IOException {
            --this.tab;
            this.printTag("/" + name, null, false);
        }

        private void printTabulation() throws IOException {
            int i = 0;
            while (i < this.tab) {
                super.write(9);
                ++i;
            }
        }

        public void printTag(String name, HashMap<String, String> parameters, boolean close) throws IOException {
            this.printTag(name, parameters, true, true, close);
        }

        private void printTag(String name, HashMap<String, String> parameters, boolean shouldTab, boolean newLine, boolean close) throws IOException {
            StringBuilder sb = new StringBuilder();
            sb.append('<');
            sb.append(name);
            if (parameters != null) {
                for (Map.Entry<String, String> entry : parameters.entrySet()) {
                    sb.append(" ");
                    String key = entry.getKey();
                    sb.append(key);
                    sb.append("=\"");
                    sb.append(XMLWriter.getEscaped(String.valueOf(entry.getValue())));
                    sb.append("\"");
                }
            }
            if (close) {
                sb.append('/');
            }
            sb.append('>');
            if (shouldTab) {
                this.printTabulation();
            }
            if (newLine) {
                this.writeln(sb.toString());
            } else {
                this.write(sb.toString());
            }
        }

        public void startTag(String name, HashMap<String, String> parameters) throws IOException {
            this.startTag(name, parameters, true);
            ++this.tab;
        }

        private void startTag(String name, HashMap<String, String> parameters, boolean newLine) throws IOException {
            this.printTag(name, parameters, true, newLine, false);
        }

        private static void appendEscapedChar(StringBuilder buffer, char c) {
            String replacement = XMLWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuilder result = new StringBuilder(s.length() + 10);
            int i = 0;
            while (i < s.length()) {
                XMLWriter.appendEscapedChar(result, s.charAt(i));
                ++i;
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

