/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figures;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.nebula.visualization.internal.widgets.introspection.MeterIntrospector;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScale;
import org.eclipse.nebula.visualization.widgets.figureparts.RoundScaledRamp;
import org.eclipse.nebula.visualization.widgets.figures.AbstractRoundRampedFigure;
import org.eclipse.nebula.visualization.widgets.util.PointsUtil;
import org.eclipse.nebula.visualization.xygraph.util.XYGraphMediaFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;

public class MeterFigure
extends AbstractRoundRampedFigure {
    private static final Font DEFAULT_LABEL_FONT = XYGraphMediaFactory.getInstance().getFont(new FontData("Arial", 12, 1));
    private Needle needle;
    private Label valueLabel;
    private static final double SPACE_ANGLE = 45.0;
    public static final int NEEDLE_WIDTH = 16;
    public static final double ALPHA = 0.7853981633974483;
    public static final double HW_RATIO = (1.0 - Math.sin(0.7853981633974483) / 2.0) / (2.0 * Math.cos(0.7853981633974483));

    public MeterFigure() {
        if (SWT.getPlatform().startsWith("rap")) {
            this.ramp.setVisible(false);
        }
        this.setTransparent(false);
        this.scale.setScaleLineVisible(false);
        ((RoundScale)this.scale).setStartAngle(135.0);
        ((RoundScale)this.scale).setEndAngle(45.0);
        this.ramp.setRampWidth(12);
        this.setLoColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_YELLOW));
        this.setHiColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_YELLOW));
        this.valueLabel = new Label();
        this.valueLabel.setFont(DEFAULT_LABEL_FONT);
        this.needle = new Needle();
        this.needle.setFill(true);
        this.needle.setOutline(false);
        this.setLayoutManager((LayoutManager)new XMeterLayout());
        this.add((IFigure)this.ramp, "ramp");
        this.add((IFigure)this.scale, "scale");
        this.add((IFigure)this.needle, "needle");
        this.add((IFigure)this.valueLabel, "valueLabel");
        this.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                MeterFigure.this.ramp.setDirty(true);
                MeterFigure.this.revalidate();
            }
        });
    }

    public void setBounds(Rectangle rect) {
        super.setBounds(rect);
    }

    @Override
    public void setShowMarkers(boolean showMarkers) {
        super.setShowMarkers(showMarkers);
        if (SWT.getPlatform().startsWith("rap")) {
            this.ramp.setVisible(false);
        } else {
            this.ramp.setVisible(showMarkers);
        }
    }

    @Override
    public void setValue(double value) {
        super.setValue(value);
        this.valueLabel.setText(this.getValueText());
    }

    public void setValueLabelVisibility(boolean visible) {
        this.valueLabel.setVisible(visible);
    }

    public void setNeedleColor(Color needleColor) {
        this.needle.setBackgroundColor(needleColor);
    }

    public Color getNeedleColor() {
        return this.needle.getBackgroundColor();
    }

    @Override
    public BeanInfo getBeanInfo() throws IntrospectionException {
        return new MeterIntrospector().getBeanInfo(this.getClass());
    }

    static class Needle
    extends Polygon {
        public Needle() {
            this.setBackgroundColor(XYGraphMediaFactory.getInstance().getColor(XYGraphMediaFactory.COLOR_RED));
        }

        protected void fillShape(Graphics g) {
            g.setAntialias(1);
            super.fillShape(g);
        }
    }

    class XMeterLayout
    extends AbstractLayout {
        private static final int GAP_BTW_NEEDLE_SCALE = -5;
        int M = 0;
        public static final String SCALE = "scale";
        public static final String NEEDLE = "needle";
        public static final String RAMP = "ramp";
        public static final String VALUE_LABEL = "valueLabel";
        private RoundScale scale;
        private RoundScaledRamp ramp;
        private Polygon needle;
        private Label valueLabel;
        private PointList needlePoints = new PointList(new int[6]);

        XMeterLayout() {
        }

        public void setConstraint(IFigure child, Object constraint) {
            if (constraint.equals(SCALE)) {
                this.scale = (RoundScale)child;
            } else if (constraint.equals(RAMP)) {
                this.ramp = (RoundScaledRamp)child;
            } else if (constraint.equals(NEEDLE)) {
                this.needle = (Polygon)child;
            } else if (constraint.equals(VALUE_LABEL)) {
                this.valueLabel = (Label)child;
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int w, int h) {
            Insets insets = container.getInsets();
            Dimension d = new Dimension(256, 256);
            d.expand(insets.getWidth(), insets.getHeight());
            return d;
        }

        public void layout(IFigure container) {
            int w;
            int h;
            Rectangle area = container.getClientArea();
            if (this.scale != null && this.scale.isDirty()) {
                this.M = Math.max(FigureUtilities.getTextWidth((String)this.scale.format(this.scale.getRange().getLower()), (Font)this.scale.getFont()), FigureUtilities.getTextWidth((String)this.scale.format(this.scale.getRange().getUpper()), (Font)this.scale.getFont())) / 2;
            }
            if ((double)(h = area.height) > HW_RATIO * (double)((w = area.width) - 2 * this.M)) {
                h = (int)(HW_RATIO * (double)(w - 2 * this.M));
            }
            double r = (double)h / (1.0 - Math.sin(0.7853981633974483) / 2.0);
            int x = (int)((double)area.x - r * (1.0 - Math.cos(0.7853981633974483)) + (double)this.M);
            int y = area.y;
            area = new Rectangle(x, y, (int)(2.0 * r), (int)(2.0 * r));
            Point center = area.getCenter();
            if (this.scale != null) {
                this.scale.setBounds(area);
            }
            if (this.ramp != null && this.ramp.isVisible()) {
                Rectangle rampBounds = area.getCopy();
                this.ramp.setBounds(rampBounds.shrink(area.width / 4 - this.ramp.getRampWidth(), area.height / 4 - this.ramp.getRampWidth()));
            }
            if (this.valueLabel != null) {
                Dimension labelSize = this.valueLabel.getPreferredSize();
                this.valueLabel.setBounds(new Rectangle(area.x + area.width / 2 - labelSize.width / 2, area.y + area.height / 2 - area.height / 4 - (this.scale.getInnerRadius() - area.height / 4) / 2 - labelSize.height / 2, labelSize.width, labelSize.height));
            }
            if (this.needle != null && this.scale != null) {
                this.needlePoints.setPoint(new Point(center.x + area.width / 4, center.y - 8 + 3), 0);
                this.scale.getScaleTickMarks();
                this.needlePoints.setPoint(new Point(center.x + this.scale.getInnerRadius() - -5, center.y), 1);
                this.needlePoints.setPoint(new Point(center.x + area.width / 4, center.y + 8 - 3), 2);
                double valuePosition = 360.0 - this.scale.getValuePosition(MeterFigure.this.getCoercedValue(), false);
                if (MeterFigure.this.maximum > MeterFigure.this.minimum) {
                    if (MeterFigure.this.value > MeterFigure.this.maximum) {
                        valuePosition += 8.0;
                    } else if (MeterFigure.this.value < MeterFigure.this.minimum) {
                        valuePosition -= 8.0;
                    }
                } else if (MeterFigure.this.value > MeterFigure.this.minimum) {
                    valuePosition -= 8.0;
                } else if (MeterFigure.this.value < MeterFigure.this.maximum) {
                    valuePosition += 8.0;
                }
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(0), valuePosition, center), 0);
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(1), valuePosition, center), 1);
                this.needlePoints.setPoint((Point)PointsUtil.rotate(this.needlePoints.getPoint(2), valuePosition, center), 2);
                this.needle.setPoints(this.needlePoints);
            }
        }
    }
}

