/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.grits.toolbox.editor.experimentdesigner.model.Connection;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;
import org.grits.toolbox.editor.experimentdesigner.model.MyColor;

public abstract class GraphNode
extends ModelElement {
    private static IPropertyDescriptor[] descriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"Node.xPos", "X"), new TextPropertyDescriptor((Object)"Node.yPos", "Y"), new TextPropertyDescriptor((Object)"Node.Width", "Width"), new TextPropertyDescriptor((Object)"Node.Height", "Height")};
    private static final String HEIGHT_PROP = "Node.Height";
    public static final String LOCATION_PROP = "Node.Location";
    private static final long serialVersionUID = 1L;
    public static final String SIZE_PROP = "Node.Size";
    public static final String SOURCE_CONNECTIONS_PROP = "Node.SourceConn";
    public static final String TARGET_CONNECTIONS_PROP = "Node.TargetConn";
    public static final String LABEL_PROP = "Node.Label";
    private static final String WIDTH_PROP = "Node.Width";
    private static final String XPOS_PROP = "Node.xPos";
    private static final String YPOS_PROP = "Node.yPos";
    private Point location = new Point(0, 0);
    private Dimension size = new Dimension(50, 50);
    private List<Connection> sourceConnections = new ArrayList<Connection>();
    private List<Connection> targetConnections = new ArrayList<Connection>();
    private String label;
    @XmlTransient
    private Color color = ColorConstants.white;
    private Integer id;
    protected String uri;
    private String description;

    static {
        int i = 0;
        while (i < descriptors.length) {
            ((PropertyDescriptor)descriptors[i]).setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    int intValue = -1;
                    try {
                        intValue = Integer.parseInt((String)value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "Not a number";
                    }
                    return intValue >= 0 ? null : "Value must be >=  0";
                }
            });
            ++i;
        }
    }

    void addConnection(Connection conn) {
        if (conn == null || conn.getSource() == conn.getTarget()) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            if (!this.sourceConnections.contains(conn)) {
                this.sourceConnections.add(conn);
                this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
            }
        } else if (conn.getTarget() == this && !this.targetConnections.contains(conn)) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public abstract Image getIcon();

    public Point getLocation() {
        return this.location.getCopy();
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return descriptors;
    }

    @Override
    public Object getPropertyValue(Object propertyId) {
        if (XPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.x);
        }
        if (YPOS_PROP.equals(propertyId)) {
            return Integer.toString(this.location.y);
        }
        if (HEIGHT_PROP.equals(propertyId)) {
            return Integer.toString(this.size.height);
        }
        if (WIDTH_PROP.equals(propertyId)) {
            return Integer.toString(this.size.width);
        }
        return super.getPropertyValue(propertyId);
    }

    public Dimension getSize() {
        return this.size.getCopy();
    }

    @XmlTransient
    public List<Connection> getSourceConnections() {
        return new ArrayList<Connection>(this.sourceConnections);
    }

    @XmlTransient
    public List<Connection> getTargetConnections() {
        return new ArrayList<Connection>(this.targetConnections);
    }

    void removeConnection(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove(conn);
            this.firePropertyChange(SOURCE_CONNECTIONS_PROP, null, conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove(conn);
            this.firePropertyChange(TARGET_CONNECTIONS_PROP, null, conn);
        }
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    @Override
    public void setPropertyValue(Object propertyId, Object value) {
        if (XPOS_PROP.equals(propertyId)) {
            int x = Integer.parseInt((String)value);
            this.setLocation(new Point(x, this.location.y));
        } else if (YPOS_PROP.equals(propertyId)) {
            int y = Integer.parseInt((String)value);
            this.setLocation(new Point(this.location.x, y));
        } else if (HEIGHT_PROP.equals(propertyId)) {
            int height = Integer.parseInt((String)value);
            this.setSize(new Dimension(this.size.width, height));
        } else if (WIDTH_PROP.equals(propertyId)) {
            int width = Integer.parseInt((String)value);
            this.setSize(new Dimension(width, this.size.height));
        } else {
            super.setPropertyValue(propertyId, value);
        }
    }

    public void setSize(Dimension newSize) {
        if (newSize != null) {
            this.size.setSize(newSize);
            this.firePropertyChange(SIZE_PROP, null, this.size);
        }
    }

    @XmlAttribute
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLabelModify(String label) {
        this.label = label;
        this.firePropertyChange(LABEL_PROP, null, label);
    }

    @XmlTransient
    public Color getColor() {
        return this.color;
    }

    @XmlElement(name="color")
    public MyColor getMyColor() {
        return new MyColor(this.color.getRGB());
    }

    public void setMyColor(MyColor myColor) {
        this.color = new Color((Device)Display.getCurrent(), myColor.getRed(), myColor.getGreen(), myColor.getBlue());
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @XmlAttribute
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @XmlAttribute
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer integer) {
        this.id = integer;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphNode other = (GraphNode)obj;
        return this.getId() == other.getId();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

