/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.JSON;

import java.util.HashMap;
import java.util.Iterator;
import org.glycoinfo.GlycanFormatconverter.Glycan.Edge;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlyContainer;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanException;
import org.glycoinfo.GlycanFormatconverter.Glycan.GlycanUndefinedUnit;
import org.glycoinfo.GlycanFormatconverter.Glycan.Linkage;
import org.glycoinfo.GlycanFormatconverter.Glycan.Node;
import org.glycoinfo.GlycanFormatconverter.Glycan.Substituent;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONFragmentsParser;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONLinkageParser;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONModificationParser;
import org.glycoinfo.GlycanFormatconverter.io.JSON.GCJSONRepeatParser;
import org.json.JSONObject;

public class GCJSONEdgeParser {
    private HashMap<String, Node> nodeIndex;
    private GCJSONLinkageParser gclinParser;

    public GCJSONEdgeParser(HashMap<String, Node> _nodeIndex) {
        this.nodeIndex = _nodeIndex;
        this.gclinParser = new GCJSONLinkageParser();
    }

    public GlyContainer parseEdge(JSONObject _monosaccharides) throws GlycanException {
        GlyContainer ret = new GlyContainer();
        for (String key : _monosaccharides.keySet()) {
            JSONObject edge = _monosaccharides.getJSONObject(key).getJSONObject("Edge");
            Node currentNode = this.nodeIndex.get(key);
            if (_monosaccharides.length() == 1) {
                ret.addNode(currentNode);
                break;
            }
            ret = this.extractEdge(edge, ret, currentNode);
        }
        return ret;
    }

    public GlyContainer extractEdge(JSONObject _edge, GlyContainer _glyCo, Node _current) throws GlycanException {
        Iterator iterator = _edge.keySet().iterator();
        block10: while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "Parent": {
                    GCJSONModificationParser gcModParser = new GCJSONModificationParser();
                    for (Object obj : _edge.getJSONArray(key)) {
                        Edge edge = new Edge();
                        Linkage lin = this.gclinParser.parsePosition((JSONObject)obj);
                        edge.addGlycosidicLinkage(lin);
                        Substituent bridge = gcModParser.parseBridge(((JSONObject)obj).getJSONObject("Bridge"));
                        edge.setSubstituent(bridge);
                        if (bridge != null) {
                            bridge.addParentEdge(edge);
                        }
                        Node parent = this.nodeIndex.get(this.extractParentID((JSONObject)obj));
                        _glyCo.addEdge(parent, _current, edge);
                    }
                    continue block10;
                }
                case "Repeat": {
                    for (Object obj : _edge.getJSONArray(key)) {
                        GCJSONRepeatParser gcRepParser = new GCJSONRepeatParser(_glyCo, _current, this.nodeIndex.get(this.extractParentID((JSONObject)obj)));
                        _glyCo = gcRepParser.makeRepeatingEdge(obj);
                    }
                    continue block10;
                }
                case "Fragment": {
                    if (_edge.getJSONObject(key).length() == 0) continue block10;
                    GCJSONFragmentsParser gcFragParser = new GCJSONFragmentsParser(this.nodeIndex);
                    GlycanUndefinedUnit und = gcFragParser.parseFragments(_edge.getJSONObject(key), _current);
                    _glyCo.addGlycanUndefinedUnit(und);
                }
            }
        }
        return _glyCo;
    }

    private String extractParentID(JSONObject _edgeUnit) {
        return _edgeUnit.get("ParentNodeID").toString();
    }
}

