/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.fillhandle.config.FillHandleConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class FillHandleLayerPainter
extends SelectionLayerPainter {
    protected Rectangle handleBounds;
    protected InternalCellClipboard clipboard;

    public FillHandleLayerPainter() {
    }

    public FillHandleLayerPainter(Color gridColor) {
        super(gridColor);
    }

    public FillHandleLayerPainter(boolean clipLeft, boolean clipTop) {
        this(GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, Color gridColor) {
        super(gridColor);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, boolean clipLeft, boolean clipTop) {
        this(clipboard, GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    public FillHandleLayerPainter(InternalCellClipboard clipboard, Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
        this.clipboard = clipboard;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle currentCellBounds;
        ILayerCell afterCell;
        ILayerCell currentCell;
        ILayerCell previousCell;
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPositionOffset = positionRectangle.x;
        int rowPositionOffset = positionRectangle.y;
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        int originalLineStyle = gc.getLineStyle();
        int originalLineWidth = gc.getLineWidth();
        Color originalForeground = gc.getForeground();
        this.applyHandleBorderStyle(gc, configRegistry);
        int handleBorderWidth = gc.getLineWidth();
        int startAdjustment = handleBorderWidth == 1 ? 1 : 0;
        int endAdjustment = handleBorderWidth == 1 ? 1 : handleBorderWidth - 1;
        ILayerCell fillHandleCell = null;
        int columnPosition = columnPositionOffset;
        while (columnPosition < columnPositionOffset + positionRectangle.width) {
            previousCell = null;
            currentCell = null;
            afterCell = null;
            int rowPosition = rowPositionOffset;
            while (rowPosition < rowPositionOffset + positionRectangle.height) {
                currentCell = natLayer.getCellByPosition(columnPosition, rowPosition);
                afterCell = natLayer.getCellByPosition(columnPosition, rowPosition + 1);
                if (currentCell != null) {
                    currentCellBounds = currentCell.getBounds();
                    if (this.isFillHandleRegion(currentCell)) {
                        int x0 = currentCellBounds.x;
                        int x1 = currentCellBounds.x + currentCellBounds.width;
                        int y = currentCellBounds.y - startAdjustment;
                        if (previousCell != null) {
                            Rectangle previousCellBounds = previousCell.getBounds();
                            x0 = Math.max(x0, previousCellBounds.x);
                            x1 = Math.min(x1, previousCellBounds.x + previousCellBounds.width);
                        }
                        if (previousCell == null || !this.isFillHandleRegion(previousCell)) {
                            gc.drawLine(x0 - startAdjustment - (handleBorderWidth == 1 ? 0 : 1), y, x1 - startAdjustment, y);
                        }
                        if (afterCell == null || !this.isFillHandleRegion(afterCell)) {
                            Rectangle cellBounds = afterCell != null ? afterCell.getBounds() : currentCell.getBounds();
                            y = currentCellBounds.y + currentCellBounds.height - endAdjustment;
                            x0 = Math.max(x0, cellBounds.x);
                            x1 = Math.min(x1, cellBounds.x + cellBounds.width);
                            gc.drawLine(x0 - startAdjustment, y, x1 - startAdjustment, y);
                        }
                    } else if ((positionRectangle.width == 2 || positionRectangle.height == 2) && afterCell != null && this.isFillHandleRegion(afterCell)) {
                        Rectangle afterCellBounds = afterCell.getBounds();
                        int x0 = Math.max(afterCellBounds.x, currentCellBounds.x);
                        int x1 = Math.min(afterCellBounds.x + afterCellBounds.width, currentCellBounds.x + currentCellBounds.width);
                        int y = currentCellBounds.y + currentCellBounds.height - startAdjustment;
                        if (this.isFillHandleRegion(afterCell)) {
                            gc.drawLine(x0 - startAdjustment, y, x1 - startAdjustment, y);
                        }
                    }
                }
                previousCell = currentCell;
                if (fillHandleCell == null && this.isFillHandleCell(currentCell)) {
                    fillHandleCell = currentCell;
                }
                ++rowPosition;
            }
            ++columnPosition;
        }
        int rowPosition = rowPositionOffset;
        while (rowPosition < rowPositionOffset + positionRectangle.height) {
            previousCell = null;
            currentCell = null;
            afterCell = null;
            int columnPosition2 = columnPositionOffset;
            while (columnPosition2 < columnPositionOffset + positionRectangle.width) {
                currentCell = natLayer.getCellByPosition(columnPosition2, rowPosition);
                afterCell = natLayer.getCellByPosition(columnPosition2 + 1, rowPosition);
                if (currentCell != null) {
                    currentCellBounds = currentCell.getBounds();
                    if (this.isFillHandleRegion(currentCell)) {
                        int y0 = currentCellBounds.y;
                        int y1 = currentCellBounds.y + currentCellBounds.height;
                        int x = currentCellBounds.x - startAdjustment;
                        if (previousCell != null) {
                            Rectangle previousCellBounds = previousCell.getBounds();
                            y0 = Math.max(y0, previousCellBounds.y);
                            y1 = Math.min(y1, previousCellBounds.y + previousCellBounds.height);
                        }
                        if (previousCell == null || !this.isFillHandleRegion(previousCell)) {
                            gc.drawLine(x, y0 - startAdjustment, x, y1 - startAdjustment);
                        }
                        if (afterCell == null || !this.isFillHandleRegion(afterCell)) {
                            Rectangle cellBounds = afterCell != null ? afterCell.getBounds() : currentCell.getBounds();
                            x = currentCellBounds.x + currentCellBounds.width - endAdjustment;
                            y0 = Math.max(y0, cellBounds.y);
                            y1 = Math.min(y1, cellBounds.y + cellBounds.height);
                            gc.drawLine(x, y0 - startAdjustment, x, y1 - startAdjustment);
                        }
                    } else if ((positionRectangle.width == 2 || positionRectangle.height == 2) && afterCell != null && this.isFillHandleRegion(afterCell)) {
                        Rectangle afterCellBounds = afterCell.getBounds();
                        int y0 = Math.max(afterCellBounds.y, currentCellBounds.y);
                        int y1 = Math.min(afterCellBounds.y + afterCellBounds.height, currentCellBounds.y + currentCellBounds.height);
                        int x = currentCellBounds.x + currentCellBounds.width - startAdjustment;
                        gc.drawLine(x, y0 - startAdjustment, x, y1 - startAdjustment);
                    }
                }
                previousCell = currentCell;
                ++columnPosition2;
            }
            ++rowPosition;
        }
        gc.setLineStyle(originalLineStyle);
        gc.setLineWidth(originalLineWidth);
        gc.setForeground(originalForeground);
        if (this.clipboard != null && this.clipboard.getCopiedCells() != null) {
            this.paintCopyBorder(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        }
        if (fillHandleCell != null) {
            this.paintFillHandle(fillHandleCell, gc, xOffset, yOffset, configRegistry);
        } else {
            this.handleBounds = null;
        }
    }

    protected void paintFillHandle(ILayerCell bottomRight, GC gc, int xOffset, int yOffset, IConfigRegistry configRegistry) {
        int originalLineStyle = gc.getLineStyle();
        int originalLineWidth = gc.getLineWidth();
        Color originalForeground = gc.getForeground();
        Color originalBackground = gc.getBackground();
        Rectangle bounds = bottomRight.getBounds();
        this.applyHandleStyle(gc, configRegistry);
        this.handleBounds = new Rectangle(bounds.x + bounds.width - GUIHelper.convertHorizontalPixelToDpi(4), bounds.y + bounds.height - GUIHelper.convertHorizontalPixelToDpi(4), GUIHelper.convertHorizontalPixelToDpi(6), GUIHelper.convertVerticalPixelToDpi(6));
        gc.fillRectangle(this.handleBounds);
        gc.drawRectangle(this.handleBounds);
        gc.setLineStyle(originalLineStyle);
        gc.setLineWidth(originalLineWidth);
        gc.setForeground(originalForeground);
        gc.setBackground(originalBackground);
    }

    protected void paintCopyBorder(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPositionOffset = positionRectangle.x;
        int rowPositionOffset = positionRectangle.y;
        int originalLineStyle = gc.getLineStyle();
        Color originalForeground = gc.getForeground();
        this.applyCopyBorderStyle(gc, configRegistry);
        int x0 = 0;
        int x1 = 0;
        int y0 = 0;
        int y1 = 0;
        boolean isFirst = true;
        ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
        int n = iLayerCellArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells;
            ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
            int n3 = cells.length;
            int n4 = 0;
            while (n4 < n3) {
                ILayerCell cell = iLayerCellArray2[n4];
                if (isFirst) {
                    x0 = cell.getBounds().x;
                    x1 = cell.getBounds().x + cell.getBounds().width;
                    y0 = cell.getBounds().y;
                    y1 = cell.getBounds().y + cell.getBounds().height;
                    isFirst = false;
                } else {
                    x0 = Math.min(x0, cell.getBounds().x);
                    x1 = Math.max(x1, cell.getBounds().x + cell.getBounds().width);
                    y0 = Math.min(y0, cell.getBounds().y);
                    y1 = Math.max(y1, cell.getBounds().y + cell.getBounds().height);
                }
                ++n4;
            }
            ++n2;
        }
        gc.drawLine(x0 += xOffset - columnPositionOffset, y0 += yOffset - rowPositionOffset, x0, y1 += yOffset - rowPositionOffset);
        gc.drawLine(x0, y0, x1 += xOffset - columnPositionOffset, y0);
        gc.drawLine(x0, y1, x1, y1);
        gc.drawLine(x1, y0, x1, y1);
        gc.setLineStyle(originalLineStyle);
        gc.setForeground(originalForeground);
    }

    protected boolean isFillHandleRegion(ILayerCell cell) {
        return cell != null ? cell.getConfigLabels().hasLabel("FILL_HANDLE_REGION") : false;
    }

    protected boolean isFillHandleCell(ILayerCell cell) {
        return cell != null ? cell.getConfigLabels().hasLabel("selectionHandleCell") : false;
    }

    protected void applyHandleBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_REGION_BORDER_STYLE, "NORMAL", new String[0]);
        if (borderStyle == null) {
            gc.setLineStyle(1);
            gc.setLineWidth(2);
            gc.setForeground(GUIHelper.getColor(0, 125, 10));
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }

    protected void applyHandleStyle(GC gc, IConfigRegistry configRegistry) {
        if (configRegistry != null) {
            BorderStyle borderStyle = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_BORDER_STYLE, "NORMAL", new String[0]);
            Color color = configRegistry.getConfigAttribute(FillHandleConfigAttributes.FILL_HANDLE_COLOR, "NORMAL", new String[0]);
            if (color != null) {
                gc.setBackground(color);
            } else {
                gc.setBackground(GUIHelper.getColor(0, 125, 10));
            }
            if (borderStyle != null) {
                gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
                gc.setLineWidth(borderStyle.getThickness());
                gc.setForeground(borderStyle.getColor());
            } else {
                gc.setLineStyle(1);
                gc.setLineWidth(1);
                gc.setForeground(GUIHelper.COLOR_WHITE);
            }
        } else {
            gc.setLineStyle(1);
            gc.setLineWidth(1);
            gc.setForeground(GUIHelper.COLOR_WHITE);
            gc.setBackground(GUIHelper.getColor(0, 125, 10));
        }
    }

    protected void applyCopyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "copyBorderStyle");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            gc.setLineStyle(2);
            gc.setLineDash(new int[]{2, 2});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }

    public Rectangle getSelectionHandleBounds() {
        return this.handleBounds;
    }

    public InternalCellClipboard getClipboard() {
        return this.clipboard;
    }

    public void setClipboard(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }
}

