/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.preference.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.grits.toolbox.core.preference.project.StringLabelProvider;
import org.grits.toolbox.core.preference.share.ProjectPreferenceStore;
import org.grits.toolbox.core.preference.share.SingleChoicePreference;
import org.grits.toolbox.core.utilShare.CheckboxTableViewer;
import org.grits.toolbox.core.utilShare.provider.GenericListContentProvider;
import org.grits.toolbox.core.utilShare.sort.CheckboxStringSorter;

public class ActionPreference
extends PreferencePage {
    private static final Logger logger = Logger.getLogger(ActionPreference.class);
    public static final String PREFERENCE_PAGE_ID = "org.grits.toolbox.core.preference.project.event.action";
    public static String lastSelection = null;
    private SingleChoicePreference actionPreference = null;
    private List<String> allActions = null;
    private String defaultAction = null;
    private CheckboxTableViewer checkboxTableViewer = null;
    private TableViewerColumn tableColumn2 = null;

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginRight = 8;
        layout.verticalSpacing = 15;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText("Actions");
        label.setLayoutData((Object)new GridData(32, 2, true, false, 2, 1));
        this.checkboxTableViewer = this.createActionsTableViewer(container);
        Button addButton = this.createButton(container, "Add", true);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int newActionCount = 1;
                while (ActionPreference.this.allActions.contains("Action " + newActionCount)) {
                    ++newActionCount;
                }
                String newAction = "Action " + newActionCount;
                ActionPreference.this.allActions.add(newAction);
                if (ActionPreference.this.allActions.size() == 1) {
                    ActionPreference.this.defaultAction = newAction;
                }
                ActionPreference.this.checkboxTableViewer.refresh();
                ActionPreference.this.tableColumn2.getViewer().editElement((Object)newAction, 1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button removeButton = this.createButton(container, "Remove", false);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.remove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.remove();
            }

            private void remove() {
                StructuredSelection selection = (StructuredSelection)ActionPreference.this.checkboxTableViewer.getSelection();
                if (!selection.isEmpty()) {
                    String selectedAction = (String)selection.getFirstElement();
                    int selectionIndex = ActionPreference.this.checkboxTableViewer.getTable().getSelectionIndex();
                    ActionPreference.this.allActions.remove(selectedAction);
                    if (selectedAction.equals(ActionPreference.this.defaultAction)) {
                        ActionPreference.this.defaultAction = ActionPreference.this.allActions.isEmpty() ? null : (String)ActionPreference.this.allActions.iterator().next();
                    }
                    ActionPreference.this.checkboxTableViewer.refresh();
                    if (!ActionPreference.this.allActions.isEmpty()) {
                        selectionIndex = Math.min(selectionIndex, ActionPreference.this.allActions.size() - 1);
                        ActionPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection(ActionPreference.this.checkboxTableViewer.getElementAt(selectionIndex)));
                    }
                }
            }
        });
        this.checkboxTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)ActionPreference.this.checkboxTableViewer.getSelection();
                lastSelection = selection.isEmpty() ? lastSelection : (String)selection.getFirstElement();
            }
        });
        this.checkboxTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return element.equals(ActionPreference.this.defaultAction);
            }
        });
        this.checkboxTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ActionPreference.this.defaultAction = (String)event.getElement();
            }
        });
        this.loadValues();
        this.initializeTable();
        return container;
    }

    private void loadValues() {
        logger.info((Object)("Loading preference " + ProjectPreferenceStore.Preference.ACTION.getPreferenceName()));
        this.actionPreference = ProjectPreferenceStore.getSingleChoicePreference(ProjectPreferenceStore.Preference.ACTION);
        this.allActions = new ArrayList<String>();
        this.allActions.addAll(this.actionPreference.getAllValues());
        this.defaultAction = this.actionPreference.getDefaultValue();
    }

    private Button createButton(Composite container, String buttonText, boolean grabHorizontal) {
        Button button = new Button(container, 0);
        button.setText(buttonText);
        GridData buttonData = new GridData(128);
        buttonData.widthHint = 80;
        buttonData.verticalSpan = 1;
        buttonData.grabExcessHorizontalSpace = grabHorizontal;
        buttonData.verticalAlignment = 2;
        buttonData.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)buttonData);
        return button;
    }

    private void initializeTable() {
        Collections.sort(this.allActions, String.CASE_INSENSITIVE_ORDER);
        this.checkboxTableViewer.setInput(this.allActions);
        this.checkboxTableViewer.refresh();
    }

    private CheckboxTableViewer createActionsTableViewer(Composite container) {
        Table actionsTable = new Table(container, 68356);
        GridData tableLayouData = new GridData(1808);
        tableLayouData.horizontalSpan = 2;
        tableLayouData.verticalSpan = 1;
        tableLayouData.minimumHeight = 260;
        tableLayouData.heightHint = 300;
        actionsTable.setLayoutData((Object)tableLayouData);
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(actionsTable, "Default", true);
        this.tableColumn2 = new TableViewerColumn((TableViewer)tableViewer, 4, 1);
        this.tableColumn2.getColumn().setText("Actions");
        this.tableColumn2.getColumn().setWidth(300);
        this.tableColumn2.setEditingSupport(new EditingSupport((ColumnViewer)tableViewer, tableViewer){
            TextCellEditor textEditor;
            {
                this.textEditor = new TextCellEditor((Composite)checkboxTableViewer.getTable());
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof String && value instanceof String) {
                    String newValue = ((String)value).trim();
                    if (ActionPreference.this.checkboxTableViewer.getChecked(element)) {
                        ActionPreference.this.defaultAction = newValue;
                    }
                    if (ActionPreference.this.allActions.contains(element)) {
                        ActionPreference.this.allActions.set(ActionPreference.this.allActions.indexOf(element), newValue);
                    }
                    ActionPreference.this.checkboxTableViewer.refresh();
                    ActionPreference.this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)newValue));
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof String ? this.textEditor : null;
            }

            protected boolean canEdit(Object element) {
                return element instanceof String;
            }
        });
        tableViewer.getTable().setHeaderVisible(true);
        tableViewer.getTable().setLinesVisible(true);
        tableViewer.setContentProvider((IContentProvider)new GenericListContentProvider());
        tableViewer.setLabelProvider((IBaseLabelProvider)new StringLabelProvider());
        this.tableColumn2.getColumn().addSelectionListener((SelectionListener)new CheckboxStringSorter(tableViewer));
        return tableViewer;
    }

    protected void performDefaults() {
        Map<String, Boolean> allActionsMap = this.actionPreference.loadDefaultValues(ProjectPreferenceStore.Preference.ACTION);
        this.allActions = new ArrayList<String>();
        this.defaultAction = null;
        for (String action : allActionsMap.keySet()) {
            this.allActions.add(action);
            if (!allActionsMap.get(action).booleanValue()) continue;
            this.defaultAction = action;
        }
        this.initializeTable();
        super.performDefaults();
    }

    protected void performApply() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage == null) {
            this.save();
        }
    }

    public boolean performOk() {
        String errorMessage = this.validateInput();
        this.setErrorMessage(errorMessage);
        if (errorMessage != null) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("There is an error in \"Action\" preference values. Please fix before saving! Error: " + errorMessage));
        }
        return errorMessage == null ? this.save() : false;
    }

    private String validateInput() {
        String errorMessage = null;
        HashSet<String> uniqueActions = new HashSet<String>();
        uniqueActions.addAll(this.allActions);
        String string = errorMessage = uniqueActions.size() == this.allActions.size() ? errorMessage : "Non-unique Actions";
        if (uniqueActions.contains("")) {
            errorMessage = "Empty Action";
            this.checkboxTableViewer.setSelection((ISelection)new StructuredSelection((Object)""));
        }
        return errorMessage;
    }

    private boolean save() {
        this.actionPreference.setAllValues(new HashSet<String>());
        this.actionPreference.setDefaultValue(null);
        for (String action : this.allActions) {
            if (this.checkboxTableViewer.getChecked(action) && this.actionPreference.getDefaultValue() == null) {
                this.actionPreference.setDefaultValue(action);
            }
            this.actionPreference.addValue(action);
        }
        return this.actionPreference.savePreference();
    }
}

