/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.utility;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.apache.poi.util.IOUtils;
import org.grits.toolbox.entry.archive.dialog.uploadfile.FileCopyProgressDialog;

public class UtilityZip {
    private static final long MAX_FOLDER_SIZE = 0x40000000L;
    private static Logger logger = Logger.getLogger(UtilityZip.class);
    public static final int bufferSize = 0xA00000;

    public static File createZippedFolder(File folderToCopy, File parentFolder, String zipFileName) throws Exception {
        File zippedFile = null;
        if (folderToCopy.length() < 0x40000000L) {
            logger.debug((Object)("Copying folder whose size is : " + folderToCopy.length()));
            try {
                zippedFile = new File(parentFolder, zipFileName);
                FileOutputStream fos = new FileOutputStream(zippedFile);
                ZipOutputStream zipOutputStream = new ZipOutputStream(fos);
                FileCopyProgressDialog progressDialog = new FileCopyProgressDialog(folderToCopy);
                progressDialog.openProgressBar();
                UtilityZip.addFiles(folderToCopy, "", zipOutputStream, progressDialog);
                zipOutputStream.flush();
                zipOutputStream.close();
                fos.close();
                progressDialog.closeProgressBar();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        } else {
            throw new Exception("Folder is too large to be compressed");
        }
        return zippedFile;
    }

    private static void addFiles(File folderToCopy, String relativeZipPath, ZipOutputStream zipOutputStream, FileCopyProgressDialog progressDialog) throws Exception {
        String relativePath = null;
        File[] fileArray = folderToCopy.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            if (childFile.exists()) {
                String string = relativePath = relativeZipPath == null || relativeZipPath.isEmpty() ? childFile.getName() : String.valueOf(relativeZipPath) + File.separator + childFile.getName();
                if (childFile.isFile()) {
                    UtilityZip.addFile(childFile, relativePath, zipOutputStream, progressDialog);
                } else if (childFile.isDirectory()) {
                    UtilityZip.addDirectory(childFile, relativePath, zipOutputStream, progressDialog);
                }
            }
            ++n2;
        }
    }

    public static void addFile(File childFile, String relativePath, ZipOutputStream zipOutputStream, FileCopyProgressDialog progressDialog) throws Exception {
        if (childFile.isFile()) {
            try {
                int len;
                ZipEntry zipEntry = new ZipEntry(relativePath);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fis = new FileInputStream(childFile);
                byte[] buffer = new byte[0xA00000];
                while ((len = fis.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                fis.close();
                zipOutputStream.closeEntry();
                if (progressDialog != null) {
                    progressDialog.updateProgressBar(childFile.length());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void addDirectory(File childFile, String relativePath, ZipOutputStream zipOutputStream, FileCopyProgressDialog progressDialog) throws Exception {
        if (childFile.isDirectory()) {
            try {
                ZipEntry zipEntry = new ZipEntry(String.valueOf(relativePath) + File.separator);
                zipOutputStream.putNextEntry(zipEntry);
                UtilityZip.addFiles(childFile, relativePath, zipOutputStream, progressDialog);
                zipOutputStream.closeEntry();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    public static void copyFile(File sourceFile, File destinationFile) throws Exception {
        FileInputStream input = null;
        OutputStream output = null;
        try {
            input = new FileInputStream(sourceFile);
            output = new FileOutputStream(destinationFile);
            byte[] buf = new byte[0xA00000];
            int bytesRead = 0;
            FileCopyProgressDialog progressDialog = new FileCopyProgressDialog(sourceFile);
            progressDialog.openProgressBar();
            int counter = 0;
            while ((bytesRead = ((InputStream)input).read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
                if (counter % 5 == 0) {
                    progressDialog.updateProgressBar(bytesRead);
                }
                ++counter;
            }
            ((InputStream)input).close();
            output.close();
            progressDialog.closeProgressBar();
        }
        catch (Exception ex) {
            if (input != null) {
                ((InputStream)input).close();
            }
            if (output != null) {
                output.close();
            }
            logger.error((Object)ex.getMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public static void copyDirectory(File sourceFile, File destinationFile) throws IOException {
        if (sourceFile.isDirectory()) {
            if (!destinationFile.exists()) {
                destinationFile.mkdir();
            }
            String[] stringArray = sourceFile.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                UtilityZip.copyDirectory(new File(sourceFile, child), new File(destinationFile, child));
                ++n2;
            }
        } else {
            FileInputStream in = null;
            FileOutputStream out = null;
            try {
                int len;
                in = new FileInputStream(sourceFile);
                out = new FileOutputStream(destinationFile);
                byte[] buf = new byte[0xA00000];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)in);
            IOUtils.closeQuietly((Closeable)out);
        }
    }
}

