/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.ms.annotation.sugar;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarExporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCT;
import org.eurocarbdb.MolecularFramework.io.GlycoCT.SugarImporterGlycoCTCondensed;
import org.eurocarbdb.MolecularFramework.io.Glyde.SugarExporterGlydeII;
import org.eurocarbdb.MolecularFramework.io.Glyde.SugarImporterGlydeII;
import org.eurocarbdb.MolecularFramework.io.SugarImporterException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycanbuilder.MassOptions;
import org.eurocarbdb.application.glycanbuilder.ResidueDictionary;
import org.eurocarbdb.application.glycanbuilder.ResidueType;
import org.grits.toolbox.ms.annotation.gelato.glycan.GlycanStructureAnnotation;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorChargeCalculator;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorGlycanCode;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorGlycanType;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorMotifCounter;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorNGlycanInformation;
import org.grits.toolbox.ms.annotation.sugar.GlycoVisitorResidueCounter;
import org.grits.toolbox.ms.om.data.CustomExtraData;
import org.grits.toolbox.ms.om.data.GlycanAnnotation;

public class GlycanExtraInfo {
    private static final Logger logger = Logger.getLogger(GlycanExtraInfo.class);
    public static final String COMPOSITON = "gg.comp";
    public static final String CODE = "gg.gcode";
    public static final String GLYCAN_CHARGE = "gg.gch";
    public static final String BISECTION = "gg.bisec";
    public static final String N_RESIDUES = "gg.n.res";
    public static final String TYPE = "gg.type";
    public static final String SUBTYPE = "gg.subtype";
    public static final String N_BRANCHES = "gg.n.nbranch";
    public static final String N_HEX = "gg.n.hex";
    public static final String N_HEXNAC = "gg.n.hexnac";
    public static final String N_NEUAC = "gg.n.neuac";
    public static final String N_FUC = "gg.n.fuc";
    public static final String N_S = "gg.n.s";
    public static final String N_NEUGC = "gg.n.neugc";
    public static final String N_P = "gg.n.p";
    public static final String N_HEXA = "gg.n.hexa";
    public static final String N_OTHERS = "gg.n.other";
    public static final String CORE_FUC = "gg.corefuc";
    public static final String NON_CORE_FUC = "gg.ncfuc";
    public static final String N_GALGAL = "gg.n.galgal";
    public static final String N_POLY_SIA = "gg.n.polysia";
    public static final String N_LACNAC = "gg.n.lacnac";
    public static final String N_LACDINAC = "gg.n.lacdinac";
    public static final String N_LEWISAX = "gg.n.lewisax";
    public static final String N_LEWISBY = "gg.n.lewisby";
    public static final String N_SIA_LEWIS_AX = "gg.n.sialewax";
    public static final String N_SDA = "gg.n.sda";
    public static final String N_SIA_HEXNAC = "gg.n.shexnac";
    public static final String N_SIA_LACDINAC = "gg.n.slacdinac";
    public static final String N_FUC_LACDINAC = "gg.n.flacdinac";
    public static final String N_FUCFUC_LACDINAC = "gg.n.fflacdinac";
    public static final String GLYCAN_PME_MASS_PLUS_NA = "gg.pme+na";
    private static final Pattern reducing_end_pattern = Pattern.compile("^([^\\=]+)\\=(\\d+\\.*\\d*)u\\-\\-\\?(.*)");

    public static void populateGlycanExtraInformation(GlycanAnnotation a_annotation, Sugar a_sugar) {
        try {
            GlycanExtraInfo.fillOutTheHashMapWithTheNewInfo(a_annotation, a_sugar);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void cloneGlycanExtraInformation(GlycanAnnotation a_sourceAnnotation, GlycanAnnotation a_targetAnnotation) {
        try {
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_RESIDUES) && a_sourceAnnotation.getIntegerProp().get(N_RESIDUES) != null) {
                a_targetAnnotation.getIntegerProp().put(N_RESIDUES, (Integer)a_sourceAnnotation.getIntegerProp().get(N_RESIDUES));
            }
            if (a_sourceAnnotation.getStringProp().containsKey(CODE) && a_sourceAnnotation.getStringProp().get(CODE) != null) {
                a_targetAnnotation.getStringProp().put(CODE, (String)a_sourceAnnotation.getStringProp().get(CODE));
            }
            if (a_sourceAnnotation.getStringProp().containsKey(COMPOSITON) && a_sourceAnnotation.getStringProp().get(COMPOSITON) != null) {
                a_targetAnnotation.getStringProp().put(COMPOSITON, (String)a_sourceAnnotation.getStringProp().get(COMPOSITON));
            }
            if (a_sourceAnnotation.getStringProp().containsKey(TYPE) && a_sourceAnnotation.getStringProp().get(TYPE) != null) {
                a_targetAnnotation.getStringProp().put(TYPE, (String)a_sourceAnnotation.getStringProp().get(TYPE));
            }
            if (a_sourceAnnotation.getStringProp().containsKey(SUBTYPE) && a_sourceAnnotation.getStringProp().get(SUBTYPE) != null) {
                a_targetAnnotation.getStringProp().put(SUBTYPE, (String)a_sourceAnnotation.getStringProp().get(SUBTYPE));
            }
            if (a_sourceAnnotation.getBooleanProp().containsKey(BISECTION) && a_sourceAnnotation.getBooleanProp().get(BISECTION) != null) {
                a_targetAnnotation.getBooleanProp().put(BISECTION, (Boolean)a_sourceAnnotation.getBooleanProp().get(BISECTION));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_BRANCHES) && a_sourceAnnotation.getIntegerProp().get(N_BRANCHES) != null) {
                a_targetAnnotation.getIntegerProp().put(N_BRANCHES, (Integer)a_sourceAnnotation.getIntegerProp().get(N_BRANCHES));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_HEX) && a_sourceAnnotation.getIntegerProp().get(N_HEX) != null) {
                a_targetAnnotation.getIntegerProp().put(N_HEX, (Integer)a_sourceAnnotation.getIntegerProp().get(N_HEX));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_HEXNAC) && a_sourceAnnotation.getIntegerProp().get(N_HEXNAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_HEXNAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_HEXNAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_NEUAC) && a_sourceAnnotation.getIntegerProp().get(N_NEUAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_NEUAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_NEUAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_FUC) && a_sourceAnnotation.getIntegerProp().get(N_FUC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_FUC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_FUC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_S) && a_sourceAnnotation.getIntegerProp().get(N_S) != null) {
                a_targetAnnotation.getIntegerProp().put(N_S, (Integer)a_sourceAnnotation.getIntegerProp().get(N_S));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_NEUGC) && a_sourceAnnotation.getIntegerProp().get(N_NEUGC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_NEUGC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_NEUGC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_P) && a_sourceAnnotation.getIntegerProp().get(N_P) != null) {
                a_targetAnnotation.getIntegerProp().put(N_P, (Integer)a_sourceAnnotation.getIntegerProp().get(N_P));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_HEXA) && a_sourceAnnotation.getIntegerProp().get(N_HEXA) != null) {
                a_targetAnnotation.getIntegerProp().put(N_HEXA, (Integer)a_sourceAnnotation.getIntegerProp().get(N_HEXA));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_OTHERS) && a_sourceAnnotation.getIntegerProp().get(N_OTHERS) != null) {
                a_targetAnnotation.getIntegerProp().put(N_OTHERS, (Integer)a_sourceAnnotation.getIntegerProp().get(N_OTHERS));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_GALGAL) && a_sourceAnnotation.getIntegerProp().get(N_GALGAL) != null) {
                a_targetAnnotation.getIntegerProp().put(N_GALGAL, (Integer)a_sourceAnnotation.getIntegerProp().get(N_GALGAL));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_POLY_SIA) && a_sourceAnnotation.getIntegerProp().get(N_POLY_SIA) != null) {
                a_targetAnnotation.getIntegerProp().put(N_POLY_SIA, (Integer)a_sourceAnnotation.getIntegerProp().get(N_POLY_SIA));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_LACNAC) && a_sourceAnnotation.getIntegerProp().get(N_LACNAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_LACNAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_LACNAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_LACDINAC) && a_sourceAnnotation.getIntegerProp().get(N_LACDINAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_LACDINAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_LACDINAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_LEWISAX) && a_sourceAnnotation.getIntegerProp().get(N_LEWISAX) != null) {
                a_targetAnnotation.getIntegerProp().put(N_LEWISAX, (Integer)a_sourceAnnotation.getIntegerProp().get(N_LEWISAX));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_LEWISBY) && a_sourceAnnotation.getIntegerProp().get(N_LEWISBY) != null) {
                a_targetAnnotation.getIntegerProp().put(N_LEWISBY, (Integer)a_sourceAnnotation.getIntegerProp().get(N_LEWISBY));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_SIA_LEWIS_AX) && a_sourceAnnotation.getIntegerProp().get(N_SIA_LEWIS_AX) != null) {
                a_targetAnnotation.getIntegerProp().put(N_SIA_LEWIS_AX, (Integer)a_sourceAnnotation.getIntegerProp().get(N_SIA_LEWIS_AX));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_SDA) && a_sourceAnnotation.getIntegerProp().get(N_SDA) != null) {
                a_targetAnnotation.getIntegerProp().put(N_SDA, (Integer)a_sourceAnnotation.getIntegerProp().get(N_SDA));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_SIA_HEXNAC) && a_sourceAnnotation.getIntegerProp().get(N_SIA_HEXNAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_SIA_HEXNAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_SIA_HEXNAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_SIA_LACDINAC) && a_sourceAnnotation.getIntegerProp().get(N_SIA_LACDINAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_SIA_LACDINAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_SIA_LACDINAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_FUC_LACDINAC) && a_sourceAnnotation.getIntegerProp().get(N_FUC_LACDINAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_FUC_LACDINAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_FUC_LACDINAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(N_FUCFUC_LACDINAC) && a_sourceAnnotation.getIntegerProp().get(N_FUCFUC_LACDINAC) != null) {
                a_targetAnnotation.getIntegerProp().put(N_FUCFUC_LACDINAC, (Integer)a_sourceAnnotation.getIntegerProp().get(N_FUCFUC_LACDINAC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(CORE_FUC) && a_sourceAnnotation.getIntegerProp().get(CORE_FUC) != null) {
                a_targetAnnotation.getIntegerProp().put(CORE_FUC, (Integer)a_sourceAnnotation.getIntegerProp().get(CORE_FUC));
            }
            if (a_sourceAnnotation.getIntegerProp().containsKey(NON_CORE_FUC) && a_sourceAnnotation.getIntegerProp().get(NON_CORE_FUC) != null) {
                a_targetAnnotation.getIntegerProp().put(NON_CORE_FUC, (Integer)a_sourceAnnotation.getIntegerProp().get(NON_CORE_FUC));
            }
            if (a_sourceAnnotation.getDoubleProp().containsKey(GLYCAN_PME_MASS_PLUS_NA) && a_sourceAnnotation.getDoubleProp().get(GLYCAN_PME_MASS_PLUS_NA) != null) {
                a_targetAnnotation.getDoubleProp().put(GLYCAN_PME_MASS_PLUS_NA, (Double)a_sourceAnnotation.getDoubleProp().get(GLYCAN_PME_MASS_PLUS_NA));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void populateGlycanExtraInformation(GlycanAnnotation a_annotation) throws SugarImporterException {
        try {
            Sugar t_sugar;
            if (a_annotation.getSequenceGWB() != null && !a_annotation.getSequenceGWB().equals("")) {
                t_sugar = GlycanExtraInfo.gwbToSugar(a_annotation.getSequenceGWB());
            } else if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYDEII)) {
                t_sugar = GlycanExtraInfo.glydeToSugar(a_annotation.getSequence());
            } else if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                t_sugar = GlycanExtraInfo.glydeToSugar(a_annotation.getSequence());
            } else if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_XML)) {
                t_sugar = GlycanExtraInfo.glydeToSugar(a_annotation.getSequence());
            } else {
                throw new Exception("Unsupported sequence type: " + a_annotation.getSequenceFormat());
            }
            GlycanExtraInfo.fillOutTheHashMapWithTheNewInfo(a_annotation, t_sugar);
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void populateGlycanExtraInformation(List<GlycanAnnotation> a_annotations) throws SugarImporterException {
        for (GlycanAnnotation t_annotation : a_annotations) {
            try {
                Sugar t_sugar = GlycanExtraInfo.glydeToSugar(t_annotation.getSequence());
                GlycanExtraInfo.fillOutTheHashMapWithTheNewInfo(t_annotation, t_sugar);
            }
            catch (GlycoVisitorException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static List<CustomExtraData> getColumns() {
        ArrayList<CustomExtraData> t_columns = new ArrayList<CustomExtraData>();
        t_columns.add(new CustomExtraData(COMPOSITON, "Composition", null, CustomExtraData.Type.String));
        t_columns.add(new CustomExtraData(CODE, "Glycan Code", null, CustomExtraData.Type.String));
        t_columns.add(new CustomExtraData(BISECTION, "Bisection", null, CustomExtraData.Type.Boolean));
        t_columns.add(new CustomExtraData(N_RESIDUES, "# Residues", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(TYPE, "Glycan Type", null, CustomExtraData.Type.String));
        t_columns.add(new CustomExtraData(SUBTYPE, "Glycan Subtype", null, CustomExtraData.Type.String));
        t_columns.add(new CustomExtraData(N_BRANCHES, "# N-Glycan Branches", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_HEX, "# Hex", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_HEXNAC, "# HexNAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_NEUAC, "# NeuAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_FUC, "# Fuc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_S, "# Sulfate", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_NEUGC, "# NeuGc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_P, "# Phosphate", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_HEXA, "# HexA", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_OTHERS, "# Other Residues", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(CORE_FUC, "# Core fucosylation", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(NON_CORE_FUC, "# non Core Fuc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_GALGAL, "# Gal-Gal", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_POLY_SIA, "# Poly Sia", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_LACNAC, "# LacNAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_LACDINAC, "# LacDiNAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_LEWISAX, "# Lewis A/X", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_LEWISBY, "# Lewis B/Y", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_SIA_LEWIS_AX, "# Sialyl Lewis A/X", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_SDA, "# SDA", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_SIA_HEXNAC, "# Sialyl HexNAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_SIA_LACDINAC, "# Sialyl LacDiNAc", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_FUC_LACDINAC, "# LacDiNAc (Fuc)", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(N_FUCFUC_LACDINAC, "# LacDiNAc (2Fuc)", null, CustomExtraData.Type.Integer));
        t_columns.add(new CustomExtraData(GLYCAN_PME_MASS_PLUS_NA, "M(pMe)+Na", null, CustomExtraData.Type.Double));
        return t_columns;
    }

    public static Sugar annotationToSugar(GlycanAnnotation a_annotation) throws GlycoVisitorException, SugarImporterException {
        try {
            if (a_annotation.getSequenceGWB() != null && !a_annotation.getSequenceGWB().equals("")) {
                return GlycanExtraInfo.gwbToSugar(a_annotation.getSequenceGWB());
            }
            if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYDEII)) {
                return GlycanExtraInfo.glydeToSugar(a_annotation.getSequence());
            }
            if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_CONDENSED)) {
                return GlycanExtraInfo.glycoCTCondensedToSugar(a_annotation.getSequence());
            }
            if (a_annotation.getSequenceFormat().equals(GlycanAnnotation.SEQ_FORMAT_GLYCOCT_XML)) {
                return GlycanExtraInfo.glycoCTToSugar(a_annotation.getSequence());
            }
            throw new Exception("Unsupported sequence type: " + a_annotation.getSequenceFormat());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Glycan gwbToGlycan(String a_gwb) throws GlycoVisitorException, SugarImporterException {
        try {
            Matcher m;
            String t_seq = a_gwb;
            ResidueType gwbRT = null;
            if (a_gwb.contains("=") && (m = reducing_end_pattern.matcher(a_gwb)).matches()) {
                String sRedEndLabel = m.group(1);
                String sRedEndMass = m.group(2);
                gwbRT = ResidueDictionary.findResidueType((String)sRedEndLabel);
                if (gwbRT == null) {
                    t_seq = "other=" + sRedEndMass + "u--?" + m.group(3);
                    gwbRT = ResidueType.createOtherReducingEnd((String)sRedEndLabel, (double)Double.parseDouble(sRedEndMass));
                }
            }
            Glycan glycan = Glycan.fromString((String)t_seq);
            if (gwbRT != null) {
                glycan.setReducingEndType(gwbRT);
            }
            return glycan;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Sugar gwbToSugar(String a_gwb) throws GlycoVisitorException, SugarImporterException {
        try {
            Glycan glycan = GlycanExtraInfo.gwbToGlycan(a_gwb);
            Sugar t_sugar = glycan.toSugar();
            return t_sugar;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Sugar glycoCTToSugar(String a_glycoCT) throws GlycoVisitorException, SugarImporterException {
        try {
            SugarImporterGlycoCT t_importer = new SugarImporterGlycoCT();
            Sugar t_sugar = t_importer.parse(a_glycoCT);
            return t_sugar;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Sugar glycoCTCondensedToSugar(String a_glycoCTCondensed) throws GlycoVisitorException, SugarImporterException {
        try {
            SugarImporterGlycoCTCondensed t_importer = new SugarImporterGlycoCTCondensed();
            Sugar t_sugar = t_importer.parse(a_glycoCTCondensed);
            return t_sugar;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static Sugar glydeToSugar(String a_glyde) throws GlycoVisitorException, SugarImporterException {
        try {
            SugarImporterGlydeII t_importer = new SugarImporterGlydeII();
            Sugar t_sugar = t_importer.parse(a_glyde);
            return t_sugar;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sugarToGlycoCT(Sugar a_sugar) throws GlycoVisitorException, SugarImporterException {
        try {
            SugarExporterGlycoCTCondensed t_exporter = new SugarExporterGlycoCTCondensed();
            t_exporter.start(a_sugar);
            return t_exporter.getHashCode();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String sugarToGlyde(Sugar a_sugar) throws GlycoVisitorException, SugarImporterException {
        try {
            SugarExporterGlydeII t_exporter = new SugarExporterGlydeII();
            t_exporter.start(a_sugar);
            return t_exporter.getXMLCode();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void fillOutTheHashMapWithTheNewInfo(GlycanAnnotation a_glycanAnnotation, Sugar a_sugar) {
        Object t_visitor;
        a_glycanAnnotation.getIntegerProp().put(N_RESIDUES, a_sugar.getNodes().size());
        try {
            GlycoVisitorGlycanCode t_visitorGlycanCode = new GlycoVisitorGlycanCode();
            t_visitorGlycanCode.start(a_sugar);
            a_glycanAnnotation.getStringProp().put(CODE, t_visitorGlycanCode.getCode());
            a_glycanAnnotation.getStringProp().put(COMPOSITON, t_visitorGlycanCode.getCompositionString());
        }
        catch (Exception e) {
            logger.error((Object)("Unable to create glycan code for " + a_glycanAnnotation.getStringId()), (Throwable)e);
        }
        String t_glycanType = null;
        try {
            String t_sub;
            GlycoVisitorGlycanType t_visitorType = new GlycoVisitorGlycanType();
            t_visitorType.start(a_sugar);
            t_glycanType = t_visitorType.getType();
            if (t_glycanType != null) {
                a_glycanAnnotation.getStringProp().put(TYPE, t_glycanType);
            }
            if ((t_sub = t_visitorType.getSubType()) != null) {
                a_glycanAnnotation.getStringProp().put(SUBTYPE, t_sub);
            }
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)("Unable to find glycan type for " + a_glycanAnnotation.getStringId()), (Throwable)e);
        }
        if (t_glycanType != null && t_glycanType.equals("N-Glycan")) {
            try {
                t_visitor = new GlycoVisitorNGlycanInformation();
                ((GlycoVisitorNGlycanInformation)t_visitor).start(a_sugar);
                if (((GlycoVisitorNGlycanInformation)t_visitor).isNGlycan()) {
                    a_glycanAnnotation.getBooleanProp().put(BISECTION, ((GlycoVisitorNGlycanInformation)t_visitor).getBisection());
                    a_glycanAnnotation.getIntegerProp().put(N_BRANCHES, ((GlycoVisitorNGlycanInformation)t_visitor).getNGlycanBranches());
                }
            }
            catch (GlycoVisitorException e) {
                logger.error((Object)("Unable to find N-glycan informaiton for " + a_glycanAnnotation.getStringId()), (Throwable)e);
            }
        }
        try {
            t_visitor = new GlycoVisitorResidueCounter();
            ((GlycoVisitorResidueCounter)t_visitor).start(a_sugar);
            a_glycanAnnotation.getIntegerProp().put(N_HEX, ((GlycoVisitorResidueCounter)t_visitor).getHex());
            a_glycanAnnotation.getIntegerProp().put(N_HEXNAC, ((GlycoVisitorResidueCounter)t_visitor).getHexNAc());
            a_glycanAnnotation.getIntegerProp().put(N_NEUAC, ((GlycoVisitorResidueCounter)t_visitor).getNeuAc());
            a_glycanAnnotation.getIntegerProp().put(N_FUC, ((GlycoVisitorResidueCounter)t_visitor).getHex6D());
            a_glycanAnnotation.getIntegerProp().put(N_S, ((GlycoVisitorResidueCounter)t_visitor).getSulfate());
            a_glycanAnnotation.getIntegerProp().put(N_NEUGC, ((GlycoVisitorResidueCounter)t_visitor).getNeuGc());
            a_glycanAnnotation.getIntegerProp().put(N_P, ((GlycoVisitorResidueCounter)t_visitor).getPhosphate());
            a_glycanAnnotation.getIntegerProp().put(N_HEXA, ((GlycoVisitorResidueCounter)t_visitor).getHexA());
            a_glycanAnnotation.getIntegerProp().put(N_OTHERS, ((GlycoVisitorResidueCounter)t_visitor).getOther());
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)("Unable to count residue information for " + a_glycanAnnotation.getStringId()), (Throwable)e);
        }
        try {
            t_visitor = new GlycoVisitorMotifCounter();
            ((GlycoVisitorMotifCounter)t_visitor).start(a_sugar);
            a_glycanAnnotation.getIntegerProp().put(N_GALGAL, ((GlycoVisitorMotifCounter)t_visitor).getGalGal());
            a_glycanAnnotation.getIntegerProp().put(N_POLY_SIA, ((GlycoVisitorMotifCounter)t_visitor).getPolySia());
            a_glycanAnnotation.getIntegerProp().put(N_LACNAC, ((GlycoVisitorMotifCounter)t_visitor).getLacNac());
            a_glycanAnnotation.getIntegerProp().put(N_LACDINAC, ((GlycoVisitorMotifCounter)t_visitor).getLacDiNac());
            a_glycanAnnotation.getIntegerProp().put(N_LEWISAX, ((GlycoVisitorMotifCounter)t_visitor).getLewisAX());
            a_glycanAnnotation.getIntegerProp().put(N_LEWISBY, ((GlycoVisitorMotifCounter)t_visitor).getLewisBY());
            a_glycanAnnotation.getIntegerProp().put(N_SIA_LEWIS_AX, ((GlycoVisitorMotifCounter)t_visitor).getSiaLewis());
            a_glycanAnnotation.getIntegerProp().put(N_SDA, ((GlycoVisitorMotifCounter)t_visitor).getSda());
            a_glycanAnnotation.getIntegerProp().put(N_SIA_HEXNAC, ((GlycoVisitorMotifCounter)t_visitor).getSiaHexNAc());
            a_glycanAnnotation.getIntegerProp().put(N_SIA_LACDINAC, ((GlycoVisitorMotifCounter)t_visitor).getSiaLacDiNac());
            a_glycanAnnotation.getIntegerProp().put(N_FUC_LACDINAC, ((GlycoVisitorMotifCounter)t_visitor).getMonoFucLacDiNac());
            a_glycanAnnotation.getIntegerProp().put(N_FUCFUC_LACDINAC, ((GlycoVisitorMotifCounter)t_visitor).getDiFucLacDiNac());
            a_glycanAnnotation.getIntegerProp().put(CORE_FUC, ((GlycoVisitorMotifCounter)t_visitor).getCoreFuc());
            a_glycanAnnotation.getIntegerProp().put(NON_CORE_FUC, ((GlycoVisitorMotifCounter)t_visitor).getNonCoreFuc());
        }
        catch (GlycoVisitorException e) {
            logger.error((Object)("Unable to count motif information for " + a_glycanAnnotation.getStringId()), (Throwable)e);
        }
        try {
            logger.debug((Object)("Calculating mass options for glycan: " + a_glycanAnnotation.getStringId()));
            Glycan t_glycan = null;
            if (a_glycanAnnotation.getSequenceGWB() != null) {
                t_glycan = Glycan.fromString((String)a_glycanAnnotation.getSequenceGWB());
            } else {
                SugarExporterGlycoCTCondensed t_exporter = new SugarExporterGlycoCTCondensed();
                t_exporter.start(a_sugar);
                t_glycan = Glycan.fromGlycoCTCondensed((String)t_exporter.getHashCode());
            }
            MassOptions t_massOptions = new MassOptions();
            t_massOptions.setDerivatization("perMe");
            t_massOptions.setIsotope("MONO");
            t_massOptions.ION_CLOUD = new IonCloud();
            ResidueType gwbRT = GlycanStructureAnnotation.getResidueTypeForReducingEnd(a_glycanAnnotation.getReducingEnd());
            t_massOptions.setReducingEndType(gwbRT);
            t_glycan.setMassOptions(t_massOptions);
            a_glycanAnnotation.getDoubleProp().put(GLYCAN_PME_MASS_PLUS_NA, t_glycan.computeMass() + 22.989769);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to calculate native mass " + a_glycanAnnotation.getStringId()), (Throwable)e);
        }
    }

    private static Integer createCharge(GlycanAnnotation a_annotation, Sugar a_sugar) {
        try {
            GlycoVisitorChargeCalculator t_visitorCharge = new GlycoVisitorChargeCalculator();
            t_visitorCharge.start(a_sugar);
            return t_visitorCharge.getCharge();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to calculate glycan charge for " + a_annotation.getStringId()), (Throwable)e);
            return null;
        }
    }
}

