/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.qrtpcr.model;

import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.grits.toolbox.entry.qrtpcr.model.QrtPCRData;
import org.grits.toolbox.entry.qrtpcr.model.xml.MapAdapter;
import org.grits.toolbox.entry.qrtpcr.model.xml.StringStringMapAdapter;

@XmlRootElement(name="qrtPCR-Table")
public class QrtPCRTable {
    public static final String defaultControlGene = "HRPL4";
    Map<String, QrtPCRData> plateDataMap;
    Map<String, String> instrumentFileMap;
    String plateLayoutFile;
    private Boolean original = true;

    @XmlAttribute
    public Boolean getOriginal() {
        return this.original;
    }

    public void setOriginal(Boolean original) {
        this.original = original;
    }

    @XmlJavaTypeAdapter(value=MapAdapter.class)
    public Map<String, QrtPCRData> getPlateDataMap() {
        return this.plateDataMap;
    }

    public void setPlateDataMap(Map<String, QrtPCRData> plateDataMap) {
        this.plateDataMap = plateDataMap;
    }

    public void addData(String plateId, QrtPCRData data) {
        if (this.plateDataMap == null) {
            this.plateDataMap = new TreeMap<String, QrtPCRData>();
        }
        if (this.plateDataMap.containsKey(plateId)) {
            this.plateDataMap.remove(plateId);
        }
        this.plateDataMap.put(plateId, data);
    }

    public QrtPCRData getData(String plateId) {
        if (this.plateDataMap != null) {
            return this.plateDataMap.get(plateId);
        }
        return null;
    }

    @XmlJavaTypeAdapter(value=StringStringMapAdapter.class)
    public Map<String, String> getInstrumentFileMap() {
        return this.instrumentFileMap;
    }

    public void setInstrumentFileMap(Map<String, String> instrumentFileMap) {
        this.instrumentFileMap = instrumentFileMap;
    }

    public void addInstrumentFile(String plateId, String instrumentFileName) {
        if (this.instrumentFileMap == null) {
            this.instrumentFileMap = new TreeMap<String, String>();
        }
        if (this.instrumentFileMap.containsKey(plateId)) {
            this.instrumentFileMap.remove(plateId);
        }
        this.instrumentFileMap.put(plateId, instrumentFileName);
    }

    @XmlAttribute
    public String getPlateLayoutFile() {
        return this.plateLayoutFile;
    }

    public void setPlateLayoutFile(String plateLayoutFile) {
        this.plateLayoutFile = plateLayoutFile;
    }

    public void remove(String plateId) {
        if (this.plateDataMap != null) {
            this.plateDataMap.remove(plateId);
        }
    }
}

