/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin.grammar;

import java.util.Collections;
import java.util.LinkedList;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycanbuilder.XMLUtils;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarOptions;
import org.eurocarbdb.application.glycoworkbench.plugin.grammar.GrammarTree;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Constraint {
    private Constraint parent = null;
    private String node_type = "";
    private String children_types = "";

    public static Constraint createConstraint(GrammarTree current, GrammarOptions opt) {
        return Constraint.createConstraint(current, null, false, 0, opt);
    }

    public static Constraint createConstraint(GrammarTree current, GrammarTree skip, boolean add_children, int level, GrammarOptions opt) {
        if (current == null) {
            return null;
        }
        if (level >= opt.MAX_LEVEL) {
            return null;
        }
        Constraint ret = new Constraint();
        ret.node_type = current.getLabel();
        if (add_children) {
            ret.children_types = Constraint.getChildrenTypes(current, skip, opt);
        }
        ret.parent = Constraint.createConstraint(current.getParent(), current, opt.ADD_UNCLES, level + 1, opt);
        return ret;
    }

    private static String getChildrenTypes(GrammarTree current, GrammarTree skip, GrammarOptions opt) {
        LinkedList<String> list = new LinkedList<String>();
        for (GrammarTree child : current.getChildren()) {
            if (child == skip) continue;
            String type = child.getLabel();
            int index = Collections.binarySearch(list, type);
            if (index < 0) {
                list.add(-index - 1, type);
                continue;
            }
            list.add(index, type);
        }
        return TextUtils.toString(list, (char)',');
    }

    public boolean matches(GrammarTree current, GrammarOptions opt) {
        return this.matches(current, null, false, opt);
    }

    public boolean matches(GrammarTree current, GrammarTree skip, boolean match_children, GrammarOptions opt) {
        if (!this.node_type.equals(current.getLabel())) {
            return false;
        }
        if (match_children && !this.children_types.equals(Constraint.getChildrenTypes(current, skip, opt))) {
            return false;
        }
        if (this.parent != null && current == null) {
            return false;
        }
        return this.parent == null || this.parent.matches(current.getParent(), current, opt.ADD_UNCLES, opt);
    }

    public String toString() {
        String ret = "";
        ret = ret + this.node_type;
        if (this.children_types.length() > 0) {
            ret = ret + "(" + this.children_types + ")";
        }
        if (this.parent != null) {
            ret = ret + " " + this.parent.toString();
        }
        return ret;
    }

    public static Constraint fromXML(Node c_node) throws Exception {
        Node p_node;
        Constraint ret = new Constraint();
        ret.node_type = XMLUtils.getAttribute((Node)c_node, (String)"node_type");
        if (ret.node_type == null) {
            ret.node_type = "";
        }
        ret.children_types = XMLUtils.getAttribute((Node)c_node, (String)"children_types");
        if (ret.children_types == null) {
            ret.children_types = "";
        }
        if ((p_node = XMLUtils.findChild((Node)c_node, (String)"Constraint")) != null) {
            ret.parent = Constraint.fromXML(p_node);
        }
        return ret;
    }

    public Element toXML(Document document) {
        if (document == null) {
            return null;
        }
        Element c_node = document.createElement("Constraint");
        c_node.setAttribute("node_type", "" + this.node_type);
        c_node.setAttribute("children_types", "" + this.children_types);
        if (this.parent != null) {
            c_node.appendChild(this.parent.toXML(document));
        }
        return c_node;
    }
}

