/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import org.eurocarbdb.application.glycanbuilder.FragmentCollection;
import org.eurocarbdb.application.glycanbuilder.FragmentDocument;
import org.eurocarbdb.application.glycanbuilder.FragmentEntry;
import org.eurocarbdb.application.glycanbuilder.Fragmenter;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.IonCloud;
import org.eurocarbdb.application.glycoworkbench.AnnotatedPeakList;
import org.eurocarbdb.application.glycoworkbench.AnnotationOptions;
import org.eurocarbdb.application.glycoworkbench.IonCloudUtils;
import org.eurocarbdb.application.glycoworkbench.Peak;
import org.eurocarbdb.application.glycoworkbench.PeakAnnotationCollection;
import org.eurocarbdb.application.glycoworkbench.PeakList;
import org.eurocarbdb.application.glycoworkbench.plugin.Generator;
import org.eurocarbdb.application.glycoworkbench.plugin.GeneratorListener;

public class AnnotationThread
extends Thread
implements GeneratorListener {
    protected int progress = 0;
    protected final int FRAGMENTER = 1;
    protected final int COLLECTION = 2;
    protected final int GENERATOR = 3;
    protected int mode = 1;
    protected int no_structures = 0;
    protected boolean has_fuzzy = false;
    protected boolean has_not_fuzzy = true;
    protected AnnotatedPeakList annotated_peaks = new AnnotatedPeakList();
    protected PeakList peaks = null;
    protected PeakAnnotationCollection match_coll = new PeakAnnotationCollection();
    Vector<IonCloud> ion_clouds = null;
    protected Collection<Glycan> structures = null;
    protected Fragmenter fragmenter = null;
    protected FragmentDocument frag_doc = null;
    protected Generator generator = null;
    protected AnnotationOptions ann_opt = null;

    public AnnotationThread(PeakList _peaks, Collection<Glycan> _structures, Fragmenter _fragmenter, AnnotationOptions _ann_opt) {
        this.peaks = _peaks;
        this.structures = _structures;
        this.fragmenter = _fragmenter;
        this.frag_doc = null;
        this.generator = null;
        this.ann_opt = _ann_opt;
        this.mode = 1;
    }

    public AnnotationThread(PeakList _peaks, Glycan _structure, FragmentCollection _frag_coll, AnnotationOptions _ann_opt) {
        this.peaks = _peaks;
        this.structures = Collections.singleton(_structure);
        this.fragmenter = null;
        this.frag_doc = new FragmentDocument();
        this.frag_doc.addFragments(_structure, _frag_coll);
        this.generator = null;
        this.ann_opt = _ann_opt;
        this.mode = 2;
    }

    public AnnotationThread(PeakList _peaks, FragmentDocument _frag_doc, AnnotationOptions _ann_opt) {
        this.peaks = _peaks;
        this.structures = _frag_doc.getStructures();
        this.fragmenter = null;
        this.frag_doc = _frag_doc;
        this.generator = null;
        this.ann_opt = _ann_opt;
        this.mode = 2;
    }

    public AnnotationThread(PeakList _peaks, Generator _generator, AnnotationOptions _ann_opt) {
        this.peaks = _peaks;
        this.structures = _generator.getMotifs();
        this.fragmenter = null;
        this.frag_doc = null;
        this.generator = _generator;
        this.ann_opt = _ann_opt;
        this.mode = 3;
    }

    public AnnotatedPeakList getAnnotatedPeaks() {
        return this.annotated_peaks;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getTarget() {
        return this.structures != null && this.peaks != null ? this.structures.size() * this.peaks.size() : 0;
    }

    public int getNoStructures() {
        return this.structures != null ? this.structures.size() : 0;
    }

    public int getNonEmptyStructures() {
        return this.no_structures;
    }

    public boolean hasFuzzyStructures() {
        return this.has_fuzzy;
    }

    public boolean hasNonFuzzyStructures() {
        return this.has_not_fuzzy;
    }

    @Override
    public void run() {
        this.progress = 0;
        this.no_structures = 0;
        this.has_fuzzy = false;
        this.has_not_fuzzy = true;
        if (this.peaks == null || this.ann_opt == null || this.fragmenter == null && this.frag_doc == null && this.generator == null || this.fragmenter != null && this.structures == null) {
            AnnotationThread.interrupted();
            return;
        }
        if (!this.ann_opt.DERIVE_FROM_PARENT || this.mode != 1) {
            this.ion_clouds = IonCloudUtils.getPossibleIonClouds(this.ann_opt);
        }
        if (this.mode == 1) {
            this.annotated_peaks.clear();
            for (Glycan structure : this.structures) {
                if (structure != null) {
                    ++this.no_structures;
                    if (structure.isFuzzy(true)) {
                        this.has_fuzzy = true;
                        this.progress += this.peaks.size();
                        continue;
                    }
                    this.has_not_fuzzy = true;
                    FragmentCollection frag_coll = this.fragmenter.computeAllFragments(structure);
                    AnnotationOptions der_ann_opt = this.ann_opt;
                    if (this.ann_opt.DERIVE_FROM_PARENT) {
                        der_ann_opt = this.ann_opt.derive(structure);
                        this.ion_clouds = IonCloudUtils.getPossibleIonClouds(der_ann_opt);
                    }
                    this.match_coll = this.match(this.peaks, frag_coll, this.ion_clouds, der_ann_opt);
                    this.annotated_peaks.addPeakAnnotations(structure, this.match_coll, false);
                    continue;
                }
                this.progress += this.peaks.size();
            }
        } else if (this.mode == 2) {
            this.annotated_peaks.clear();
            for (int i = 0; i < this.frag_doc.getNoStructures(); ++i) {
                this.match_coll = this.match(this.peaks, this.frag_doc.getFragments(i), this.ion_clouds, this.ann_opt);
                this.annotated_peaks.addPeakAnnotations(this.frag_doc.getStructure(i), this.match_coll, false);
            }
        } else if (this.mode == 3) {
            this.annotated_peaks.clear();
            int ind = 0;
            for (Glycan s : this.structures) {
                this.match_coll = new PeakAnnotationCollection();
                this.generator.generate(ind, this);
                for (Peak p : this.peaks.getPeaks()) {
                    if (this.match_coll.isAnnotated(p)) continue;
                    this.match_coll.addPeakAnnotation(p);
                }
                this.progress += this.peaks.size();
                this.annotated_peaks.addPeakAnnotations(s, this.match_coll, false);
                ++ind;
            }
        }
        this.progress = this.getTarget();
    }

    public static Collection<FragmentEntry> computeChargesAndExchanges(Glycan structure, Collection<FragmentEntry> fragments, AnnotationOptions ann_opt) {
        if (ann_opt.DERIVE_FROM_PARENT) {
            ann_opt = ann_opt.derive(structure);
        }
        Vector<IonCloud> ion_clouds = IonCloudUtils.getPossibleIonClouds(ann_opt);
        return AnnotationThread.computeChargesAndExchanges(fragments, ion_clouds, ann_opt);
    }

    public static Collection<FragmentEntry> computeChargesAndExchanges(Collection<FragmentEntry> fragments, Collection<IonCloud> ion_clouds, AnnotationOptions ann_opt) {
        Vector<FragmentEntry> ret = new Vector<FragmentEntry>();
        for (FragmentEntry fe : fragments) {
            if (ann_opt.COMPUTE_EXCHANGES) {
                Vector<IonCloud> neutral_exchanges = IonCloudUtils.getPossibleNeutralExchanges(fe.fragment.countCharges(), ann_opt);
                for (IonCloud nex : neutral_exchanges) {
                    for (IonCloud cloud : ion_clouds) {
                        if (!cloud.and(nex).isRealistic()) continue;
                        ret.add(fe.and(cloud, nex));
                    }
                }
                continue;
            }
            for (IonCloud cloud : ion_clouds) {
                ret.add(fe.and(cloud));
            }
        }
        return ret;
    }

    @Override
    public boolean generatorCallback(FragmentEntry fe) {
        if (this.ann_opt.COMPUTE_EXCHANGES) {
            Vector<IonCloud> neutral_exchanges = IonCloudUtils.getPossibleNeutralExchanges(fe.fragment.countCharges(), this.ann_opt);
            for (IonCloud nex : neutral_exchanges) {
                for (IonCloud cloud : this.ion_clouds) {
                    if (cloud.and(nex).isRealistic()) {
                        for (Peak p : this.peaks.getPeaks()) {
                            if (!AnnotationThread.match(p, fe, cloud, nex, this.ann_opt)) continue;
                            this.match_coll.addPeakAnnotation(p, fe.and(cloud, nex));
                        }
                    }
                    if (!AnnotationThread.interrupted()) continue;
                    return false;
                }
            }
        } else {
            for (IonCloud cloud : this.ion_clouds) {
                for (Peak p : this.peaks.getPeaks()) {
                    if (!AnnotationThread.match(p, fe, cloud, this.ann_opt)) continue;
                    this.match_coll.addPeakAnnotation(p, fe.and(cloud));
                }
                if (!AnnotationThread.interrupted()) continue;
                return false;
            }
        }
        return true;
    }

    public PeakAnnotationCollection match(PeakList peaklist, FragmentCollection fc, Vector<IonCloud> ion_clouds, AnnotationOptions ann_opt) {
        PeakAnnotationCollection matched = new PeakAnnotationCollection();
        int i = 0;
        while (i < peaklist.size() && !AnnotationThread.interrupted()) {
            Peak p = peaklist.getPeak(i);
            boolean has_matched = false;
            for (FragmentEntry fe : fc.getFragments()) {
                if (p.getCharge() != Integer.MIN_VALUE && p.getCharge() != fe.getCharges().getNoCharges()) continue;
                if (ann_opt.COMPUTE_EXCHANGES) {
                    Vector<IonCloud> neutral_exchanges = IonCloudUtils.getPossibleNeutralExchanges(fe.fragment.countCharges(), ann_opt);
                    for (IonCloud nex : neutral_exchanges) {
                        for (IonCloud cloud : ion_clouds) {
                            if (!cloud.and(nex).isRealistic() || !AnnotationThread.match(p, fe, cloud, nex, ann_opt)) continue;
                            matched.addPeakAnnotation(p, fe.and(cloud, nex));
                            has_matched = true;
                        }
                    }
                    continue;
                }
                for (IonCloud cloud : ion_clouds) {
                    if (!AnnotationThread.match(p, fe, cloud, ann_opt)) continue;
                    matched.addPeakAnnotation(p, fe.and(cloud));
                    has_matched = true;
                }
            }
            if (!has_matched) {
                matched.addPeakAnnotation(p);
            }
            ++i;
            ++this.progress;
        }
        return matched;
    }

    public static boolean match(double fmz, double mz_ratio, AnnotationOptions ann_opt) {
        if (ann_opt.MASS_ACCURACY_UNIT.equals("ppm")) {
            return Math.abs(1.0 - fmz / mz_ratio) < 1.0E-6 * ann_opt.MASS_ACCURACY;
        }
        return Math.abs(mz_ratio - fmz) < ann_opt.MASS_ACCURACY;
    }

    public static boolean match(Peak p, FragmentEntry fe, AnnotationOptions ann_opt) {
        double fmz = fe.mz_ratio;
        double mz_ratio = p.getMZ();
        return AnnotationThread.match(fmz, mz_ratio, ann_opt);
    }

    public static boolean match(Peak p, FragmentEntry fe, IonCloud ions, AnnotationOptions ann_opt) {
        double fmz = ions.computeMZ(fe.mass.doubleValue());
        double mz_ratio = p.getMZ();
        return AnnotationThread.match(fmz, mz_ratio, ann_opt);
    }

    public static boolean match(Peak p, FragmentEntry fe, IonCloud ions, IonCloud neutral_exchange, AnnotationOptions ann_opt) {
        double fmz = ions.computeMZ(neutral_exchange.getIonsMass() + fe.mass);
        double mz_ratio = p.getMZ();
        return AnnotationThread.match(fmz, mz_ratio, ann_opt);
    }
}

