/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.editor.experimentdesigner.parts;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ShortestPathConnectionRouter;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.grits.toolbox.editor.experimentdesigner.commands.GraphNodeCreateCommand;
import org.grits.toolbox.editor.experimentdesigner.commands.GraphNodeSetConstraintCommand;
import org.grits.toolbox.editor.experimentdesigner.model.ExperimentGraph;
import org.grits.toolbox.editor.experimentdesigner.model.GraphNode;
import org.grits.toolbox.editor.experimentdesigner.model.InputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ModelElement;
import org.grits.toolbox.editor.experimentdesigner.model.OutputNode;
import org.grits.toolbox.editor.experimentdesigner.model.ProtocolNode;
import org.grits.toolbox.editor.experimentdesigner.parts.GraphNodeEditPart;

class GraphEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    GraphEditPart() {
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener(this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ShapesXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer();
        f.setBorder((Border)new MarginBorder(3));
        f.setLayoutManager((LayoutManager)new FreeformLayout());
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter((ConnectionRouter)new ShortestPathConnectionRouter((IFigure)f));
        return f;
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener(this);
        }
    }

    private ExperimentGraph getCastedModel() {
        return (ExperimentGraph)this.getModel();
    }

    protected List getModelChildren() {
        return this.getCastedModel().getChildren();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if ("Graph.ChildAdded".equals(prop) || "Graph.ChildRemoved".equals(prop)) {
            this.refreshChildren();
        }
    }

    private static class ShapesXYLayoutEditPolicy
    extends XYLayoutEditPolicy {
        private ShapesXYLayoutEditPolicy() {
        }

        protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
            if (child instanceof GraphNodeEditPart && constraint instanceof Rectangle) {
                return new GraphNodeSetConstraintCommand((GraphNode)child.getModel(), request, (Rectangle)constraint);
            }
            return super.createChangeConstraintCommand(request, child, constraint);
        }

        protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
            return null;
        }

        protected Command getCreateCommand(CreateRequest request) {
            Object childClass = request.getNewObjectType();
            if (childClass == ProtocolNode.class || childClass == InputNode.class || childClass == OutputNode.class) {
                return new GraphNodeCreateCommand((GraphNode)request.getNewObject(), (GraphicalViewer)this.getHost().getViewer(), (ExperimentGraph)this.getHost().getModel(), (Rectangle)this.getConstraintFor(request));
            }
            return null;
        }
    }
}

