/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.core.utils;

import java.io.File;
import java.io.FileInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class UtilityZip {
    private static final long MAX_FOLDER_SIZE = 0x40000000L;
    private static Logger logger = Logger.getLogger(UtilityZip.class);
    public static final int bufferSize = 0xA00000;

    public static void addDirectory(File childFile, String relativePath, ZipOutputStream zipOutputStream) throws Exception {
        if (childFile.isDirectory()) {
            if (childFile.length() < 0x40000000L) {
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(String.valueOf(relativePath) + "/"));
                    zipOutputStream.closeEntry();
                    UtilityZip.addFiles(childFile, relativePath, zipOutputStream);
                }
                catch (Exception ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                    throw ex;
                }
            } else {
                throw new Exception("Cannot compress folders with large sizes (>1073741824");
            }
        }
    }

    public static void addFile(File childFile, String relativePath, ZipOutputStream zipOutputStream) throws Exception {
        if (childFile.isFile()) {
            try {
                int len;
                ZipEntry zipEntry = new ZipEntry(relativePath);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fis = new FileInputStream(childFile);
                byte[] buffer = new byte[0xA00000];
                while ((len = fis.read(buffer)) > 0) {
                    zipOutputStream.write(buffer, 0, len);
                }
                fis.close();
                zipOutputStream.closeEntry();
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
                throw ex;
            }
        }
    }

    private static void addFiles(File folderToCopy, String relativeZipPath, ZipOutputStream zipOutputStream) throws Exception {
        String relativePath = null;
        File[] fileArray = folderToCopy.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File childFile = fileArray[n2];
            if (childFile.exists()) {
                String string = relativePath = relativeZipPath == null || relativeZipPath.isEmpty() ? childFile.getName() : String.valueOf(relativeZipPath) + "/" + childFile.getName();
                if (childFile.isDirectory()) {
                    UtilityZip.addDirectory(childFile, relativePath, zipOutputStream);
                } else if (childFile.isFile() || childFile.isHidden() && !childFile.isDirectory()) {
                    UtilityZip.addFile(childFile, relativePath, zipOutputStream);
                } else {
                    logger.error((Object)("Error zipping " + childFile.getName()));
                }
            }
            ++n2;
        }
    }
}

