/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.utilities;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TextCellEditorWithContentProposal
extends TextCellEditor {
    private ContentProposalAdapter contentProposalAdapter;
    private boolean popupOpen = false;
    ControlDecoration controlDecoration;
    IContentProposal[] proposals = null;

    public TextCellEditorWithContentProposal(Composite parent, IContentProposalProvider contentProposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        super(parent);
        this.enableContentProposal(contentProposalProvider, keyStroke, autoActivationCharacters);
    }

    private void enableContentProposal(IContentProposalProvider contentProposalProvider, KeyStroke keyStroke, char[] autoActivationCharacters) {
        this.contentProposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), contentProposalProvider, keyStroke, autoActivationCharacters);
        this.contentProposalAdapter.setProposalAcceptanceStyle(2);
        this.controlDecoration = new ControlDecoration((Control)this.text, 16512);
        this.controlDecoration.setMarginWidth(0);
        this.controlDecoration.setShowHover(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        this.controlDecoration.setImage(contentProposalImage.getImage());
        this.controlDecoration.hide();
        this.contentProposalAdapter.addContentProposalListener(new IContentProposalListener2(){

            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                TextCellEditorWithContentProposal.this.popupOpen = false;
            }

            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                TextCellEditorWithContentProposal.this.popupOpen = true;
                TextCellEditorWithContentProposal.this.proposals = TextCellEditorWithContentProposal.this.contentProposalAdapter.getContentProposalProvider().getProposals(TextCellEditorWithContentProposal.this.contentProposalAdapter.getControlContentAdapter().getControlContents((Control)TextCellEditorWithContentProposal.this.text), TextCellEditorWithContentProposal.this.contentProposalAdapter.getControlContentAdapter().getCursorPosition((Control)TextCellEditorWithContentProposal.this.text));
            }
        });
    }

    public ContentProposalAdapter getContentProposalAdapter() {
        return this.contentProposalAdapter;
    }

    protected boolean isCorrect(Object value) {
        if (super.isCorrect(value)) {
            if (this.proposals != null) {
                IContentProposal[] iContentProposalArray = this.proposals;
                int n = this.proposals.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentProposal proposal = iContentProposalArray[n2];
                    if (proposal.getContent().equals(this.text.getText())) {
                        this.controlDecoration.hide();
                        return true;
                    }
                    ++n2;
                }
                this.controlDecoration.setDescriptionText(this.getErrorMessage());
                this.controlDecoration.show();
                return false;
            }
            return true;
        }
        return false;
    }

    public String getErrorMessage() {
        return "You must select from the suggested entries";
    }

    protected void focusLost() {
        if (!this.popupOpen) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

