/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.archive.editor;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.entry.archive.editor.pages.AbstractArchivePage;
import org.grits.toolbox.entry.archive.editor.pages.archivedemail.EmailArchivePage;
import org.grits.toolbox.entry.archive.editor.pages.archivedfile.FileArchivePage;
import org.grits.toolbox.entry.archive.model.Archive;
import org.grits.toolbox.entry.archive.model.ArchivedFile;
import org.grits.toolbox.entry.archive.property.ArchiveProperty;

public class ArchiveEntryEditor {
    private static final Logger logger = Logger.getLogger(ArchiveEntryEditor.class);
    public static final String DATE_FORMAT = "MM/dd/yyyy";
    private Entry archiveEntry = null;
    private File archiveFolder = null;
    private HashMap<String, String> renamedArchives = new HashMap();
    private Archive archive = null;
    private File archiveXmlFile = null;
    @Inject
    MDirtyable dirtyFlag;
    private CTabFolder cTabFolder;
    private Map<CTabItem, AbstractArchivePage> cTabItemToPartTabMap = new HashMap<CTabItem, AbstractArchivePage>();
    private FileArchivePage filePage;
    private EmailArchivePage emailPage;

    public Map<CTabItem, AbstractArchivePage> getcTabItemToPartTabMap() {
        return this.cTabItemToPartTabMap;
    }

    public HashMap<String, String> getRenamedArchives() {
        return this.renamedArchives;
    }

    @Inject
    public ArchiveEntryEditor(@Named(value="org.eclipse.ui.selection") Entry entry) throws Exception {
        if (entry == null) {
            return;
        }
        this.archiveEntry = entry;
        this.archiveEntry.setDisplayName(String.valueOf(this.archiveEntry.getParent().getDisplayName()) + "- " + "Archive");
        this.archiveFolder = ArchiveProperty.getFolderForArchiveEntry(this.archiveEntry);
        if (this.archiveFolder != null && this.archiveFolder.exists() && this.archiveFolder.isDirectory()) {
            this.archiveXmlFile = this.loadArchiveXmlFile();
            if (this.archiveXmlFile != null && this.archiveXmlFile.exists() && this.archiveXmlFile.isFile()) {
                this.archive = this.loadArchive();
                this.verifyArchiveFiles();
            } else {
                throw new Exception("Could not find archive xml file.");
            }
        }
        logger.debug((Object)"- END : Getting Input for Archive Entry Editor...");
    }

    private void verifyArchiveFiles() {
        ArrayList<ArchivedFile> filesToRemove = new ArrayList<ArchivedFile>();
        for (ArchivedFile archivedFile : this.archive.getArchivedFiles()) {
            if (new File(this.archiveFolder, archivedFile.getTypicalArchivedFile().getFileName()).exists()) continue;
            filesToRemove.add(archivedFile);
        }
        if (!filesToRemove.isEmpty()) {
            String archivedFileNames = "(";
            int i = 0;
            int max = 5;
            for (ArchivedFile ftr : filesToRemove) {
                if (i < max) {
                    archivedFileNames = String.valueOf(archivedFileNames) + ftr.getTypicalArchivedFile().getFileName() + ", ";
                } else if (i == max) {
                    archivedFileNames = String.valueOf(archivedFileNames) + "...";
                }
                ++i;
            }
            if (archivedFileNames.endsWith(", ")) {
                archivedFileNames = archivedFileNames.substring(0, archivedFileNames.length() - 2);
            }
            archivedFileNames = String.valueOf(archivedFileNames) + ")\n\n";
            boolean remove = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Files not Found", (String)("These are the archives that were not found in the system :\n" + archivedFileNames + "Do you want to remove them from the archive list?"));
            if (remove) {
                for (ArchivedFile ftr : filesToRemove) {
                    this.archive.getArchivedFiles().remove(ftr);
                }
                this.saveModel();
            }
        }
    }

    public Entry getArchiveEntry() {
        return this.archiveEntry;
    }

    public Archive getArchive() {
        return this.archive;
    }

    @PostConstruct
    public void postConstruct(Composite parent, final MPart part) {
        part.setLabel(String.valueOf(this.archiveEntry.getParent().getDisplayName()) + "- " + "Archive");
        logger.info((Object)"Creating tabs");
        parent.setLayout((Layout)new FillLayout());
        this.cTabFolder = new CTabFolder(parent, 0);
        this.cTabFolder.setTabPosition(1024);
        this.cTabFolder.setSimple(false);
        part.getContext().set(CTabFolder.class, (Object)this.cTabFolder);
        part.getContext().set(ArchiveEntryEditor.class, (Object)this);
        try {
            this.cTabFolder.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    this.changeTab(e);
                }

                private void changeTab(SelectionEvent e) {
                    int selectionIndex = ArchiveEntryEditor.this.cTabFolder.getSelectionIndex();
                    logger.info((Object)("Tab changed to " + selectionIndex));
                    selectionIndex = selectionIndex < 0 ? 0 : selectionIndex;
                    AbstractArchivePage currentTab = ArchiveEntryEditor.this.getcTabItemToPartTabMap().get(ArchiveEntryEditor.this.cTabFolder.getSelection());
                    part.getContext().set(AbstractArchivePage.class, (Object)currentTab);
                    ArchiveEntryEditor.this.cTabFolder.getSelection().notifyListeners(13, new Event());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.changeTab(e);
                }
            });
            this.addPages(part);
            this.cTabFolder.setSelection(0);
            this.cTabFolder.notifyListeners(13, new Event());
        }
        catch (Exception e) {
            logger.fatal((Object)("Error while adding tabs to the qrtpcr editor.\n" + e.getMessage()), (Throwable)e);
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Creating Page", (String)"Some unexpected error occurred while opening the editor. Please contact developers for further information/help.");
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        logger.info((Object)"END   : Creating QrtPCRTableEditor. ");
    }

    protected void addPages(MPart part) {
        logger.info((Object)"Adding pages");
        CTabItem cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("File   ");
        cTabItem.setShowClose(false);
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        this.filePage = (FileArchivePage)ContextInjectionFactory.make(FileArchivePage.class, (IEclipseContext)part.getContext());
        this.getcTabItemToPartTabMap().put(cTabItem, this.filePage);
        cTabItem = new CTabItem(this.cTabFolder, 0);
        cTabItem.setText("Email  ");
        cTabItem.setShowClose(false);
        part.getContext().set(CTabItem.class, (Object)cTabItem);
        this.emailPage = (EmailArchivePage)ContextInjectionFactory.make(EmailArchivePage.class, (IEclipseContext)part.getContext());
        this.getcTabItemToPartTabMap().put(cTabItem, this.emailPage);
    }

    @Persist
    public void doSave(IProgressMonitor monitor) {
        this.verifyArchiveFiles();
        this.saveModel();
        this.checkAndResetDirty();
    }

    public void checkAndResetDirty() {
        if (this.dirtyFlag.isDirty()) {
            this.dirtyFlag.setDirty(false);
            AbstractArchivePage activePage = this.getcTabItemToPartTabMap().get(this.cTabFolder.getSelection());
            if (activePage != null) {
                activePage.refreshPage();
            }
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag.isDirty();
    }

    public void markDirty() {
        if (!this.dirtyFlag.isDirty()) {
            this.dirtyFlag.setDirty(true);
        }
    }

    private File loadArchiveXmlFile() {
        File archiveXmlFile;
        block4: {
            archiveXmlFile = null;
            logger.debug((Object)"- START : Loading all Archive Xml File from the archive.");
            try {
                if (!this.archiveFolder.exists() || !this.archiveFolder.isDirectory()) break block4;
                File[] fileArray = this.archiveFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    if (file.getName().equals("archive.xml") && file.isFile()) {
                        archiveXmlFile = file;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        logger.debug((Object)"- END   : Loading all Archive Xml File from the archive.");
        return archiveXmlFile;
    }

    public Archive loadArchive() throws Exception {
        Archive archive = null;
        if (this.archiveXmlFile != null && this.archiveXmlFile.exists()) {
            try {
                FileInputStream inputStream = new FileInputStream(this.archiveXmlFile.getAbsolutePath());
                InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Archive.class});
                    Unmarshaller unmarshaller = context.createUnmarshaller();
                    archive = (Archive)unmarshaller.unmarshal((Reader)reader);
                }
                catch (JAXBException ex) {
                    logger.error((Object)("Error parsing the archive xml file." + ex.getMessage()), (Throwable)ex);
                    throw ex;
                }
            }
            catch (FileNotFoundException | UnsupportedEncodingException ex) {
                logger.error((Object)("Error loading the archive from the file location. " + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
        }
        return archive;
    }

    public boolean saveModel() {
        return ArchiveEntryEditor.saveModel(this.archive, this.archiveXmlFile);
    }

    public static boolean saveModel(Archive archive, File archiveXmlFile) {
        boolean updated = false;
        if (archive != null) {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Archive.class});
                    Marshaller marshaller = context.createMarshaller();
                    marshaller.setProperty("jaxb.formatted.output", (Object)true);
                    marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
                    marshaller.marshal((Object)archive, (OutputStream)os);
                    try {
                        FileWriter fileWriter = new FileWriter(archiveXmlFile);
                        fileWriter.write(os.toString((String)marshaller.getProperty("jaxb.encoding")));
                        fileWriter.close();
                        os.close();
                        updated = true;
                    }
                    catch (IOException e) {
                        logger.error((Object)"The changes made could not be written to the file.", (Throwable)e);
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Writing File", (String)"The changes made could not be written to the file.");
                    }
                }
                catch (JAXBException e) {
                    logger.error((Object)"The changes made could not be serialized as xml.", (Throwable)e);
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Parsing File", (String)"The changes made could not be serialized to xml.");
                }
            }
            catch (Exception e) {
                logger.fatal((Object)e);
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error Saving File", (String)"The changes made could not be saved to the file. Please contact the development team.");
            }
        }
        return updated;
    }

    public File getArchiveFolder() {
        return this.archiveFolder;
    }

    public Date renameArchive(String previousName, String newName) throws Exception {
        Date modifiedDate = null;
        Archive tempArchiveModel = this.loadArchive();
        for (ArchivedFile archiveFile : tempArchiveModel.getArchivedFiles()) {
            if (!archiveFile.getTypicalArchivedFile().getFileName().equals(previousName)) continue;
            archiveFile.getTypicalArchivedFile().setFileName(newName);
            modifiedDate = new Date();
            archiveFile.setModifiedDate(modifiedDate);
            break;
        }
        ArchiveEntryEditor.saveModel(tempArchiveModel, this.archiveXmlFile);
        return modifiedDate;
    }

    public void removeArchivedFile(ArchivedFile archivedFile) throws Exception {
        Archive tempArchiveModel = this.loadArchive();
        ArchivedFile archivedFileToRemove = null;
        for (ArchivedFile thisArchive : tempArchiveModel.getArchivedFiles()) {
            if (!thisArchive.getTypicalArchivedFile().getFileName().equals(archivedFile.getTypicalArchivedFile().getFileName())) continue;
            archivedFileToRemove = thisArchive;
            break;
        }
        tempArchiveModel.getArchivedFiles().remove(archivedFileToRemove);
        ArchiveEntryEditor.saveModel(tempArchiveModel, this.archiveXmlFile);
    }
}

