/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import org.eurocarbdb.application.glycanbuilder.BaseDocument;
import org.eurocarbdb.application.glycanbuilder.CustomFocusTraversalPolicy;
import org.eurocarbdb.application.glycanbuilder.EscapeDialog;
import org.eurocarbdb.application.glycanbuilder.TextUtils;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.ScanData;
import org.jdesktop.layout.GroupLayout;

public class ScanDataPropertiesDialog
extends EscapeDialog
implements ActionListener {
    private ScanData current;
    private GlycanWorkspace theWorkspace;
    private DecimalFormat double_format = new DecimalFormat("0.0000");
    private JButton button_cancel;
    private JButton button_ok;
    private JTextField field_base_peak_intensity;
    private JTextField field_base_peak_mz;
    private JCheckBox field_centroided;
    private JCheckBox field_charge_deconvoluted;
    private JCheckBox field_deisotoped;
    private JTextField field_end_mz;
    private JTextField field_high_mz;
    private JTextField field_low_mz;
    private JTextField field_ms_level;
    private JCheckBox field_positive_mode;
    private JTextField field_precursor_charge;
    private JTextField field_precursor_mz;
    private JTextField field_retention_time;
    private JTextField field_start_mz;
    private JTextField field_total_ion_current;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JSeparator jSeparator1;

    public ScanDataPropertiesDialog(Frame parent, ScanData _current, GlycanWorkspace _workspace) {
        super(parent, true);
        this.current = _current;
        this.theWorkspace = _workspace;
        this.initComponents();
        this.setSelections();
        this.setTraversal();
        this.setActions();
        this.enableItems();
        this.setLocationRelativeTo(parent);
    }

    private void setSelections() {
        this.setValue(this.field_ms_level, this.current.getMSLevel());
        this.setValue(this.field_precursor_mz, this.current.getPrecursorMZ());
        this.setValue(this.field_precursor_charge, this.current.getPrecursorCharge());
        this.setValue(this.field_positive_mode, this.current.getPositiveMode());
        this.setValue(this.field_centroided, this.current.getCentroided());
        this.setValue(this.field_deisotoped, this.current.getDeisotoped());
        this.setValue(this.field_charge_deconvoluted, this.current.getChargeDeconvoluted());
        this.setValue(this.field_retention_time, this.current.getRetentionTime());
        this.setValue(this.field_base_peak_mz, this.current.getBasePeakMZ());
        this.setValue(this.field_base_peak_intensity, this.current.getBasePeakIntensity());
        this.setValue(this.field_start_mz, this.current.getStartMZ());
        this.setValue(this.field_end_mz, this.current.getEndMZ());
        this.setValue(this.field_low_mz, this.current.getLowMZ());
        this.setValue(this.field_high_mz, this.current.getHighMZ());
        this.setValue(this.field_total_ion_current, this.current.getTotalIonCurrent());
    }

    private void setValue(JTextField tf, Double v) {
        if (v != null) {
            tf.setText(this.double_format.format(v));
        } else {
            tf.setText("");
        }
    }

    private void setValue(JTextField tf, Integer v) {
        if (v != null) {
            tf.setText("" + v);
        } else {
            tf.setText("");
        }
    }

    private void setValue(JCheckBox cb, Boolean v) {
        if (v != null) {
            cb.setSelected(v);
        } else {
            cb.setSelected(false);
        }
    }

    private Double getDoubleValue(JTextField tf) {
        if (TextUtils.trim((String)tf.getText()).length() > 0) {
            Number ret = this.double_format.parse(tf.getText(), new ParsePosition(0));
            if (ret == null) {
                return null;
            }
            return ret.doubleValue();
        }
        return null;
    }

    private Integer getIntegerValue(JTextField tf) {
        String text = TextUtils.trim((String)tf.getText());
        if (text.length() > 0) {
            try {
                return Integer.valueOf(text);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    private void setTraversal() {
        CustomFocusTraversalPolicy tp = new CustomFocusTraversalPolicy();
        tp.addComponent((Component)this.field_ms_level);
        tp.addComponent((Component)this.field_precursor_mz);
        tp.addComponent((Component)this.field_precursor_charge);
        tp.addComponent((Component)this.field_base_peak_mz);
        tp.addComponent((Component)this.field_base_peak_intensity);
        tp.addComponent((Component)this.field_start_mz);
        tp.addComponent((Component)this.field_end_mz);
        tp.addComponent((Component)this.field_low_mz);
        tp.addComponent((Component)this.field_high_mz);
        tp.addComponent((Component)this.field_retention_time);
        tp.addComponent((Component)this.field_total_ion_current);
        tp.addComponent((Component)this.field_positive_mode);
        tp.addComponent((Component)this.field_centroided);
        tp.addComponent((Component)this.field_deisotoped);
        tp.addComponent((Component)this.field_charge_deconvoluted);
        tp.addComponent((Component)this.button_ok);
        tp.addComponent((Component)this.button_cancel);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)tp);
        this.getRootPane().setDefaultButton(this.button_ok);
    }

    private void setActions() {
        this.button_ok.addActionListener(this);
        this.button_cancel.addActionListener(this);
    }

    private void enableItems() {
    }

    private void retrieveData() {
        this.current.setMSLevel(this.getIntegerValue(this.field_ms_level));
        this.current.setPrecursorMZ(this.getDoubleValue(this.field_precursor_mz));
        this.current.setPrecursorCharge(this.getIntegerValue(this.field_precursor_charge));
        this.current.setPositiveMode(this.field_positive_mode.isSelected());
        this.current.setCentroided(this.field_centroided.isSelected());
        this.current.setDeisotoped(this.field_deisotoped.isSelected());
        this.current.setChargeDeconvoluted(this.field_charge_deconvoluted.isSelected());
        this.current.setRetentionTime(this.getDoubleValue(this.field_retention_time));
        this.current.setBasePeakMZ(this.getDoubleValue(this.field_base_peak_mz));
        this.current.setBasePeakIntensity(this.getDoubleValue(this.field_base_peak_intensity));
        this.current.setStartMZ(this.getDoubleValue(this.field_start_mz));
        this.current.setEndMZ(this.getDoubleValue(this.field_end_mz));
        this.current.setLowMZ(this.getDoubleValue(this.field_low_mz));
        this.current.setHighMZ(this.getDoubleValue(this.field_high_mz));
        this.current.setTotalIonCurrent(this.getDoubleValue(this.field_total_ion_current));
        this.theWorkspace.fireDocumentChanged((BaseDocument)this.theWorkspace);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action == "OK") {
            this.retrieveData();
            this.closeDialog();
        } else if (action == "Cancel") {
            this.closeDialog();
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.field_precursor_mz = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.button_ok = new JButton();
        this.button_cancel = new JButton();
        this.field_precursor_charge = new JTextField();
        this.jLabel4 = new JLabel();
        this.field_positive_mode = new JCheckBox();
        this.field_centroided = new JCheckBox();
        this.field_deisotoped = new JCheckBox();
        this.field_charge_deconvoluted = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.field_start_mz = new JTextField();
        this.jLabel6 = new JLabel();
        this.field_end_mz = new JTextField();
        this.jLabel7 = new JLabel();
        this.field_base_peak_mz = new JTextField();
        this.jLabel8 = new JLabel();
        this.field_base_peak_intensity = new JTextField();
        this.jLabel9 = new JLabel();
        this.field_low_mz = new JTextField();
        this.jLabel10 = new JLabel();
        this.field_high_mz = new JTextField();
        this.jLabel11 = new JLabel();
        this.field_retention_time = new JTextField();
        this.jLabel12 = new JLabel();
        this.field_total_ion_current = new JTextField();
        this.jLabel13 = new JLabel();
        this.field_ms_level = new JTextField();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ScanDataPropertiesDialog.this.closeDialog();
            }
        });
        this.jLabel2.setText("Precursor m/z");
        this.field_precursor_mz.setText("jTextField1");
        this.button_ok.setText("OK");
        this.button_cancel.setText("Cancel");
        this.field_precursor_charge.setText("jTextField1");
        this.jLabel4.setText("charge");
        this.field_positive_mode.setText("positive mode");
        this.field_centroided.setText("centroided");
        this.field_deisotoped.setText("deisotoped");
        this.field_charge_deconvoluted.setText("deconvoluted");
        this.jLabel5.setText("Start m/z");
        this.field_start_mz.setText("jTextField1");
        this.jLabel6.setText("end m/z");
        this.field_end_mz.setText("jTextField1");
        this.jLabel7.setText("Base peak m/z");
        this.field_base_peak_mz.setText("jTextField1");
        this.jLabel8.setText("intensity");
        this.field_base_peak_intensity.setText("jTextField1");
        this.jLabel9.setText("Low m/z");
        this.field_low_mz.setText("jTextField1");
        this.jLabel10.setText("high m/z");
        this.field_high_mz.setText("jTextField1");
        this.jLabel11.setText("Retention time");
        this.field_retention_time.setText("jTextField1");
        this.jLabel12.setText("TIC");
        this.field_total_ion_current.setText("jTextField1");
        this.jLabel13.setText("MS level");
        this.field_ms_level.setText("jTextField1");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel7).add((Component)this.jLabel5).add((Component)this.jLabel9).add((Component)this.jLabel11).add((Component)this.jLabel13, -1, 95, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_precursor_mz).add((Component)this.field_base_peak_mz, -2, -1, -2).add((Component)this.field_start_mz, -2, -1, -2).add((Component)this.field_low_mz, -2, -1, -2).add((Component)this.field_retention_time, -2, -1, -2).add((Component)this.field_positive_mode).add((Component)this.field_deisotoped)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel4, -1, 55, Short.MAX_VALUE).add((Component)this.jLabel8).add((Component)this.jLabel6).add((Component)this.jLabel10).add((Component)this.jLabel12)).add(12, 12, 12)).add((Component)this.field_ms_level, -2, -1, -2)).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.field_centroided).add((Component)this.field_charge_deconvoluted).add((Component)this.field_total_ion_current, -2, -1, -2).add((Component)this.field_high_mz, -2, -1, -2).add((Component)this.field_end_mz, -2, -1, -2).add((Component)this.field_base_peak_intensity, -2, -1, -2).add((Component)this.field_precursor_charge)).add(12, 12, 12)).add((GroupLayout.Group)layout.createSequentialGroup().add(140, 140, 140).add((Component)this.button_ok).addPreferredGap(0).add((Component)this.button_cancel).addContainerGap(178, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jSeparator1, -1, 410, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(new Component[]{this.button_cancel, this.button_ok}, 1);
        layout.linkSize(new Component[]{this.field_base_peak_intensity, this.field_end_mz, this.field_high_mz, this.field_total_ion_current}, 1);
        layout.linkSize(new Component[]{this.field_base_peak_mz, this.field_low_mz, this.field_precursor_charge, this.field_precursor_mz, this.field_retention_time, this.field_start_mz}, 1);
        layout.linkSize(new Component[]{this.jLabel11, this.jLabel2, this.jLabel5, this.jLabel7, this.jLabel9}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_ms_level, -2, -1, -2).add((Component)this.jLabel13)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.field_precursor_mz, -2, -1, -2).add((Component)this.jLabel4).add((Component)this.field_precursor_charge, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.field_base_peak_mz, -2, -1, -2).add((Component)this.jLabel8).add((Component)this.field_base_peak_intensity, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel5).add((Component)this.field_start_mz, -2, -1, -2).add((Component)this.jLabel6).add((Component)this.field_end_mz, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel9).add((Component)this.field_low_mz, -2, -1, -2).add((Component)this.jLabel10).add((Component)this.field_high_mz, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel11).add((Component)this.field_retention_time, -2, -1, -2).add((Component)this.jLabel12).add((Component)this.field_total_ion_current, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_positive_mode).add((Component)this.field_centroided)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.field_deisotoped).add((Component)this.field_charge_deconvoluted)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 16, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.button_cancel).add((Component)this.button_ok)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

