/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.application.glycoworkbench.plugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eurocarbdb.application.glycanbuilder.ClipUtils;
import org.eurocarbdb.application.glycanbuilder.FileUtils;
import org.eurocarbdb.application.glycanbuilder.Glycan;
import org.eurocarbdb.application.glycanbuilder.GlycanCanvas;
import org.eurocarbdb.application.glycanbuilder.GlycanRendererAWT;
import org.eurocarbdb.application.glycanbuilder.LogUtils;
import org.eurocarbdb.application.glycanbuilder.STOCK_ICON;
import org.eurocarbdb.application.glycoworkbench.GlycanWorkspace;
import org.eurocarbdb.application.glycoworkbench.GlycoWorkbench;
import org.eurocarbdb.application.glycoworkbench.plugin.DictionarySelection;
import org.eurocarbdb.application.glycoworkbench.plugin.Plugin;
import org.eurocarbdb.application.glycoworkbench.plugin.ProfilerPlugin;
import org.eurocarbdb.application.glycoworkbench.plugin.StructureType;
import org.eurocarbdb.application.glycoworkbench.plugin.TablePanel;

public class DictionariesSearchPanel
extends TablePanel<ProfilerPlugin>
implements ActionListener,
ChangeListener {
    private static final int ROWS = 10;
    private JToolBar theToolBarNavigation;
    private JToolBar theToolBarDocument;
    private JSlider theDictionarySlider;
    private JLabel theDictionaryStatus;
    private int current_page_start;
    private Collection<StructureType> entries;
    private Vector<DictionaryEntry> ordered_entries;
    private Vector<DictionaryEntry> shown_entries;
    private boolean ignore_slider = false;
    private boolean ignore_selector = false;

    public DictionariesSearchPanel(ProfilerPlugin profiler) {
        this.setProfiler(profiler);
        this.setData(new Vector<StructureType>());
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.theDictionarySlider = new JSlider();
        this.theDictionarySlider.addChangeListener(this);
        this.theDictionaryStatus = new JLabel("");
        JPanel top_panel = new JPanel(new BorderLayout());
        top_panel.add((Component)this.theDictionarySlider, "Center");
        top_panel.add((Component)this.theDictionaryStatus, "East");
        this.add((Component)top_panel, "North");
        this.theTable.setGlycanScale(0.35);
        JPanel bottom_panel = new JPanel(new BorderLayout());
        this.theToolBarNavigation = this.createToolBarNavigation();
        bottom_panel.add((Component)this.theToolBarNavigation, "North");
        this.theToolBarDocument = this.createToolBarDocument();
        bottom_panel.add((Component)this.theToolBarDocument, "Center");
        this.add((Component)bottom_panel, "South");
    }

    @Override
    protected ProfilerPlugin getDocumentFromWorkspace(GlycanWorkspace workspace) {
        return null;
    }

    @Override
    protected void setDocumentFromWorkspace(GlycanWorkspace workspace) {
    }

    public void setProfiler(ProfilerPlugin profiler) {
        this.theDocument = profiler;
    }

    public void setData(Collection<StructureType> _entries) {
        this.entries = _entries;
        this.current_page_start = 0;
        this.updateData();
        this.updateActions();
        this.updateView();
    }

    public Collection<StructureType> getData() {
        return this.entries;
    }

    @Override
    protected void createActions() {
        this.theActionManager.add("first", FileUtils.defaultThemeManager.getImageIcon("first"), "First page", -1, "", (ActionListener)this);
        this.theActionManager.add("pprevious", FileUtils.defaultThemeManager.getImageIcon("pprevious"), "Five pages before", -1, "", (ActionListener)this);
        this.theActionManager.add("previous", FileUtils.defaultThemeManager.getImageIcon("previous"), "Previous page", -1, "", (ActionListener)this);
        this.theActionManager.add("next", FileUtils.defaultThemeManager.getImageIcon("next"), "Next page", -1, "", (ActionListener)this);
        this.theActionManager.add("nnext", FileUtils.defaultThemeManager.getImageIcon("nnext"), "Five pages after", -1, "", (ActionListener)this);
        this.theActionManager.add("last", FileUtils.defaultThemeManager.getImageIcon("last"), "Last page", -1, "", (ActionListener)this);
        this.theActionManager.add("print", FileUtils.defaultThemeManager.getImageIcon("print"), "Print...", 80, "", (ActionListener)this);
        this.theActionManager.add("copy", GlycoWorkbench.getDefaultThemeManager().getResizableIcon(STOCK_ICON.COPY, Plugin.DEFAULT_ICON_SIZE), "Copy", 67, "", (ActionListener)this);
        this.theActionManager.add("transfer", FileUtils.defaultThemeManager.getImageIcon("transfer"), "Copy structures to canvas", 86, "", (ActionListener)this);
        this.theActionManager.add("goto", FileUtils.defaultThemeManager.getImageIcon("goto"), "Jump to a specific m/z value", -1, "", (ActionListener)this);
        this.theActionManager.add("search", FileUtils.defaultThemeManager.getImageIcon("search"), "Search the dictionary", -1, "", (ActionListener)this);
        this.theActionManager.add("searchagain", FileUtils.defaultThemeManager.getImageIcon("searchagain"), "Search in the current results", -1, "", (ActionListener)this);
        this.theActionManager.add("clearsearch", FileUtils.defaultThemeManager.getImageIcon("clearsearch"), "Clear search", -1, "", (ActionListener)this);
    }

    @Override
    protected void updateActions() {
        boolean has_selection = this.theTable.getSelectedRows().length > 0;
        this.theActionManager.get("first").setEnabled(this.current_page_start > 0);
        this.theActionManager.get("pprevious").setEnabled(this.current_page_start > 0);
        this.theActionManager.get("previous").setEnabled(this.current_page_start > 0);
        if (this.ordered_entries != null) {
            this.theActionManager.get("next").setEnabled(this.current_page_start < this.ordered_entries.size() - 10);
            this.theActionManager.get("nnext").setEnabled(this.current_page_start < this.ordered_entries.size() - 10);
            this.theActionManager.get("last").setEnabled(this.current_page_start < this.ordered_entries.size() - 10);
        } else {
            this.theActionManager.get("next").setEnabled(false);
            this.theActionManager.get("nnext").setEnabled(false);
            this.theActionManager.get("last").setEnabled(false);
        }
        this.theActionManager.get("copy").setEnabled(has_selection);
        this.theActionManager.get("transfer").setEnabled(has_selection);
    }

    private JToolBar createToolBarNavigation() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("first"));
        toolbar.add((Action)this.theActionManager.get("pprevious"));
        toolbar.add((Action)this.theActionManager.get("previous"));
        toolbar.add((Action)this.theActionManager.get("next"));
        toolbar.add((Action)this.theActionManager.get("nnext"));
        toolbar.add((Action)this.theActionManager.get("last"));
        return toolbar;
    }

    private JToolBar createToolBarDocument() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add((Action)this.theActionManager.get("print"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("copy"));
        toolbar.add((Action)this.theActionManager.get("transfer"));
        toolbar.addSeparator();
        toolbar.add((Action)this.theActionManager.get("goto"));
        toolbar.add((Action)this.theActionManager.get("search"));
        toolbar.add((Action)this.theActionManager.get("searchagain"));
        toolbar.add((Action)this.theActionManager.get("clearsearch"));
        return toolbar;
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add((Action)this.theActionManager.get("copy"));
        menu.add((Action)this.theActionManager.get("transfer"));
        return menu;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Glycan.class;
        }
        if (columnIndex == 1) {
            return String.class;
        }
        if (columnIndex == 2) {
            return String.class;
        }
        if (columnIndex == 3) {
            return String.class;
        }
        if (columnIndex == 4) {
            return Double.class;
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Structure";
        }
        if (columnIndex == 1) {
            return "Type";
        }
        if (columnIndex == 2) {
            return "Source";
        }
        if (columnIndex == 3) {
            return "Database";
        }
        if (columnIndex == 4) {
            return "m/z";
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this.ordered_entries == null) {
            return 0;
        }
        return Math.min(10, this.ordered_entries.size() - this.current_page_start);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.shown_entries.get((int)rowIndex).structure;
        }
        if (columnIndex == 1) {
            return this.shown_entries.get((int)rowIndex).type;
        }
        if (columnIndex == 2) {
            return this.shown_entries.get((int)rowIndex).source;
        }
        if (columnIndex == 2) {
            return this.shown_entries.get((int)rowIndex).database;
        }
        if (columnIndex == 4) {
            return this.shown_entries.get((int)rowIndex).mz_ratio;
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    @Override
    public void updateData() {
        this.ordered_entries = new Vector();
        try {
            if (this.entries != null) {
                for (StructureType st : this.entries) {
                    DictionaryEntry de = new DictionaryEntry(st);
                    de.structure = null;
                    this.ordered_entries.add(de);
                }
                Collections.sort(this.ordered_entries, new Comparator<DictionaryEntry>(){

                    @Override
                    public int compare(DictionaryEntry a, DictionaryEntry b) {
                        if (a.mz_ratio < b.mz_ratio) {
                            return -1;
                        }
                        if (a.mz_ratio > b.mz_ratio) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.ordered_entries.clear();
        }
        System.out.println(this.ordered_entries.size());
        this.current_page_start = Math.max(0, Math.min(this.current_page_start, this.ordered_entries.size() - this.ordered_entries.size() % 10));
    }

    public void updateShownEntries() {
        this.shown_entries = new Vector();
        try {
            for (int i = this.current_page_start; i < this.current_page_start + 10 && i < this.ordered_entries.size(); ++i) {
                this.shown_entries.add(new DictionaryEntry(this.ordered_entries.get((int)i).generator));
            }
        }
        catch (Exception e) {
            LogUtils.report((Exception)e);
            this.shown_entries.clear();
        }
    }

    public void updateSlider() {
        if (this.theDictionarySlider != null) {
            this.ignore_slider = true;
            if (this.ordered_entries == null) {
                this.theDictionarySlider.setMinimum(0);
                this.theDictionarySlider.setMaximum(1);
                this.theDictionarySlider.setValue(0);
            } else {
                this.theDictionarySlider.setMinimum(0);
                this.theDictionarySlider.setMaximum(this.ordered_entries.size() / 10);
                this.theDictionarySlider.setValue(this.current_page_start / 10);
            }
            this.ignore_slider = false;
        }
    }

    public void updateStatus() {
        if (this.theDictionaryStatus != null) {
            String title = this.current_page_start + "/" + this.ordered_entries.size();
            this.theDictionaryStatus.setText(title);
        }
    }

    @Override
    public void updateView() {
        this.updateSlider();
        this.updateStatus();
        this.updateShownEntries();
        this.fireTableChanged();
    }

    public void updateMasses() {
        this.updateData();
        this.updateActions();
        this.updateView();
    }

    public void showFirst() {
        if (this.current_page_start > 0) {
            this.current_page_start = 0;
            this.updateActions();
            this.updateView();
        }
    }

    public void showFiveBefore() {
        if (this.current_page_start > 0) {
            this.current_page_start = Math.max(0, this.current_page_start - 50);
            this.updateActions();
            this.updateView();
        }
    }

    public void showPrevious() {
        if (this.current_page_start > 0) {
            this.current_page_start = Math.max(0, this.current_page_start - 10);
            this.updateActions();
            this.updateView();
        }
    }

    public void showNext() {
        if (this.current_page_start < this.ordered_entries.size() - 10) {
            this.current_page_start += 10;
            this.updateActions();
            this.updateView();
        }
    }

    public void showFiveAfter() {
        if (this.current_page_start < this.ordered_entries.size() - 10) {
            this.current_page_start = Math.min(this.current_page_start + 50, this.ordered_entries.size() - this.ordered_entries.size() % 10);
            this.updateActions();
            this.updateView();
        }
    }

    public void showLast() {
        if (this.current_page_start < this.ordered_entries.size() - 10) {
            this.current_page_start = this.ordered_entries.size() - this.ordered_entries.size() % 10;
            this.updateActions();
            this.updateView();
        }
    }

    public void onPrint() {
        this.theTable.print(this.theWorkspace.getPrinterJob(), null);
    }

    public void copy() {
        Vector<Glycan> structures = new Vector<Glycan>();
        Vector<StructureType> structure_types = new Vector<StructureType>();
        for (int sel_ind : this.theTable.getSelectedRows()) {
            structures.add(this.shown_entries.get((int)sel_ind).structure);
            structure_types.add(this.shown_entries.get((int)sel_ind).generator);
        }
        if (structures.size() > 0) {
            ClipUtils.setContents((Transferable)((Object)new DictionarySelection(this.theTable.getSelectedData(), structure_types, (GlycanRendererAWT)this.theWorkspace.getGlycanRenderer(), structures)));
        }
    }

    public void transfer() {
        GlycanCanvas theCanvas = this.theApplication.getCanvas();
        this.copy();
        theCanvas.resetSelection();
        theCanvas.paste();
    }

    public void goToMZ() {
        String mz_str = JOptionPane.showInputDialog(this, (Object)"Insert m/z value");
        if (mz_str != null) {
            int i;
            Double mz_ratio = Double.valueOf(mz_str);
            for (i = 10; i < this.ordered_entries.size() && mz_ratio > this.ordered_entries.get((int)i).mz_ratio; i += 10) {
            }
            this.current_page_start = Math.max(0, i - 10);
            this.updateActions();
            this.updateView();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.ignore_slider) {
            this.current_page_start = this.theDictionarySlider.getValue() * 10;
            this.updateActions();
            this.updateView();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals("first")) {
            this.showFirst();
        } else if (action.equals("pprevious")) {
            this.showFiveBefore();
        } else if (action.equals("previous")) {
            this.showPrevious();
        } else if (action.equals("next")) {
            this.showNext();
        } else if (action.equals("nnext")) {
            this.showFiveAfter();
        } else if (action.equals("last")) {
            this.showLast();
        } else if (action.equals("print")) {
            this.onPrint();
        } else if (action.equals("copy")) {
            this.copy();
        } else if (action.equals("transfer")) {
            this.transfer();
        } else if (action.equals("search")) {
            try {
                ((ProfilerPlugin)this.theDocument).search(null, null, false);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        } else if (action.equals("searchagain")) {
            try {
                ((ProfilerPlugin)this.theDocument).search(null, null, true);
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        } else if (action.equals("clearsearch")) {
            this.setData(new Vector<StructureType>());
        } else if (action.equals("goto")) {
            this.goToMZ();
        }
        this.updateActions();
    }

    private class DictionaryEntry {
        public Glycan structure;
        public String type;
        public String source;
        public String database;
        public Double mz_ratio;
        public StructureType generator;

        public DictionaryEntry(StructureType src) throws Exception {
            this.structure = src.generateStructure(DictionariesSearchPanel.this.theWorkspace.getDefaultMassOptions());
            this.type = src.getType();
            this.source = src.getSource();
            this.database = src.getDatabase();
            this.mz_ratio = this.structure.computeMZ();
            this.generator = src;
        }
    }
}

