/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.wizard.analyte.pages;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.grits.toolbox.core.dataShare.PropertyHandler;
import org.grits.toolbox.core.datamodel.Entry;
import org.grits.toolbox.core.datamodel.dialog.ProjectExplorerDialog;
import org.grits.toolbox.core.utilShare.ListenerFactory;
import org.grits.toolbox.entry.sample.wizard.analyte.pages.NewAnalytePageTwo;

public class NewAnalytePageOne
extends WizardPage {
    private static final String PAGE_NAME = "NewAnalytePage";
    protected final Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
    private Label projectNameLabel = null;
    private Text projectNameText = null;
    private Entry projectEntry = null;
    private Label nameLabel = null;
    private Text nameText = null;
    private Label descriptionLabel = null;
    private Text descriptionText = null;
    private Composite container = null;

    public NewAnalytePageOne() {
        super(PAGE_NAME);
        this.setTitle("New Analyte");
        this.setDescription("Create a new Analyte");
    }

    public Entry getProjectEntry() {
        return this.projectEntry;
    }

    public String getName() {
        return this.nameText.getText();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        this.container.setLayout((Layout)gridLayout);
        GridData projectNameData = new GridData();
        this.projectNameLabel = new Label(this.container, 0);
        this.projectNameLabel.setText("Project");
        this.projectNameLabel = this.setMandatoryLabel(this.projectNameLabel);
        this.projectNameLabel.setLayoutData((Object)projectNameData);
        GridData projectnameTextData = new GridData();
        projectnameTextData.grabExcessHorizontalSpace = true;
        projectnameTextData.horizontalAlignment = 4;
        projectnameTextData.horizontalSpan = 2;
        this.projectNameText = new Text(this.container, 2048);
        this.projectNameText.setLayoutData((Object)projectnameTextData);
        if (this.projectEntry != null) {
            this.projectNameText.setText(this.projectEntry.getDisplayName());
        }
        this.projectNameText.setEditable(false);
        GridData browseButtonData = new GridData();
        Button button = new Button(this.container, 8);
        button.setText("Browse");
        button.setLayoutData((Object)browseButtonData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Entry selected;
                Shell newShell = new Shell(NewAnalytePageOne.this.getWizard().getContainer().getShell(), 0x10008000);
                newShell.setLayout((Layout)new GridLayout());
                ProjectExplorerDialog dlg = new ProjectExplorerDialog(newShell);
                dlg.addFilter("org.grits.toolbox.property.project");
                dlg.setTitle("Project Selection");
                dlg.setMessage("Choose a project");
                if (dlg.open() == 0 && (selected = dlg.getEntry()) != null) {
                    NewAnalytePageOne.this.projectEntry = selected;
                    NewAnalytePageOne.this.projectNameText.setText(NewAnalytePageOne.this.projectEntry.getDisplayName());
                    boolean valid = NewAnalytePageOne.this.isValidInput();
                    NewAnalytePageOne.this.setPageComplete(valid);
                    if (valid) {
                        NewAnalytePageTwo nextPage = (NewAnalytePageTwo)NewAnalytePageOne.this.getWizard().getNextPage((IWizardPage)NewAnalytePageOne.this);
                        nextPage.setOldName(NewAnalytePageOne.this.nameText.getText());
                    }
                }
            }
        });
        this.createSeparator(this.container, 4);
        GridData nameData = new GridData();
        this.nameLabel = new Label(this.container, 16384);
        this.nameLabel.setText("Name");
        this.nameLabel = this.setMandatoryLabel(this.nameLabel);
        this.nameLabel.setLayoutData((Object)nameData);
        GridData nameTextData = new GridData();
        nameTextData.grabExcessHorizontalSpace = true;
        nameTextData.horizontalAlignment = 4;
        nameTextData.horizontalSpan = 3;
        this.nameText = new Text(this.container, 2048);
        this.nameText.setLayoutData((Object)nameTextData);
        this.nameText.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    NewAnalytePageOne.this.setPageComplete(true);
                }
            }
        });
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = NewAnalytePageOne.this.isValidInput();
                NewAnalytePageOne.this.setPageComplete(valid);
                if (valid) {
                    NewAnalytePageTwo nextPage = (NewAnalytePageTwo)NewAnalytePageOne.this.getWizard().getNextPage((IWizardPage)NewAnalytePageOne.this);
                    nextPage.setOldName(NewAnalytePageOne.this.nameText.getText());
                }
            }
        });
        GridData descriptionData = new GridData();
        this.descriptionLabel = new Label(this.container, 16384);
        this.descriptionLabel.setText("Description");
        this.descriptionLabel.setLayoutData((Object)descriptionData);
        GridData descriptionTextData = new GridData();
        descriptionTextData.minimumHeight = 80;
        descriptionTextData.grabExcessHorizontalSpace = true;
        descriptionTextData.grabExcessVerticalSpace = true;
        descriptionTextData.horizontalAlignment = 4;
        descriptionTextData.horizontalSpan = 3;
        this.descriptionText = new Text(this.container, 2562);
        this.descriptionText.setLayoutData((Object)descriptionTextData);
        this.descriptionText.addTraverseListener(ListenerFactory.getTabTraverseListener());
        this.descriptionText.addKeyListener(ListenerFactory.getCTRLAListener());
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.nameText.setFocus();
    }

    private Label createSeparator(Composite parent, int span) {
        GridData separatorData = new GridData();
        separatorData.grabExcessHorizontalSpace = true;
        separatorData.horizontalAlignment = 4;
        separatorData.horizontalSpan = span;
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)separatorData);
        return separator;
    }

    private Label setMandatoryLabel(Label label) {
        label.setText(String.valueOf(label.getText()) + "*");
        label.setFont(this.boldFont);
        return label;
    }

    private boolean isValidInput() {
        if (!this.checkBasicLengthCheck(this.projectNameLabel, this.projectNameText, 0, 32)) {
            return false;
        }
        if (!this.checkBasicLengthCheck(this.nameLabel, this.nameText, 0, 80)) {
            return false;
        }
        if (this.findSameNameEntry(this.nameText.getText().trim(), this.projectEntry, "org.grits.toolbox.property.sample")) {
            this.setError(this.nameLabel, "Same name exists for another Analyte. Please use a different name.");
            return false;
        }
        this.removeError(this.nameLabel);
        return this.checkBasicLengthCheck(this.descriptionLabel, this.descriptionText, 0, Integer.parseInt(PropertyHandler.getVariable((String)"descriptionLength")));
    }

    protected boolean checkBasicLengthCheck(Label targetLabel, Text targetText, int min, int max) {
        if (targetLabel.getFont().equals((Object)this.boldFont) && targetText.getText().length() == min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be empty. Please provide a name.");
            return false;
        }
        if (targetText.getText().length() > max || targetText.getText().length() < min) {
            this.setError(targetLabel, String.valueOf(targetLabel.getText()) + " cannot be longer than " + max + " characters");
            return false;
        }
        this.removeError(targetLabel);
        return true;
    }

    protected void setError(Label targetLabel, String string) {
        this.setErrorMessage(string);
        targetLabel.setForeground(Display.getCurrent().getSystemColor(3));
    }

    protected boolean findSameNameEntry(String _entryName, Entry parent, String type) {
        if (parent != null) {
            List children = parent.getChildren();
            for (Entry child : children) {
                if (!child.getProperty().getType().equals(type) || !child.getDisplayName().equals(_entryName)) continue;
                return true;
            }
        }
        return false;
    }

    protected void removeError(Label targetLabel) {
        targetLabel.setForeground(Display.getCurrent().getSystemColor(2));
        this.setErrorMessage(null);
    }

    public void setProjectEntry(Entry projectEntry) {
        this.projectEntry = projectEntry;
    }
}

