/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.part.providers;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.grits.toolbox.entry.sample.model.Descriptor;
import org.grits.toolbox.entry.sample.model.DescriptorGroup;

public class DescriptorColumnLabelProvider
extends ColumnLabelProvider {
    private Font boldFont = null;

    public String getToolTipText(Object obj) {
        String toolTipText = "";
        if (obj instanceof Descriptor) {
            Descriptor desc = (Descriptor)obj;
            toolTipText = String.valueOf(toolTipText) + desc.getLabel() + " \n\n     ";
            if (desc.getDescription() != null) {
                toolTipText = String.valueOf(toolTipText) + desc.getDescription() + " \n\n     ";
            }
        } else if (obj instanceof DescriptorGroup) {
            DescriptorGroup dg = (DescriptorGroup)obj;
            toolTipText = String.valueOf(toolTipText) + dg.getLabel() + " \n\n     ";
            if (dg.getDescription() != null) {
                toolTipText = String.valueOf(toolTipText) + dg.getDescription() + " \n\n     ";
            }
        }
        return toolTipText;
    }

    public Image getToolTipImage(Object obj) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof DescriptorGroup) {
            return ((DescriptorGroup)element).getLabel();
        }
        if (element instanceof Descriptor) {
            return ((Descriptor)element).getLabel();
        }
        return null;
    }

    public Font getFont(Object element) {
        Font font = null;
        if (element instanceof DescriptorGroup) {
            if (this.boldFont == null) {
                Font currentFont = Display.getCurrent().getSystemFont();
                FontData fontData = currentFont.getFontData()[0];
                this.boldFont = new Font((Device)Display.getCurrent(), fontData.getName(), fontData.getHeight(), 1);
            }
            font = this.boldFont;
        }
        return font;
    }

    public void dispose() {
        if (this.boldFont != null && !this.boldFont.isDisposed()) {
            this.boldFont.dispose();
        }
        super.dispose();
    }
}

