/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.entry.sample.config;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ImageRegistry {
    private static Logger logger = Logger.getLogger(ImageRegistry.class);
    private static final String IMAGE_PATH = "icons" + File.separator;
    private static Map<SampleImage, ImageDescriptor> imageCache = new HashMap<SampleImage, ImageDescriptor>();

    public static ImageDescriptor getImageDescriptor(SampleImage sampleImage) {
        logger.info((Object)("Get image from sample plugin : " + (Object)((Object)sampleImage)));
        ImageDescriptor imageDescriptor = null;
        if (sampleImage != null) {
            imageDescriptor = imageCache.get((Object)sampleImage);
            if (imageDescriptor == null) {
                logger.info((Object)"ImageDescriptor not found in cache");
                URL fullPathString = FileLocator.find((Bundle)Platform.getBundle((String)"org.grits.toolbox.entry.sample"), (IPath)new Path(String.valueOf(IMAGE_PATH) + sampleImage.iconName), null);
                logger.info((Object)("Loading image from url : " + fullPathString));
                if (fullPathString != null) {
                    imageDescriptor = ImageDescriptor.createFromURL((URL)fullPathString);
                    imageCache.put(sampleImage, imageDescriptor);
                }
            }
        } else {
            logger.error((Object)"Cannot load image from sample plugin (image name is null)");
        }
        return imageDescriptor;
    }

    public static enum SampleImage {
        SAMPLES_ICON("sampleGroup.png"),
        SAMPLE_ICON_SMALL("sampleIconSmall.png"),
        COMPONENT_ICON("sample16.png"),
        ADD_COMPONENT_LAUNCHER_ICON("test-tube2.png"),
        ADD_DESCRIPTOR_GROUP_ICON("chart_bar_add.png"),
        EDIT_DESCRIPTOR_ICON("pencil_icon.png"),
        CHECKBOX_TICKED_ICON("checkbox_ticked_icon.png"),
        CHECKBOX_OPTIONAL_TICKED_ICON("checkbox_optional_ticked_icon.png"),
        EDIT_NAME_ICON("rename.png"),
        CREATE_TEMPLATE_ICON("template_icon.png");

        private String iconName = null;

        private SampleImage(String iconName) {
            this.iconName = iconName;
        }
    }
}

