/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.configuration.internal;

import java.io.File;
import org.apache.commons.lang3.Validate;
import org.apache.maven.configuration.BeanConfigurationException;
import org.apache.maven.configuration.BeanConfigurationPathTranslator;
import org.apache.maven.configuration.BeanConfigurationRequest;
import org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import org.apache.maven.configuration.BeanConfigurator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=BeanConfigurator.class)
public class DefaultBeanConfigurator
implements BeanConfigurator {
    private final ConverterLookup converterLookup = new DefaultConverterLookup();

    @Override
    public void configureBean(BeanConfigurationRequest request) throws BeanConfigurationException {
        ClassLoader classLoader;
        PlexusConfiguration plexusConfig;
        Validate.notNull((Object)request, (String)"request cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)request.getBean(), (String)"request.bean cannot be null", (Object[])new Object[0]);
        Object configuration = request.getConfiguration();
        if (configuration == null) {
            return;
        }
        if (configuration instanceof PlexusConfiguration) {
            plexusConfig = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            plexusConfig = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            throw new BeanConfigurationException("unsupported bean configuration source (" + configuration.getClass().getName() + ")");
        }
        if (request.getConfigurationElement() != null) {
            plexusConfig = plexusConfig.getChild(request.getConfigurationElement());
        }
        if ((classLoader = request.getClassLoader()) == null) {
            classLoader = request.getBean().getClass().getClassLoader();
        }
        BeanExpressionEvaluator evaluator = new BeanExpressionEvaluator(request);
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        try {
            converter.processConfiguration(this.converterLookup, request.getBean(), classLoader, plexusConfig, (ExpressionEvaluator)evaluator);
        }
        catch (ComponentConfigurationException e) {
            throw new BeanConfigurationException(e.getMessage(), e);
        }
    }

    static class BeanExpressionEvaluator
    implements TypeAwareExpressionEvaluator {
        private final BeanConfigurationValuePreprocessor preprocessor;
        private final BeanConfigurationPathTranslator translator;

        BeanExpressionEvaluator(BeanConfigurationRequest request) {
            this.preprocessor = request.getValuePreprocessor();
            this.translator = request.getPathTranslator();
        }

        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            if (this.preprocessor != null) {
                try {
                    return this.preprocessor.preprocessValue(expression, type);
                }
                catch (BeanConfigurationException e) {
                    throw new ExpressionEvaluationException(e.getMessage(), (Throwable)e);
                }
            }
            return expression;
        }

        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        public File alignToBaseDirectory(File file) {
            if (this.translator != null) {
                return this.translator.translatePath(file);
            }
            return file;
        }
    }
}

