/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.structure.document;

import java.util.LinkedList;

public class StateManager {
    private static final int MAXIMUM_NUMBER_OF_STATES = 20;
    private int m_nActions;
    private int m_iCurState;
    private String m_strCurState;
    private LinkedList<String> m_lStates;

    public StateManager() {
        this.reset();
    }

    public void reset() {
        this.m_nActions = 0;
        this.m_iCurState = 0;
        this.m_strCurState = "";
        this.m_lStates = new LinkedList();
        this.m_lStates.add(this.m_strCurState);
    }

    public String getCurrentState() {
        return this.m_strCurState;
    }

    public void addState(String str) {
        if (str == null) {
            return;
        }
        this.m_strCurState = str;
        while (this.m_iCurState < this.m_lStates.size() - 1) {
            this.m_lStates.removeLast();
        }
        this.m_lStates.addLast(str);
        while (this.m_lStates.size() > 20) {
            this.m_lStates.removeFirst();
        }
        this.m_iCurState = this.m_lStates.size() - 1;
        ++this.m_nActions;
    }

    public boolean canUndo() {
        return this.m_iCurState > 0;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        --this.m_iCurState;
        this.m_strCurState = this.m_lStates.get(this.m_iCurState);
        --this.m_nActions;
    }

    public boolean canRedo() {
        return this.m_iCurState < this.m_lStates.size() - 1;
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ++this.m_iCurState;
        this.m_strCurState = this.m_lStates.get(this.m_iCurState);
        ++this.m_nActions;
    }

    public String toString() {
        String str = "[";
        str = String.valueOf(str) + " curStateNo=" + this.m_iCurState;
        str = String.valueOf(str) + " curState=" + this.m_strCurState;
        str = String.valueOf(str) + " nActions=" + this.m_nActions;
        str = String.valueOf(str) + " savedStates=" + this.m_lStates;
        str = String.valueOf(str) + " ]";
        return str;
    }
}

