/*
 * Decompiled with CFR 0.152.
 */
package org.grits.toolbox.tools.glycanbuilder.core.renderer.utils;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;

public class TextRendererUtils {
    public static Image getStyledTextImage(Device device, String text, String font_face, int font_size) {
        TextLayout layout = TextRendererUtils.createStyledTextLayout(device, text, font_face, font_size);
        Image img = new Image(device, layout.getBounds());
        GC gc = new GC((Drawable)img);
        gc.setBackground(device.getSystemColor(1));
        gc.setForeground(device.getSystemColor(2));
        layout.draw(gc, 0, 0);
        gc.dispose();
        return img;
    }

    public static Rectangle getStyledTextBounds(String text, String font_face, int font_size) {
        return TextRendererUtils.createStyledTextLayout((Device)Display.getCurrent(), text, font_face, font_size).getBounds();
    }

    private static TextLayout createStyledTextLayout(Device device, String text, String font_face, int font_size) {
        font_size = (int)((double)font_size / 0.75);
        TextLayout layout = new TextLayout(device);
        Font font = new Font(device, font_face, font_size, 1);
        layout.setFont(font);
        String text_new = "";
        ArrayList<int[]> lRanges = null;
        ArrayList<int[]> lSubs = new ArrayList<int[]>();
        ArrayList lSups = new ArrayList();
        int[] range = new int[2];
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '_' || c == '^') {
                lRanges = c == '_' ? lSubs : lSups;
            } else if (c == '{') {
                range[0] = text_new.length();
            } else if (c == '}') {
                range[1] = text_new.length() - 1;
                lRanges.add(range);
                range = new int[2];
            } else {
                text_new = String.valueOf(text_new) + c;
            }
            ++i;
        }
        layout.setText(text_new);
        Font subFont = new Font(device, font_face, font_size, 0);
        TextStyle style = new TextStyle(subFont, null, null);
        style.rise = -font_size / 2;
        for (int[] rangeSub : lSubs) {
            layout.setStyle(style, rangeSub[0], rangeSub[1]);
        }
        style = new TextStyle(subFont, null, null);
        style.rise += font_size / 2;
        for (int[] rangeSup : lSups) {
            layout.setStyle(style, rangeSup[0], rangeSup[1]);
        }
        return layout;
    }
}

