/*
 * Decompiled with CFR 0.152.
 */
package org.glycoinfo.GlycanFormatconverter.io.LinearCode;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinearCodeStacker {
    private String baseUnit;
    private String linearCodeSU;
    private String annotation;
    private String anomericStatus;
    private String parentLinkage;
    private String substituents;

    public LinearCodeStacker(String _linearCodeSU) {
        Matcher linMat;
        this.baseUnit = _linearCodeSU;
        Matcher monoMat = Pattern.compile("([A-Z]+)+(~|\\^|')?(\\[(.+)+])?").matcher(_linearCodeSU);
        if (monoMat.find()) {
            this.linearCodeSU = monoMat.group(1);
            this.annotation = monoMat.group(2);
            this.substituents = monoMat.group(4);
        }
        if ((linMat = Pattern.compile("((?![A-Z])[ab?])([\\d?/]+)?").matcher(_linearCodeSU)).find()) {
            this.anomericStatus = linMat.group(1);
            this.parentLinkage = linMat.group(2);
        }
    }

    public String getBaseUnit() {
        return this.baseUnit;
    }

    public String getLinearCodeSU() {
        return this.linearCodeSU;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getAnomericStatus() {
        return this.anomericStatus;
    }

    public String getParentLinkage() {
        return this.parentLinkage;
    }

    public String getSubstituent() {
        return this.substituents;
    }
}

