/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class SourceLookupManager
implements IWindowListener {
    private static SourceLookupManager fgDefault;
    private Map<IWorkbenchWindow, SourceLookupService> fServices = new HashMap<IWorkbenchWindow, SourceLookupService>();

    private SourceLookupManager() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] workbenchWindows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < workbenchWindows.length) {
            IWorkbenchWindow window = workbenchWindows[i];
            this.windowOpened(window);
            ++i;
        }
        workbench.addWindowListener((IWindowListener)this);
    }

    public static SourceLookupManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new SourceLookupManager();
        }
        return fgDefault;
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        SourceLookupService service = this.fServices.get(window);
        if (service != null) {
            this.fServices.remove(window);
            service.dispose();
        }
    }

    public void windowOpened(IWorkbenchWindow window) {
        SourceLookupService service = this.fServices.get(window);
        if (service == null) {
            service = new SourceLookupService(window);
            this.fServices.put(window, service);
        }
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean forceSourceLookup) {
        IWorkbenchWindow window = page.getWorkbenchWindow();
        SourceLookupService service = this.fServices.get(window);
        if (service != null) {
            service.displaySource(context, page, forceSourceLookup);
        }
    }
}

