/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.resourcesdb.monosaccharide;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eurocarbdb.resourcesdb.Config;
import org.eurocarbdb.resourcesdb.ResourcesDbException;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbAnomer;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbBaseType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModification;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbModificationType;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbMonosaccharide;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.EcdbSuperclass;
import org.eurocarbdb.resourcesdb.glycoconjugate_derived.GlycoconjugateException;
import org.eurocarbdb.resourcesdb.monosaccharide.Anomer;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModification;
import org.eurocarbdb.resourcesdb.monosaccharide.CoreModificationTemplate;
import org.eurocarbdb.resourcesdb.monosaccharide.Monosaccharide;
import org.eurocarbdb.resourcesdb.monosaccharide.MonosaccharideException;
import org.eurocarbdb.resourcesdb.monosaccharide.StereoConfiguration;
import org.eurocarbdb.resourcesdb.monosaccharide.Stereocode;
import org.eurocarbdb.resourcesdb.template.TemplateContainer;

public class BasetypeConversion {
    private static HashMap<String, EcdbBaseType> eurocarbBasetypesByStereocodeMap = null;

    public static Monosaccharide eurcarbdbToMsdb(EcdbMonosaccharide eurocarbdbMs, Config conf, TemplateContainer container) throws ResourcesDbException {
        Monosaccharide msdbMs = new Monosaccharide(conf, container);
        BasetypeConversion.eurocarbdbToMsdb(eurocarbdbMs, msdbMs);
        return msdbMs;
    }

    public static void eurocarbdbToMsdb(EcdbMonosaccharide eurocarbdbMs, Monosaccharide msdbMs) throws ResourcesDbException {
        msdbMs.setSize(eurocarbdbMs.getSuperclass().getNumberOfC());
        int ringStart = eurocarbdbMs.getRingStart();
        if (ringStart == 0) {
            ringStart = -1;
        } else if (ringStart == -1) {
            ringStart = 0;
        }
        msdbMs.setRingStartNoAdjustment(ringStart);
        msdbMs.setDefaultCarbonylPosition(ringStart);
        int ringEnd = eurocarbdbMs.getRingEnd();
        if (ringEnd == 0) {
            ringEnd = -1;
        } else if (ringEnd == -1) {
            ringEnd = 0;
        }
        msdbMs.setRingEnd(ringEnd);
        msdbMs.setAnomer(BasetypeConversion.anomerEurocarbdbToMsdb(eurocarbdbMs.getAnomer()));
        BasetypeConversion.copyCoreModificationsFromEurocarbdbToMsdb(eurocarbdbMs, msdbMs);
        String stereo = BasetypeConversion.getStereocodeFromBasetypeList(eurocarbdbMs.getBaseTypeList());
        if (stereo.length() > 0) {
            stereo = Stereocode.expandChiralonlyStereoString(stereo, msdbMs);
        } else {
            stereo = Stereocode.getSuperclassStereostring(msdbMs.getSize());
            stereo = Stereocode.markNonchiralPositionsInStereoString(stereo, msdbMs);
        }
        msdbMs.setStereoStr(stereo);
        msdbMs.setAnomerInStereocode();
    }

    public static EcdbMonosaccharide msdbToEurocarbdb(Monosaccharide msdbMs) throws GlycoconjugateException {
        EcdbMonosaccharide eurocarbdbMs = new EcdbMonosaccharide(BasetypeConversion.anomerMsdbToEurocarbdb(msdbMs.getAnomer()), EcdbSuperclass.forCAtoms(msdbMs.getSize()));
        int ringStart = msdbMs.getRingStart();
        if (ringStart == -1) {
            ringStart = 0;
        } else if (ringStart == 0) {
            ringStart = -1;
        }
        int ringEnd = msdbMs.getRingEnd();
        if (ringEnd == -1) {
            ringEnd = 0;
        } else if (ringEnd == 0) {
            ringEnd = -1;
        }
        if (ringEnd == -1) {
            ringStart = -1;
        }
        if (ringEnd == 0) {
            ringStart = 0;
        }
        eurocarbdbMs.setRing(ringStart, ringEnd);
        ArrayList<EcdbBaseType> basetypeList = BasetypeConversion.getEurocarbdbMsBasetypesFromMsdbMonosaccharide(msdbMs);
        Iterator<Object> iter = basetypeList.iterator();
        while (iter.hasNext()) {
            eurocarbdbMs.addBaseType(iter.next());
        }
        for (CoreModification msdbMod : msdbMs.getCoreModifications()) {
            if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.ANHYDRO) || msdbMod.getTemplate().equals((Object)CoreModificationTemplate.LACTONE) || msdbMod.getTemplate().equals((Object)CoreModificationTemplate.EPOXY)) continue;
            eurocarbdbMs.addModification(BasetypeConversion.ModificationMsdbToEurocarbdb(msdbMod));
        }
        return eurocarbdbMs;
    }

    public static EcdbAnomer anomerMsdbToEurocarbdb(Anomer anom) {
        if (Anomer.ALPHA.equals((Object)anom)) {
            return EcdbAnomer.Alpha;
        }
        if (Anomer.BETA.equals((Object)anom)) {
            return EcdbAnomer.Beta;
        }
        if (Anomer.OPEN_CHAIN.equals((Object)anom) || Anomer.NONE.equals((Object)anom)) {
            return EcdbAnomer.OpenChain;
        }
        return EcdbAnomer.Unknown;
    }

    public static Anomer anomerEurocarbdbToMsdb(EcdbAnomer anom) {
        if (anom.equals((Object)EcdbAnomer.Alpha)) {
            return Anomer.ALPHA;
        }
        if (anom.equals((Object)EcdbAnomer.Beta)) {
            return Anomer.BETA;
        }
        if (anom.equals((Object)EcdbAnomer.OpenChain)) {
            return Anomer.OPEN_CHAIN;
        }
        return Anomer.UNKNOWN;
    }

    private static void fillEurocarbBasetypeByStereocodeMap() {
        eurocarbBasetypesByStereocodeMap = new HashMap();
        for (EcdbBaseType bt : EcdbBaseType.values()) {
            eurocarbBasetypesByStereocodeMap.put(bt.getStereo(), bt);
        }
    }

    private static EcdbBaseType getEurocarbBasetypeByStereoString(String stereo) throws ResourcesDbException {
        EcdbBaseType base = null;
        if (Stereocode.stereoStringHasRelativePosition(stereo)) {
            if (Stereocode.stereoStringContainsAbsoluteAndRelative(stereo)) {
                throw new MonosaccharideException("Cannot get EurocarbDB basetype from a stereocode string that contains both absolute and relative configurations: " + stereo);
            }
            return BasetypeConversion.getEuroCarbBasetypeByRelativeStereostring(stereo);
        }
        base = eurocarbBasetypesByStereocodeMap.get(stereo);
        if (base == null) {
            throw new ResourcesDbException("Cannot get EurocarbDB basetype from stereocode string " + stereo);
        }
        return base;
    }

    private static EcdbBaseType getEuroCarbBasetypeByRelativeStereostring(String rStereo) throws ResourcesDbException {
        String aStereo = Stereocode.relativeToAbsolute(rStereo);
        EcdbBaseType aBase = BasetypeConversion.getEurocarbBasetypeByStereoString(aStereo);
        try {
            EcdbBaseType rBase = EcdbBaseType.forName("x" + aBase.getName().substring(1));
            return rBase;
        }
        catch (GlycoconjugateException ge) {
            ResourcesDbException me = new ResourcesDbException("Cannot get EurocarbDB basetype from stereocode string " + rStereo);
            me.initCause(ge);
            throw me;
        }
    }

    public static ArrayList<EcdbBaseType> getEurocarbdbMsBasetypesFromMsdbMonosaccharide(Monosaccharide msdbMs) throws GlycoconjugateException {
        if (eurocarbBasetypesByStereocodeMap == null) {
            BasetypeConversion.fillEurocarbBasetypeByStereocodeMap();
        }
        ArrayList<EcdbBaseType> basetypeList = new ArrayList<EcdbBaseType>();
        try {
            String stereo = msdbMs.getStereoStr();
            if (msdbMs.getRingStart() > 1) {
                stereo = Stereocode.setPositionInStereoString(stereo, StereoConfiguration.Nonchiral.getStereosymbol(), msdbMs.getRingStart());
            }
            stereo = stereo.substring(1);
            if (!(stereo = stereo.replaceAll("" + StereoConfiguration.Nonchiral.getStereosymbol(), "")).replaceAll("" + StereoConfiguration.Unknown.getStereosymbol(), "").equals("")) {
                if (stereo.contains("" + StereoConfiguration.Unknown.getStereosymbol())) {
                    throw new ResourcesDbException("MonosaccharideDB stereocode contains unknown configurations - cannot generate basetype list for EuroCarbDB monosaccharide from that.");
                }
                while (stereo.length() > 0) {
                    if (stereo.length() > 4) {
                        basetypeList.add(0, BasetypeConversion.getEurocarbBasetypeByStereoString(stereo.substring(0, 4)));
                        stereo = stereo.substring(4);
                        continue;
                    }
                    basetypeList.add(0, BasetypeConversion.getEurocarbBasetypeByStereoString(stereo));
                    stereo = "";
                }
            }
        }
        catch (ResourcesDbException me) {
            throw new GlycoconjugateException("Error in translating stereocode to basetype list: " + me.getMessage());
        }
        return basetypeList;
    }

    public static String getStereocodeFromBasetypeList(ArrayList<EcdbBaseType> basetypeList) throws ResourcesDbException {
        String stereo = "";
        for (EcdbBaseType basetype : basetypeList) {
            String tmpStereo = basetype.getStereo();
            if (tmpStereo.contains("*")) {
                String basename = basetype.getName();
                try {
                    basetype = EcdbBaseType.forName("d" + basename.substring(1));
                    tmpStereo = Stereocode.absoluteToRelative(basetype.getStereo());
                }
                catch (GlycoconjugateException ge) {
                    ResourcesDbException me = new ResourcesDbException("GetStereocodeFromBasetypeList: Cannot get absolute equivalent for relative basetype " + basename + " (d" + basename.substring(1) + ")");
                    me.initCause(ge);
                    throw me;
                }
            }
            stereo = tmpStereo + stereo;
        }
        return stereo;
    }

    public static void copyCoreModificationsFromEurocarbdbToMsdb(EcdbMonosaccharide eurocarbdbMs, Monosaccharide msdbMs) throws ResourcesDbException {
        ArrayList<EcdbModification> eurocarbdbModificationList = eurocarbdbMs.getModificationList();
        for (EcdbModification eurocarbMod : eurocarbdbModificationList) {
            if (eurocarbMod.getName().equals(EcdbModificationType.ALDI.getName())) {
                if (eurocarbMod.getPositionOne() != 1) {
                    throw new ResourcesDbException("Alditol position other than one in EuroCarbDB monosaccharide");
                }
                msdbMs.setAlditol(true);
                continue;
            }
            CoreModification msdbCoremod = BasetypeConversion.ModificationEurocarbdbToMsdb(eurocarbMod);
            if (msdbCoremod.getTemplate().equals((Object)CoreModificationTemplate.KETO) && msdbMs.getDefaultCarbonylPosition() == 0) {
                msdbMs.setDefaultCarbonylPosition(msdbCoremod.getPosition1().get(0));
            }
            msdbMs.addCoreModification(msdbCoremod);
        }
    }

    public static CoreModification ModificationEurocarbdbToMsdb(EcdbModification eurocarbdbMod) throws MonosaccharideException {
        CoreModification msdbMod = new CoreModification();
        if (eurocarbdbMod.getName().equals(EcdbModificationType.DEOXY.getName())) {
            msdbMod.setModification(CoreModificationTemplate.DEOXY, eurocarbdbMod.getPositionOne());
        } else if (eurocarbdbMod.getName().equals(EcdbModificationType.ACID.getName())) {
            msdbMod.setModification(CoreModificationTemplate.ACID, eurocarbdbMod.getPositionOne());
        } else if (eurocarbdbMod.getName().equals(EcdbModificationType.KETO.getName())) {
            msdbMod.setModification(CoreModificationTemplate.KETO, eurocarbdbMod.getPositionOne());
        } else if (eurocarbdbMod.getName().equals(EcdbModificationType.DOUBLEBOND.getName())) {
            msdbMod.setDivalentModification(CoreModificationTemplate.EN, eurocarbdbMod.getPositionOne(), eurocarbdbMod.getPositionOne() + 1);
        } else if (eurocarbdbMod.getName().equals(EcdbModificationType.UNKNOWN_BOUBLEBOND.getName())) {
            msdbMod.setDivalentModification(CoreModificationTemplate.ENX, eurocarbdbMod.getPositionOne(), eurocarbdbMod.getPositionOne() + 1);
        } else if (eurocarbdbMod.getName().equals(EcdbModificationType.SP2_HYBRID.getName())) {
            msdbMod.setModification(CoreModificationTemplate.SP2, eurocarbdbMod.getPositionOne());
        } else {
            if (eurocarbdbMod.getName().equals(EcdbModificationType.GEMINAL.getName())) {
                throw new MonosaccharideException("Geminal residues not yet supported.");
            }
            if (eurocarbdbMod.getName().equals(EcdbModificationType.ANHYDRO.getName())) {
                msdbMod.setDivalentModification(CoreModificationTemplate.ANHYDRO, eurocarbdbMod.getPositionOne(), eurocarbdbMod.getPositionTwo());
            } else {
                throw new MonosaccharideException("cannot convert eurocarbdb core modification " + eurocarbdbMod.getName());
            }
        }
        return msdbMod;
    }

    public static EcdbModification ModificationMsdbToEurocarbdb(CoreModification msdbMod) throws GlycoconjugateException {
        EcdbModification eurocarbdbMod = null;
        if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.DEOXY)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.DEOXY.getName(), (Integer)msdbMod.getIntValuePosition1());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.EN)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.DOUBLEBOND.getName(), (Integer)msdbMod.getIntValuePosition1(), (Integer)msdbMod.getIntValuePosition2());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.ENX)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.UNKNOWN_BOUBLEBOND.getName(), (Integer)msdbMod.getIntValuePosition1(), (Integer)msdbMod.getIntValuePosition2());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.ACID)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.ACID.getName(), (Integer)msdbMod.getIntValuePosition1());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.KETO)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.KETO.getName(), (Integer)msdbMod.getIntValuePosition1());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.SP2)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.SP2_HYBRID.getName(), (Integer)msdbMod.getIntValuePosition1());
        } else if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.ALDITOL)) {
            eurocarbdbMod = new EcdbModification(EcdbModificationType.ALDI.getName(), (Integer)msdbMod.getIntValuePosition1());
        } else {
            if (msdbMod.getTemplate().equals((Object)CoreModificationTemplate.YN)) {
                throw new GlycoconjugateException("Core modification 'Yn' not defined for EuroCarbDB monosaccharides.");
            }
            throw new GlycoconjugateException("Unknown msdb core modification: " + msdbMod.getName());
        }
        return eurocarbdbMod;
    }
}

