/*
 * Decompiled with CFR 0.152.
 */
package org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine;

import java.util.Vector;
import org.eurocarbdb.MolecularFramework.sugar.GlycoEdge;
import org.eurocarbdb.MolecularFramework.sugar.GlycoNode;
import org.eurocarbdb.MolecularFramework.sugar.GlycoconjugateException;
import org.eurocarbdb.MolecularFramework.sugar.Sugar;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.EdgeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.MatrixDataObject;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.NodeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchEngineException;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SearchVisitor;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.SimpleGetNameVisitor;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardEdgeComparator;
import org.eurocarbdb.MolecularFramework.util.similiarity.SearchEngine.StandardNodeComparator;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorCountNodeType;
import org.eurocarbdb.MolecularFramework.util.visitor.GlycoVisitorException;

public class SearchEngine {
    private Vector<MatrixDataObject> v_query = new Vector();
    private Vector<MatrixDataObject> v_queried = new Vector();
    private Boolean OnlyReducingEnd = false;
    private NodeComparator NodeComparator = new StandardNodeComparator();
    private EdgeComparator EdgeComparator = new StandardEdgeComparator();
    private Sugar queried = null;
    private Sugar query = null;
    Sugar result = new Sugar();
    private int[][] m_aMatrix;
    private int score = 0;
    private MatrixDataObject queryMax = new MatrixDataObject();
    private MatrixDataObject queriedMax = new MatrixDataObject();

    public void setQueriedStructure(Sugar queriedStructure) {
        this.queried = queriedStructure;
    }

    public void setQueryStructure(Sugar queryStructure) throws GlycoVisitorException {
        GlycoVisitorCountNodeType gvnt = new GlycoVisitorCountNodeType();
        gvnt.start(queryStructure);
        if (gvnt.getRepeatCount() > 0) {
            throw new GlycoVisitorException("No Repeats as queries. Expand Repeat query!");
        }
        this.query = queryStructure;
    }

    public void setNodeComparator(NodeComparator NodeComparator2) {
        this.NodeComparator = NodeComparator2;
    }

    public void setEdgeComparator(EdgeComparator EdgeComparator2) {
        this.EdgeComparator = EdgeComparator2;
    }

    public Boolean isExactMatch() throws SearchEngineException {
        try {
            this.match();
        }
        catch (GlycoVisitorException e2) {
            e2.printStackTrace();
        }
        catch (GlycoconjugateException e2) {
            e2.printStackTrace();
        }
        catch (SearchEngineException e2) {
            e2.printStackTrace();
        }
        GlycoVisitorCountNodeType g_count = new GlycoVisitorCountNodeType();
        try {
            g_count.start(this.query);
        }
        catch (GlycoVisitorException e) {
            e.printStackTrace();
        }
        Integer count = g_count.getMonosaccharideCount() + g_count.getNonMonosaccharideCount() + g_count.getSubstituentCount() + g_count.getUnvalidatedNodeCount();
        if (this.getMax().equals(count)) {
            return true;
        }
        return false;
    }

    public Integer getScore() {
        return this.getMax();
    }

    public float getResultSize() {
        return (float)this.v_query.size() / (float)this.v_queried.size();
    }

    public void restrictToReducingEnds() {
        this.OnlyReducingEnd = true;
    }

    public void match() throws GlycoVisitorException, GlycoconjugateException, SearchEngineException {
        if (this.queried == null || this.query == null) {
            throw new SearchEngineException("You forgot to add sugars");
        }
        SearchVisitor sv = new SearchVisitor();
        sv.start(this.queried);
        this.v_queried = sv.getVector();
        SearchVisitor sv1 = new SearchVisitor();
        sv1.start(this.query);
        this.v_query = sv1.getVector();
        this.m_aMatrix = new int[this.v_queried.size()][this.v_query.size()];
        for (int i = 0; i < this.v_queried.size(); ++i) {
            for (int q = 0; q < this.v_query.size(); ++q) {
                this.score = 0;
                for (MatrixDataObject mdo : this.v_queried) {
                    mdo.visited = false;
                }
                for (MatrixDataObject mdo : this.v_query) {
                    mdo.visited = false;
                }
                this.m_aMatrix[i][q] = this.recursive(this.v_queried.get(i), this.v_query.get(q));
            }
        }
    }

    private int recursive(MatrixDataObject MDO_queried, MatrixDataObject MDO_query) throws GlycoconjugateException {
        GlycoNode queryNode;
        GlycoNode queriedNode = MDO_queried.getNode();
        if (this.NodeComparator.compare(queriedNode, queryNode = MDO_query.getNode()) == 0) {
            ++this.score;
            for (GlycoEdge t_childEdge_queried : MDO_queried.getChildren()) {
                for (GlycoEdge t_childEdge_query : MDO_query.getChildren()) {
                    if (this.EdgeComparator.compare(t_childEdge_queried, t_childEdge_query) != 0 || this.NodeComparator.compare(t_childEdge_queried.getChild(), t_childEdge_query.getChild()) != 0) continue;
                    for (MatrixDataObject a : this.v_queried) {
                        for (MatrixDataObject b : this.v_query) {
                            if (t_childEdge_queried.getChild() != a.getNode() || t_childEdge_query.getChild() != b.getNode() || b.visited.booleanValue() || this.score >= this.v_query.size()) continue;
                            this.block(b);
                            this.recursive(a, b);
                        }
                    }
                }
            }
        }
        return this.score;
    }

    private void block(MatrixDataObject mdo_queried) {
        for (MatrixDataObject mdo : this.v_queried) {
            if (mdo_queried != mdo) continue;
            mdo.visited = true;
        }
        for (MatrixDataObject mdo : this.v_query) {
            if (mdo_queried != mdo) continue;
            mdo.visited = true;
        }
    }

    public void plotMatrix() {
        SimpleGetNameVisitor snv = new SimpleGetNameVisitor();
        for (int i = 0; i < this.v_queried.size(); ++i) {
            GlycoNode g1 = this.v_queried.get((int)i).fragment;
            try {
                g1.accept(snv);
            }
            catch (GlycoVisitorException e) {
                e.printStackTrace();
            }
            System.out.print(snv.getName().trim() + "\t");
            for (int q = 0; q < this.v_query.size(); ++q) {
                System.out.print(this.m_aMatrix[i][q] + " ");
            }
            System.out.print("\n");
        }
    }

    private Integer getMax() {
        this.score = 0;
        if (this.OnlyReducingEnd.booleanValue()) {
            Integer temp = 0;
            for (int t_counterG1 = 0; t_counterG1 < this.v_queried.size(); ++t_counterG1) {
                for (int t_counterG2 = 0; t_counterG2 < this.v_query.size(); ++t_counterG2) {
                    if (this.m_aMatrix[t_counterG1][t_counterG2] <= temp || !this.v_queried.get((int)t_counterG1).reducingEnd.booleanValue()) continue;
                    temp = this.m_aMatrix[t_counterG1][t_counterG2];
                    this.score = temp;
                    this.queriedMax = this.v_queried.get(t_counterG1);
                    this.queryMax = this.v_query.get(t_counterG2);
                }
            }
        } else {
            Integer temp = 0;
            for (int t_counterG1 = 0; t_counterG1 < this.v_queried.size(); ++t_counterG1) {
                for (int t_counterG2 = 0; t_counterG2 < this.v_query.size(); ++t_counterG2) {
                    if (this.m_aMatrix[t_counterG1][t_counterG2] <= temp) continue;
                    temp = this.m_aMatrix[t_counterG1][t_counterG2];
                    this.score = temp;
                    this.queriedMax = this.v_queried.get(t_counterG1);
                    this.queryMax = this.v_query.get(t_counterG2);
                }
            }
        }
        return this.score;
    }

    public Sugar getMaximumCommonSubstructure() {
        this.getMax();
        if (this.score > 0) {
            try {
                this.result.addNode(this.queryMax.getNode().copy());
            }
            catch (GlycoconjugateException e1) {
                e1.printStackTrace();
            }
            try {
                for (MatrixDataObject mdo : this.v_queried) {
                    mdo.visited = false;
                }
                for (MatrixDataObject mdo : this.v_query) {
                    mdo.visited = false;
                }
                this.SugarBuild(this.queriedMax, this.queryMax);
            }
            catch (GlycoconjugateException e) {
                e.printStackTrace();
            }
        }
        return this.result;
    }

    private void SugarBuild(MatrixDataObject MDO_queried, MatrixDataObject MDO_query) throws GlycoconjugateException {
        GlycoNode queryNode;
        GlycoNode queriedNode = MDO_queried.getNode();
        if (this.NodeComparator.compare(queriedNode, queryNode = MDO_query.getNode()) == 0) {
            for (GlycoEdge t_childEdge_queried : MDO_queried.getChildren()) {
                for (GlycoEdge t_childEdge_query : MDO_query.getChildren()) {
                    if (this.EdgeComparator.compare(t_childEdge_queried, t_childEdge_query) != 0 || this.NodeComparator.compare(t_childEdge_queried.getChild(), t_childEdge_query.getChild()) != 0) continue;
                    for (MatrixDataObject a : this.v_queried) {
                        for (MatrixDataObject b : this.v_query) {
                            if (t_childEdge_queried.getChild() != a.getNode() || t_childEdge_query.getChild() != b.getNode() || MDO_queried.visited.booleanValue() || this.score >= this.v_query.size()) continue;
                            this.block(b);
                            this.result.addEdge(queryNode, t_childEdge_query.getChild(), t_childEdge_query);
                            this.SugarBuild(a, b);
                        }
                    }
                }
            }
        }
    }
}

